/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.busi.api.AgrAddImportSkuBusiService;
import com.tydic.agreement.busi.bo.AgrAddImportSkuBusiReqBO;
import com.tydic.agreement.busi.bo.AgrAddImportSkuBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgrAgreementSkuImportLogMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.po.AgrAgreementSkuImportLogPO;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementSkuPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgrAddImportSkuBusiServiceImpl
implements AgrAddImportSkuBusiService {
    @Autowired
    private AgrAgreementSkuImportLogMapper agrAgreementSkuImportLogMapper;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementMapper agreementMapper;

    @Override
    public AgrAddImportSkuBusiRspBO addImportSku(AgrAddImportSkuBusiReqBO reqBO) {
        AgrAddImportSkuBusiRspBO rspBO = new AgrAddImportSkuBusiRspBO();
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(reqBO.getAgreementId());
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
        AgrAgreementSkuImportLogPO agrAgreementSkuImportLogPo = new AgrAgreementSkuImportLogPO();
        agrAgreementSkuImportLogPo.setImportFileId(reqBO.getImportFileId());
        agrAgreementSkuImportLogPo.setVerifyStatus("1");
        List<AgrAgreementSkuImportLogPO> agrAgreementSkuImportLogPOList = this.agrAgreementSkuImportLogMapper.getList(agrAgreementSkuImportLogPo);
        if (!CollectionUtils.isEmpty(agrAgreementSkuImportLogPOList)) {
            ArrayList<AgreementSkuPO> insertSkuPoList = new ArrayList<AgreementSkuPO>();
            for (AgrAgreementSkuImportLogPO agrAgreementSkuImportLogPO : agrAgreementSkuImportLogPOList) {
                AgreementSkuPO po = new AgreementSkuPO();
                BeanUtils.copyProperties((Object)agrAgreementSkuImportLogPO, (Object)po);
                po.setAgreementSkuId(Sequence.getInstance().nextId());
                po.setAgreementId(agreement.getAgreementId());
                po.setSupplierId(agreement.getSupplierId());
                po.setAgreementVersion(agreement.getAgreementVersion());
                po.setSkuStatus(AgrCommConstant.SkuStatus.TO_BE_RELEASED);
                po.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
                po.setCreateLoginId(reqBO.getMemIdIn());
                po.setCreateName(reqBO.getUserName());
                po.setCreateTime(new Date());
                po.setBuyPrice(agrAgreementSkuImportLogPO.getBuyPrice().multiply(new BigDecimal(10000)).longValue());
                po.setBuyPriceSum(agrAgreementSkuImportLogPO.getBuyPrice().multiply(agrAgreementSkuImportLogPO.getBuyNumber()).multiply(new BigDecimal(10000)).longValue());
                po.setSalePrice(agrAgreementSkuImportLogPO.getSalePrice().multiply(new BigDecimal(10000)).longValue());
                po.setSalePriceSum(agrAgreementSkuImportLogPO.getSalePrice().multiply(agrAgreementSkuImportLogPO.getBuyNumber()).multiply(new BigDecimal(10000)).longValue());
                if (agrAgreementSkuImportLogPO.getExtField6() != null) {
                    po.setExtField6(agrAgreementSkuImportLogPO.getExtField6().multiply(new BigDecimal(10000)).toString());
                }
                if (agrAgreementSkuImportLogPO.getExtField7() != null) {
                    po.setExtField7(agrAgreementSkuImportLogPO.getExtField7().multiply(new BigDecimal(10000)).toString());
                }
                if (agreement.getTradeMode() == 1) {
                    if (agrAgreementSkuImportLogPO.getMarkupRate() != null) {
                        po.setMarkupRule((byte)1);
                    } else {
                        po.setMarkupRule((byte)2);
                        po.setMarkupAmount(agrAgreementSkuImportLogPO.getMarkupAmount().multiply(new BigDecimal(10000)).longValue());
                    }
                }
                insertSkuPoList.add(po);
            }
            this.agreementSkuMapper.insertBatch(insertSkuPoList);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("0000");
        return rspBO;
    }
}

