/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.agreement.ability.bo.AgrAgreementBO;
import com.tydic.agreement.atom.api.AgrCheckAgreementExistAndStatusAtomService;
import com.tydic.agreement.busi.api.AgrAgreementSubmitBusiConfirService;
import com.tydic.agreement.busi.bo.AgrAgreementSubmitBusiReqBO;
import com.tydic.agreement.busi.bo.AgrAgreementSubmitBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.EacRuTaskMapper;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.EacRuTaskPO;
import com.tydic.osworkflow.approve.ability.EacRuTaskAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacApproveAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacApproveAbilityReqInfoBO;
import com.tydic.osworkflow.approve.ability.bo.EacApproveAbilityRspBO;
import com.tydic.osworkflow.approve.ability.bo.EacRuInstAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacRuInstAbilityRspBO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.uac.exception.BusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrAgreementSubmitBusiConfirServiceImpl
implements AgrAgreementSubmitBusiConfirService {
    private static final Logger log = LoggerFactory.getLogger(AgrAgreementSubmitBusiConfirServiceImpl.class);
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgrCheckAgreementExistAndStatusAtomService agrCheckAgreementExistAndStatusAtomService;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private EacRuTaskAbilityService eacRuTaskAbilityService;
    @Autowired
    private EacRuTaskMapper eacRuTaskMapper;

    @Override
    public AgrAgreementSubmitBusiRspBO confirmAgreementInfo(AgrAgreementSubmitBusiReqBO busiReqBO) {
        AgrAgreementSubmitBusiRspBO busiRspBO = new AgrAgreementSubmitBusiRspBO();
        List<AgrAgreementBO> agreementList = busiReqBO.getAgreementList();
        for (AgrAgreementBO abo : agreementList) {
            AgreementPO poQuery = new AgreementPO();
            poQuery.setAgreementId(abo.getAgreementId());
            poQuery.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            AgreementPO modelBy = this.agreementMapper.getModelBy(poQuery);
            AgrAgreementBO agrAgreementBO = new AgrAgreementBO();
            if (modelBy == null) {
                throw new BusinessException("22005", "\u534f\u8bae\u672a\u5b58\u5728");
            }
            BeanUtils.copyProperties((Object)modelBy, (Object)agrAgreementBO);
            AgreementPO po = new AgreementPO();
            po.setAgreementId(abo.getAgreementId());
            po.setSupplierId(abo.getSupplierId());
            EacRuTaskPO eacRuTaskPO = new EacRuTaskPO();
            eacRuTaskPO.setBusinessId(modelBy.getAgreementId().toString());
            eacRuTaskPO.setOrderBy("CREATE_TIME");
            eacRuTaskPO.setStatus("ACTIVE");
            List<EacRuTaskPO> eacRuTaskPOList = this.eacRuTaskMapper.getList(eacRuTaskPO);
            EacApproveAbilityRspBO eacApproveAbilityRspBO = null;
            if (AgrCommConstant.AgrConfirmOrNo.CONFIRM.equals(busiReqBO.getOperType())) {
                EacApproveAbilityReqBO eacApproveAbilityReqBO = new EacApproveAbilityReqBO();
                ArrayList data = new ArrayList();
                eacApproveAbilityReqBO.setData(data);
                for (EacRuTaskPO ruTaskPO : eacRuTaskPOList) {
                    EacApproveAbilityReqInfoBO eacApproveAbilityReqInfoBO = new EacApproveAbilityReqInfoBO();
                    eacApproveAbilityReqInfoBO.setTaskId(ruTaskPO.getTaskId());
                    eacApproveAbilityReqInfoBO.setVariables(new HashMap());
                    eacApproveAbilityReqInfoBO.setApproveResult("pass");
                    eacApproveAbilityReqInfoBO.getVariables().put("auditOrderStatus", "\u901a\u8fc7");
                    eacApproveAbilityReqInfoBO.getVariables().put("sysTenantId", modelBy.getSysTenantId());
                    data.add(eacApproveAbilityReqInfoBO);
                }
                eacApproveAbilityReqBO.setSysTenantId(modelBy.getSysTenantId().toString());
                try {
                    log.info("\u5ba1\u6279\u5355\u5ba1\u6279\u901a\u8fc7\u5165\u53c2eacApproveAbilityReqInfoBO:" + JSON.toJSON((Object)eacApproveAbilityReqBO));
                    eacApproveAbilityRspBO = this.eacRuTaskAbilityService.approveByMq(eacApproveAbilityReqBO);
                    log.info("\u5ba1\u6279\u5355\u5ba1\u6279\u901a\u8fc7\u51fa\u53c2eacApproveAbilityRspBO:" + JSON.toJSON((Object)eacApproveAbilityRspBO));
                    if (!"0000".equals(eacApproveAbilityRspBO.getRespCode())) {
                        throw new BusinessException(eacApproveAbilityRspBO.getRespCode(), eacApproveAbilityRspBO.getRespDesc());
                    }
                }
                catch (BusinessException e) {
                    throw new BusinessException("11201", e.getMessage());
                }
                po.setAgreementStatus(AgrCommConstant.AgreementStatus.IN_AUDIT);
            } else {
                eacApproveAbilityRspBO = new EacApproveAbilityRspBO();
                ArrayList list = new ArrayList();
                eacApproveAbilityRspBO.setData(list);
                for (EacRuTaskPO each : eacRuTaskPOList) {
                    EacRuInstAbilityReqBO eacRuInstAbilityReqBO = new EacRuInstAbilityReqBO();
                    eacRuInstAbilityReqBO.setApproveInstId(each.getApproveInstId());
                    eacRuInstAbilityReqBO.setSysTenantId(modelBy.getSysTenantId().toString());
                    try {
                        log.info("\u5ba1\u6279\u5355\u5ba1\u6279\u6d41\u7a0b\u7ec8\u6b62\u5165\u53c2eacRuInstAbilityReqBO:" + JSON.toJSON((Object)eacRuInstAbilityReqBO));
                        EacRuInstAbilityRspBO eacRuInstAbilityRspBO = this.eacRuTaskAbilityService.suspensionApprove(eacRuInstAbilityReqBO);
                        log.info("\u5ba1\u6279\u5355\u5ba1\u6279\u6d41\u7a0b\u7ec8\u6b62\u51fa\u53c2eacRuInstAbilityRspBO:" + JSON.toJSON((Object)eacRuInstAbilityRspBO));
                        if ("0000".equals(eacRuInstAbilityRspBO.getRespCode())) continue;
                        throw new BusinessException(eacApproveAbilityRspBO.getRespCode(), eacApproveAbilityRspBO.getRespDesc());
                    }
                    catch (BusinessException e) {
                        throw new BusinessException("11201", e.getMessage());
                    }
                }
                po.setAgreementStatus(AgrCommConstant.AgreementStatus.NO_CONFIRM);
            }
            int count = this.agreementMapper.updateByCondition(po);
            if (count < 1) {
                throw new BusinessException("22005", "\u66f4\u65b0\u534f\u8bae\u72b6\u6001\u5931\u8d25");
            }
            List<Long> taskIds = eacRuTaskPOList.stream().map(EacRuTaskPO::getTaskId).collect(Collectors.toList());
            EacRuTaskPO where = new EacRuTaskPO();
            where.setTaskIds(taskIds);
            EacRuTaskPO set = new EacRuTaskPO();
            if (busiReqBO.getOperType() == 1) {
                set.setColumn2("0");
            } else {
                set.setColumn2("1");
            }
            set.setStatus("COMPLETE");
            set.setDueTime(new Date(System.currentTimeMillis()));
            if (CollectionUtils.isEmpty(taskIds)) continue;
            this.eacRuTaskMapper.updateBy(set, where);
        }
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u534f\u8bae\u786e\u8ba4\u6210\u529f");
        return busiRspBO;
    }

    private void createProcess(Long agreementId, AgrAgreementBO agrAgreementBO) {
        ArrayList<ApprovalObjBO> approvalObjInfo = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjType(AgrCommConstant.AuditObjType.AGREEMENT_AUDIT);
        approvalObjBO.setObjId(agreementId.toString());
        approvalObjInfo.add(approvalObjBO);
        ArrayList<UacNoTaskAuditCreateInfoReqBO> uacNoTaskAuditCreateInfoReqBOs = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(AgrCommConstant.AuditObjType.AGREEMENT_AUDIT);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(agreementId);
        uacNoTaskAuditCreateInfoReqBO.setRemark("\u534f\u8bae\u65b0\u589e\u5ba1\u6279");
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjInfo);
        uacNoTaskAuditCreateInfoReqBOs.add(uacNoTaskAuditCreateInfoReqBO);
        UacNoTaskAuditCreateReqBO uacNoTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        if (AgrCommConstant.agreementMode.PLAT_AGREEMENT.equals(agrAgreementBO.getAgreementMode())) {
            uacNoTaskAuditCreateReqBO.setProcDefKey("agreementPlatAudit");
        } else if (AgrCommConstant.agreementMode.UNIT_AGREEMENT.equals(agrAgreementBO.getAgreementMode())) {
            uacNoTaskAuditCreateReqBO.setProcDefKey("agreementPurchaseAudit");
        }
        uacNoTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        uacNoTaskAuditCreateReqBO.setCreateOperDept(agrAgreementBO.getVendorDepartmentName());
        uacNoTaskAuditCreateReqBO.setCreateOperId(agrAgreementBO.getProducerId().toString());
        uacNoTaskAuditCreateReqBO.setCreateOperName(agrAgreementBO.getProducerName());
        uacNoTaskAuditCreateReqBO.setCreateBusiReqBO(uacNoTaskAuditCreateInfoReqBOs);
        log.error("\u5f00\u59cb\u8c03\u7528\u5ba1\u6279-----");
        log.error("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u521b\u5efaAPI\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditCreateReqBO));
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(uacNoTaskAuditCreateReqBO);
        log.error("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u521b\u5efaAPI\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new BusinessException(uacNoTaskAuditCreateRspBO.getRespCode(), uacNoTaskAuditCreateRspBO.getRespDesc());
        }
    }
}

