/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.agreement.ability.bo.AgrAgreementSkuBO;
import com.tydic.agreement.busi.api.AgrModifyAgreementSkuBusiService;
import com.tydic.agreement.busi.bo.AgrModifyAgreementSkuBusiReqBO;
import com.tydic.agreement.busi.bo.AgrModifyAgreementSkuBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementSkuPO;
import com.tydic.cfc.ability.api.CfcQryCommodityAtuoMappingAbilityService;
import com.tydic.cfc.ability.bo.CfcQryCommodityAtuoMappingAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcQryCommodityAtuoMappingAbilityRspBO;
import com.tydic.commodity.common.ability.api.UccEbsMaterialAddAbilityService;
import com.tydic.commodity.common.ability.api.UccEbsMaterialEditAbilityService;
import com.tydic.commodity.common.ability.api.UccEbsMaterialListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccEbsMaterialAddAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccEbsMaterialAddAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccEbsMaterialBO;
import com.tydic.commodity.common.ability.bo.UccEbsMaterialEditAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccEbsMaterialEditAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccEbsMaterialListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccEbsMaterialListQryAbilityRspBO;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgrModifyAgreementSkuBusiServiceImpl
implements AgrModifyAgreementSkuBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrModifyAgreementSkuBusiServiceImpl.class);
    private static final String CFC_AUTO_MAPPING_STATUS = "1";
    private static final Integer UCC_MATERIAL_RELATED = 1;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private CfcQryCommodityAtuoMappingAbilityService cfcQryCommodityAtuoMappingAbilityService;
    @Autowired
    private UccEbsMaterialListQryAbilityService uccEbsMaterialListQryAbilityService;
    @Autowired
    private UccEbsMaterialAddAbilityService uccEbsMaterialAddAbilityService;
    @Autowired
    private UccEbsMaterialEditAbilityService uccEbsMaterialEditAbilityService;

    @Override
    public AgrModifyAgreementSkuBusiRspBO modifyAgreementSku(AgrModifyAgreementSkuBusiReqBO busiReqBO) {
        AgrModifyAgreementSkuBusiRspBO rsp = new AgrModifyAgreementSkuBusiRspBO();
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(busiReqBO.getAgrAgreementSkuBOs().getAgreementId());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
        if (null == agreement) {
            throw new BusinessException("0101", "\u4e0d\u5b58\u5728\u8be5\u534f\u8bae\uff01");
        }
        if (!(AgrCommConstant.AgreementStatus.DRAFT.equals(agreement.getAgreementStatus()) || AgrCommConstant.AgreementStatus.REJECT.equals(agreement.getAgreementStatus()) || AgrCommConstant.AgreementStatus.NO_ASS.equals(agreement.getAgreementStatus()) || AgrCommConstant.AgreementStatus.NO_CONFIRM.equals(agreement.getAgreementStatus()))) {
            throw new BusinessException("22002", "\u53ea\u6709\u8349\u7a3f\u4e2d\u3001\u672a\u63a5\u53d7\u548c\u9a73\u56de\u72b6\u6001\u7684\u534f\u8bae\u53ef\u4ee5\u4fee\u6539\u534f\u8bae\u660e\u7ec6\uff01");
        }
        AgreementSkuPO updateAgreementSkuPO = new AgreementSkuPO();
        BeanUtils.copyProperties((Object)busiReqBO.getAgrAgreementSkuBOs(), (Object)updateAgreementSkuPO);
        updateAgreementSkuPO.setUpdateLoginId(busiReqBO.getMemIdIn());
        updateAgreementSkuPO.setUpdateName(busiReqBO.getUserName());
        updateAgreementSkuPO.setUpdateTime(new Date());
        if (agreement.getTradeMode().equals((byte)2)) {
            updateAgreementSkuPO.setBuyPrice(updateAgreementSkuPO.getSalePrice());
            updateAgreementSkuPO.setBuyPriceSum(new BigDecimal(updateAgreementSkuPO.getBuyPrice()).multiply(updateAgreementSkuPO.getBuyNumber()).longValue());
        }
        updateAgreementSkuPO.setSalePriceSum(new BigDecimal(updateAgreementSkuPO.getSalePrice()).multiply(updateAgreementSkuPO.getBuyNumber()).longValue());
        this.agreementSkuMapper.updateBy(updateAgreementSkuPO);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u660e\u7ec6\u4fee\u6539\u6210\u529f\uff01");
        return rsp;
    }

    private void buildMaterialMapping(AgrModifyAgreementSkuBusiReqBO reqBo, AgreementPO agreementPo) {
        if (AgrCommConstant.agreementMode.UNIT_AGREEMENT.equals(agreementPo.getAgreementMode()) && ObjectUtil.isNotEmpty((Object)agreementPo.getAgreementBelongsId())) {
            CfcQryCommodityAtuoMappingAbilityReqBO cfcAutoMappingReqBO = new CfcQryCommodityAtuoMappingAbilityReqBO();
            cfcAutoMappingReqBO.setSecondId(Long.valueOf(agreementPo.getAgreementBelongsId()));
            cfcAutoMappingReqBO.setSysTenantId(agreementPo.getSysTenantId());
            CfcQryCommodityAtuoMappingAbilityRspBO cfcAutoMappingRspBO = this.cfcQryCommodityAtuoMappingAbilityService.qryCommodityAtuoMapping(cfcAutoMappingReqBO);
            log.info("\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3{}\u81ea\u52a8\u6620\u5c04\u914d\u7f6e\u8fd4\u56de\uff1a{}", (Object)agreementPo.getAgreementBelongsId(), (Object)JSON.toJSONString((Object)cfcAutoMappingRspBO));
            if (!"0000".equals(cfcAutoMappingRspBO.getRespCode())) {
                log.warn("\u67e5\u8be2SP25\u534f\u8bae\u5546\u54c1\u81ea\u52a8\u6620\u5c04\u8bbe\u7f6e\u5931\u8d25");
                return;
            }
            if (!CFC_AUTO_MAPPING_STATUS.equals(cfcAutoMappingRspBO.getStatus())) {
                log.info("SP25\u534f\u8bae\u5546\u54c1\u81ea\u52a8\u6620\u5c04\u8bbe\u7f6e\u4e3a\u5173\u95ed\uff0c\u672c\u6b21\u4e0d\u6267\u884c\u5efa\u7acb\u7269\u6599\u6620\u5c04\u5173\u7cfb\u4fe1\u606f\u3002");
                return;
            }
            AgrAgreementSkuBO agrSkuBo = reqBo.getAgrAgreementSkuBOs();
            if (!StringUtils.isBlank((CharSequence)agrSkuBo.getEbsMaterialCode())) {
                UccEbsMaterialListQryAbilityReqBO uccEbsMaterialQryReqBo = new UccEbsMaterialListQryAbilityReqBO();
                uccEbsMaterialQryReqBo.setEbsMaterialCode(agrSkuBo.getEbsMaterialCode());
                UccEbsMaterialListQryAbilityRspBO uccEbsMaterialQryRspBo = this.uccEbsMaterialListQryAbilityService.ebsMaterialQryList(uccEbsMaterialQryReqBo);
                if ("0000".equals(uccEbsMaterialQryRspBo.getRespCode())) {
                    UccEbsMaterialAddAbilityReqBO uccEbsMaterialAddReqBo = new UccEbsMaterialAddAbilityReqBO();
                    UccEbsMaterialEditAbilityReqBO uccEbsMaterialEditReqBo = new UccEbsMaterialEditAbilityReqBO();
                    if (uccEbsMaterialQryRspBo.getRecordsTotal() > 0) {
                        UccEbsMaterialBO ebsMaterialBo = (UccEbsMaterialBO)uccEbsMaterialQryRspBo.getRows().get(0);
                        if (StringUtils.isNotBlank((CharSequence)ebsMaterialBo.getMaterialCode())) {
                            AgreementSkuPO updateAgreementSkuPO = new AgreementSkuPO();
                            updateAgreementSkuPO.setAgreementSkuId(agrSkuBo.getAgreementSkuId());
                            if (ObjectUtil.isNotNull((Object)ebsMaterialBo.getMaterialId())) {
                                updateAgreementSkuPO.setMaterialId(ebsMaterialBo.getMaterialId().toString());
                            }
                            updateAgreementSkuPO.setMaterialCode(ebsMaterialBo.getMaterialCode());
                            this.agreementSkuMapper.updateBy(updateAgreementSkuPO);
                        }
                    } else {
                        uccEbsMaterialAddReqBo.setEbsMaterialCode(agrSkuBo.getEbsMaterialCode());
                        uccEbsMaterialAddReqBo.setEbsMeasure(agrSkuBo.getMeasureName());
                        uccEbsMaterialAddReqBo.setEbsMaterialName(agrSkuBo.getMaterialName());
                        uccEbsMaterialAddReqBo.setEbsLongDesc(agrSkuBo.getMaterialName());
                        uccEbsMaterialAddReqBo.setEbsModel(agrSkuBo.getSpec() + "/" + agrSkuBo.getModel());
                        uccEbsMaterialAddReqBo.setBrandName(agrSkuBo.getBrandName());
                        uccEbsMaterialAddReqBo.setEbsInvalid("N");
                        uccEbsMaterialAddReqBo.setSysCode(agreementPo.getAgreementBelongsCode());
                        log.info("\u65b0\u589e\u7269\u6599\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uccEbsMaterialAddReqBo));
                        UccEbsMaterialAddAbilityRspBO uccEbsMaterialAddRspBo = this.uccEbsMaterialAddAbilityService.dealAddMaterialEdit(uccEbsMaterialAddReqBo);
                        log.info("\u65b0\u589e\u7269\u6599\u63a5\u53e3\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString((Object)uccEbsMaterialAddRspBo));
                        if (!"0000".equals(uccEbsMaterialAddRspBo.getRespCode())) {
                            log.warn("\u65b0\u589e\u5173\u8054\u7269\u6599[{}]\u5931\u8d25\uff1a{}", (Object)agrSkuBo.getEbsMaterialCode(), (Object)uccEbsMaterialAddRspBo.getRespDesc());
                        } else {
                            uccEbsMaterialEditReqBo.setEbsMaterialId(uccEbsMaterialAddRspBo.getEsbMaterialId());
                            uccEbsMaterialEditReqBo.setMaterialId(Long.valueOf(agrSkuBo.getMaterialId()));
                            uccEbsMaterialEditReqBo.setIsOut(Integer.valueOf(1));
                            log.info("\u5173\u8054\u7269\u6599\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uccEbsMaterialEditReqBo));
                            UccEbsMaterialEditAbilityRspBO uccEbsMaterialEditRspBO = this.uccEbsMaterialEditAbilityService.dealEbsMaterialEdit(uccEbsMaterialEditReqBo);
                            log.info("\u5173\u8054\u7269\u6599\u63a5\u53e3\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString((Object)uccEbsMaterialEditRspBO));
                            if (!"0000".equals(uccEbsMaterialEditRspBO.getRespCode())) {
                                log.warn("\u5173\u8054\u7269\u6599\u5173\u7cfb\u5931\u8d25\uff1a{}", (Object)uccEbsMaterialEditRspBO.getRespDesc());
                            }
                            log.info("\u7269\u6599{}-{}\u5173\u8054\u6210\u529f\u3002", (Object)agrSkuBo.getEbsMaterialCode(), (Object)agrSkuBo.getMaterialCode());
                        }
                    }
                } else {
                    log.warn("\u8c03\u7528\u201c\u7269\u6599\u6620\u5c04\u5173\u7cfb\u7ef4\u62a4\u5217\u8868\u67e5\u8be2API\u201d\u5931\u8d25\uff0c\u65e0\u6cd5\u5224\u65ad\u4e1a\u52a1\u5355\u4f4d\u7684\u7269\u8d44\u7f16\u7801\u662f\u5426\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u8fdb\u884c\u7269\u6599\u7f16\u7801\u6620\u5c04\u521b\u5efa\u3002");
                }
            } else {
                log.info("\u534f\u8bae\u660e\u7ec6\u4e2d\u7684\u4e1a\u52a1\u5355\u4f4d\u7269\u8d44\u7f16\u7801\u4e3a\u7a7a\uff0c\u6ca1\u6709\u9700\u8981\u5efa\u7acb\u7269\u6599\u6620\u5c04\u5173\u7cfb\u4fe1\u606f\u3002");
            }
        } else {
            log.info("\u975e\u5355\u4f4d\u534f\u8bae\u6216\u534f\u8bae\u6240\u5c5eID\u4e3a\u7a7a\uff0c\u534f\u8bae\u660e\u7ec6\u521b\u5efaAPI\u4e0d\u6267\u884c\u5efa\u7acb\u7269\u6599\u6620\u5c04\u5173\u7cfb\u4fe1\u606f\u3002");
        }
    }
}

