/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.agreement.ability.bo.EvaluateSummarysBO;
import com.tydic.agreement.ability.bo.RfxQuotationLinesBO;
import com.tydic.agreement.ability.bo.SupplierCompanyBO;
import com.tydic.agreement.busi.api.AgrNonBiddingPushDataBusiService;
import com.tydic.agreement.busi.bo.AgrNonBiddingPushDataBusiReqBO;
import com.tydic.agreement.busi.bo.AgrNonBiddingPushDataBusiRspBO;
import com.tydic.agreement.consumer.bo.AgrPushAddBO;
import com.tydic.agreement.dao.AgrPushDataMapper;
import com.tydic.agreement.po.AgrPushDataPO;
import com.tydic.ppc.ability.api.PpcPurchaseDemandUpdateStatusAbilityService;
import com.tydic.ppc.ability.api.PpcPurchaseEnquiryUpdateStatusAbilityService;
import com.tydic.ppc.ability.bo.PpcPurchaseDemandSupRelAbilityBO;
import com.tydic.ppc.ability.bo.PpcPurchaseDemandUpdateStatusAbilityReqBO;
import com.tydic.ppc.ability.bo.PpcPurchaseEnquiryUpdateStatusAbilityReqBO;
import com.tydic.umc.general.ability.api.CrcQryCorporationByFmsAbilityService;
import com.tydic.umc.general.ability.bo.CrcQryCorporationByFmsAbilityReqBO;
import com.tydic.umc.general.ability.bo.CrcQryCorporationByFmsAbilityRspBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AgrNonBiddingPushDataBusiServiceImpl
implements AgrNonBiddingPushDataBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrNonBiddingPushDataBusiServiceImpl.class);
    @Autowired
    private AgrPushDataMapper agrPushDataMapper;
    @Value(value="${AGR_PUSH_ADD_TOPIC:AGR_PUSH_ADD_TOPIC}")
    private String agrPushAddTopic;
    @Value(value="${AGR_PUSH_ADD_TAG:*}")
    private String agrPushAddTag;
    @Resource(name="pushAddMqServiceProvider")
    private ProxyMessageProducer pushAddMqServiceProvider;
    @Autowired
    private PpcPurchaseEnquiryUpdateStatusAbilityService ppcPurchaseEnquiryUpdateStatusAbilityService;
    @Autowired
    private CrcQryCorporationByFmsAbilityService crcQryCorporationByFmsAbilityService;
    @Autowired
    private PpcPurchaseDemandUpdateStatusAbilityService ppcPurchaseDemandUpdateStatusAbilityService;

    @Override
    public AgrNonBiddingPushDataBusiRspBO nonBiddingPushData(AgrNonBiddingPushDataBusiReqBO reqBO) {
        AgrNonBiddingPushDataBusiRspBO rspBO = new AgrNonBiddingPushDataBusiRspBO();
        AgrPushDataPO agrPushDataPo = new AgrPushDataPO();
        agrPushDataPo.setId(Sequence.getInstance().nextId());
        agrPushDataPo.setData(JSONObject.toJSONString((Object)reqBO));
        agrPushDataPo.setPurchaseEnquiryOrderNo(reqBO.getRfxNum());
        List<EvaluateSummarysBO> evaluateSummarys = reqBO.getEvaluateSummarys();
        HashSet<String> supplierNames = new HashSet<String>();
        HashSet<SupplierCompanyBO> suppliers = new HashSet<SupplierCompanyBO>();
        for (EvaluateSummarysBO evaluateSummarysBO : evaluateSummarys) {
            if (!"\u662f".equals(evaluateSummarysBO.getCandidateFlagMeaning())) continue;
            supplierNames.add(evaluateSummarysBO.getSupplierCompanyName());
            SupplierCompanyBO supplierCompanyBO = new SupplierCompanyBO();
            supplierCompanyBO.setSupplierCompanyNum(evaluateSummarysBO.getSupplierCompanyNum());
            supplierCompanyBO.setSupplierCompanyName(evaluateSummarysBO.getSupplierCompanyName());
            suppliers.add(supplierCompanyBO);
        }
        agrPushDataPo.setField1(String.join((CharSequence)",", supplierNames));
        agrPushDataPo.setPurchaseEnquiryOrderNo(reqBO.getRfxNum());
        agrPushDataPo.setStatus("0");
        agrPushDataPo.setCreateTime(new Date());
        agrPushDataPo.setSysTenantId(305775845729763327L);
        agrPushDataPo.setSysTenantName("\u534e\u6da6\u79df\u6237\u673a\u6784");
        this.agrPushDataMapper.insert(agrPushDataPo);
        ArrayList<PpcPurchaseDemandSupRelAbilityBO> supRelPOList = new ArrayList<PpcPurchaseDemandSupRelAbilityBO>();
        for (SupplierCompanyBO supplier : suppliers) {
            CrcQryCorporationByFmsAbilityReqBO verndorReqBO = new CrcQryCorporationByFmsAbilityReqBO();
            verndorReqBO.setCorporationCode(supplier.getSupplierCompanyNum());
            log.info("\u901a\u8fc7fms\u7f16\u7801\u67e5\u8be2\u4f9b\u5e94\u5546\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)verndorReqBO));
            CrcQryCorporationByFmsAbilityRspBO verndorRspBO = this.crcQryCorporationByFmsAbilityService.qryCorporationByFms(verndorReqBO);
            log.info("\u901a\u8fc7fms\u7f16\u7801\u67e5\u8be2\u4f9b\u5e94\u5546\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)verndorRspBO));
            if (!"0000".equals(verndorRspBO.getRespCode())) {
                log.error("\u67e5\u8be2\u4f9b\u5e94\u5546\u62a5\u9519" + JSONObject.toJSONString((Object)supplier.getSupplierCompanyNum()));
                continue;
            }
            PpcPurchaseDemandSupRelAbilityBO ppcPurchaseDemandSupRelAbilityBO = new PpcPurchaseDemandSupRelAbilityBO();
            ppcPurchaseDemandSupRelAbilityBO.setSupName(supplier.getSupplierCompanyName());
            if (null != verndorRspBO.getCorPorationBO()) {
                ppcPurchaseDemandSupRelAbilityBO.setSupId(verndorRspBO.getCorPorationBO().getCorporationId());
                ppcPurchaseDemandSupRelAbilityBO.setSupContacts(verndorRspBO.getCorPorationBO().getRemark());
                ppcPurchaseDemandSupRelAbilityBO.setSupContactsPhone(verndorRspBO.getCorPorationBO().getPhone());
            }
            supRelPOList.add(ppcPurchaseDemandSupRelAbilityBO);
        }
        PpcPurchaseEnquiryUpdateStatusAbilityReqBO ppcPurchaseEnquiryUpdateStatusAbilityReqBO = new PpcPurchaseEnquiryUpdateStatusAbilityReqBO();
        ppcPurchaseEnquiryUpdateStatusAbilityReqBO.setStatus(Long.valueOf(10L));
        ppcPurchaseEnquiryUpdateStatusAbilityReqBO.setEnquiryOrderNo(reqBO.getRfxNum());
        ppcPurchaseEnquiryUpdateStatusAbilityReqBO.setSupRelPOList(supRelPOList);
        this.ppcPurchaseEnquiryUpdateStatusAbilityService.enquiryUpdateStatus(ppcPurchaseEnquiryUpdateStatusAbilityReqBO);
        PpcPurchaseDemandUpdateStatusAbilityReqBO ppcPurchaseDemandUpdateStatusAbilityReqBO = new PpcPurchaseDemandUpdateStatusAbilityReqBO();
        ArrayList<String> purchaseDemandNos = new ArrayList<String>();
        List<RfxQuotationLinesBO> rfxQuotationLines = reqBO.getRfxQuotationLines();
        for (RfxQuotationLinesBO rfxQuotationLinesBO : rfxQuotationLines) {
            if (!"1".equals(rfxQuotationLinesBO.getSuggestedFlag())) continue;
            purchaseDemandNos.add(rfxQuotationLinesBO.getExternalItemUniqueIndex());
        }
        ppcPurchaseDemandUpdateStatusAbilityReqBO.setPurchaseDemandNos(purchaseDemandNos);
        ppcPurchaseDemandUpdateStatusAbilityReqBO.setStatus("10");
        this.ppcPurchaseDemandUpdateStatusAbilityService.batchUpdatePurchaseDemandStatus(ppcPurchaseDemandUpdateStatusAbilityReqBO);
        AgrPushAddBO agrPushAddBO = new AgrPushAddBO();
        agrPushAddBO.setId(agrPushDataPo.getId());
        String content = JSON.toJSONString((Object)agrPushAddBO);
        log.info("\u53d1\u6d88\u606f\u975e\u62db\u63a8\u9001\u6570\u636e\u8fdb\u4e34\u65f6\u8868mq\u5165\u53c2\u4e3a" + JSON.toJSONString((Object)content));
        this.pushAddMqServiceProvider.send(new ProxyMessage(this.agrPushAddTopic, this.agrPushAddTag, content));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

