/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.api.AgrEncodedSerialGetAbilityService;
import com.tydic.agreement.ability.bo.AgrAgreementAttachBO;
import com.tydic.agreement.ability.bo.AgrAgreementBO;
import com.tydic.agreement.ability.bo.AgrAgreementMajorChangeBO;
import com.tydic.agreement.ability.bo.AgrEncodedSerialGetAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrEncodedSerialGetAbilityRspBO;
import com.tydic.agreement.ability.bo.AgrSkuChangeBO;
import com.tydic.agreement.ability.bo.AgreementSettlementBO;
import com.tydic.agreement.ability.bo.AgrskuChangePriceBO;
import com.tydic.agreement.ability.bo.CrcAgreementScopeBO;
import com.tydic.agreement.atom.api.AgrSyncAddSkuToCommidityAtomService;
import com.tydic.agreement.atom.api.AgrSyncSkuStatusToCommidityAtomService;
import com.tydic.agreement.atom.bo.AgrSyncSkuStatusToCommidityAtomReqBO;
import com.tydic.agreement.atom.bo.AgrSyncSkuStatusToCommidityAtomRspBO;
import com.tydic.agreement.busi.api.CrcAddAgreementChangeBusiService;
import com.tydic.agreement.busi.bo.CrcAddAgreementChangeBusiReqBO;
import com.tydic.agreement.busi.bo.CrcAddAgreementChangeBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgrAgreementAttachChangeMapper;
import com.tydic.agreement.dao.AgrAgreementAttachLogMapper;
import com.tydic.agreement.dao.AgrPushLogMapper;
import com.tydic.agreement.dao.AgreementAttachMapper;
import com.tydic.agreement.dao.AgreementChangeMapper;
import com.tydic.agreement.dao.AgreementLogMapper;
import com.tydic.agreement.dao.AgreementMajorChangeMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementScopeChangeMapper;
import com.tydic.agreement.dao.AgreementScopeLogMapper;
import com.tydic.agreement.dao.AgreementScopeMapper;
import com.tydic.agreement.dao.AgreementSettlementLogMapper;
import com.tydic.agreement.dao.AgreementSettlementMapper;
import com.tydic.agreement.dao.AgreementSkuChangeMapper;
import com.tydic.agreement.dao.AgreementSkuLogMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgrAgreementAttachChangePO;
import com.tydic.agreement.po.AgrAgreementAttachLogPO;
import com.tydic.agreement.po.AgrPushLogPO;
import com.tydic.agreement.po.AgreementAttachPO;
import com.tydic.agreement.po.AgreementChangePO;
import com.tydic.agreement.po.AgreementLogPO;
import com.tydic.agreement.po.AgreementMajorChangePO;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementScopeChangePO;
import com.tydic.agreement.po.AgreementScopeLogPO;
import com.tydic.agreement.po.AgreementScopePO;
import com.tydic.agreement.po.AgreementSettlementLogPO;
import com.tydic.agreement.po.AgreementSettlementPO;
import com.tydic.agreement.po.AgreementSkuChangePO;
import com.tydic.agreement.po.AgreementSkuLogPO;
import com.tydic.agreement.po.AgreementSkuPO;
import com.tydic.commodity.common.ability.api.UccQueryCatalogByMaterialAbilityService;
import com.tydic.commodity.common.ability.bo.UccQueryCatalogByMaterialAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccQueryCatalogByMaterialAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccQueryCatalogByMaterialBO;
import com.tydic.umc.general.ability.api.UmcQryMemLegalOrgInfoAbilityService;
import com.tydic.umc.general.ability.bo.UmcQryMemLegalOrgInfoAbilityServiceReqBO;
import com.tydic.umc.general.ability.bo.UmcQryMemLegalOrgInfoAbilityServiceRspBO;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class CrcAddAgreementChangeBusiServiceImpl
implements CrcAddAgreementChangeBusiService {
    private static final Logger log = LoggerFactory.getLogger(CrcAddAgreementChangeBusiServiceImpl.class);
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgrEncodedSerialGetAbilityService agrEncodedSerialGetAbilityService;
    @Autowired
    private AgreementLogMapper agreementLogMapper;
    @Autowired
    private UmcQryMemLegalOrgInfoAbilityService umcQryMemLegalOrgInfoAbilityService;
    @Autowired
    private AgreementChangeMapper agreementChangeMapper;
    @Autowired
    private AgrSyncSkuStatusToCommidityAtomService agrSyncSkuStatusToCommidityAtomService;
    @Autowired
    private AgreementSkuChangeMapper agreementSkuChangeMapper;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private UccQueryCatalogByMaterialAbilityService uccQueryCatalogByMaterialAbilityService;
    @Autowired
    private AgreementMajorChangeMapper agreementMajorChangeMapper;
    @Autowired
    private AgreementSettlementMapper agreementSettlementMapper;
    @Autowired
    private AgrAgreementAttachChangeMapper agrAgreementAttachChangeMapper;
    @Autowired
    private AgreementAttachMapper agreementAttachMapper;
    @Autowired
    private AgrSyncAddSkuToCommidityAtomService agrSyncAddSkuToCommidityAtomService;
    @Autowired
    private AgrPushLogMapper agrPushLogMapper;
    @Autowired
    private AgreementScopeMapper agreementScopeMapper;
    @Autowired
    private AgreementScopeChangeMapper agreementScopeChangeMapper;
    @Autowired
    private AgreementSkuLogMapper agreementSkuLogMapper;
    @Autowired
    private AgreementScopeLogMapper agreementScopeLogMapper;
    @Autowired
    private AgrAgreementAttachLogMapper agrAgreementAttachLogMapper;
    @Autowired
    private AgreementSettlementLogMapper agreementSettlementLogMapper;

    @Override
    public CrcAddAgreementChangeBusiRspBO addAgreementChange(CrcAddAgreementChangeBusiReqBO reqBO) {
        CrcAddAgreementChangeBusiRspBO rspBO = new CrcAddAgreementChangeBusiRspBO();
        ArrayList<AgreementSkuPO> addAgreementSkuPOList = new ArrayList<AgreementSkuPO>();
        AgreementPO qryPo = new AgreementPO();
        qryPo.setEntAgreementCode(reqBO.getEntAgreementCode());
        AgreementPO agreementPO = this.agreementMapper.getModelBy(qryPo);
        if (null == agreementPO) {
            throw new BusinessException("8888", "\u4e1a\u52a1\u5355\u4f4d\u5408\u540c\u7f16\u7801\u4e3a\u3010" + reqBO.getEntAgreementCode() + "\u3011\u5728\u5546\u57ce\u4e0d\u5b58\u5728");
        }
        int i = 0;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)reqBO.getSubjectChangeType()) && ("1".equals(reqBO.getSubjectChangeType()) || "2".equals(reqBO.getSubjectChangeType()) || "3".equals(reqBO.getSubjectChangeType()))) {
            this.createChange(reqBO.getSubjectChangeType(), reqBO, agreementPO, addAgreementSkuPOList, i);
        }
        if (!"3".equals(reqBO.getSubjectChangeType())) {
            if (null != reqBO.getExpDate()) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date expDate = null;
                try {
                    expDate = sdf1.parse(sdf.format(new Date(reqBO.getExpDate())));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                log.info("\u534f\u8bae\u5931\u6548\u65f6\u95f4" + agreementPO.getExpDate());
                log.info("\u53d8\u66f4\u534f\u8bae\u5931\u6548\u65f6\u95f4" + expDate);
                if (expDate.getTime() > agreementPO.getExpDate().getTime()) {
                    this.createChange("5", reqBO, agreementPO, addAgreementSkuPOList, i);
                }
            }
            if (!(!"7".equals(reqBO.getSubjectChangeType()) && null == reqBO.getWarantty() && CollectionUtils.isEmpty(reqBO.getScope()) && CollectionUtils.isEmpty(reqBO.getChangeAttach()) || null != reqBO.getWarantty() && reqBO.getWarantty().equals(agreementPO.getWarantty()) && CollectionUtils.isEmpty(reqBO.getScope()) && CollectionUtils.isEmpty(reqBO.getChangeAttach()))) {
                this.createChange("7", reqBO, agreementPO, addAgreementSkuPOList, i);
            }
            if (!CollectionUtils.isEmpty(reqBO.getSkuChangeList())) {
                ArrayList<AgrSkuChangeBO> addList = new ArrayList<AgrSkuChangeBO>();
                ArrayList<AgrSkuChangeBO> updateList = new ArrayList<AgrSkuChangeBO>();
                ArrayList<AgrSkuChangeBO> delList = new ArrayList<AgrSkuChangeBO>();
                for (AgrSkuChangeBO agrSkuChangeBO : reqBO.getSkuChangeList()) {
                    if (1 == agrSkuChangeBO.getChangeType()) {
                        addList.add(agrSkuChangeBO);
                        continue;
                    }
                    if (2 == agrSkuChangeBO.getChangeType()) {
                        updateList.add(agrSkuChangeBO);
                        continue;
                    }
                    if (3 == agrSkuChangeBO.getChangeType()) {
                        delList.add(agrSkuChangeBO);
                        continue;
                    }
                    throw new BusinessException("8888", agrSkuChangeBO.getSerialNo() + "\u7684\u53d8\u66f4\u7c7b\u578b\u503c\u6709\u8bef");
                }
                if (!CollectionUtils.isEmpty(addList) || !CollectionUtils.isEmpty(delList)) {
                    this.createChange("6", reqBO, agreementPO, addAgreementSkuPOList, i);
                }
                if (!CollectionUtils.isEmpty(updateList)) {
                    this.createChange("4", reqBO, agreementPO, addAgreementSkuPOList, i);
                }
            }
        }
        AgrPushLogPO agrPushLogPO = new AgrPushLogPO();
        agrPushLogPO.setId(Sequence.getInstance().nextId());
        agrPushLogPO.setSysCode(reqBO.getSysCode());
        agrPushLogPO.setPushType("3");
        agrPushLogPO.setInContent(JSONObject.toJSONString((Object)reqBO));
        agrPushLogPO.setCreateTime(new Date());
        agrPushLogPO.setIsFinish("1");
        agrPushLogPO.setSysTenantId(305775845729763327L);
        agrPushLogPO.setSysTenantName("\u534e\u6da6\u79df\u6237\u673a\u6784");
        this.agrPushLogMapper.insert(agrPushLogPO);
        rspBO.setAddAgreementSkuPOList(addAgreementSkuPOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u63a8\u9001\u6210\u529f");
        return rspBO;
    }

    public void createChange(String subjectChangeType, CrcAddAgreementChangeBusiReqBO reqBO, AgreementPO agreementPO, List<AgreementSkuPO> addAgreementSkuPOList, int i) {
        String plaAgreementChangeCode = "";
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)subjectChangeType)) {
            AgrEncodedSerialGetAbilityReqBO abilityReqBO = (AgrEncodedSerialGetAbilityReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), AgrEncodedSerialGetAbilityReqBO.class);
            abilityReqBO.setChangeType(Integer.valueOf(Integer.parseInt(subjectChangeType)));
            abilityReqBO.setPlaAgreementCode("");
            abilityReqBO.setPlaAgreementCode(agreementPO.getPlaAgreementCode());
            AgrEncodedSerialGetAbilityRspBO abilityRspBO = this.agrEncodedSerialGetAbilityService.getEncodedSerial(abilityReqBO);
            plaAgreementChangeCode = abilityRspBO.getPlaAgreementChangeCode();
        }
        Long changeId = Sequence.getInstance().nextId();
        AgrAgreementBO agrAgreementBO = new AgrAgreementBO();
        BeanUtils.copyProperties((Object)agreementPO, (Object)agrAgreementBO);
        AgreementChangePO agreementChangePO = new AgreementChangePO();
        agreementChangePO.setChangeId(changeId);
        agreementChangePO.setChangeCode(plaAgreementChangeCode);
        agreementChangePO.setSupplierId(agreementPO.getSupplierId());
        agreementChangePO.setAgreementId(agreementPO.getAgreementId());
        agreementChangePO.setAgreementVersion("V1");
        agreementChangePO.setChangeType(Byte.valueOf(subjectChangeType));
        agreementChangePO.setChangeComment(reqBO.getChangeComment());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date produceTime = null;
        Date expDate = null;
        try {
            produceTime = sdf1.parse(sdf.format(new Date(reqBO.getProduceTime())));
            if (null != reqBO.getExpDate()) {
                expDate = sdf1.parse(sdf.format(new Date(reqBO.getExpDate())));
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        agreementChangePO.setOperateTime(produceTime);
        agreementChangePO.setPreInvalidDate(agreementPO.getExpDate());
        agreementChangePO.setPostInvalidDate(expDate);
        UmcQryMemLegalOrgInfoAbilityServiceReqBO umcQryMemLegalOrgInfoAbilityServiceReqBO = new UmcQryMemLegalOrgInfoAbilityServiceReqBO();
        umcQryMemLegalOrgInfoAbilityServiceReqBO.setRegAccount(reqBO.getProducerId().toLowerCase());
        umcQryMemLegalOrgInfoAbilityServiceReqBO.setSysTenantId(reqBO.getSysTenantId());
        log.info("\u901a\u8fc7ldap\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)umcQryMemLegalOrgInfoAbilityServiceReqBO));
        UmcQryMemLegalOrgInfoAbilityServiceRspBO umcQryMemLegalOrgInfoAbilityServiceRspBO = this.umcQryMemLegalOrgInfoAbilityService.qryMemLegalOrgInfo(umcQryMemLegalOrgInfoAbilityServiceReqBO);
        log.info("\u901a\u8fc7ldap\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)umcQryMemLegalOrgInfoAbilityServiceRspBO));
        if (!"0000".equals(umcQryMemLegalOrgInfoAbilityServiceRspBO.getRespCode())) {
            throw new BusinessException("0101", umcQryMemLegalOrgInfoAbilityServiceRspBO.getRespCode());
        }
        agreementChangePO.setCreateLoginId(umcQryMemLegalOrgInfoAbilityServiceRspBO.getMemInformation().getMemId());
        agreementChangePO.setCreateName(umcQryMemLegalOrgInfoAbilityServiceRspBO.getMemInformation().getMemName2());
        agreementChangePO.setCreateTime(produceTime);
        agreementChangePO.setSubmissionTime(produceTime);
        agreementChangePO.setStatus(AgrCommConstant.ChangeApplyStatus.PASS);
        agreementChangePO.setSysTenantId(reqBO.getSysTenantId());
        agreementChangePO.setSysTenantName(reqBO.getSysTenantName());
        int count = this.agreementChangeMapper.insert(agreementChangePO);
        if (count < 1) {
            throw new BusinessException("0101", "\u63d2\u5165\u534f\u8bae\u53d8\u66f4\u8868\u5931\u8d25\uff01");
        }
        AgrAgreementMajorChangeBO abo = new AgrAgreementMajorChangeBO();
        if (null != reqBO.getWarantty()) {
            abo.setWarantty(reqBO.getWarantty());
        }
        ArrayList<AgreementSkuChangePO> agreementSkuChangePOs = new ArrayList<AgreementSkuChangePO>();
        if ("4".equals(subjectChangeType) || "6".equals(subjectChangeType)) {
            this.insertAgreementSkuChange(reqBO, agreementChangePO, agreementSkuChangePOs);
        }
        ArrayList<AgreementSettlementPO> agreementSettlementPOList = new ArrayList<AgreementSettlementPO>();
        ArrayList<AgrAgreementAttachChangePO> agreementAttachChangePOS = new ArrayList<AgrAgreementAttachChangePO>();
        if ("7".equals(subjectChangeType)) {
            this.insertAgreementChangeSubject(reqBO, agrAgreementBO, agreementChangePO, agreementSettlementPOList, agreementAttachChangePOS);
        }
        HashSet<Long> stopAgreementIds = new HashSet<Long>();
        HashSet<Long> startAgreementIds = new HashSet<Long>();
        HashSet<Long> terminationAgreementIds = new HashSet<Long>();
        HashSet<Long> changeAgreementIds = new HashSet<Long>();
        HashSet<Long> delayAgreementIds = new HashSet<Long>();
        HashSet<AgreementChangePO> delayAgreementChangePOs = new HashSet<AgreementChangePO>();
        HashSet<AgreementChangePO> terminationAgreementChangePOs = new HashSet<AgreementChangePO>();
        HashSet<Long> majorChangIds = new HashSet<Long>();
        HashSet<Long> skuChangeIds = new HashSet<Long>();
        switch (agreementChangePO.getChangeType()) {
            case 1: {
                stopAgreementIds.add(agreementChangePO.getAgreementId());
                break;
            }
            case 2: {
                startAgreementIds.add(agreementChangePO.getAgreementId());
                break;
            }
            case 3: {
                terminationAgreementIds.add(agreementChangePO.getAgreementId());
                terminationAgreementChangePOs.add(agreementChangePO);
                break;
            }
            case 4: {
                changeAgreementIds.add(agreementChangePO.getAgreementId());
                skuChangeIds.add(agreementChangePO.getChangeId());
                break;
            }
            case 5: {
                delayAgreementIds.add(agreementChangePO.getAgreementId());
                delayAgreementChangePOs.add(agreementChangePO);
                break;
            }
            case 6: {
                skuChangeIds.add(agreementChangePO.getChangeId());
                break;
            }
            case 7: {
                majorChangIds.add(agreementChangePO.getChangeId());
                break;
            }
            default: {
                throw new BusinessException("0002", "\u53d8\u66f4\u7c7b\u578b\u3010" + agreementChangePO.getChangeType() + "\u3011\u4e0d\u652f\u6301");
            }
        }
        if (!CollectionUtils.isEmpty(stopAgreementIds)) {
            HashSet<Long> startToSuspend = new HashSet<Long>();
            for (Long agreementId : stopAgreementIds) {
                startToSuspend.add(agreementId);
            }
            this.invokeAgreementStatusChange(stopAgreementIds, AgrCommConstant.CommiditySkuStatus.AGREEMENT_FREEZEN);
        }
        if (!CollectionUtils.isEmpty(startAgreementIds)) {
            HashSet<Long> frozenToStart = new HashSet<Long>();
            for (Long agreementId : startAgreementIds) {
                frozenToStart.add(agreementId);
            }
            this.invokeAgreementStatusChange(startAgreementIds, AgrCommConstant.CommiditySkuStatus.BE_SHELF);
        }
        if (!CollectionUtils.isEmpty(terminationAgreementIds)) {
            HashSet startToTermination = new HashSet();
            for (Long agreementId : terminationAgreementIds) {
                startToTermination.add(agreementId);
            }
            this.invokeAgreementStatusChange(startToTermination, AgrCommConstant.CommiditySkuStatus.AGREEMENT_FREEZEN);
            this.dealTerminationChange(terminationAgreementChangePOs);
        }
        if (!CollectionUtils.isEmpty(delayAgreementIds)) {
            log.info("\u5ef6\u671f\u53d8\u66f4\u53c2\u6570:{}", delayAgreementIds);
            for (Long agreementId : delayAgreementIds) {
                if (!agreementPO.getAgreementStatus().equals(AgrCommConstant.AgreementStatus.BE_OVERDUE)) continue;
                delayAgreementIds.remove(agreementId);
            }
            this.invokeAgreementStatusChange(delayAgreementIds, AgrCommConstant.CommiditySkuStatus.BE_SHELF);
            this.dealDelayChange(delayAgreementChangePOs);
        }
        if (!CollectionUtils.isEmpty(majorChangIds)) {
            this.dealMajorChang(reqBO, agreementPO, agreementSettlementPOList, agreementAttachChangePOS);
        }
        if (skuChangeIds.size() > 0) {
            this.updateAgreementSku(agreementSkuChangePOs, addAgreementSkuPOList);
        }
        Set<Long> agreementIdSet = this.insertLog(agreementChangePO, agrAgreementBO.getSupplierId(), abo, i);
    }

    private Set<Long> insertLog(AgreementChangePO agreementChangePO, Long supplierId, AgrAgreementMajorChangeBO abo, int i) {
        HashSet<Long> agreementIds = new HashSet<Long>();
        Long agreementLogId = this.insertAgreementLog(agreementChangePO, supplierId, abo, i);
        this.insertAgreementSkuLog(agreementChangePO, supplierId, abo, agreementLogId);
        this.insertAgreementScopeLog(agreementChangePO, supplierId, abo, agreementLogId);
        this.insertAgreementAttachLog(agreementChangePO, supplierId, agreementLogId);
        this.insertAgreementSettlementLog(agreementChangePO, supplierId, agreementLogId);
        return agreementIds;
    }

    private Long insertAgreementLog(AgreementChangePO agreementChangePO, Long supplierId, AgrAgreementMajorChangeBO abo, int j) {
        HashSet<Long> agreementIds = new HashSet<Long>();
        agreementIds.add(agreementChangePO.getAgreementId());
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(agreementChangePO.getAgreementId());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO ao = this.agreementMapper.getModelBy(agreementPO);
        Long agreementLogId = Sequence.getInstance().nextId();
        AgreementLogPO agreementLogPO = new AgreementLogPO();
        BeanUtils.copyProperties((Object)ao, (Object)agreementLogPO);
        if (abo != null) {
            if (!StringUtils.isEmpty((Object)abo.getVendorContact())) {
                agreementLogPO.setVendorContact(abo.getVendorContact());
            }
            if (!StringUtils.isEmpty((Object)abo.getVendorPhone())) {
                agreementLogPO.setVendorPhone(abo.getVendorPhone());
            }
            if (abo.getWarantty() != null) {
                agreementLogPO.setWarantty(abo.getWarantty());
            }
            if (abo.getScopeType() != null) {
                agreementLogPO.setScopeType(abo.getScopeType());
            }
            if (abo.getAdjustPrice() != null) {
                agreementLogPO.setAdjustPrice(abo.getAdjustPrice());
            }
            if (abo.getTradeMode() != null) {
                agreementLogPO.setTradeMode(abo.getTradeMode());
            }
        }
        agreementLogPO.setChangeCode(agreementChangePO.getChangeCode());
        agreementLogPO.setChangeType(agreementChangePO.getChangeType());
        if (AgrCommConstant.AgreementChangeType.DELAY.equals(agreementChangePO.getChangeType())) {
            agreementLogPO.setExpDate(agreementChangePO.getPostInvalidDate());
        }
        agreementLogPO.setChangeTime(new Date());
        agreementLogPO.setAgreementLogId(agreementLogId);
        String agreementVersion = ao.getAgreementVersion();
        String versionS = agreementVersion.substring(1);
        int versionI = Integer.parseInt(versionS);
        int i = ++versionI;
        String newAgreementVersion = "V" + i;
        agreementLogPO.setAgreementVersion(newAgreementVersion);
        agreementLogPO.setLogStatus("2");
        if (j == 0) {
            AgreementLogPO apo = new AgreementLogPO();
            apo.setAgreementId(agreementChangePO.getAgreementId());
            apo.setLogStatus("1");
            this.agreementLogMapper.updateBy(apo);
            j = 1;
        }
        int count = this.agreementLogMapper.insert(agreementLogPO);
        return agreementLogId;
    }

    private void invokeAgreementStatusChange(Set<Long> agreementIds, Byte status) {
        AgrSyncSkuStatusToCommidityAtomReqBO atomReqBO1 = new AgrSyncSkuStatusToCommidityAtomReqBO();
        atomReqBO1.setAgreementIds(agreementIds);
        atomReqBO1.setSkuStatus(status);
        log.info("\u5ef6\u671f\u534f\u8baemq\u5165\u53c2\uff1a{}", (Object)atomReqBO1);
        AgrSyncSkuStatusToCommidityAtomRspBO atomRspBO1 = this.agrSyncSkuStatusToCommidityAtomService.syncSkuStatusToCommidity(atomReqBO1);
    }

    private void dealDelayChange(Set<AgreementChangePO> delayAgreementChangePOs) {
        if (!CollectionUtils.isEmpty(delayAgreementChangePOs)) {
            for (AgreementChangePO po : delayAgreementChangePOs) {
                AgreementPO agreementPO = new AgreementPO();
                agreementPO.setSupplierId(po.getSupplierId());
                agreementPO.setAgreementId(po.getAgreementId());
                agreementPO.setExpDate(po.getPostInvalidDate());
                agreementPO.setAgreementStatus(AgrCommConstant.AgreementStatus.ENABLE);
                int count = this.agreementMapper.updateByCondition(agreementPO);
                if (count == 1) continue;
                throw new BusinessException("22005", "\u66f4\u65b0\u534f\u8bae\u8868\u534f\u8bae\u3010" + po.getAgreementId() + "\u3011\u5230\u671f\u65f6\u95f4\u5931\u8d25");
            }
        }
    }

    private void dealTerminationChange(Set<AgreementChangePO> delayAgreementChangePOs) {
        if (!CollectionUtils.isEmpty(delayAgreementChangePOs)) {
            for (AgreementChangePO po : delayAgreementChangePOs) {
                AgreementPO agreementPO = new AgreementPO();
                agreementPO.setSupplierId(po.getSupplierId());
                agreementPO.setAgreementId(po.getAgreementId());
                agreementPO.setExpDate(po.getPostInvalidDate());
                agreementPO.setAgreementStatus(AgrCommConstant.AgreementStatus.TERMINATION);
                int count = this.agreementMapper.updateByCondition(agreementPO);
                if (count == 1) continue;
                throw new BusinessException("22005", "\u66f4\u65b0\u534f\u8bae\u8868\u534f\u8bae\u3010" + po.getAgreementId() + "\u3011\u5230\u671f\u65f6\u95f4\u5931\u8d25");
            }
        }
    }

    private void dealMajorChang(CrcAddAgreementChangeBusiReqBO reqBO, AgreementPO agreementPO, List<AgreementSettlementPO> agreementSettlementPOList, List<AgrAgreementAttachChangePO> agreementAttachChangePOS) {
        if (null != reqBO.getWarantty()) {
            agreementPO.setWarantty(reqBO.getWarantty());
            int count = this.agreementMapper.updateByMajorChange(agreementPO);
            if (count != 1) {
                throw new BusinessException("22005", "\u4fee\u6539\u534f\u8bae\u8868\u5931\u8d25");
            }
        }
        if (!CollectionUtils.isEmpty(agreementSettlementPOList)) {
            AgreementSettlementPO deletePO = new AgreementSettlementPO();
            deletePO.setAgreementId(agreementPO.getAgreementId());
            this.agreementSettlementMapper.deleteBy(deletePO);
            ArrayList<AgreementSettlementPO> poList = new ArrayList<AgreementSettlementPO>();
            for (AgreementSettlementPO po : agreementSettlementPOList) {
                AgreementSettlementPO agreementSettlementPO = new AgreementSettlementPO();
                BeanUtils.copyProperties((Object)po, (Object)agreementSettlementPO);
                Long settlementId = Sequence.getInstance().nextId();
                agreementSettlementPO.setSettlementId(settlementId);
                agreementSettlementPO.setChangeId(null);
                agreementSettlementPO.setAgreementId(agreementPO.getAgreementId());
                agreementSettlementPO.setSettlementId(settlementId);
                agreementSettlementPO.setSysTenantId(305775845729763327L);
                agreementSettlementPO.setSysTenantName("\u534e\u6da6\u79df\u6237\u673a\u6784");
                poList.add(agreementSettlementPO);
            }
            this.agreementSettlementMapper.insertBatch(poList);
        }
        this.updateAgreementAttach(agreementPO, agreementAttachChangePOS);
    }

    /*
     * WARNING - void declaration
     */
    private void insertAgreementChangeSubject(CrcAddAgreementChangeBusiReqBO busiReqBO, AgrAgreementBO agrAgreementBO, AgreementChangePO agreementChangePO, List<AgreementSettlementPO> agreementSettlementPOList, List<AgrAgreementAttachChangePO> agreementAttachChangePOS) {
        void var10_16;
        AgreementMajorChangePO addAgreementMajorChangePO = new AgreementMajorChangePO();
        BeanUtils.copyProperties((Object)agrAgreementBO, (Object)addAgreementMajorChangePO);
        addAgreementMajorChangePO.setChangeId(agreementChangePO.getChangeId());
        addAgreementMajorChangePO.setChangeCode(agreementChangePO.getChangeCode());
        addAgreementMajorChangePO.setMajorChangeId(Sequence.getInstance().nextId());
        addAgreementMajorChangePO.setUpdateLoginId(agreementChangePO.getCreateLoginId());
        addAgreementMajorChangePO.setUpdateName(agreementChangePO.getCreateName());
        addAgreementMajorChangePO.setUpdateTime(agreementChangePO.getCreateTime());
        addAgreementMajorChangePO.setScopeType(agrAgreementBO.getScopeType());
        addAgreementMajorChangePO.setWarantty(busiReqBO.getWarantty());
        addAgreementMajorChangePO.setScopeType(agrAgreementBO.getScopeType());
        int count = this.agreementMajorChangeMapper.insert(addAgreementMajorChangePO);
        if (count < 1) {
            throw new BusinessException("22005", "\u65b0\u589e\u534f\u8bae\u53d8\u66f4\u4e3b\u4f53\u8868\u5931\u8d25");
        }
        List<Object> paymentMethodList = new ArrayList();
        if (CollectionUtils.isEmpty(busiReqBO.getPaymentMethod())) {
            AgreementSettlementPO record = new AgreementSettlementPO();
            record.setAgreementId(agrAgreementBO.getAgreementId());
            List<AgreementSettlementPO> list = this.agreementSettlementMapper.getList(record);
            for (AgreementSettlementPO agreementSettlementPO : list) {
                AgreementSettlementBO agreementSettlementBO = new AgreementSettlementBO();
                BeanUtils.copyProperties((Object)agreementSettlementPO, (Object)agreementSettlementBO);
                paymentMethodList.add(agreementSettlementBO);
            }
        } else {
            paymentMethodList = busiReqBO.getPaymentMethod();
        }
        if (paymentMethodList == null) {
            throw new BusinessException("0101", "\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u53ef\u4e3a\u7a7a");
        }
        for (AgreementSettlementBO agreementSettlementBO : paymentMethodList) {
            AgreementSettlementPO asp = new AgreementSettlementPO();
            BeanUtils.copyProperties((Object)agreementSettlementBO, (Object)asp);
            asp.setChangeId(agreementChangePO.getChangeId());
            asp.setAgreementId(null);
            Long l = Sequence.getInstance().nextId();
            asp.setSettlementId(l);
            asp.setSettlementDate("60");
            asp.setAssign("2");
            asp.setSysTenantId(305775845729763327L);
            asp.setSysTenantName("\u534e\u6da6\u79df\u6237\u673a\u6784");
            agreementSettlementPOList.add(asp);
        }
        int insertResult = this.agreementSettlementMapper.insertBatch(agreementSettlementPOList);
        if (insertResult != agreementSettlementPOList.size()) {
            throw new BusinessException("0101", "\u65b0\u589e\u4ed8\u6b3e\u65b9\u5f0f\u5931\u8d25\uff01");
        }
        ArrayList<AgrAgreementAttachBO> arrayList = new ArrayList<AgrAgreementAttachBO>();
        if (CollectionUtils.isEmpty(busiReqBO.getChangeAttach())) {
            AgreementAttachPO agreementAttachPO = new AgreementAttachPO();
            agreementAttachPO.setAgreementId(agrAgreementBO.getAgreementId());
            List<AgreementAttachPO> list = this.agreementAttachMapper.getList(agreementAttachPO);
            for (AgreementAttachPO attachPO : list) {
                AgrAgreementAttachBO agrAgreementAttachBO = new AgrAgreementAttachBO();
                BeanUtils.copyProperties((Object)attachPO, (Object)agrAgreementAttachBO);
                arrayList.add(agrAgreementAttachBO);
            }
        } else {
            List<AgrAgreementAttachBO> list = busiReqBO.getChangeAttach();
        }
        if (!CollectionUtils.isEmpty((Collection)var10_16)) {
            void var12_28;
            for (AgrAgreementAttachBO agrAgreementAttachBO : var10_16) {
                AgrAgreementAttachChangePO agrAgreementAttachChangePO = new AgrAgreementAttachChangePO();
                agrAgreementAttachChangePO.setAttachmentChangeId(Sequence.getInstance().nextId());
                agrAgreementAttachChangePO.setAttachmentId(Sequence.getInstance().nextId());
                agrAgreementAttachChangePO.setChangeId(agreementChangePO.getChangeId());
                agrAgreementAttachChangePO.setChangeCode(agreementChangePO.getChangeCode());
                agrAgreementAttachChangePO.setAgreementId(agrAgreementBO.getAgreementId());
                agrAgreementAttachChangePO.setAgreementVersion(agrAgreementBO.getAgreementVersion());
                agrAgreementAttachChangePO.setSupplierId(agreementChangePO.getSupplierId());
                agrAgreementAttachChangePO.setAttachmentName(agrAgreementAttachBO.getAttachmentName());
                agrAgreementAttachChangePO.setAttachmentAddr(agrAgreementAttachBO.getAttachmentAddr());
                agrAgreementAttachChangePO.setCreateLoginId(agreementChangePO.getCreateLoginId());
                agrAgreementAttachChangePO.setCreateName(agreementChangePO.getCreateName());
                agrAgreementAttachChangePO.setCreateTime(agreementChangePO.getCreateTime());
                agrAgreementAttachChangePO.setRemark(agrAgreementAttachBO.getRemark());
                agrAgreementAttachChangePO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
                agrAgreementAttachChangePO.setAttachmentType((byte)1);
                agrAgreementAttachChangePO.setSysTenantId(agreementChangePO.getSysTenantId());
                agrAgreementAttachChangePO.setSysTenantName(agreementChangePO.getSysTenantName());
                agreementAttachChangePOS.add(agrAgreementAttachChangePO);
            }
            int isInsert5 = this.agrAgreementAttachChangeMapper.insertBatch(agreementAttachChangePOS);
            if (isInsert5 != agreementAttachChangePOS.size()) {
                throw new BusinessException("0101", "\u63d2\u5165\u534f\u8bae\u9644\u4ef6\u53d8\u66f4\u8868\u5931\u8d25\uff01");
            }
            ArrayList<CrcAgreementScopeBO> arrayList2 = new ArrayList<CrcAgreementScopeBO>();
            if (CollectionUtils.isEmpty(busiReqBO.getScope())) {
                AgreementScopePO agreementScopePO = new AgreementScopePO();
                agreementScopePO.setAgreementId(agrAgreementBO.getAgreementId());
                List<AgreementScopePO> agreementScopePOList = this.agreementScopeMapper.getList(agreementScopePO);
                Iterator iterator = agreementScopePOList.iterator();
                while (iterator.hasNext()) {
                    AgreementScopePO scopePO = (AgreementScopePO)iterator.next();
                    CrcAgreementScopeBO crcAgreementScopeBO = new CrcAgreementScopeBO();
                    BeanUtils.copyProperties((Object)scopePO, (Object)crcAgreementScopeBO);
                    crcAgreementScopeBO.setScopeCode(scopePO.getScopeCode().toString());
                    arrayList2.add(crcAgreementScopeBO);
                }
            } else {
                List<CrcAgreementScopeBO> list = busiReqBO.getScope();
            }
            ArrayList<AgreementScopeChangePO> agreementScopeChangePOS = new ArrayList<AgreementScopeChangePO>();
            if (!CollectionUtils.isEmpty((Collection)var12_28)) {
                for (CrcAgreementScopeBO crcAgreementScopeBO : var12_28) {
                    AgreementScopeChangePO agreementScopeChangePO = new AgreementScopeChangePO();
                    Long scopeChangeId = Sequence.getInstance().nextId();
                    Long scopeId = Sequence.getInstance().nextId();
                    agreementScopeChangePO.setChangeId(agreementChangePO.getChangeId());
                    agreementScopeChangePO.setScopeChangeId(scopeChangeId);
                    agreementScopeChangePO.setScopeId(scopeId);
                    agreementScopeChangePO.setAgreementId(agrAgreementBO.getAgreementId());
                    agreementScopeChangePO.setAgreementVersion(agrAgreementBO.getAgreementVersion());
                    agreementScopeChangePO.setSupplierId(agreementChangePO.getSupplierId());
                    agreementScopeChangePO.setScopeType(addAgreementMajorChangePO.getScopeType());
                    agreementScopeChangePO.setScopeCode(Long.parseLong(crcAgreementScopeBO.getScopeCode()));
                    agreementScopeChangePO.setScopeName(crcAgreementScopeBO.getScopeName());
                    agreementScopeChangePO.setRemark(crcAgreementScopeBO.getRemark());
                    agreementScopeChangePO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
                    agreementScopeChangePO.setCreateTime(new Date());
                    agreementScopeChangePO.setChangeCode(agreementChangePO.getChangeCode());
                    agreementScopeChangePO.setSysTenantId(busiReqBO.getSysTenantId());
                    agreementScopeChangePO.setSysTenantName(busiReqBO.getSysTenantName());
                    agreementScopeChangePOS.add(agreementScopeChangePO);
                }
                int isInsert4 = this.agreementScopeChangeMapper.insertBatch(agreementScopeChangePOS);
                if (isInsert4 != agreementScopeChangePOS.size()) {
                    throw new BusinessException("0101", "\u63d2\u5165\u534f\u8bae\u5e94\u7528\u8303\u56f4\u53d8\u66f4\u8868\u5931\u8d25\uff01");
                }
            }
        }
    }

    private void insertAgreementSkuChange(CrcAddAgreementChangeBusiReqBO busiReqBO, AgreementChangePO agreementChangePO, List<AgreementSkuChangePO> agreementSkuChangePOs) {
        if (!CollectionUtils.isEmpty(busiReqBO.getSkuChangeList())) {
            UccQueryCatalogByMaterialAbilityReqBO uccQueryCatalogByMaterialAbilityReqBO = new UccQueryCatalogByMaterialAbilityReqBO();
            ArrayList<UccQueryCatalogByMaterialBO> rows = new ArrayList<UccQueryCatalogByMaterialBO>();
            for (AgrSkuChangeBO bo : busiReqBO.getSkuChangeList()) {
                bo.setSkuChangeId(Long.valueOf(Sequence.getInstance().nextId()));
                Object agreementSkuPO = new AgreementSkuPO();
                if (2 == bo.getChangeType() || 3 == bo.getChangeType()) {
                    AgreementSkuPO qryPO = new AgreementSkuPO();
                    qryPO.setSerialNo(bo.getSerialNo());
                    qryPO.setAgreementId(agreementChangePO.getAgreementId());
                    agreementSkuPO = this.agreementSkuMapper.getModelBy(qryPO);
                    if (null == agreementSkuPO) {
                        throw new BusinessException("8888", "\u534f\u8bae\u660e\u7ec6\u884c\u53f7\u4e3a\u3010" + bo.getSerialNo() + "\u3011\u5728\u5e93\u91cc\u4e0d\u5b58\u5728");
                    }
                    bo.setAgreementSkuId(((AgreementSkuPO)agreementSkuPO).getAgreementSkuId());
                    bo.setAgreementId(((AgreementSkuPO)agreementSkuPO).getAgreementId());
                }
                UccQueryCatalogByMaterialBO uccQueryCatalogByMaterialBO = new UccQueryCatalogByMaterialBO();
                if (null == ((AgreementSkuPO)agreementSkuPO).getAgreementSkuId()) {
                    bo.setAgreementSkuId(Long.valueOf(Sequence.getInstance().nextId()));
                }
                uccQueryCatalogByMaterialBO.setAgreementDetailsId(bo.getAgreementSkuId());
                uccQueryCatalogByMaterialBO.setMaterialCode(bo.getMaterialCode());
                uccQueryCatalogByMaterialBO.setMeasureName(bo.getMeasureName());
                uccQueryCatalogByMaterialBO.setBrandName(bo.getBrandName());
                rows.add(uccQueryCatalogByMaterialBO);
            }
            uccQueryCatalogByMaterialAbilityReqBO.setMaterials(rows);
            log.info("\u5546\u54c1\u7c7b\u578b\u67e5\u8be2\u5165\u53c2uccAgrSkuImportCheckAbilityReqBO:" + JSON.toJSONString((Object)uccQueryCatalogByMaterialAbilityReqBO));
            UccQueryCatalogByMaterialAbilityRspBO uccQueryCatalogByMaterialAbilityRspBO = this.uccQueryCatalogByMaterialAbilityService.qryCatalog(uccQueryCatalogByMaterialAbilityReqBO);
            log.info("\u5546\u54c1\u7c7b\u578b\u67e5\u8be2\u51fa\u53c2uccAgrSkuImportCheckAbilityRspBO:" + JSON.toJSONString((Object)uccQueryCatalogByMaterialAbilityRspBO));
            if (!"0000".equals(uccQueryCatalogByMaterialAbilityRspBO.getRespCode())) {
                throw new BusinessException("8888", uccQueryCatalogByMaterialAbilityRspBO.getRespDesc());
            }
            Map<Long, UccQueryCatalogByMaterialBO> commodityMap = uccQueryCatalogByMaterialAbilityRspBO.getMaterials().stream().collect(Collectors.toMap(item -> item.getAgreementDetailsId(), item -> item, (item1, item2) -> item1));
            for (AgrSkuChangeBO bo : busiReqBO.getSkuChangeList()) {
                AgreementSkuChangePO agreementSkuChangePO = new AgreementSkuChangePO();
                BeanUtils.copyProperties((Object)bo, (Object)agreementSkuChangePO);
                agreementSkuChangePO.setSupplierId(agreementChangePO.getSupplierId());
                agreementSkuChangePO.setAgreementVersion(agreementChangePO.getAgreementVersion());
                agreementSkuChangePO.setChangeCode(agreementChangePO.getChangeCode());
                agreementSkuChangePO.setChangeId(agreementChangePO.getChangeId());
                UccQueryCatalogByMaterialBO uccQueryCatalogByMaterialBO = commodityMap.get(bo.getAgreementSkuId());
                if (null == uccQueryCatalogByMaterialBO.getMaterialId()) {
                    throw new BusinessException("8888", "e\u8d2d\u7269\u6599\u7f16\u7801" + bo.getMaterialCode() + "\u5728\u5546\u57ce\u91cc\u4e0d\u5b58\u5728");
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)uccQueryCatalogByMaterialBO.getBrandName())) {
                    throw new BusinessException("8888", "e\u8d2d\u7269\u6599\u7f16\u7801" + bo.getMaterialCode() + "\u7684\u54c1\u724c\u5728\u5546\u57ce\u91cc\u4e0d\u5b58\u5728");
                }
                log.info("uccAgrSkuImportCheckBO=>" + JSON.toJSONString((Object)uccQueryCatalogByMaterialBO));
                agreementSkuChangePO.setCommodityTypeId(uccQueryCatalogByMaterialBO.getCommodityTypeId());
                agreementSkuChangePO.setCommodityTypeName(uccQueryCatalogByMaterialBO.getCommodityTypeName());
                agreementSkuChangePO.setCatalogId(uccQueryCatalogByMaterialBO.getCatalogId());
                agreementSkuChangePO.setCatalogName(uccQueryCatalogByMaterialBO.getCatalogName());
                if (null != uccQueryCatalogByMaterialBO.getMaterialId()) {
                    agreementSkuChangePO.setMaterialId(uccQueryCatalogByMaterialBO.getMaterialId().toString());
                }
                agreementSkuChangePO.setBrandId(uccQueryCatalogByMaterialBO.getBrandId());
                agreementSkuChangePO.setBrandName(uccQueryCatalogByMaterialBO.getBrandName());
                agreementSkuChangePO.setMeasureId(uccQueryCatalogByMaterialBO.getMeasureId());
                agreementSkuChangePO.setMeasureName(uccQueryCatalogByMaterialBO.getMeasureName());
                agreementSkuChangePO.setMaterialName(uccQueryCatalogByMaterialBO.getMaterialName());
                agreementSkuChangePO.setIsDelete((byte)0);
                agreementSkuChangePO.setAgreementId(agreementChangePO.getAgreementId());
                DecimalFormat df = new DecimalFormat("0.0000");
                BigDecimal bigDecimal = new BigDecimal(bo.getSalePrice());
                BigDecimal bigDecimal1 = new BigDecimal(bo.getSalePriceSum());
                String salePrice = df.format(bigDecimal);
                String salePriceSum = df.format(bigDecimal1);
                agreementSkuChangePO.setSalePrice(new BigDecimal(salePrice).multiply(new BigDecimal(10000)).longValue());
                agreementSkuChangePO.setSalePriceSum(new BigDecimal(salePriceSum).multiply(new BigDecimal(10000)).longValue());
                agreementSkuChangePO.setBuyPrice(agreementSkuChangePO.getSalePrice());
                agreementSkuChangePO.setBuyPriceSum(agreementSkuChangePO.getSalePriceSum());
                agreementSkuChangePO.setBuyNumber(null == bo.getBuyNumber() ? null : bo.getBuyNumber());
                agreementSkuChangePO.setMarkupRate(null == bo.getMarkupRate() ? null : bo.getMarkupRate());
                Date date = new Date();
                try {
                    date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(bo.getCreateTime());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                agreementSkuChangePO.setCreateTime(date);
                agreementSkuChangePO.setEbsMaterialCode(bo.getEbsMaterialCode());
                agreementSkuChangePO.setMaterialCode(bo.getMaterialCode());
                agreementSkuChangePO.setVendorMaterialCode(bo.getVendorMaterialCode());
                agreementSkuChangePO.setVendorMaterialName(bo.getVendorMaterialName());
                agreementSkuChangePO.setAgreementVersion("V1");
                agreementSkuChangePO.setSkuStatus((byte)20);
                if (null == bo.getIsOil()) {
                    agreementSkuChangePO.setIsOil((byte)0);
                }
                agreementSkuChangePO.setSysTenantId(305775845729763327L);
                agreementSkuChangePO.setSysTenantName("\u534e\u6da6\u79df\u6237\u673a\u6784");
                agreementSkuChangePOs.add(agreementSkuChangePO);
            }
            int isInsert = this.agreementSkuChangeMapper.insertBatch(agreementSkuChangePOs);
            if (isInsert != agreementSkuChangePOs.size()) {
                throw new BusinessException("22003", "\u534f\u8bae\u660e\u7ec6\u53d8\u66f4\u8868\u65b0\u589e\u5931\u8d25\uff01");
            }
        }
    }

    private void updateAgreementAttach(AgreementPO agreementPO, List<AgrAgreementAttachChangePO> agreementAttachChangePOS) {
        if (!CollectionUtils.isEmpty(agreementAttachChangePOS)) {
            AgreementAttachPO agreementAttachPO = new AgreementAttachPO();
            agreementAttachPO.setAgreementId(agreementPO.getAgreementId());
            this.agreementAttachMapper.deleteBy(agreementAttachPO);
            ArrayList<AgreementAttachPO> addAgreementAttachPOList = new ArrayList<AgreementAttachPO>();
            for (AgrAgreementAttachChangePO agrAgreementAttachChangePO1 : agreementAttachChangePOS) {
                AgreementAttachPO agreementAttachPO1 = new AgreementAttachPO();
                BeanUtils.copyProperties((Object)agrAgreementAttachChangePO1, (Object)agreementAttachPO1);
                addAgreementAttachPOList.add(agreementAttachPO1);
            }
            int count2 = this.agreementAttachMapper.insertBatch(addAgreementAttachPOList);
            if (count2 < addAgreementAttachPOList.size()) {
                throw new BusinessException("22005", "\u65b0\u589e\u534f\u8bae\u9644\u4ef6\u8868\u5931\u8d25");
            }
        }
    }

    private void updateAgreementSku(List<AgreementSkuChangePO> agreementSkuChangePOs, List<AgreementSkuPO> addAgreementSkuPOList) {
        ArrayList<AgreementSkuPO> updateAgreementSkuPOList = new ArrayList<AgreementSkuPO>();
        ArrayList<AgreementSkuPO> deleteAgreementSkuPOList = new ArrayList<AgreementSkuPO>();
        this.dealSkuChang(agreementSkuChangePOs, addAgreementSkuPOList, updateAgreementSkuPOList, deleteAgreementSkuPOList);
        if (!CollectionUtils.isEmpty(addAgreementSkuPOList)) {
            ArrayList<AgreementSkuPO> list = new ArrayList<AgreementSkuPO>();
            for (AgreementSkuPO agreementSkuPO : addAgreementSkuPOList) {
                AgreementSkuPO addAgreementSkuPO = new AgreementSkuPO();
                BeanUtils.copyProperties((Object)agreementSkuPO, (Object)addAgreementSkuPO);
                addAgreementSkuPO.setAgreementSkuId(Sequence.getInstance().nextId());
                list.add(addAgreementSkuPO);
            }
            int count = this.agreementSkuMapper.insertBatch(list);
            if (count != list.size()) {
                throw new BusinessException("22005", "\u65b0\u589e\u534f\u8bae\u660e\u7ec6\u8868\u5931\u8d25");
            }
        }
        if (!CollectionUtils.isEmpty(updateAgreementSkuPOList)) {
            ArrayList<AgrskuChangePriceBO> skuChangePriceBOs = new ArrayList<AgrskuChangePriceBO>();
            for (AgreementSkuPO agreementSkuPO : updateAgreementSkuPOList) {
                AgreementSkuPO updateAgreementSkuPO = new AgreementSkuPO();
                BeanUtils.copyProperties((Object)agreementSkuPO, (Object)updateAgreementSkuPO);
                AgrskuChangePriceBO bo = new AgrskuChangePriceBO();
                if (StringUtils.hasText((String)agreementSkuPO.getExtField1()) && StringUtils.hasText((String)agreementSkuPO.getExtField2())) {
                    updateAgreementSkuPO.setBuyNumber(agreementSkuPO.getBuyNumber().add(new BigDecimal(agreementSkuPO.getExtField1()).subtract(new BigDecimal(agreementSkuPO.getExtField2()))));
                    bo.setBuyNumber(new BigDecimal(agreementSkuPO.getExtField1()).subtract(new BigDecimal(agreementSkuPO.getExtField2())));
                }
                updateAgreementSkuPO.setExtField1(null);
                updateAgreementSkuPO.setExtField2(null);
                updateAgreementSkuPO.setExtField3(null);
                int count = this.agreementSkuMapper.updateBy(updateAgreementSkuPO);
                if (count < 1) {
                    throw new BusinessException("22005", "\u4fee\u6539\u534f\u8bae\u660e\u7ec6\u8868\u5931\u8d25");
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)agreementSkuPO.getExtField6())) {
                    bo.setExtField6(null);
                } else {
                    bo.setExtField6(agreementSkuPO.getExtField6());
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)agreementSkuPO.getExtField7())) {
                    bo.setExtField7(null);
                } else {
                    bo.setExtField7(agreementSkuPO.getExtField7());
                }
                bo.setAgreementId(agreementSkuPO.getAgreementId());
                bo.setAgreementSkuId(agreementSkuPO.getAgreementSkuId());
                bo.setBuyPrice(agreementSkuPO.getBuyPrice());
                bo.setSalePrice(agreementSkuPO.getSalePrice());
                skuChangePriceBOs.add(bo);
            }
            AgrSyncSkuStatusToCommidityAtomReqBO atomReqBO = new AgrSyncSkuStatusToCommidityAtomReqBO();
            atomReqBO.setSkuChangePriceBOs(skuChangePriceBOs);
            Object atomRspBO = this.agrSyncSkuStatusToCommidityAtomService.syncSkuStatusToCommidity(atomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new BusinessException(atomRspBO.getRespCode(), atomRspBO.getRespCode());
            }
        }
        if (!CollectionUtils.isEmpty(deleteAgreementSkuPOList)) {
            ArrayList<Long> agreementSkuIds = new ArrayList<Long>();
            HashSet<Long> agreementIds = new HashSet<Long>();
            for (AgreementSkuPO agreementSkuPO : deleteAgreementSkuPOList) {
                agreementSkuIds.add(agreementSkuPO.getAgreementSkuId());
                agreementIds.add(agreementSkuPO.getAgreementId());
            }
            AgreementSkuPO agreementSkuPO1 = new AgreementSkuPO();
            agreementSkuPO1.setAgreementSkuIds(agreementSkuIds);
            agreementSkuPO1.setAgreementIds(agreementIds);
            int count = this.agreementSkuMapper.deleteBy(agreementSkuPO1);
            if (count != agreementSkuIds.size()) {
                throw new BusinessException("22005", "\u5220\u9664\u534f\u8bae\u660e\u7ec6\u8868\u5931\u8d25");
            }
            AgrSyncSkuStatusToCommidityAtomReqBO atomReqBO = new AgrSyncSkuStatusToCommidityAtomReqBO();
            atomReqBO.setSkuStatus(AgrCommConstant.CommiditySkuStatus.INVALID);
            atomReqBO.setAgreementSkuIds(new HashSet<Long>(agreementSkuIds));
            AgrSyncSkuStatusToCommidityAtomRspBO atomRspBO = this.agrSyncSkuStatusToCommidityAtomService.syncSkuStatusToCommidity(atomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new BusinessException(atomRspBO.getRespCode(), atomRspBO.getRespCode());
            }
        }
    }

    private void dealSkuChang(List<AgreementSkuChangePO> list, List<AgreementSkuPO> addAgreementSkuPOList, List<AgreementSkuPO> updateAgreementSkuPOList, List<AgreementSkuPO> deleteAgreementSkuPOList) {
        if (!CollectionUtils.isEmpty(list)) {
            for (AgreementSkuChangePO agreementSkuChangePO1 : list) {
                AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
                if (AgrCommConstant.AgreementSkuChangeType.ADD.equals(agreementSkuChangePO1.getChangeType())) {
                    BeanUtils.copyProperties((Object)agreementSkuChangePO1, (Object)agreementSkuPO);
                    agreementSkuPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
                    addAgreementSkuPOList.add(agreementSkuPO);
                    continue;
                }
                if (AgrCommConstant.AgreementSkuChangeType.UPDATE.equals(agreementSkuChangePO1.getChangeType())) {
                    agreementSkuPO.setAgreementSkuId(agreementSkuChangePO1.getAgreementSkuId());
                    agreementSkuPO.setBuyPrice(agreementSkuChangePO1.getBuyPrice());
                    agreementSkuPO.setBuyPriceSum(agreementSkuChangePO1.getBuyPriceSum());
                    agreementSkuPO.setSalePrice(agreementSkuChangePO1.getSalePrice());
                    agreementSkuPO.setSalePriceSum(agreementSkuChangePO1.getSalePriceSum());
                    agreementSkuPO.setMarkupRate(agreementSkuChangePO1.getMarkupRate());
                    agreementSkuPO.setUpdateLoginId(agreementSkuChangePO1.getCreateLoginId());
                    agreementSkuPO.setUpdateName(agreementSkuChangePO1.getCreateName());
                    agreementSkuPO.setAgreementId(agreementSkuChangePO1.getAgreementId());
                    agreementSkuPO.setBuyNumber(agreementSkuChangePO1.getBuyNumber());
                    agreementSkuPO.setExtField1(agreementSkuChangePO1.getExtField1());
                    agreementSkuPO.setExtField2(agreementSkuChangePO1.getExtField2());
                    agreementSkuPO.setExtField6(agreementSkuChangePO1.getExtField6());
                    agreementSkuPO.setExtField7(agreementSkuChangePO1.getExtField7());
                    agreementSkuPO.setCommodityTypeName(agreementSkuChangePO1.getCommodityTypeName());
                    agreementSkuPO.setCommodityTypeId(agreementSkuChangePO1.getCommodityTypeId());
                    updateAgreementSkuPOList.add(agreementSkuPO);
                    continue;
                }
                agreementSkuPO.setAgreementSkuId(agreementSkuChangePO1.getAgreementSkuId());
                agreementSkuPO.setUpdateLoginId(agreementSkuChangePO1.getCreateLoginId());
                agreementSkuPO.setUpdateTime(agreementSkuChangePO1.getCreateTime());
                agreementSkuPO.setUpdateName(agreementSkuChangePO1.getCreateName());
                agreementSkuPO.setIsDelete(AgrCommConstant.IsDelete.DELETED);
                agreementSkuPO.setAgreementId(agreementSkuChangePO1.getAgreementId());
                deleteAgreementSkuPOList.add(agreementSkuPO);
            }
        }
    }

    private void insertAgreementSkuLog(AgreementChangePO agreementChangePO, Long supplierId, AgrAgreementMajorChangeBO abo, Long agreementLogId) {
        int count;
        log.info("\u8fdb\u5165\u534f\u8bae\u660e\u7ec6\u65e5\u5fd7\u65b0\u589e");
        AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
        agreementSkuPO.setSupplierId(supplierId);
        agreementSkuPO.setAgreementId(agreementChangePO.getAgreementId());
        agreementSkuPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementSkuPO> agreementSkuList = this.agreementSkuMapper.getList(agreementSkuPO);
        ArrayList<AgreementSkuLogPO> agreementSkuLogPOList = new ArrayList<AgreementSkuLogPO>();
        for (AgreementSkuPO agreementSkuPO1 : agreementSkuList) {
            AgreementSkuLogPO agreementSkuLogPO = new AgreementSkuLogPO();
            BeanUtils.copyProperties((Object)agreementSkuPO1, (Object)agreementSkuLogPO);
            agreementSkuLogPO.setAgreementLogId(agreementLogId);
            agreementSkuLogPO.setMarkupRate(0.0);
            agreementSkuLogPOList.add(agreementSkuLogPO);
        }
        if (!CollectionUtils.isEmpty(agreementSkuLogPOList) && (count = this.agreementSkuLogMapper.insertBatch(agreementSkuLogPOList)) != agreementSkuLogPOList.size()) {
            throw new BusinessException("22003", "\u65b0\u589e\u534f\u8bae\u660e\u7ec6\u65e5\u5fd7\u8868\u5931\u8d25");
        }
    }

    private void insertAgreementScopeLog(AgreementChangePO agreementChangePO, Long supplierId, AgrAgreementMajorChangeBO abo, Long agreementLogId) {
        int count;
        AgreementScopePO agreementScopePO = new AgreementScopePO();
        agreementScopePO.setSupplierId(supplierId);
        agreementScopePO.setAgreementId(agreementChangePO.getAgreementId());
        agreementScopePO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementScopePO> agreementScopeList = this.agreementScopeMapper.getList(agreementScopePO);
        ArrayList<AgreementScopeLogPO> agreementScopeLogPOList = new ArrayList<AgreementScopeLogPO>();
        for (AgreementScopePO agreementScopePO1 : agreementScopeList) {
            AgreementScopeLogPO agreementScopeLogPO = new AgreementScopeLogPO();
            BeanUtils.copyProperties((Object)agreementScopePO1, (Object)agreementScopeLogPO);
            agreementScopeLogPO.setAgreementLogId(agreementLogId);
            agreementScopeLogPOList.add(agreementScopeLogPO);
        }
        if (!CollectionUtils.isEmpty(agreementScopeLogPOList) && (count = this.agreementScopeLogMapper.insertBatch(agreementScopeLogPOList)) != agreementScopeLogPOList.size()) {
            throw new BusinessException("22003", "\u65b0\u589e\u534f\u8bae\u8303\u56f4\u65e5\u5fd7\u8868\u5931\u8d25");
        }
    }

    private void insertAgreementAttachLog(AgreementChangePO agreementChangePO, Long supplierId, Long agreementLogId) {
        int count;
        AgreementAttachPO agreementAttachPO = new AgreementAttachPO();
        agreementAttachPO.setSupplierId(supplierId);
        agreementAttachPO.setAgreementId(agreementChangePO.getAgreementId());
        agreementAttachPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementAttachPO> agreementAttachList = this.agreementAttachMapper.getList(agreementAttachPO);
        ArrayList<AgrAgreementAttachLogPO> agrAgreementAttachLogPOList = new ArrayList<AgrAgreementAttachLogPO>();
        for (AgreementAttachPO agreementAttachPO1 : agreementAttachList) {
            AgrAgreementAttachLogPO agrAgreementAttachLogPO = new AgrAgreementAttachLogPO();
            BeanUtils.copyProperties((Object)agreementAttachPO1, (Object)agrAgreementAttachLogPO);
            agrAgreementAttachLogPO.setAgreementLogId(agreementLogId);
            agrAgreementAttachLogPOList.add(agrAgreementAttachLogPO);
        }
        if (!CollectionUtils.isEmpty(agrAgreementAttachLogPOList) && (count = this.agrAgreementAttachLogMapper.insertBatch(agrAgreementAttachLogPOList)) != agrAgreementAttachLogPOList.size()) {
            throw new BusinessException("22003", "\u65b0\u589e\u534f\u8bae\u9644\u4ef6\u65e5\u5fd7\u8868\u5931\u8d25");
        }
    }

    private void insertAgreementSettlementLog(AgreementChangePO agreementChangePO, Long supplierId, Long agreementLogId) {
        int count;
        AgreementSettlementPO agreementSettlementPO = new AgreementSettlementPO();
        agreementSettlementPO.setAgreementId(agreementChangePO.getAgreementId());
        List<AgreementSettlementPO> list = this.agreementSettlementMapper.getList(agreementSettlementPO);
        ArrayList<AgreementSettlementLogPO> agreementSettlementLogPOList = new ArrayList<AgreementSettlementLogPO>();
        for (AgreementSettlementPO as : list) {
            AgreementSettlementLogPO agreementSettlementLogPO = new AgreementSettlementLogPO();
            BeanUtils.copyProperties((Object)as, (Object)agreementSettlementLogPO);
            Long settleMentLogId = Sequence.getInstance().nextId();
            agreementSettlementLogPO.setAgreementLogId(agreementLogId);
            agreementSettlementLogPO.setSettlementLogId(settleMentLogId);
            agreementSettlementLogPOList.add(agreementSettlementLogPO);
        }
        if (!CollectionUtils.isEmpty(agreementSettlementLogPOList) && (count = this.agreementSettlementLogMapper.insertBatch(agreementSettlementLogPOList)) != agreementSettlementLogPOList.size()) {
            throw new BusinessException("22003", "\u65b0\u589e\u534f\u8bae\u660e\u7ec6\u65e5\u5fd7\u8868\u5931\u8d25");
        }
    }
}

