/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.api.CrcAddAgreementChangeAbilityService;
import com.tydic.agreement.ability.bo.AgrSkuChangeBO;
import com.tydic.agreement.ability.bo.CrcAddAgreementChangeAbilityReqBO;
import com.tydic.agreement.ability.bo.CrcAddAgreementChangeAbilityRspBO;
import com.tydic.agreement.ability.bo.CrcAgreementScopeBO;
import com.tydic.agreement.atom.api.AgrSyncAddSkuToCommidityAtomService;
import com.tydic.agreement.atom.bo.AgrSyncAddSkuToCommidityAtomReqBO;
import com.tydic.agreement.atom.bo.AgrSyncAddSkuToCommidityAtomRspBO;
import com.tydic.agreement.busi.api.CrcAddAgreementChangeBusiService;
import com.tydic.agreement.busi.bo.CrcAddAgreementChangeBusiReqBO;
import com.tydic.agreement.busi.bo.CrcAddAgreementChangeBusiRspBO;
import com.tydic.agreement.dao.AgrPushLogMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgrPushLogPO;
import com.tydic.agreement.po.AgreementSkuPO;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGREEMENT_GROUP_DEV/2.1.0/com.tydic.agreement.ability.api.CrcAddAgreementChangeAbilityService"})
public class CrcAddAgreementChangeAbilityServiceImpl
implements CrcAddAgreementChangeAbilityService {
    @Autowired
    private CrcAddAgreementChangeBusiService crcAddAgreementChangeBusiService;
    @Autowired
    private AgrPushLogMapper agrPushLogMapper;
    @Autowired
    private AgrSyncAddSkuToCommidityAtomService agrSyncAddSkuToCommidityAtomService;

    @PostMapping(value={"addAgreementChange"})
    public CrcAddAgreementChangeAbilityRspBO addAgreementChange(@RequestBody CrcAddAgreementChangeAbilityReqBO reqBO) {
        CrcAddAgreementChangeAbilityRspBO rspBO = new CrcAddAgreementChangeAbilityRspBO();
        AgrPushLogPO agrPushLogPO = new AgrPushLogPO();
        agrPushLogPO.setId(Sequence.getInstance().nextId());
        agrPushLogPO.setSysCode(reqBO.getSysCode());
        agrPushLogPO.setPushType("3");
        agrPushLogPO.setInContent(JSONObject.toJSONString((Object)reqBO));
        agrPushLogPO.setCreateTime(new Date());
        this.validateParam(reqBO);
        CrcAddAgreementChangeBusiReqBO busiReqBO = (CrcAddAgreementChangeBusiReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue}), CrcAddAgreementChangeBusiReqBO.class);
        CrcAddAgreementChangeBusiRspBO busiRspBO = this.crcAddAgreementChangeBusiService.addAgreementChange(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            agrPushLogPO.setIsFinish("0");
            agrPushLogPO.setFailReason(busiRspBO.getRespDesc());
            agrPushLogPO.setSysTenantId(305775845729763327L);
            agrPushLogPO.setSysTenantName("\u534e\u6da6\u79df\u6237\u673a\u6784");
            this.agrPushLogMapper.insert(agrPushLogPO);
        }
        if (!CollectionUtils.isEmpty(busiRspBO.getAddAgreementSkuPOList())) {
            for (AgreementSkuPO agreementSkuPO : busiRspBO.getAddAgreementSkuPOList()) {
                AgrSyncAddSkuToCommidityAtomReqBO atomReqBO = new AgrSyncAddSkuToCommidityAtomReqBO();
                atomReqBO.setAgreementId(agreementSkuPO.getAgreementId());
                atomReqBO.setAgreementSkuId(agreementSkuPO.getAgreementSkuId());
                AgrSyncAddSkuToCommidityAtomRspBO atomRspBO = this.agrSyncAddSkuToCommidityAtomService.syncAddSkuToCommidity(atomReqBO);
                if ("0000".equals(atomRspBO.getRespCode())) continue;
                agrPushLogPO.setIsFinish("0");
                agrPushLogPO.setFailReason(busiRspBO.getRespDesc());
                agrPushLogPO.setSysTenantId(305775845729763327L);
                agrPushLogPO.setSysTenantName("\u534e\u6da6\u79df\u6237\u673a\u6784");
                this.agrPushLogMapper.insert(agrPushLogPO);
                throw new BusinessException(atomRspBO.getRespCode(), atomRspBO.getRespCode());
            }
        }
        BeanUtils.copyProperties((Object)((Object)busiRspBO), (Object)rspBO);
        return rspBO;
    }

    private void validateParam(CrcAddAgreementChangeAbilityReqBO abilityReqBO) {
        if (null == abilityReqBO) {
            throw new BusinessException("0001", "\u534f\u8bae\u4e3b\u4f53\u521b\u5efaAPI\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getSysCode())) {
            throw new BusinessException("0001", "\u534f\u8bae\u4e3b\u4f53\u521b\u5efaAPI\u5165\u53c2\u3010sysCode\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getProducerId())) {
            throw new BusinessException("0001", "\u534f\u8bae\u4e3b\u4f53\u521b\u5efaAPI\u5165\u53c2\u3010producerId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getEntAgreementCode())) {
            throw new BusinessException("0001", "\u534f\u8bae\u4e3b\u4f53\u521b\u5efaAPI\u5165\u53c2\u3010entAgreementCode\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getChangeComment())) {
            throw new BusinessException("0001", "\u534f\u8bae\u4e3b\u4f53\u521b\u5efaAPI\u5165\u53c2\u3010changeComment\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getProduceTime()) {
            throw new BusinessException("0001", "\u534f\u8bae\u4e3b\u4f53\u521b\u5efaAPI\u5165\u53c2\u3010produceTime\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!CollectionUtils.isEmpty((Collection)abilityReqBO.getScope())) {
            for (CrcAgreementScopeBO bo : abilityReqBO.getScope()) {
                if (null == bo.getScopeCode()) {
                    throw new BusinessException("0001", "\u534f\u8bae\u4e3b\u4f53\u521b\u5efaAPI\u5165\u53c2\u3010agrAgreementBO.getScope.scopeCode\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!StringUtils.isBlank((CharSequence)bo.getScopeName())) continue;
                throw new BusinessException("0001", "\u534f\u8bae\u4e3b\u4f53\u521b\u5efaAPI\u5165\u53c2\u3010agrAgreementBO.getScope.scopeName\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)abilityReqBO.getChangeAttach())) {
            for (CrcAgreementScopeBO bo : abilityReqBO.getChangeAttach()) {
                if (StringUtils.isBlank((CharSequence)bo.getAttachmentName())) {
                    throw new BusinessException("0001", "\u534f\u8bae\u4e3b\u4f53\u521b\u5efaAPI\u5165\u53c2\u3010agrAgreementBO.getAttach.attachmentName\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (null == bo.getAttachmentType()) {
                    throw new BusinessException("0001", "\u534f\u8bae\u4e3b\u4f53\u521b\u5efaAPI\u5165\u53c2\u3010agrAgreementBO.getAttach.attachmentType\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!StringUtils.isBlank((CharSequence)bo.getAttachmentAddr())) continue;
                throw new BusinessException("0001", "\u534f\u8bae\u4e3b\u4f53\u521b\u5efaAPI\u5165\u53c2\u3010agrAgreementBO.getAttach.attachmentAddr\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)abilityReqBO.getSkuChangeList())) {
            for (AgrSkuChangeBO po : abilityReqBO.getSkuChangeList()) {
                if (null == po.getChangeType()) {
                    throw new BusinessException("0001", "\u534f\u8bae\u4e3b\u4f53\u521b\u5efaAPI\u5165\u53c2\u3010agrAgreementBO.getSkuChangeList.changeType\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (2 != po.getChangeType() && 1 != po.getChangeType()) continue;
                String failReason = null;
                if (StringUtils.isEmpty((CharSequence)po.getEntAgreementCode())) {
                    failReason = "\u3010entAgreementCode\u3011\u4e3a\u7a7a";
                } else if (StringUtils.isEmpty((CharSequence)po.getSysCode())) {
                    failReason = "\u3010sysCode\u3011\u4e3a\u7a7a";
                } else if (StringUtils.isEmpty((CharSequence)po.getMaterialCode())) {
                    failReason = "\u3010materialCode\u3011\u4e3a\u7a7a";
                } else if (StringUtils.isEmpty((CharSequence)po.getEbsMaterialCode())) {
                    failReason = "\u3010ebsMaterialCode\u3011\u4e3a\u7a7a";
                } else if (null == po.getTaxRate()) {
                    failReason = "\u3010taxRate\u3011\u4e3a\u7a7a";
                } else if (null == po.getBuyNumber()) {
                    failReason = "\u3010buyNumber\u3011\u4e3a\u7a7a";
                } else if (StringUtils.isEmpty((CharSequence)po.getMeasureName())) {
                    failReason = "\u3010measureName\u3011\u4e3a\u7a7a";
                } else if (StringUtils.isEmpty((CharSequence)po.getSalePrice())) {
                    failReason = "\u3010salePrice\u3011\u4e3a\u7a7a";
                } else if (StringUtils.isEmpty((CharSequence)po.getSalePriceSum())) {
                    failReason = "\u3010salePriceSum\u3011\u4e3a\u7a7a";
                } else if (StringUtils.isEmpty((CharSequence)po.getSerialNo())) {
                    failReason = "\u3010serialNo\u3011\u4e3a\u7a7a";
                } else if (StringUtils.isBlank((CharSequence)po.getCreateTime())) {
                    failReason = "\u3010createTime\u3011\u4e3a\u7a7a";
                }
                if (StringUtils.isEmpty((CharSequence)failReason)) continue;
                throw new BusinessException("0001", failReason);
            }
        }
    }
}

