/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.agreement.ability.bo.AgrUpdateBeOverdueAgreementStatusTimeTaskReqBO;
import com.tydic.agreement.atom.api.AgrAgreementStatusChangeAtomService;
import com.tydic.agreement.atom.api.AgrDicDictionaryAtomService;
import com.tydic.agreement.atom.bo.AgrAgreementStatusChangeAtomReqBO;
import com.tydic.agreement.atom.bo.AgrAgreementStatusChangeAtomRspBO;
import com.tydic.agreement.busi.api.AgrUpdateExpiredToEndTimeTaskBusiService;
import com.tydic.agreement.busi.bo.AgrUpdateBeOverdueAgreementStatusTimeTaskBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.consumer.bo.PriceAgreementBO;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.cfc.ability.api.CfcParamConfigAbilityService;
import com.tydic.cfc.ability.bo.CfcParamConfigItemBO;
import com.tydic.cfc.ability.bo.CfcQryParamConfigListAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcQryParamConfigListAbilityRspBO;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class AgrUpdateExpiredToEndTimeTaskBusiServiceImpl
implements AgrUpdateExpiredToEndTimeTaskBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrUpdateExpiredToEndTimeTaskBusiServiceImpl.class);
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgrAgreementStatusChangeAtomService agrAgreementStatusChangeAtomService;
    @Autowired
    private CfcParamConfigAbilityService cfcParamConfigAbilityService;
    @Value(value="${AGR_PRICE_AGREEMENT_TOPIC:AGR_PRICE_AGREEMENT_TOPIC}")
    private String agrPriceAgreementTopic;
    @Value(value="${AGR_PRICE_AGREEMENT_TAG:*}")
    private String agrPriceAgreementTag;
    @Resource(name="agrSyncPriceAgreementMqServiceProvider")
    private ProxyMessageProducer agrSyncPriceAgreementMqServiceProvider;

    @Override
    public AgrUpdateBeOverdueAgreementStatusTimeTaskBusiRspBO execute(AgrUpdateBeOverdueAgreementStatusTimeTaskReqBO reqBO) {
        List<Long> agreementIds;
        AgrUpdateBeOverdueAgreementStatusTimeTaskBusiRspBO rsp = new AgrUpdateBeOverdueAgreementStatusTimeTaskBusiRspBO();
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u6210\u529f");
        int configDays = 0;
        String configDaysString = null;
        CfcQryParamConfigListAbilityReqBO cfcQryParamConfigListAbilityReqBO = new CfcQryParamConfigListAbilityReqBO();
        cfcQryParamConfigListAbilityReqBO.setParamConfigCode("agr_base_param");
        cfcQryParamConfigListAbilityReqBO.setSysTenantId(Long.valueOf(305775845729763327L));
        CfcQryParamConfigListAbilityRspBO ccar = this.cfcParamConfigAbilityService.qryParamConfigList(cfcQryParamConfigListAbilityReqBO);
        String jstr = JSONObject.toJSONString((Object)ccar);
        log.error("\u67e5\u8be2\u914d\u7f6e\u9879\u51fa\u53c2=" + jstr);
        List paramConfigItemList = ccar.getParamConfigItemList();
        if (paramConfigItemList != null && paramConfigItemList.size() > 0) {
            for (CfcParamConfigItemBO pib : paramConfigItemList) {
                if (!pib.getItemCode().equals("agr_delay")) continue;
                configDaysString = pib.getItemValue();
            }
        }
        if (!StringUtils.isEmpty(configDaysString)) {
            configDays = Integer.parseInt(configDaysString);
        }
        if (configDays > 0 && !CollectionUtils.isEmpty(agreementIds = this.agreementMapper.getOverdue())) {
            AgrAgreementStatusChangeAtomReqBO agrAgreementStatusChangeAtomReqBO = new AgrAgreementStatusChangeAtomReqBO();
            agrAgreementStatusChangeAtomReqBO.setAgreementIds(new HashSet<Long>(agreementIds));
            agrAgreementStatusChangeAtomReqBO.setAgreementStatusPre(AgrCommConstant.AgreementStatus.ENABLE);
            agrAgreementStatusChangeAtomReqBO.setAgreementStatusPost(AgrCommConstant.AgreementStatus.BE_OVERDUE);
            AgrAgreementStatusChangeAtomRspBO agrAgreementStatusChangeAtomRspBO = this.agrAgreementStatusChangeAtomService.updateAgreementStatus(agrAgreementStatusChangeAtomReqBO);
            if (!"0000".equals(agrAgreementStatusChangeAtomRspBO.getRespCode())) {
                throw new BusinessException(agrAgreementStatusChangeAtomRspBO.getRespCode(), agrAgreementStatusChangeAtomRspBO.getRespDesc());
            }
            List<String> priceCodes = this.agreementMapper.getPriceOverdue(agreementIds);
            if (!CollectionUtils.isEmpty(priceCodes)) {
                for (String priceCode : priceCodes) {
                    PriceAgreementBO priceAgreementBO = new PriceAgreementBO();
                    priceAgreementBO.setPlaAgreementCode(priceCode);
                    log.info("\u5b9a\u4ef7\u534f\u8bae\u5931\u6548\u540c\u6b65\u5546\u54c1\u5546\u54c1\u4e2d\u5fc3\u5165\u53c2\u4e3a" + JSON.toJSONString((Object)priceAgreementBO));
                    this.agrSyncPriceAgreementMqServiceProvider.send(new ProxyMessage(this.agrPriceAgreementTopic, this.agrPriceAgreementTag, JSON.toJSONString((Object)priceAgreementBO)));
                }
            }
        }
        List<Long> onAgreementIds = this.agreementMapper.getExpiredToEndTimeOn(configDays);
        List<Long> overdueAgreementIds = this.agreementMapper.getExpiredToEndTimeOverdue(configDays);
        AgrAgreementStatusChangeAtomReqBO agrAgreementStatusChangeAtomReqBO = new AgrAgreementStatusChangeAtomReqBO();
        if (!CollectionUtils.isEmpty(onAgreementIds)) {
            agrAgreementStatusChangeAtomReqBO.setAgreementIds(new HashSet<Long>(onAgreementIds));
            agrAgreementStatusChangeAtomReqBO.setAgreementStatusPre(AgrCommConstant.AgreementStatus.ENABLE);
            agrAgreementStatusChangeAtomReqBO.setAgreementStatusPost(AgrCommConstant.AgreementStatus.TERMINATION);
            AgrAgreementStatusChangeAtomRspBO agrAgreementStatusChangeAtomRspBO = this.agrAgreementStatusChangeAtomService.updateAgreementStatus(agrAgreementStatusChangeAtomReqBO);
            if (!"0000".equals(agrAgreementStatusChangeAtomRspBO.getRespCode())) {
                throw new BusinessException(agrAgreementStatusChangeAtomRspBO.getRespCode(), agrAgreementStatusChangeAtomRspBO.getRespDesc());
            }
        }
        if (!CollectionUtils.isEmpty(overdueAgreementIds)) {
            agrAgreementStatusChangeAtomReqBO.setAgreementIds(new HashSet<Long>(overdueAgreementIds));
            agrAgreementStatusChangeAtomReqBO.setAgreementStatusPre(AgrCommConstant.AgreementStatus.BE_OVERDUE);
            agrAgreementStatusChangeAtomReqBO.setAgreementStatusPost(AgrCommConstant.AgreementStatus.TERMINATION);
            AgrAgreementStatusChangeAtomRspBO agrAgreementStatusChangeAtomRspBO2 = this.agrAgreementStatusChangeAtomService.updateAgreementStatus(agrAgreementStatusChangeAtomReqBO);
            if (!"0000".equals(agrAgreementStatusChangeAtomRspBO2.getRespCode())) {
                throw new BusinessException(agrAgreementStatusChangeAtomRspBO2.getRespCode(), agrAgreementStatusChangeAtomRspBO2.getRespDesc());
            }
        }
        if (log.isInfoEnabled()) {
            log.info("==========\u8fc7\u671f\u7ec8\u6b62\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5==========");
        }
        return rsp;
    }
}

