/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.busi.api.FscBillOrderCreateBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderCreateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderCreateBusiRspBO;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.bo.RelOrderBO;
import com.tydic.fsc.bo.SplitOrderBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.api.FscPayShouldPayCreateAtomService;
import com.tydic.fsc.busibase.atom.api.FscUocOrderRelUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceRuleMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoiceRulePO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscBillOrderCreateBusiServiceImpl
implements FscBillOrderCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderCreateBusiServiceImpl.class);
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscInvoiceRuleMapper fscInvoiceRuleMapper;
    @Autowired
    private FscUocOrderRelUpdateAtomService fscUocOrderRelUpdateAtomService;
    @Autowired
    private FscPayShouldPayCreateAtomService fscPayShouldPayCreateAtomService;

    @Override
    public FscBillOrderCreateBusiRspBO dealCreate(FscBillOrderCreateBusiReqBO reqBO) {
        ArrayList<FscOrderPO> fscOrderPOS = new ArrayList<FscOrderPO>();
        ArrayList<FscOrderRelationPO> fscOrderRelationPOS = new ArrayList<FscOrderRelationPO>();
        ArrayList fscOrderItemPOS = new ArrayList();
        ArrayList<FscOrderInvoicePO> fscOrderInvoicePOS = new ArrayList<FscOrderInvoicePO>();
        ArrayList<FscInvoiceRulePO> fscInvoiceRulePOS = new ArrayList<FscInvoiceRulePO>();
        ArrayList<Long> fscOrderIds = new ArrayList<Long>();
        Integer elecFlag = FscConstants.FscInvoiceRuleElecFlag.NO;
        if (FscConstants.FscInvoiceCategory.ELEC.equals(reqBO.getInvoiceCategory())) {
            elecFlag = FscConstants.FscInvoiceRuleElecFlag.YES;
        }
        int num = 0;
        for (SplitOrderBO splitOrderBO : reqBO.getSplitOrderList()) {
            FscOrderPO fscOrderPo = (FscOrderPO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderPO.class);
            fscOrderPo.setFscOrderId(Long.valueOf(Sequence.getInstance().nextId()));
            fscOrderPo.setCreateTime(new Date());
            fscOrderPo.setCreateOperId(reqBO.getUserId());
            fscOrderPo.setCreateOperName(reqBO.getName());
            fscOrderPo.setCreateOrgId(reqBO.getOrgId());
            fscOrderPo.setCreateOrgName(reqBO.getOrgName());
            fscOrderPo.setCreateCompanyId(reqBO.getCompanyId());
            fscOrderPo.setCreateCompanyName(reqBO.getCompanyName());
            fscOrderPo.setTotalCharge(splitOrderBO.getAmount().setScale(2, RoundingMode.HALF_UP));
            fscOrderPo.setOrderNo(reqBO.getOrderNos().get(num));
            fscOrderPo.setBuildAction(FscConstants.FscOrderBuildAction.HAND);
            if (null != reqBO.getBuildAction()) {
                fscOrderPo.setBuildAction(reqBO.getBuildAction());
            }
            ++num;
            fscOrderIds.add(fscOrderPo.getFscOrderId());
            for (RelOrderBO relOrderBO : splitOrderBO.getRelOrderList()) {
                FscOrderInfoBO fscOrderInfoBO = reqBO.getFscOrderInfoBoMap().get(relOrderBO.getAcceptOrderId());
                if (null == fscOrderInfoBO) {
                    throw new FscBusinessException("193008", "\u83b7\u53d6\u8ba2\u5355\u5bf9\u8c61\u4e3a\u7a7a");
                }
                FscOrderRelationPO fscOrderRelationPO = (FscOrderRelationPO)JSONObject.parseObject((String)JSON.toJSONString((Object)fscOrderInfoBO), FscOrderRelationPO.class);
                fscOrderRelationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                fscOrderRelationPO.setFscOrderId(fscOrderPo.getFscOrderId());
                fscOrderRelationPOS.add(fscOrderRelationPO);
                fscOrderItemPOS.addAll(JSONObject.parseArray((String)JSON.toJSONString((Object)fscOrderInfoBO.getFscOrderItemBOS()), FscOrderItemPO.class));
                fscOrderItemPOS.forEach(fscOrderItemPO -> {
                    fscOrderItemPO.setFscOrderId(fscOrderPo.getFscOrderId());
                    fscOrderItemPO.setAccountEndDate(this.calShouldPayDate(fscOrderInfoBO));
                });
            }
            if (!CollectionUtils.isEmpty(fscOrderItemPOS)) {
                fscOrderPo.setLastPayDate(((FscOrderItemPO)fscOrderItemPOS.stream().sorted(Comparator.comparing(FscOrderItemPO::getAccountEndDate)).collect(Collectors.toList()).get(0)).getAccountEndDate());
            }
            fscOrderPo.setOrderNum(Integer.valueOf(splitOrderBO.getRelOrderList().size()));
            fscOrderPOS.add(fscOrderPo);
            FscOrderInvoicePO fscOrderInvoicePo = (FscOrderInvoicePO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderInvoicePO.class);
            fscOrderInvoicePo.setFscOrderId(fscOrderPo.getFscOrderId());
            fscOrderInvoicePo.setBillOperId(reqBO.getUserId().toString());
            fscOrderInvoicePo.setBillOperName(reqBO.getName());
            fscOrderInvoicePo.setBillTime(new Date());
            fscOrderInvoicePo.setBillTimeStart(new Date());
            fscOrderInvoicePo.setMemo(reqBO.getInvoiceMemo());
            fscOrderInvoicePOS.add(fscOrderInvoicePo);
            FscInvoiceRulePO fscInvoiceRulePO = new FscInvoiceRulePO();
            fscInvoiceRulePO.setFscOrderId(fscOrderPo.getFscOrderId());
            fscInvoiceRulePO.setDataFlag(FscConstants.FscInvoiceRuleDataFlag.YES);
            fscInvoiceRulePO.setDataStatus(FscConstants.FscInvoiceRuleStatus.NO);
            fscInvoiceRulePO.setElecFlag(elecFlag);
            fscInvoiceRulePO.setElecStatus(FscConstants.FscInvoiceRuleStatus.NO);
            fscInvoiceRulePOS.add(fscInvoiceRulePO);
            if (null == reqBO.getPayType()) {
                reqBO.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD);
            }
            this.dealAccountRule(reqBO, fscOrderPo);
        }
        if (CollectionUtils.isEmpty(fscOrderPOS) || CollectionUtils.isEmpty(fscOrderRelationPOS) || CollectionUtils.isEmpty(fscOrderItemPOS) || CollectionUtils.isEmpty(fscOrderInvoicePOS) || CollectionUtils.isEmpty(fscInvoiceRulePOS)) {
            throw new FscBusinessException("193008", "\u5f00\u7968\u4e3b\u5355\u7ec4\u88c5\u53c2\u6570\u4e3a\u7a7a");
        }
        fscOrderItemPOS.forEach(fscOrderItemPO -> fscOrderItemPO.setId(Long.valueOf(Sequence.getInstance().nextId())));
        this.fscOrderMapper.insertBatch(fscOrderPOS);
        this.fscOrderRelationMapper.insertBatch(fscOrderRelationPOS);
        this.fscOrderItemMapper.insertBatch(fscOrderItemPOS);
        this.fscOrderInvoiceMapper.insertBatch(fscOrderInvoicePOS);
        this.fscInvoiceRuleMapper.insertBatch(fscInvoiceRulePOS);
        if (!CollectionUtils.isEmpty(reqBO.getFscShouldPayBOS())) {
            this.createShouldPay(reqBO.getFscShouldPayBOS(), reqBO);
        }
        FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = (FscOrderStatusStartAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderStatusStartAtomReqBO.class);
        for (Long fscOrderId : fscOrderIds) {
            fscOrderStatusStartAtomReqBO.setOrderId(fscOrderId);
            FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealStatusStart(fscOrderStatusStartAtomReqBO);
            if ("0000".equals(fscOrderStatusStartAtomRspBO.getRespCode())) continue;
            throw new FscBusinessException("193008", fscOrderStatusStartAtomRspBO.getRespDesc());
        }
        this.syncOrderStatus(fscOrderIds);
        FscBillOrderCreateBusiRspBO fscBillOrderCreateBusiRspBO = new FscBillOrderCreateBusiRspBO();
        fscBillOrderCreateBusiRspBO.setFscOrderIds(fscOrderIds);
        return fscBillOrderCreateBusiRspBO;
    }

    private void syncOrderStatus(List<Long> fscOrderIds) {
        fscOrderIds.forEach(fscOrderId -> {
            FscUocOrderRelUpdateAtomReqBO fscUocOrderRelUpdateAtomReqBO = new FscUocOrderRelUpdateAtomReqBO();
            fscUocOrderRelUpdateAtomReqBO.setFscOrderId(fscOrderId);
            fscUocOrderRelUpdateAtomReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
            this.fscUocOrderRelUpdateAtomService.dealRelUpdate(fscUocOrderRelUpdateAtomReqBO);
        });
    }

    private Date calShouldPayDate(FscOrderInfoBO fscOrderInfoBO) {
        Calendar now = Calendar.getInstance();
        if (FscConstants.MerchantPayRule.MERCHANT_PAY_RULE_SPECIFY.equals(fscOrderInfoBO.getPayRule())) {
            if (null == fscOrderInfoBO.getPayAccountDay()) {
                throw new FscBusinessException("191019", "\u8ba2\u5355\u6307\u5b9a\u8d26\u671f\u65e5\u4e3a\u7a7a");
            }
            Integer day = now.get(5);
            if (day >= fscOrderInfoBO.getPayAccountDay()) {
                now.add(2, 1);
            }
            now.add(5, fscOrderInfoBO.getPayAccountDay() - day);
        }
        if (FscConstants.MerchantPayRule.Merchant_PAY_RULE_BUSIESS_NODE.equals(fscOrderInfoBO.getPayRule())) {
            if (null == fscOrderInfoBO.getPayNodeAccountDays()) {
                throw new FscBusinessException("191019", "\u8ba2\u5355\u8d26\u671f\u5929\u6570\u4e3a\u7a7a");
            }
            now.add(5, fscOrderInfoBO.getPayNodeAccountDays());
        }
        return now.getTime();
    }

    private void dealAccountRule(FscBillOrderCreateBusiReqBO reqBO, FscOrderPO fscOrderPO) {
        if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(reqBO.getPayType())) {
            FscOrderInfoBO fscOrderInfoBO = reqBO.getFscOrderInfoBoMap().values().stream().max(Comparator.comparing(FscOrderInfoBO::getOrderCreateTime)).get();
            if (null == fscOrderInfoBO) {
                throw new FscBusinessException("191019", "\u83b7\u53d6\u8ba2\u5355\u4e3a\u7a7a");
            }
            if (FscConstants.MerchantPayAccountDayRule.INVOICE.equals(fscOrderInfoBO.getPayAccountDayRule()) || FscConstants.MerchantPayNodeRule.INVOICE.equals(fscOrderInfoBO.getPayNodeRule()) || StringUtils.isEmpty((Object)fscOrderInfoBO.getPayAccountDayRule())) {
                ArrayList<FscShouldPayBO> fscShouldPayBOS = new ArrayList<FscShouldPayBO>();
                FscShouldPayBO fscShouldPayBO = new FscShouldPayBO();
                fscShouldPayBO.setShouldPayType(FscConstants.ShouldPayType.PAYMENT_DAY_PAY);
                fscShouldPayBO.setShouldPayNo(fscOrderPO.getOrderNo());
                fscShouldPayBO.setObjectType(FscConstants.ShouldObjectType.SIGN_INVOICE_ORDER);
                fscShouldPayBO.setObjectId(fscOrderPO.getFscOrderId());
                fscShouldPayBO.setObjectNo(fscOrderPO.getOrderNo());
                fscShouldPayBO.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD);
                fscShouldPayBO.setShouldPayAmount(fscOrderPO.getTotalCharge());
                fscShouldPayBO.setPayeeId(fscOrderPO.getPayeeId());
                fscShouldPayBO.setPayeeName(fscOrderPO.getPayeeName());
                fscShouldPayBO.setPayerId(fscOrderPO.getPayerId());
                fscShouldPayBO.setPayerName(fscOrderPO.getPayerName());
                fscShouldPayBO.setPenaltyRatio(fscOrderInfoBO.getPayBreakScale());
                fscShouldPayBO.setContractId(fscOrderInfoBO.getModelContractId());
                fscShouldPayBO.setContractNo(fscOrderInfoBO.getModelContractNo());
                fscShouldPayBO.setShouldPayDate(this.calShouldPayDate(fscOrderInfoBO));
                fscShouldPayBOS.add(fscShouldPayBO);
                reqBO.setFscShouldPayBOS(fscShouldPayBOS);
            }
        }
    }

    private void createShouldPay(List<FscShouldPayBO> fscShouldPayBOS, FscBillOrderCreateBusiReqBO reqBO) {
        if (!CollectionUtils.isEmpty(fscShouldPayBOS)) {
            FscPayShouldPayCreateAtomReqBO fscPayShouldPayCreateAtomReqBO = new FscPayShouldPayCreateAtomReqBO();
            fscPayShouldPayCreateAtomReqBO.setFscShouldPayBOS(fscShouldPayBOS);
            fscPayShouldPayCreateAtomReqBO.setUserId(reqBO.getUserId());
            fscPayShouldPayCreateAtomReqBO.setName(reqBO.getName());
            fscPayShouldPayCreateAtomReqBO.setUserName(reqBO.getUserName());
            fscPayShouldPayCreateAtomReqBO.setCompanyId(reqBO.getCompanyId());
            fscPayShouldPayCreateAtomReqBO.setCompanyName(reqBO.getCompanyName());
            fscPayShouldPayCreateAtomReqBO.setOrgId(reqBO.getOrgId());
            fscPayShouldPayCreateAtomReqBO.setOrgName(reqBO.getOrgName());
            FscPayShouldPayCreateAtomRspBO fscPayShouldPayCreateAtomRspBO = this.fscPayShouldPayCreateAtomService.dealShouldPayCreate(fscPayShouldPayCreateAtomReqBO);
            if (!"0000".equals(fscPayShouldPayCreateAtomRspBO.getRespCode())) {
                throw new FscBusinessException("193011", fscPayShouldPayCreateAtomRspBO.getRespDesc());
            }
        }
    }
}

