/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.bill.ability.api.FscBillTaxListQueryAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillTaxListDetailEntityQueryBO;
import com.tydic.fsc.bill.ability.bo.FscBillTaxListQueryAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillTaxListQueryAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscBillTaxListResultQueryBO;
import com.tydic.fsc.bo.FscComOrderListBO;
import com.tydic.fsc.bo.FscOrderItemDetailBO;
import com.tydic.fsc.common.ability.api.FscComOrderListPageQueryAbilityService;
import com.tydic.fsc.common.ability.api.FscOrderItemDetailQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListQueryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscOrderItemDetailQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscOrderItemDetailQueryAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.util.TaxUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillTaxListQueryAbilityService"})
public class FscBillTaxListQueryAbilityServiceImpl
implements FscBillTaxListQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillTaxListQueryAbilityServiceImpl.class);
    @Autowired
    private FscOrderItemDetailQueryAbilityService fscOrderItemDetailQueryAbilityService;
    @Autowired
    private FscComOrderListPageQueryAbilityService fscComOrderListPageQueryAbilityService;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Value(value="${FSC_TAX_COMPANY_NO:198611102630}")
    private String FSC_TAX_COMPANY_NO;
    @Value(value="${FSC_DRAWER:\u8fea\u6613\u91c7\u8fd0\u8425\u673a\u6784}")
    private String FSC_DRAWER;
    @Value(value="${FSC_SELLER_ADDR_PHONE:}")
    private String FSC_SELLER_ADDR_PHONE;
    @Value(value="${FSC_SELLER_BANK_ACCOUNT:}")
    private String FSC_SELLER_BANK_ACCOUNT;
    @Value(value="${TRANSACTION_SERVICE_FEE:\u6210\u4ea4\u670d\u52a1\u8d39}")
    private String TRANSACTION_SERVICE_FEE;
    @Value(value="${PLATFORM_USAGE_FEE:\u5e73\u53f0\u4f7f\u7528\u8d39}")
    private String PLATFORM_USAGE_FEE;
    @Value(value="${TAX_RATE:0.13}")
    private String TAX_RATE;
    @Value(value="${TAX_CODE:1020206010000000000}")
    private String TAX_CODE;
    @Value(value="${TYPE_SWITCH:true}")
    private Boolean TYPE_SWITCH;

    @PostMapping(value={"qryBillTaxList"})
    public FscBillTaxListQueryAbilityRspBO qryBillTaxList(@RequestBody FscBillTaxListQueryAbilityReqBO reqBO) {
        List<Integer> orderFlows = Collections.singletonList(FscConstants.OrderFlow.INVOICE);
        List<FscComOrderListBO> orderInvoiceListRspBO = this.queryComOrderList(FscConstants.FscOrderMakeType.OPERTION, FscConstants.FscOrderReceiveType.PURCHASE, orderFlows);
        orderFlows = Arrays.asList(FscConstants.OrderFlow.MONTH_SERVICE_FEE, FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE, FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE, FscConstants.OrderFlow.PL_SERVICE_FEE);
        List<FscComOrderListBO> unionComOrderListRspBO = this.queryComOrderList(FscConstants.FscOrderMakeType.OPERTION, FscConstants.FscOrderReceiveType.SUPPLIER, orderFlows);
        ArrayList<FscComOrderListBO> comOrderListRspBO = new ArrayList<FscComOrderListBO>();
        comOrderListRspBO.addAll(orderInvoiceListRspBO);
        comOrderListRspBO.addAll(unionComOrderListRspBO);
        if (CollectionUtils.isNotEmpty(comOrderListRspBO)) {
            List fscOrderIds = comOrderListRspBO.stream().map(FscComOrderListBO::getFscOrderId).collect(Collectors.toList());
            log.info("==============================fscOrderIds" + fscOrderIds);
            FscBillTaxListQueryAbilityRspBO fscBillTaxListQueryAbilityRspBO = new FscBillTaxListQueryAbilityRspBO();
            fscBillTaxListQueryAbilityRspBO.setRows(JSON.parseArray((String)JSON.toJSONString(comOrderListRspBO), FscBillTaxListResultQueryBO.class));
            FscOrderInvoicePO fscOrderInvoicePO2 = new FscOrderInvoicePO();
            fscOrderInvoicePO2.setFscOrderIdList(fscOrderIds);
            List fscOrderInvoicePOList = this.fscOrderInvoiceMapper.getList(fscOrderInvoicePO2);
            Map<Long, FscOrderInvoicePO> collect = fscOrderInvoicePOList.stream().collect(Collectors.toMap(FscOrderInvoicePO::getFscOrderId, fscOrderInvoicePO -> fscOrderInvoicePO));
            FscOrderItemDetailQueryAbilityReqBO fscOrderItemDetailQueryAbilityReqBO = new FscOrderItemDetailQueryAbilityReqBO();
            fscOrderItemDetailQueryAbilityReqBO.setFscOrderIdList(fscOrderIds);
            FscOrderItemDetailQueryAbilityRspBO fscOrderItemDetailQueryAbilityRspBO = this.fscOrderItemDetailQueryAbilityService.queryOrderItemDetail(fscOrderItemDetailQueryAbilityReqBO);
            if (!fscOrderItemDetailQueryAbilityRspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException("191028", fscOrderItemDetailQueryAbilityRspBO.getRespDesc());
            }
            log.info("==============================fscOrderItemDetailQueryAbilityRspBO" + fscOrderItemDetailQueryAbilityRspBO);
            ArrayList<FscBillTaxListResultQueryBO> fscBillTaxListResultQueryBOS = new ArrayList<FscBillTaxListResultQueryBO>();
            for (FscComOrderListBO fscComOrderListBO : comOrderListRspBO) {
                FscBillTaxListResultQueryBO fscBillTaxListResultQueryBO = new FscBillTaxListResultQueryBO();
                FscOrderInvoicePO fscOrderInvoicePO3 = collect.get(fscComOrderListBO.getFscOrderId());
                fscBillTaxListResultQueryBO.setBusiType(reqBO.getBusiType());
                fscBillTaxListResultQueryBO.setOrderNo(String.valueOf(fscComOrderListBO.getFscOrderId()));
                fscBillTaxListResultQueryBO.setYCompanyNo("198611102630");
                fscBillTaxListResultQueryBO.setCOrgnCode(fscComOrderListBO.getSupplierId().toString());
                fscBillTaxListResultQueryBO.setCustName(fscOrderInvoicePO3.getBuyName());
                fscBillTaxListResultQueryBO.setCustTaxNo(fscOrderInvoicePO3.getTaxNo());
                fscBillTaxListResultQueryBO.setCustAddrPhone(fscOrderInvoicePO3.getAddress() + " " + fscOrderInvoicePO3.getPhone());
                fscBillTaxListResultQueryBO.setCustBankAccount(fscOrderInvoicePO3.getBank() + " " + fscOrderInvoicePO3.getAccount());
                Integer invoiceCategory = fscOrderInvoicePO3.getInvoiceCategory();
                String invoiceType = fscOrderInvoicePO3.getInvoiceType();
                if (FscConstants.InvoiceCategory.PAPER.equals(invoiceCategory) && "01".equals(invoiceType)) {
                    fscBillTaxListResultQueryBO.setInvType(FscConstants.FscTaxInvType.GENERAL);
                } else if (FscConstants.InvoiceCategory.PAPER.equals(invoiceCategory) && "00".equals(invoiceType)) {
                    fscBillTaxListResultQueryBO.setInvType(FscConstants.FscTaxInvType.SPECIAL);
                } else if (this.TYPE_SWITCH.booleanValue()) {
                    fscBillTaxListResultQueryBO.setInvType(FscConstants.FscTaxInvType.ELEC_SPECIAL);
                } else if (FscConstants.InvoiceCategory.ELECTRON.equals(invoiceCategory) && "01".equals(invoiceType)) {
                    fscBillTaxListResultQueryBO.setInvType(FscConstants.FscTaxInvType.ELEC_GENERAL);
                } else if (FscConstants.InvoiceCategory.ELECTRON.equals(invoiceCategory) && "00".equals(invoiceType)) {
                    fscBillTaxListResultQueryBO.setInvType(FscConstants.FscTaxInvType.ELEC_SPECIAL);
                }
                fscBillTaxListResultQueryBO.setInvRemark("*");
                fscBillTaxListResultQueryBO.setDrawer(this.FSC_DRAWER);
                fscBillTaxListResultQueryBO.setPayer(fscComOrderListBO.getPayeeName());
                fscBillTaxListResultQueryBO.setReviewer("");
                fscBillTaxListResultQueryBO.setExpressTelphone(fscOrderInvoicePO3.getReceivePhone());
                fscBillTaxListResultQueryBO.setSellerAddrPhone(this.FSC_SELLER_ADDR_PHONE);
                fscBillTaxListResultQueryBO.setSellerBankAccount(this.FSC_SELLER_BANK_ACCOUNT);
                SimpleDateFormat f = new SimpleDateFormat("yyyyMMdd");
                String format = f.format(fscComOrderListBO.getCreateTime());
                fscBillTaxListResultQueryBO.setOrderDate(format);
                fscBillTaxListResultQueryBO.setOrderType(fscComOrderListBO.getOrderFlowStr());
                fscBillTaxListResultQueryBO.setExpressAddress(fscOrderInvoicePO3.getAddress());
                fscBillTaxListResultQueryBO.setExpressCity(fscOrderInvoicePO3.getCity());
                fscBillTaxListResultQueryBO.setExpressContact(fscOrderInvoicePO3.getSignOperName());
                fscBillTaxListResultQueryBO.setExpressTelphone(fscOrderInvoicePO3.getReceivePhone());
                fscBillTaxListResultQueryBO.setCustEmail(fscOrderInvoicePO3.getReceiveEmail());
                fscBillTaxListResultQueryBO.setCustTelephone("");
                ArrayList<FscBillTaxListDetailEntityQueryBO> fscBillTaxListDetailEntityQueryBOS = new ArrayList<FscBillTaxListDetailEntityQueryBO>();
                if (FscConstants.OrderFlow.INVOICE.equals(fscComOrderListBO.getOrderFlow())) {
                    for (FscOrderItemDetailBO fscOrderItemDetailBO : fscOrderItemDetailQueryAbilityRspBO.getFscOrderItemDetailBOS()) {
                        if (!fscOrderItemDetailBO.getFscOrderId().equals(fscComOrderListBO.getFscOrderId())) continue;
                        FscBillTaxListDetailEntityQueryBO fscBillTaxListDetailEntityQueryBO = new FscBillTaxListDetailEntityQueryBO();
                        BeanUtils.copyProperties((Object)fscOrderItemDetailBO, (Object)fscBillTaxListDetailEntityQueryBO);
                        fscBillTaxListDetailEntityQueryBO.setGoodsNo(String.valueOf(fscOrderItemDetailBO.getOrderItemId()));
                        fscBillTaxListDetailEntityQueryBO.setOldOrderNo(fscOrderItemDetailBO.getOrderNo());
                        fscBillTaxListDetailEntityQueryBO.setInspectionId(fscOrderItemDetailBO.getAcceptOrderId());
                        fscBillTaxListDetailEntityQueryBO.setGoodsName(fscOrderItemDetailBO.getSkuName());
                        if (null != fscOrderItemDetailBO.getSkuId()) {
                            String s = String.valueOf(fscOrderItemDetailBO.getSkuId());
                            fscBillTaxListDetailEntityQueryBO.setLineCode(Integer.valueOf(s));
                        }
                        fscBillTaxListDetailEntityQueryBO.setQty(fscOrderItemDetailBO.getNum());
                        fscBillTaxListDetailEntityQueryBO.setTaxPrice(fscOrderItemDetailBO.getPrice());
                        fscBillTaxListDetailEntityQueryBO.setAmount(fscOrderItemDetailBO.getUntaxAmt());
                        fscBillTaxListDetailEntityQueryBO.setDisAmount(null);
                        fscBillTaxListDetailEntityQueryBO.setDistaxAmount(null);
                        fscBillTaxListDetailEntityQueryBO.setGropGoodsNo("");
                        fscBillTaxListResultQueryBO.setInvRemark("*");
                        fscBillTaxListDetailEntityQueryBO.setTax(fscOrderItemDetailBO.getTaxAmt());
                        fscBillTaxListDetailEntityQueryBO.setTaxAmount(fscOrderItemDetailBO.getAmt());
                        fscBillTaxListDetailEntityQueryBO.setTaxPre(Integer.valueOf(0));
                        fscBillTaxListDetailEntityQueryBO.setTaxCode(fscOrderItemDetailBO.getTaxCode());
                        fscBillTaxListDetailEntityQueryBO.setTaxRate(fscOrderItemDetailBO.getTaxRate().setScale(2, 4));
                        fscBillTaxListDetailEntityQueryBO.setItemSpare1(String.valueOf(fscOrderItemDetailBO.getOrderItemId()));
                        fscBillTaxListDetailEntityQueryBO.setPrice(fscOrderItemDetailBO.getUntaxPrice());
                        fscBillTaxListDetailEntityQueryBOS.add(fscBillTaxListDetailEntityQueryBO);
                    }
                } else {
                    FscBillTaxListDetailEntityQueryBO fscBillTaxListDetailEntityQueryBO = new FscBillTaxListDetailEntityQueryBO();
                    fscBillTaxListDetailEntityQueryBO.setItemSpare1(String.valueOf(fscComOrderListBO.getFscOrderId()));
                    fscBillTaxListDetailEntityQueryBO.setGoodsNo(String.valueOf(fscComOrderListBO.getFscOrderId()));
                    fscBillTaxListDetailEntityQueryBO.setInspectionId(fscComOrderListBO.getFscOrderId());
                    if (FscConstants.OrderFlow.PL_SERVICE_FEE.equals(fscComOrderListBO.getOrderFlow())) {
                        fscBillTaxListDetailEntityQueryBO.setGoodsName(this.PLATFORM_USAGE_FEE);
                    } else {
                        fscBillTaxListDetailEntityQueryBO.setGoodsName(this.TRANSACTION_SERVICE_FEE);
                    }
                    fscBillTaxListDetailEntityQueryBO.setLineCode(Integer.valueOf(1));
                    fscBillTaxListDetailEntityQueryBO.setModel("-");
                    fscBillTaxListDetailEntityQueryBO.setUnit("-");
                    fscBillTaxListDetailEntityQueryBO.setQty(BigDecimal.ONE);
                    fscBillTaxListDetailEntityQueryBO.setTaxPrice(fscComOrderListBO.getActualAmount());
                    fscBillTaxListDetailEntityQueryBO.setTaxRate(new BigDecimal(this.TAX_RATE).setScale(2, RoundingMode.HALF_UP));
                    fscBillTaxListDetailEntityQueryBO.setTax(TaxUtils.calTaxAmt((BigDecimal)fscComOrderListBO.getActualAmount(), (BigDecimal)new BigDecimal(this.TAX_RATE).setScale(2, RoundingMode.HALF_UP)));
                    fscBillTaxListDetailEntityQueryBO.setPrice(fscBillTaxListDetailEntityQueryBO.getTaxPrice().subtract(fscBillTaxListDetailEntityQueryBO.getTax()));
                    fscBillTaxListDetailEntityQueryBO.setTaxAmount(fscBillTaxListDetailEntityQueryBO.getTaxPrice());
                    fscBillTaxListDetailEntityQueryBO.setAmount(fscBillTaxListDetailEntityQueryBO.getPrice());
                    fscBillTaxListDetailEntityQueryBO.setTaxCode(this.TAX_CODE);
                    fscBillTaxListDetailEntityQueryBO.setTaxPre(Integer.valueOf(0));
                    fscBillTaxListDetailEntityQueryBOS.add(fscBillTaxListDetailEntityQueryBO);
                }
                fscBillTaxListResultQueryBO.setDetail(fscBillTaxListDetailEntityQueryBOS);
                fscBillTaxListResultQueryBOS.add(fscBillTaxListResultQueryBO);
            }
            fscBillTaxListQueryAbilityRspBO.setRows(fscBillTaxListResultQueryBOS);
            return fscBillTaxListQueryAbilityRspBO;
        }
        return new FscBillTaxListQueryAbilityRspBO();
    }

    private List<FscComOrderListBO> queryComOrderList(Integer makeType, Integer receiveType, List<Integer> orderFlows) {
        FscComOrderListQueryAbilityReqBO fscComOrderListQueryAbilityReqBO = new FscComOrderListQueryAbilityReqBO();
        fscComOrderListQueryAbilityReqBO.setMakeType(makeType);
        fscComOrderListQueryAbilityReqBO.setReceiveType(receiveType);
        fscComOrderListQueryAbilityReqBO.setOrderFlows(orderFlows);
        ArrayList<Integer> orderStates = new ArrayList<Integer>();
        orderStates.add(FscConstants.FscInvoiceOrderState.SUBMITTING);
        fscComOrderListQueryAbilityReqBO.setOrderStates(orderStates);
        FscComOrderListQueryAbilityRspBO comOrderListPageRspBO = this.fscComOrderListPageQueryAbilityService.getComOrderListPageQuery(fscComOrderListQueryAbilityReqBO);
        if (!"0000".equals(comOrderListPageRspBO.getRespCode())) {
            throw new FscBusinessException("191028", comOrderListPageRspBO.getRespDesc());
        }
        return comOrderListPageRspBO.getRows();
    }
}

