/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.api.FscPayQueryBankCheckFileAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBankCheckFileItemBO;
import com.tydic.fsc.bill.ability.bo.FscPayQueryBankCheckFileAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscPayQueryBankCheckFileAbilityRspBO;
import com.tydic.fsc.bill.atom.api.FscFileUploadOSSByUrlAtomService;
import com.tydic.fsc.bill.atom.bo.FscFileUploadOSSByUrlAtomReqBO;
import com.tydic.fsc.bill.atom.bo.FscFileUploadOSSByUrlAtomRspBO;
import com.tydic.fsc.bill.busi.api.FscPayBillBankCheckFileBusiService;
import com.tydic.fsc.bill.busi.bo.FscBankCheckFileBO;
import com.tydic.fsc.bill.busi.bo.FscPayBillBankCheckFileBusiReqBO;
import com.tydic.fsc.busibase.external.api.pay.FscBToBPingAnBankDownLoadCheckFileService;
import com.tydic.fsc.busibase.external.api.pay.FscBToBPingAnBankQueryCheckFileService;
import com.tydic.fsc.busibase.external.api.pay.bo.FscBToBPingAnBankDownLoadCheckFileReqBO;
import com.tydic.fsc.busibase.external.api.pay.bo.FscBToBPingAnBankDownLoadCheckFileRspBO;
import com.tydic.fsc.busibase.external.api.pay.bo.FscBToBPingAnBankQueryCheckFileReqBO;
import com.tydic.fsc.busibase.external.api.pay.bo.FscBToBPingAnBankQueryCheckFileRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscBankCheckFileMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscBankCheckFilePO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.io.BufferedReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscPayQueryBankCheckFileAbilityService"})
public class FscPayQueryBankCheckFileAbilityServiceImpl
implements FscPayQueryBankCheckFileAbilityService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscBankCheckFileMapper fscBankCheckFileMapper;
    @Autowired
    private FscBToBPingAnBankQueryCheckFileService fscBToBPingAnBankQueryCheckFileService;
    @Autowired
    private FscPayBillBankCheckFileBusiService fscPayBillBankCheckFileBusiService;
    @Autowired
    private FscBToBPingAnBankDownLoadCheckFileService fscBToBPingAnBankDownLoadCheckFileService;
    @Autowired
    private FscFileUploadOSSByUrlAtomService fscFileUploadOSSByUrlAtomService;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"qryBankCheckFile"})
    public FscPayQueryBankCheckFileAbilityRspBO qryBankCheckFile(@RequestBody FscPayQueryBankCheckFileAbilityReqBO abilityReqBO) {
        FscBToBPingAnBankQueryCheckFileReqBO bankReqBO = new FscBToBPingAnBankQueryCheckFileReqBO();
        bankReqBO.setFileDate(DateUtil.dateToStrYYMMdd((Date)new Date()));
        bankReqBO.setFileType("JY");
        FscBToBPingAnBankQueryCheckFileRspBO bankRspBO = this.fscBToBPingAnBankQueryCheckFileService.checkAmountFile(bankReqBO);
        ArrayList<FscBankCheckFileBO> fscBankCheckFileBOs = new ArrayList<FscBankCheckFileBO>();
        if (null != bankRspBO && !CollectionUtils.isEmpty((Collection)bankRspBO.getTranItemArray())) {
            bankRspBO.getTranItemArray().forEach(row -> {
                FscBankCheckFileBO fscBankCheckFileBO = new FscBankCheckFileBO();
                fscBankCheckFileBO.setFileName(row.getFileName());
                fscBankCheckFileBO.setFilePath(row.getFilePath());
                fscBankCheckFileBO.setRandomPassword(row.getRandomPassword());
                fscBankCheckFileBO.setDrawCode(row.getDrawCode());
                fscBankCheckFileBOs.add(fscBankCheckFileBO);
            });
        }
        FscPayBillBankCheckFileBusiReqBO fscPayBillBankCheckFileBusiReqBO = new FscPayBillBankCheckFileBusiReqBO();
        if (!CollectionUtils.isEmpty(fscBankCheckFileBOs)) {
            fscPayBillBankCheckFileBusiReqBO.setFscBankCheckFileBOs(fscBankCheckFileBOs);
            this.fscPayBillBankCheckFileBusiService.bankCheckFile(fscPayBillBankCheckFileBusiReqBO);
        }
        FscBankCheckFilePO fscBankCheckFilePO = new FscBankCheckFilePO();
        fscBankCheckFilePO.setStatus(FscConstants.BANK_CHECK_STATUS.NO);
        List fscBankCheckFilePOList = this.fscBankCheckFileMapper.getList(fscBankCheckFilePO);
        if (!CollectionUtils.isEmpty((Collection)fscBankCheckFilePOList)) {
            for (FscBankCheckFilePO fscBankCheckFilePOFor : fscBankCheckFilePOList) {
                FscBToBPingAnBankDownLoadCheckFileReqBO downLoadCheckFileReqBO = new FscBToBPingAnBankDownLoadCheckFileReqBO();
                downLoadCheckFileReqBO.setFileName(fscBankCheckFilePOFor.getFileName());
                downLoadCheckFileReqBO.setFilePath(fscBankCheckFilePOFor.getFilePath());
                FscBToBPingAnBankDownLoadCheckFileRspBO dlRspBO = this.fscBToBPingAnBankDownLoadCheckFileService.downLoadCheckFile(downLoadCheckFileReqBO);
                FscFileUploadOSSByUrlAtomReqBO fscFileUploadOSSByUrlAtomReqBO = new FscFileUploadOSSByUrlAtomReqBO();
                fscFileUploadOSSByUrlAtomReqBO.setOldUrl(dlRspBO.getLocalFilePath());
                FscFileUploadOSSByUrlAtomRspBO uploadRspBO = this.fscFileUploadOSSByUrlAtomService.uploadFileByBrl(fscFileUploadOSSByUrlAtomReqBO);
                if (!"0000".equals(uploadRspBO.getRespCode())) {
                    throw new FscBusinessException("193130", uploadRspBO.getRespDesc());
                }
                ArrayList<FscBankCheckFileItemBO> fscBankCheckFileItemBOList = new ArrayList<FscBankCheckFileItemBO>();
                try {
                    Path path = Paths.get("D:/aa.txt", new String[0]);
                    BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);
                    String str = null;
                    while ((str = reader.readLine()) != null) {
                        if (!StringUtils.isEmpty((Object)str)) continue;
                        String[] newStr = str.split("&");
                        FscBankCheckFileItemBO fscBankCheckFileItemBO = new FscBankCheckFileItemBO();
                        fscBankCheckFileItemBO.setBankCheckId(Long.valueOf(Sequence.getInstance().nextId()));
                        fscBankCheckFileItemBO.setSortNo(Long.valueOf(Long.parseLong(newStr[0])));
                        fscBankCheckFileItemBO.setFuncFlag(newStr[1]);
                        fscBankCheckFileItemBO.setPayerOrgCode(newStr[2]);
                        fscBankCheckFileItemBO.setPayerSubAccountNo(newStr[3]);
                        fscBankCheckFileItemBO.setPayerAccountName(newStr[4]);
                        fscBankCheckFileItemBO.setPayeeOraCode(newStr[5]);
                        fscBankCheckFileItemBO.setPayeeSubAccountNo(newStr[6]);
                        fscBankCheckFileItemBO.setPayeeAccountName(newStr[7]);
                        if (!StringUtils.isEmpty((Object)newStr[8])) {
                            fscBankCheckFileItemBO.setTradeAmt(new BigDecimal(newStr[8]));
                        }
                        if (!StringUtils.isEmpty((Object)newStr[9])) {
                            fscBankCheckFileItemBO.setHandlingFee(new BigDecimal(newStr[9]));
                        }
                        fscBankCheckFileItemBO.setTradeDate(newStr[10]);
                        fscBankCheckFileItemBO.setTradeTime(newStr[11]);
                        fscBankCheckFileItemBO.setBankWitnessSeq(newStr[12]);
                        fscBankCheckFileItemBO.setBankTradeSeq(newStr[13]);
                        fscBankCheckFileItemBO.setMemo(newStr[14]);
                        fscBankCheckFileItemBO.setShouldPayNo(newStr[15]);
                        fscBankCheckFileItemBO.setFileName(dlRspBO.getFileName());
                        fscBankCheckFileItemBO.setFileAddr(uploadRspBO.getFileUrl());
                        fscBankCheckFileItemBOList.add(fscBankCheckFileItemBO);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new FscBusinessException("193130", "\u8bfb\u53d6\u94f6\u884c\u5bf9\u8d26\u6587\u4ef6\u9519\u8bef");
                }
                if (CollectionUtils.isEmpty(fscBankCheckFileItemBOList)) continue;
                fscPayBillBankCheckFileBusiReqBO = new FscPayBillBankCheckFileBusiReqBO();
                fscPayBillBankCheckFileBusiReqBO.setFileName(fscBankCheckFilePOFor.getFileName());
                fscPayBillBankCheckFileBusiReqBO.setStatus(FscConstants.BANK_CHECK_STATUS.YES);
                fscPayBillBankCheckFileBusiReqBO.setFscBankCheckFileItemBOs(fscBankCheckFileItemBOList);
                this.fscPayBillBankCheckFileBusiService.bankCheckFile(fscPayBillBankCheckFileBusiReqBO);
            }
        }
        return new FscPayQueryBankCheckFileAbilityRspBO();
    }
}

