/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.busi.api.FscPayBillBankCheckFileBusiService;
import com.tydic.fsc.bill.busi.bo.FscPayBillBankCheckFileBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscPayBillBankCheckFileBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscBankCheckFileItemMapper;
import com.tydic.fsc.dao.FscBankCheckFileMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscWriteOffItemMapper;
import com.tydic.fsc.po.FscBankCheckFileItemPO;
import com.tydic.fsc.po.FscBankCheckFilePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscWriteOffItemPO;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscPayBillBankCheckFileBusiServiceImpl
implements FscPayBillBankCheckFileBusiService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscBankCheckFileItemMapper fscBankCheckFileItemMapper;
    @Autowired
    private FscBankCheckFileMapper fscBankCheckFileMapper;
    @Autowired
    private FscWriteOffItemMapper fscWriteoffitemMapper;

    @Override
    public FscPayBillBankCheckFileBusiRspBO bankCheckFile(FscPayBillBankCheckFileBusiReqBO busiReqBO) {
        ArrayList fscBankCheckFilePOList = new ArrayList();
        if (!CollectionUtils.isEmpty(busiReqBO.getFscBankCheckFileBOs())) {
            busiReqBO.getFscBankCheckFileBOs().forEach(row -> {
                FscBankCheckFilePO fscBankCheckFilePO = new FscBankCheckFilePO();
                fscBankCheckFilePO.setFileName(row.getFileName());
                if (this.fscBankCheckFileMapper.getCheckBy(fscBankCheckFilePO) > 0) {
                    BeanUtils.copyProperties((Object)row, (Object)fscBankCheckFilePO);
                    fscBankCheckFilePO.setCreateTime(new Date());
                    fscBankCheckFilePO.setStatus(FscConstants.BANK_CHECK_STATUS.NO);
                    fscBankCheckFilePOList.add(fscBankCheckFilePO);
                }
            });
        }
        if (!CollectionUtils.isEmpty(fscBankCheckFilePOList)) {
            this.fscBankCheckFileMapper.insertBatch(fscBankCheckFilePOList);
        }
        if (!StringUtils.isEmpty((Object)busiReqBO.getFileName()) && !StringUtils.isEmpty((Object)busiReqBO.getStatus())) {
            FscBankCheckFilePO fscBankCheckFilePO = new FscBankCheckFilePO();
            fscBankCheckFilePO.setFileName(busiReqBO.getFileName());
            fscBankCheckFilePO.setStatus(busiReqBO.getStatus());
            this.fscBankCheckFileMapper.updateById(fscBankCheckFilePO);
        }
        ArrayList fscBankCheckFileItemPOList = new ArrayList();
        ArrayList fscWriteOffItemPOList = new ArrayList();
        if (!CollectionUtils.isEmpty(busiReqBO.getFscBankCheckFileItemBOs())) {
            busiReqBO.getFscBankCheckFileItemBOs().forEach(row -> {
                FscBankCheckFileItemPO fscBankCheckFileItemPO = new FscBankCheckFileItemPO();
                fscBankCheckFileItemPO.setBankTradeSeq(row.getBankTradeSeq());
                BeanUtils.copyProperties((Object)row, (Object)fscBankCheckFileItemPO);
                fscBankCheckFileItemPO.setCreateTime(new Date());
                if (!StringUtils.isEmpty((Object)fscBankCheckFileItemPO.getShouldPayNo())) {
                    FscOrderPO fscOrderPo = new FscOrderPO();
                    fscOrderPo.setOrderNo(fscBankCheckFileItemPO.getShouldPayNo());
                    fscOrderPo.setPayeeBankAccount(fscBankCheckFileItemPO.getPayeeSubAccountNo());
                    fscOrderPo = this.fscOrderMapper.getModelBy(fscOrderPo);
                    if (fscOrderPo.getActualAmount().compareTo(fscBankCheckFileItemPO.getTradeAmt()) == 0) {
                        fscBankCheckFileItemPO.setStatus(FscConstants.BANK_CHECK_ITEM_STATUS.YES);
                        FscWriteOffItemPO fscWriteOffItemPO = new FscWriteOffItemPO();
                        fscWriteOffItemPO.setWriteOffItemId(Long.valueOf(Sequence.getInstance().nextId()));
                        fscWriteOffItemPO.setBankCheckId(fscBankCheckFileItemPO.getBankCheckId());
                        fscWriteOffItemPO.setFscOrderId(fscOrderPo.getFscOrderId());
                        fscWriteOffItemPOList.add(fscWriteOffItemPO);
                    } else if (fscOrderPo.getActualAmount().compareTo(fscBankCheckFileItemPO.getTradeAmt()) > 0) {
                        fscBankCheckFileItemPO.setStatus(FscConstants.BANK_CHECK_ITEM_STATUS.LESS);
                    } else {
                        fscBankCheckFileItemPO.setStatus(FscConstants.BANK_CHECK_ITEM_STATUS.MORE);
                    }
                } else {
                    fscBankCheckFileItemPO.setStatus(FscConstants.BANK_CHECK_ITEM_STATUS.NO);
                }
                fscBankCheckFileItemPO.setWriteOffFlag(FscConstants.WRITE_OFF_FLAG.NO + "");
                fscBankCheckFileItemPOList.add(fscBankCheckFileItemPO);
            });
        }
        if (!CollectionUtils.isEmpty(fscBankCheckFileItemPOList)) {
            this.fscBankCheckFileItemMapper.insertBatch(fscBankCheckFileItemPOList);
        }
        if (!CollectionUtils.isEmpty(fscWriteOffItemPOList)) {
            this.fscWriteoffitemMapper.insertBatch(fscWriteOffItemPOList);
        }
        FscPayBillBankCheckFileBusiRspBO busiRspBO = new FscPayBillBankCheckFileBusiRspBO();
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u4fee\u6539\u6210\u529f");
        return busiRspBO;
    }
}

