/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.busi.api.FscPayBillBankCheckFileBusiService;
import com.tydic.fsc.bill.busi.bo.FscPayBillBankCheckFileBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscPayBillBankCheckFileBusiRspBO;
import com.tydic.fsc.busibase.busi.api.FscOrderStatusFlowBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderStatusFlowBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscOrderStatusFlowBusiRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscBalanceMapper;
import com.tydic.fsc.dao.FscBankCheckFileItemMapper;
import com.tydic.fsc.dao.FscBankCheckFileMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscWriteOffItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscBalancePO;
import com.tydic.fsc.po.FscBankCheckFileItemPO;
import com.tydic.fsc.po.FscBankCheckFilePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscWriteOffItemPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscPayBillBankCheckFileBusiServiceImpl
implements FscPayBillBankCheckFileBusiService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscBankCheckFileItemMapper fscBankCheckFileItemMapper;
    @Autowired
    private FscBankCheckFileMapper fscBankCheckFileMapper;
    @Autowired
    private FscWriteOffItemMapper fscWriteoffitemMapper;
    @Autowired
    private FscBalanceMapper fscBalanceMapper;
    @Autowired
    private FscOrderStatusFlowBusiService fscOrderStatusFlowBusiService;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public FscPayBillBankCheckFileBusiRspBO bankCheckFile(FscPayBillBankCheckFileBusiReqBO busiReqBO) {
        FscPayBillBankCheckFileBusiRspBO busiRspBO = new FscPayBillBankCheckFileBusiRspBO();
        if (FscConstants.BANK_CHECK_OPER_TYPE.INSERT_FILE.equals(busiReqBO.getOperType())) {
            ArrayList fscBankCheckFilePOList = new ArrayList();
            if (!CollectionUtils.isEmpty(busiReqBO.getFscBankCheckFileBOs())) {
                busiReqBO.getFscBankCheckFileBOs().forEach(row -> {
                    FscBankCheckFilePO fscBankCheckFilePO = new FscBankCheckFilePO();
                    fscBankCheckFilePO.setFileName(row.getFileName());
                    if (this.fscBankCheckFileMapper.getCheckBy(fscBankCheckFilePO) <= 0) {
                        BeanUtils.copyProperties((Object)row, (Object)fscBankCheckFilePO);
                        fscBankCheckFilePO.setCreateTime(new Date());
                        fscBankCheckFilePO.setStatus(FscConstants.BANK_CHECK_STATUS.NO);
                        fscBankCheckFilePOList.add(fscBankCheckFilePO);
                    }
                });
            }
            if (!CollectionUtils.isEmpty(fscBankCheckFilePOList)) {
                this.fscBankCheckFileMapper.insertBatch(fscBankCheckFilePOList);
            }
        } else if (FscConstants.BANK_CHECK_OPER_TYPE.INSERT_FILE_ITEM.equals(busiReqBO.getOperType())) {
            ArrayList fscBankCheckFileItemPOList = new ArrayList();
            if (!CollectionUtils.isEmpty(busiReqBO.getFscBankCheckFileItemBOs())) {
                busiReqBO.getFscBankCheckFileItemBOs().forEach(row -> {
                    FscBankCheckFileItemPO fscBankCheckFileItemPO = new FscBankCheckFileItemPO();
                    BeanUtils.copyProperties((Object)row, (Object)fscBankCheckFileItemPO);
                    fscBankCheckFileItemPO.setWriteOffFlag("0");
                    fscBankCheckFileItemPO.setCreateTime(new Date());
                    fscBankCheckFileItemPO.setStatus(FscConstants.BANK_CHECK_ITEM_STATUS.NO_CHECK);
                    fscBankCheckFileItemPOList.add(fscBankCheckFileItemPO);
                });
                this.fscBankCheckFileItemMapper.insertBatch(fscBankCheckFileItemPOList);
                FscBankCheckFilePO fscBankCheckFilePO = new FscBankCheckFilePO();
                fscBankCheckFilePO.setFileName(busiReqBO.getFileName());
                fscBankCheckFilePO.setAttachmentName(busiReqBO.getAttachmentName());
                fscBankCheckFilePO.setAttachmentUrl(busiReqBO.getAttachmentUrl());
                fscBankCheckFilePO.setStatus(busiReqBO.getStatus());
                this.fscBankCheckFileMapper.updateById(fscBankCheckFilePO);
            }
        } else if (FscConstants.BANK_CHECK_OPER_TYPE.CHECK_FILE_ITEM.equals(busiReqBO.getOperType())) {
            ArrayList fscWriteOffItemPOList = new ArrayList();
            ArrayList fscBalancePOList = new ArrayList();
            ArrayList<Long> fscOrderIds = new ArrayList<Long>();
            if (!CollectionUtils.isEmpty(busiReqBO.getFscBankCheckFileItemBOs())) {
                busiReqBO.getFscBankCheckFileItemBOs().forEach(row -> {
                    FscBankCheckFileItemPO fscBankCheckFileItemPO = new FscBankCheckFileItemPO();
                    BeanUtils.copyProperties((Object)row, (Object)fscBankCheckFileItemPO);
                    fscBankCheckFileItemPO.setWriteOffFlag("0");
                    fscBankCheckFileItemPO.setBankTradeSeq(row.getBankTradeSeq());
                    fscBankCheckFileItemPO.setCreateTime(new Date());
                    if (!StringUtils.isEmpty((Object)fscBankCheckFileItemPO.getShouldPayNo())) {
                        FscOrderPO fscOrderPo = new FscOrderPO();
                        fscOrderPo.setOrderNo(fscBankCheckFileItemPO.getShouldPayNo());
                        fscOrderPo.setPayeeBankAccount(fscBankCheckFileItemPO.getPayeeSubAccountNo());
                        fscOrderPo = this.fscOrderMapper.getModelBy(fscOrderPo);
                        if (null != fscOrderPo) {
                            FscOrderPO fscOrderPoUpdate = new FscOrderPO();
                            fscOrderPoUpdate.setFscOrderId(fscOrderPo.getFscOrderId());
                            fscOrderPoUpdate.setPayOperId("1");
                            fscOrderPoUpdate.setPayOperName("");
                            fscOrderPoUpdate.setPayState(FscConstants.PayOrderPayStatus.PAIED);
                            fscOrderPoUpdate.setActualAmount(fscOrderPo.getTotalCharge());
                            int row1 = this.fscOrderMapper.updateByFscOrderId(fscOrderPoUpdate);
                            if ((null == fscOrderPo.getTotalCharge() ? BigDecimal.ZERO : fscOrderPo.getTotalCharge()).compareTo(null == fscBankCheckFileItemPO.getTradeAmt() ? BigDecimal.ZERO : fscBankCheckFileItemPO.getTradeAmt()) == 0) {
                                fscBankCheckFileItemPO.setStatus(FscConstants.BANK_CHECK_ITEM_STATUS.YES);
                                fscBankCheckFileItemPO.setWriteOffFlag("1");
                                FscWriteOffItemPO fscWriteOffItemPO = new FscWriteOffItemPO();
                                fscWriteOffItemPO.setWriteOffItemId(Long.valueOf(Sequence.getInstance().nextId()));
                                fscWriteOffItemPO.setBankCheckId(fscBankCheckFileItemPO.getBankCheckId());
                                fscWriteOffItemPO.setFscOrderId(fscOrderPo.getFscOrderId());
                                fscWriteOffItemPOList.add(fscWriteOffItemPO);
                                FscBalancePO fscBalancePO = new FscBalancePO();
                                fscBalancePO.setBalanceId(Long.valueOf(Sequence.getInstance().nextId()));
                                fscBalancePO.setBankCheckId(fscBankCheckFileItemPO.getBankCheckId());
                                fscBalancePO.setOrgId(fscOrderPo.getPayeeId());
                                fscBalancePO.setOrgCode("");
                                fscBalancePO.setOrgName(fscOrderPo.getPayeeName());
                                fscBalancePO.setSubAccountNo(fscOrderPo.getPayeeBankAccount());
                                fscBalancePO.setPayerOrgId(fscOrderPo.getPayerId());
                                fscBalancePO.setPayerOrgName(fscOrderPo.getPayerName());
                                fscBalancePO.setPayerOrgCode(null);
                                fscBalancePO.setPayerSubAccountNo(null);
                                Calendar curDate = Calendar.getInstance();
                                if (null != fscOrderPo.getLastPayDate()) {
                                    curDate.setTime(fscOrderPo.getLastPayDate());
                                    Integer advanceUnfreezeDays = this.getConfiguration(fscOrderPo.getPayeeId().toString());
                                    if (!"0".equals(advanceUnfreezeDays)) {
                                        curDate.add(5, 0 - advanceUnfreezeDays);
                                    }
                                }
                                fscBalancePO.setFrozenEndTime(curDate.getTime());
                                fscBalancePO.setPayAmount(fscOrderPo.getTotalCharge());
                                if (fscBalancePO.getFrozenEndTime().compareTo(new Date()) <= 0) {
                                    fscBalancePO.setFrozenAmount(new BigDecimal(0));
                                    fscBalancePO.setUsableAmount(fscOrderPo.getTotalCharge());
                                    fscBalancePO.setThawOperTime(new Date());
                                } else {
                                    fscBalancePO.setFrozenAmount(fscOrderPo.getTotalCharge());
                                    fscBalancePO.setUsableAmount(new BigDecimal(0));
                                }
                                fscBalancePO.setUsedAmount(new BigDecimal(0));
                                fscBalancePOList.add(fscBalancePO);
                                fscOrderIds.add(fscOrderPo.getFscOrderId());
                            } else if ((null == fscBankCheckFileItemPO.getTradeAmt() ? BigDecimal.ZERO : fscBankCheckFileItemPO.getTradeAmt()).compareTo(null == fscOrderPo.getTotalCharge() ? BigDecimal.ZERO : fscOrderPo.getTotalCharge()) > 0) {
                                fscBankCheckFileItemPO.setStatus(FscConstants.BANK_CHECK_ITEM_STATUS.MORE);
                            } else {
                                fscBankCheckFileItemPO.setStatus(FscConstants.BANK_CHECK_ITEM_STATUS.LESS);
                            }
                        } else {
                            fscBankCheckFileItemPO.setStatus(FscConstants.BANK_CHECK_ITEM_STATUS.NO);
                        }
                    } else {
                        fscBankCheckFileItemPO.setStatus(FscConstants.BANK_CHECK_ITEM_STATUS.NO);
                    }
                    this.fscBankCheckFileItemMapper.updateByBankCheckId(fscBankCheckFileItemPO);
                });
            }
            if (!CollectionUtils.isEmpty(fscWriteOffItemPOList)) {
                this.fscWriteoffitemMapper.insertBatch(fscWriteOffItemPOList);
            }
            if (!CollectionUtils.isEmpty(fscBalancePOList)) {
                this.fscBalanceMapper.insertBatch(fscBalancePOList);
            }
            if (null != fscOrderIds) {
                FscOrderStatusFlowBusiReqBO fscOrderStatusFlowBusiReqBO = new FscOrderStatusFlowBusiReqBO();
                fscOrderStatusFlowBusiReqBO.setOrderIds(fscOrderIds);
                HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
                paramMap.put("confirmFlag", 0);
                fscOrderStatusFlowBusiReqBO.setParamMap(paramMap);
                fscOrderStatusFlowBusiReqBO.setCurStatus(FscConstants.FscPayOrderState.TO_PAY);
                FscOrderStatusFlowBusiRspBO fscOrderStatusFlowBusiRspBO = this.fscOrderStatusFlowBusiService.dealStatusFlow(fscOrderStatusFlowBusiReqBO);
            }
            busiRspBO.setFscOrderIds(fscOrderIds);
        }
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u4fee\u6539\u6210\u529f");
        return busiRspBO;
    }

    private Integer getConfiguration(String relId) {
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("cash_withdrawal");
        fscCfcUniteParamQryListDetailExternalReqBO.setRelId(relId);
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191014", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        if (!StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceUnfreezeDays())) {
            return Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceUnfreezeDays());
        }
        return 0;
    }
}

