/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.util.StrUtil;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.api.FscPayQueryBankCheckFileAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBankCheckFileItemBO;
import com.tydic.fsc.bill.ability.bo.FscPayQueryBankCheckFileAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscPayQueryBankCheckFileAbilityRspBO;
import com.tydic.fsc.bill.atom.api.FscFileUploadOSSByUrlAtomService;
import com.tydic.fsc.bill.atom.bo.FscFileUploadOSSByUrlAtomReqBO;
import com.tydic.fsc.bill.atom.bo.FscFileUploadOSSByUrlAtomRspBO;
import com.tydic.fsc.bill.busi.api.FscPayBillBankCheckFileBusiService;
import com.tydic.fsc.bill.busi.bo.FscBankCheckFileBO;
import com.tydic.fsc.bill.busi.bo.FscPayBillBankCheckFileBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscPayBillBankCheckFileBusiRspBO;
import com.tydic.fsc.bo.FscOrderRelUpdateBO;
import com.tydic.fsc.busibase.comb.api.FscUocOrderRelUpdateCombService;
import com.tydic.fsc.busibase.comb.bo.FscUocOrderRelUpdateCombReqBO;
import com.tydic.fsc.busibase.comb.bo.FscUocOrderRelUpdateCombRspBO;
import com.tydic.fsc.busibase.external.api.pay.FscBToBPingAnBankDownLoadCheckFileService;
import com.tydic.fsc.busibase.external.api.pay.FscBToBPingAnBankQueryCheckFileService;
import com.tydic.fsc.busibase.external.api.pay.bo.FscBToBPingAnBankDownLoadCheckFileReqBO;
import com.tydic.fsc.busibase.external.api.pay.bo.FscBToBPingAnBankDownLoadCheckFileRspBO;
import com.tydic.fsc.busibase.external.api.pay.bo.FscBToBPingAnBankQueryCheckFileReqBO;
import com.tydic.fsc.busibase.external.api.pay.bo.FscBToBPingAnBankQueryCheckFileRspBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscBankCheckFileItemMapper;
import com.tydic.fsc.dao.FscBankCheckFileMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscBankCheckFileItemPO;
import com.tydic.fsc.po.FscBankCheckFilePO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscPayQueryBankCheckFileAbilityService"})
public class FscPayQueryBankCheckFileAbilityServiceImpl
implements FscPayQueryBankCheckFileAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscPayQueryBankCheckFileAbilityServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscBankCheckFileMapper fscBankCheckFileMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscBankCheckFileItemMapper fscBankCheckFileItemMapper;
    @Autowired
    private FscBToBPingAnBankQueryCheckFileService fscBToBPingAnBankQueryCheckFileService;
    @Autowired
    private FscPayBillBankCheckFileBusiService fscPayBillBankCheckFileBusiService;
    @Autowired
    private FscBToBPingAnBankDownLoadCheckFileService fscBToBPingAnBankDownLoadCheckFileService;
    @Autowired
    private FscFileUploadOSSByUrlAtomService fscFileUploadOSSByUrlAtomService;
    @Autowired
    private FscUocOrderRelUpdateCombService fscUocOrderRelUpdateCombService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"qryBankCheckFile"})
    public FscPayQueryBankCheckFileAbilityRspBO qryBankCheckFile(@RequestBody FscPayQueryBankCheckFileAbilityReqBO abilityReqBO) {
        FscBToBPingAnBankQueryCheckFileReqBO bankReqBO = new FscBToBPingAnBankQueryCheckFileReqBO();
        if (!StringUtils.isEmpty((Object)abilityReqBO.getFileDate())) {
            bankReqBO.setFileDate(abilityReqBO.getFileDate());
        } else {
            Calendar curDate = Calendar.getInstance();
            curDate.setTime(new Date());
            curDate.add(5, -1);
            bankReqBO.setFileDate(DateUtil.dateToStrYYYYMMdd((Date)curDate.getTime()));
        }
        bankReqBO.setFileType("CZ");
        FscBToBPingAnBankQueryCheckFileRspBO bankRspBO = this.fscBToBPingAnBankQueryCheckFileService.checkAmountFile(bankReqBO);
        if (!"0000".equals(bankRspBO.getRespCode())) {
            throw new FscBusinessException("193130", bankRspBO.getRespDesc());
        }
        ArrayList<FscBankCheckFileBO> fscBankCheckFileBOs = new ArrayList<FscBankCheckFileBO>();
        if (null != bankRspBO && !CollectionUtils.isEmpty((Collection)bankRspBO.getTranItemArray())) {
            bankRspBO.getTranItemArray().forEach(row -> {
                if (row.getFileName().indexOf(".txt.enc") > 0) {
                    FscBankCheckFileBO fscBankCheckFileBO = new FscBankCheckFileBO();
                    fscBankCheckFileBO.setFileName(row.getFileName());
                    fscBankCheckFileBO.setFilePath(row.getFilePath());
                    fscBankCheckFileBO.setRandomPassword(row.getRandomPassword());
                    fscBankCheckFileBO.setDrawCode(row.getDrawCode());
                    fscBankCheckFileBOs.add(fscBankCheckFileBO);
                }
            });
        }
        if (!CollectionUtils.isEmpty(fscBankCheckFileBOs)) {
            FscPayBillBankCheckFileBusiReqBO fscPayBillBankCheckFileBusiReqBO = new FscPayBillBankCheckFileBusiReqBO();
            fscPayBillBankCheckFileBusiReqBO.setFscBankCheckFileBOs(fscBankCheckFileBOs);
            fscPayBillBankCheckFileBusiReqBO.setOperType(FscConstants.BANK_CHECK_OPER_TYPE.INSERT_FILE);
            FscPayBillBankCheckFileBusiRspBO fscPayBillBankCheckFileBusiRspBO = this.fscPayBillBankCheckFileBusiService.bankCheckFile(fscPayBillBankCheckFileBusiReqBO);
            if (!"0000".equals(fscPayBillBankCheckFileBusiRspBO.getRespCode())) {
                throw new FscBusinessException("193130", fscPayBillBankCheckFileBusiRspBO.getRespDesc());
            }
        }
        FscBankCheckFilePO fscBankCheckFilePO = new FscBankCheckFilePO();
        fscBankCheckFilePO.setStatus(FscConstants.BANK_CHECK_STATUS.NO);
        List fscBankCheckFilePOList = this.fscBankCheckFileMapper.getList(fscBankCheckFilePO);
        if (!CollectionUtils.isEmpty((Collection)fscBankCheckFilePOList)) {
            for (FscBankCheckFilePO fscBankCheckFilePOFor : fscBankCheckFilePOList) {
                String fileName;
                FscBToBPingAnBankDownLoadCheckFileReqBO downLoadCheckFileReqBO = new FscBToBPingAnBankDownLoadCheckFileReqBO();
                downLoadCheckFileReqBO.setFileName(fscBankCheckFilePOFor.getFileName());
                downLoadCheckFileReqBO.setFilePath(fscBankCheckFilePOFor.getFilePath());
                downLoadCheckFileReqBO.setDecryptKey(fscBankCheckFilePOFor.getRandomPassword());
                FscBToBPingAnBankDownLoadCheckFileRspBO dlRspBO = null;
                try {
                    dlRspBO = this.fscBToBPingAnBankDownLoadCheckFileService.downLoadCheckFile(downLoadCheckFileReqBO);
                }
                catch (FscBusinessException e) {
                    e.printStackTrace();
                    log.debug("\u8bfb\u53d6\u94f6\u884c\u5bf9\u8d26\u6587\u4ef6\u9519\u8bef");
                    continue;
                }
                FscFileUploadOSSByUrlAtomReqBO fscFileUploadOSSByUrlAtomReqBO = new FscFileUploadOSSByUrlAtomReqBO();
                fscFileUploadOSSByUrlAtomReqBO.setLocalUrl(dlRspBO.getLocalFilePath());
                FscFileUploadOSSByUrlAtomRspBO uploadRspBO = null;
                try {
                    uploadRspBO = this.fscFileUploadOSSByUrlAtomService.uploadFileByBrl(fscFileUploadOSSByUrlAtomReqBO);
                }
                catch (FscBusinessException e) {
                    e.printStackTrace();
                    log.debug("\u8bfb\u53d6\u94f6\u884c\u5bf9\u8d26\u6587\u4ef6\u9519\u8bef");
                    continue;
                }
                ArrayList<FscBankCheckFileItemBO> fscBankCheckFileItemBOList = new ArrayList<FscBankCheckFileItemBO>();
                try {
                    File file = new File(dlRspBO.getLocalFilePath());
                    fileName = file.getName();
                    InputStreamReader insr = new InputStreamReader((InputStream)new FileInputStream(file), "GBK");
                    BufferedReader reader = new BufferedReader(insr);
                    String str = null;
                    while ((str = reader.readLine()) != null) {
                        if (StringUtils.isEmpty((Object)str)) continue;
                        String[] newStr = str.split("&");
                        FscBankCheckFileItemBO fscBankCheckFileItemBO = new FscBankCheckFileItemBO();
                        fscBankCheckFileItemBO.setBankCheckId(Long.valueOf(Sequence.getInstance().nextId()));
                        fscBankCheckFileItemBO.setSortNo(newStr[0]);
                        fscBankCheckFileItemBO.setPayeeOraCode(newStr[1]);
                        fscBankCheckFileItemBO.setPayeeSubAccountNo(newStr[2]);
                        fscBankCheckFileItemBO.setPayeeAccountName(newStr[3]);
                        if (!StringUtils.isEmpty((Object)newStr[4])) {
                            fscBankCheckFileItemBO.setTradeAmt(new BigDecimal(newStr[4]));
                        }
                        if (!StringUtils.isEmpty((Object)newStr[5])) {
                            fscBankCheckFileItemBO.setHandlingFee(new BigDecimal(newStr[5]));
                        }
                        fscBankCheckFileItemBO.setTradeDate(newStr[6]);
                        fscBankCheckFileItemBO.setTradeTime(newStr[7]);
                        fscBankCheckFileItemBO.setBankWitnessSeq(newStr[8]);
                        fscBankCheckFileItemBO.setBankTradeSeq(newStr[9]);
                        fscBankCheckFileItemBO.setMemo(newStr[11]);
                        fscBankCheckFileItemBO.setShouldPayNo(newStr[10]);
                        fscBankCheckFileItemBO.setFileName(fileName);
                        fscBankCheckFileItemBO.setFileAddr(uploadRspBO.getInnerFileUrl());
                        fscBankCheckFileItemBOList.add(fscBankCheckFileItemBO);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    log.debug("\u8bfb\u53d6\u94f6\u884c\u5bf9\u8d26\u6587\u4ef6\u9519\u8bef");
                    continue;
                }
                if (CollectionUtils.isEmpty(fscBankCheckFileItemBOList)) continue;
                FscPayBillBankCheckFileBusiReqBO fscPayBillBankCheckFileBusiReqBO = new FscPayBillBankCheckFileBusiReqBO();
                fscPayBillBankCheckFileBusiReqBO.setFileName(fscBankCheckFilePOFor.getFileName());
                fscPayBillBankCheckFileBusiReqBO.setAttachmentUrl(uploadRspBO.getInnerFileUrl());
                fscPayBillBankCheckFileBusiReqBO.setAttachmentName(fileName);
                fscPayBillBankCheckFileBusiReqBO.setStatus(FscConstants.BANK_CHECK_STATUS.YES);
                fscPayBillBankCheckFileBusiReqBO.setFscBankCheckFileItemBOs(fscBankCheckFileItemBOList);
                fscPayBillBankCheckFileBusiReqBO.setOperType(FscConstants.BANK_CHECK_OPER_TYPE.INSERT_FILE_ITEM);
                try {
                    this.fscPayBillBankCheckFileBusiService.bankCheckFile(fscPayBillBankCheckFileBusiReqBO);
                }
                catch (FscBusinessException e) {
                    e.printStackTrace();
                    log.debug("\u5199\u5bf9\u8d26\u6587\u4ef6\u660e\u7ec6\u5931\u8d25");
                }
            }
        }
        FscBankCheckFileItemPO fscBankCheckFileItemPo = new FscBankCheckFileItemPO();
        fscBankCheckFileItemPo.setStatus(FscConstants.BANK_CHECK_ITEM_STATUS.NO_CHECK);
        fscBankCheckFileItemPo.setWriteOffFlag("0".toString());
        List fscBankCheckFileItemPOList = this.fscBankCheckFileItemMapper.getList(fscBankCheckFileItemPo);
        if (!CollectionUtils.isEmpty((Collection)fscBankCheckFileItemPOList)) {
            for (FscBankCheckFileItemPO fscBankCheckFileItemPO : fscBankCheckFileItemPOList) {
                FscPayBillBankCheckFileBusiReqBO fscPayBillBankCheckFileBusiReqBO = new FscPayBillBankCheckFileBusiReqBO();
                FscBankCheckFileItemBO fscBankCheckFileItemBO = new FscBankCheckFileItemBO();
                BeanUtils.copyProperties((Object)fscBankCheckFileItemPO, (Object)fscBankCheckFileItemBO);
                fscPayBillBankCheckFileBusiReqBO.setFscBankCheckFileItemBOs(Arrays.asList(fscBankCheckFileItemBO));
                fscPayBillBankCheckFileBusiReqBO.setOperType(FscConstants.BANK_CHECK_OPER_TYPE.CHECK_FILE_ITEM);
                FscPayBillBankCheckFileBusiRspBO fscPayBillBankCheckFileBusiRspBO = null;
                try {
                    fscPayBillBankCheckFileBusiRspBO = this.fscPayBillBankCheckFileBusiService.bankCheckFile(fscPayBillBankCheckFileBusiReqBO);
                }
                catch (FscBusinessException e) {
                    e.printStackTrace();
                    continue;
                }
                if (null == fscPayBillBankCheckFileBusiRspBO.getFscOrderIds()) continue;
                for (Long fscOrderId : fscPayBillBankCheckFileBusiRspBO.getFscOrderIds()) {
                    FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
                    fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
                    this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
                    this.syncOrderStatus(fscOrderId);
                }
            }
        }
        return new FscPayQueryBankCheckFileAbilityRspBO();
    }

    private void syncOrderStatus(Long fscPayOrderId) {
        List fscShouldPayPOList = this.fscShouldPayMapper.getByFscOrderId(fscPayOrderId);
        for (FscShouldPayPO fscShouldPayPO : fscShouldPayPOList) {
            FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
            fscOrderRelationPo.setFscOrderId(fscShouldPayPO.getObjectId());
            List fscOrderRelationPOs = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
            for (FscOrderRelationPO fscOrderRelationPO : fscOrderRelationPOs) {
                FscUocOrderRelUpdateCombReqBO fscUocOrderRelUpdateCombReqBO = new FscUocOrderRelUpdateCombReqBO();
                fscUocOrderRelUpdateCombReqBO.setFscOrderId(fscShouldPayPO.getObjectId());
                fscUocOrderRelUpdateCombReqBO.setRelState(FscConstants.FscRelStatus.COMMITTED);
                fscUocOrderRelUpdateCombReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.ORDER);
                ArrayList<FscOrderRelUpdateBO> fscOrderRelUpdateBOS = new ArrayList<FscOrderRelUpdateBO>();
                FscOrderRelUpdateBO fscOrderRelUpdateBO = new FscOrderRelUpdateBO();
                fscOrderRelUpdateBO.setOrderId(fscOrderRelationPO.getOrderId());
                fscOrderRelUpdateBO.setRelId(fscShouldPayPO.getObjectId());
                fscOrderRelUpdateBO.setRelState(FscConstants.PAY_STATE.PAYED);
                fscOrderRelUpdateBO.setPayTime(new Date());
                fscOrderRelUpdateBOS.add(fscOrderRelUpdateBO);
                fscUocOrderRelUpdateCombReqBO.setFscOrderRelUpdateBOS(fscOrderRelUpdateBOS);
                FscUocOrderRelUpdateCombRspBO fscUocOrderRelUpdateCombRspBO = this.fscUocOrderRelUpdateCombService.dealRelUpdate(fscUocOrderRelUpdateCombReqBO);
                if ("0000".equals(fscUocOrderRelUpdateCombRspBO.getRespCode())) continue;
                throw new FscBusinessException("193207", StrUtil.format((CharSequence)"\u540c\u6b65\u66f4\u65b0\u8ba2\u5355\u51fa\u9519\uff1a{}", (Object[])new Object[]{fscUocOrderRelUpdateCombRspBO.getRespDesc()}));
            }
        }
    }
}

