/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DelFormatHelper;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.fsc.bill.ability.api.FscQryEsLogisticsInfoAbilityService;
import com.tydic.fsc.bill.ability.bo.FscEsbReqParamBO;
import com.tydic.fsc.bill.ability.bo.FscQryEsLogisticsInfoAbilityServiceReqBo;
import com.tydic.fsc.bill.ability.bo.FscQryEsLogisticsInfoAbilityServiceRspBo;
import com.tydic.fsc.bill.ability.bo.FscTrackInfoBO;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoicePostMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscInvoicePostPO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.utils.EsbParamUtil;
import com.tydic.fsc.utils.SSLClient;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscQryEsLogisticsInfoAbilityService"})
public class FscQryEsLogisticsInfoAbilityServiceImpl
implements FscQryEsLogisticsInfoAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscQryEsLogisticsInfoAbilityServiceImpl.class);
    @Autowired
    private Environment prop;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscInvoicePostMapper fscInvoicePostMapper;
    @Value(value="${ESB_QRY_INVOICE_TRACK_URL:${ESB_ACCESS_IP}/OSN/api/invoiceWayBill/v1}")
    private String ESB_QRY_INVOICE_TRACK_URL;
    public static final String FIELD_CODE = "jdOrgId";
    public static final String RESULT2_CODE = "4";

    @PostMapping(value={"qryEsLogisticsDataList"})
    public FscQryEsLogisticsInfoAbilityServiceRspBo qryEsLogisticsDataList(@RequestBody FscQryEsLogisticsInfoAbilityServiceReqBo reqBo) {
        FscQryEsLogisticsInfoAbilityServiceRspBo rspBo = new FscQryEsLogisticsInfoAbilityServiceRspBo();
        FscInvoicePostPO invoicePostPO = this.fscInvoicePostMapper.getModelByMailId(reqBo.getFscOrderId());
        this.validateParams(reqBo);
        log.debug("\u67e5\u8be2\u7269\u6d41\u914d\u9001\u4fe1\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqBo));
        FscInvoicePO fscInvoicePo = new FscInvoicePO();
        fscInvoicePo.setFscOrderId(reqBo.getFscOrderId());
        List fscInvoicePOList = this.fscInvoiceMapper.getList(fscInvoicePo);
        if (ObjectUtil.isEmpty((Object)fscInvoicePOList)) {
            throw new BaseBusinessException("101013", "\u672a\u67e5\u8be2\u5230\u53d1\u7968\u4fe1\u606f");
        }
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBo.getFscOrderId());
        fscOrderPo = this.fscOrderMapper.getModelBy(fscOrderPo);
        try {
            FscEsbReqParamBO esbReqParam = new FscEsbReqParamBO();
            esbReqParam.setOrderId(((FscInvoicePO)fscInvoicePOList.get(0)).getMailId() + "");
            esbReqParam.setType(UocConstant.ORD_TYPE.SHIP_ORD);
            esbReqParam.setSupplierId(fscOrderPo.getSupplierId());
            esbReqParam.setOrgId(null);
            esbReqParam.setMarkId(((FscInvoicePO)fscInvoicePOList.get(0)).getFscOrderId().toString());
            esbReqParam.setNum(invoicePostPO.getSendOrder());
            esbReqParam.setCom(invoicePostPO.getSendCompany());
            esbReqParam.setResultv2(RESULT2_CODE);
            String reqStr = this.initPostStr(esbReqParam);
            log.debug("\u8bf7\u6c42\u53c2\u6570:{}", (Object)reqStr);
            String returnString = SSLClient.doPost((String)this.ESB_QRY_INVOICE_TRACK_URL, (String)reqStr);
            log.debug("\u8c03\u7528ESB\u67e5\u8be2\u914d\u9001\u4fe1\u606f\u63a5\u53e3\u54cd\u5e94\u62a5\u6587:{}", (Object)returnString);
            if (ObjectUtil.isEmpty((Object)returnString)) {
                throw new BaseBusinessException("101014", "\u8c03\u7528ESB\u67e5\u8be2\u914d\u9001\u4fe1\u606f\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
            }
            rspBo = this.resolveRsp(returnString, rspBo);
            FscOrderInvoicePO fscOrderInvoicePO = new FscOrderInvoicePO();
            fscOrderInvoicePO.setFscOrderId(reqBo.getFscOrderId());
            List list = this.fscOrderInvoiceMapper.getList(fscOrderInvoicePO);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                rspBo.setReceiveName(((FscOrderInvoicePO)list.get(0)).getReceiveName());
                rspBo.setReceivePhone(((FscOrderInvoicePO)list.get(0)).getReceivePhone());
                rspBo.setReceiveEmail(((FscOrderInvoicePO)list.get(0)).getReceiveEmail());
                StringBuilder address = new StringBuilder("");
                if (!StringUtils.isEmpty((Object)((FscOrderInvoicePO)list.get(0)).getProvince())) {
                    address.append(((FscOrderInvoicePO)list.get(0)).getProvince());
                }
                if (!StringUtils.isEmpty((Object)((FscOrderInvoicePO)list.get(0)).getCity())) {
                    address.append(((FscOrderInvoicePO)list.get(0)).getCity());
                }
                if (!StringUtils.isEmpty((Object)((FscOrderInvoicePO)list.get(0)).getArea())) {
                    address.append(((FscOrderInvoicePO)list.get(0)).getArea());
                }
                if (!StringUtils.isEmpty((Object)((FscOrderInvoicePO)list.get(0)).getTown())) {
                    address.append(((FscOrderInvoicePO)list.get(0)).getTown());
                }
                if (!StringUtils.isEmpty((Object)((FscOrderInvoicePO)list.get(0)).getReceiveAddr())) {
                    address.append(((FscOrderInvoicePO)list.get(0)).getReceiveAddr());
                }
                rspBo.setAddress(address.toString());
            }
            return rspBo;
        }
        catch (Exception e) {
            log.error("\u8c03\u7528ESB\u67e5\u8be2\u914d\u9001\u4fe1\u606f\u670d\u52a1\u63a5\u53e3\u5f02\u5e38:{}", (Throwable)e);
            throw new BaseBusinessException("101013", "\u8c03\u7528ESB\u67e5\u8be2\u914d\u9001\u4fe1\u606f\u670d\u52a1\u63a5\u53e3\u5f02\u5e38");
        }
    }

    private String initPostStr(FscEsbReqParamBO reqParam) {
        String hsn = this.prop.getProperty("SUPPLIER_ID_" + reqParam.getSupplierId());
        String esbReqParam = EsbParamUtil.getEsbReqParam((Object)reqParam, (String)hsn, (String)"BUSINESS_PAY");
        log.debug("\u8c03\u7528\u914d\u9001\u4fe1\u606f\u67e5\u8be2ESB\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)esbReqParam);
        return esbReqParam;
    }

    private FscQryEsLogisticsInfoAbilityServiceRspBo resolveRsp(String returnString, FscQryEsLogisticsInfoAbilityServiceRspBo rspBo) {
        log.debug("\u8c03\u7528\u914d\u9001\u4fe1\u606f\u67e5\u8be2ESB\u63a5\u53e3\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)returnString);
        JSONObject jsonObject = JSONObject.parseObject((String)returnString);
        if (jsonObject.getBoolean("success").booleanValue()) {
            String jsonStr = JSONObject.toJSONString((Object)jsonObject.get((Object)"result"));
            if (ObjectUtil.isNotEmpty((Object)jsonStr)) {
                String waybillCode;
                List orderTrackList;
                JSONObject object = JSONObject.parseObject((String)JSONObject.parseArray((String)jsonStr).get(0).toString());
                String orderTrack = JSONObject.toJSONString((Object)object.get((Object)"orderTrack"));
                rspBo.setSendCompany(object.get((Object)"postCompany") == null ? null : object.get((Object)"postCompany").toString());
                rspBo.setPostTime(object.get((Object)"postTime") == null ? null : object.get((Object)"postTime").toString());
                rspBo.setDeliveryOrderId(object.get((Object)"deliveryId") == null ? null : object.get((Object)"deliveryId").toString());
                rspBo.setSendOrder(object.get((Object)"postId") == null ? null : object.get((Object)"postId").toString());
                rspBo.setState(object.get((Object)"state") == null ? null : object.get((Object)"state").toString());
                if (!StringUtils.isEmpty((Object)rspBo.getState())) {
                    if (rspBo.getState().equals("1")) {
                        rspBo.setState("\u5df2\u914d\u9001");
                    } else if (rspBo.getState().equals("2")) {
                        rspBo.setState("\u5df2\u53d6\u6d88");
                    }
                }
                if (ObjectUtil.isNotEmpty((Object)orderTrack) && ObjectUtil.isNotEmpty((Object)(orderTrackList = JSON.parseArray((String)orderTrack, FscTrackInfoBO.class)))) {
                    this.listSort(orderTrackList);
                    rspBo.setFscTrackList(orderTrackList);
                }
                if ((waybillCode = object.getString("waybillCode")) != null) {
                    try {
                        JSONArray array = JSONArray.parseArray((String)waybillCode);
                        rspBo.setCarrier(array.getJSONObject(0).getString("carrier"));
                        rspBo.setDeliveryOrderId(array.getJSONObject(0).getString("deliveryOrderId"));
                    }
                    catch (Exception e) {
                        try {
                            JSONObject code = JSONObject.parseObject((String)waybillCode);
                            rspBo.setCarrier(code.getString("carrier"));
                            rspBo.setDeliveryOrderId(code.getString("deliveryOrderId"));
                        }
                        catch (Exception ignored) {
                            log.error("\u89e3\u6790\u5f02\u5e38:{}", (Object)ignored.getMessage());
                        }
                    }
                }
            }
        } else {
            rspBo.setRespCode("101012");
            rspBo.setRespDesc("\u8c03\u7528\u914d\u9001\u4fe1\u606f\u67e5\u8be2ESB\u63a5\u53e3\u5931\u8d25" + jsonObject.get((Object)"resultMessage"));
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void listSort(List<FscTrackInfoBO> list) {
        Collections.sort(list, new Comparator<FscTrackInfoBO>(){

            @Override
            public int compare(FscTrackInfoBO o1, FscTrackInfoBO o2) {
                try {
                    Date dt1 = DelFormatHelper.fromSdfToDate((String)o1.getMsgTime());
                    Date dt2 = DelFormatHelper.fromSdfToDate((String)o2.getMsgTime());
                    if (dt1.getTime() < dt2.getTime()) {
                        return 1;
                    }
                    if (dt1.getTime() > dt2.getTime()) {
                        return -1;
                    }
                    return 0;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 0;
                }
            }
        });
    }

    private void validateParams(FscQryEsLogisticsInfoAbilityServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[FscQryLogisticsInfoServiceReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNull((Object)reqBo.getFscOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u7ed3\u7b97\u5355ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

