/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.cfc.ability.api.CfcQryFinancialTypeMapAbilityService;
import com.tydic.fsc.bill.busi.api.FscBillOrderApprovalCreateBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderCreateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderCreateBusiRspBO;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.bo.RelOrderBO;
import com.tydic.fsc.bo.SplitOrderBO;
import com.tydic.fsc.busibase.atom.api.FscAuditOrderCreateAtomService;
import com.tydic.fsc.busibase.atom.api.FscGeneralBusiRuleExecAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.api.FscPayShouldPayCreateAtomService;
import com.tydic.fsc.busibase.atom.api.FscUocOrderRelUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAuditOrderCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAuditOrderCreateAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscGeneralBusiRuleExecAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscGeneralBusiRuleExecAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomReqBO;
import com.tydic.fsc.busibase.busi.api.FscBillOrderCreatePdfBusiService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscInvoiceRuleMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoiceRulePO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.osworkflow.approve.ability.EacProjectAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscBillOrderApprovalCreateBusiServiceImpl
implements FscBillOrderApprovalCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderApprovalCreateBusiServiceImpl.class);
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscInvoiceRuleMapper fscInvoiceRuleMapper;
    @Autowired
    private FscUocOrderRelUpdateAtomService fscUocOrderRelUpdateAtomService;
    @Autowired
    private FscPayShouldPayCreateAtomService fscPayShouldPayCreateAtomService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscBillOrderCreatePdfBusiService fscBillOrderCreatePdfBusiService;
    @Autowired
    private FscAuditOrderCreateAtomService fscAuditOrderCreateAtomService;
    @Value(value="${process.sysCode}")
    private String processSysCode;
    @Autowired
    private FscGeneralBusiRuleExecAtomService fscGeneralBusiRuleExecAtomService;
    @Autowired
    private CfcQryFinancialTypeMapAbilityService cfcQryFinancialTypeMapAbilityService;
    @Autowired
    private EacProjectAbilityService eacProjectAbilityService;
    private static final String BUSI_NAME = "\u7ed3\u7b97\u5355\u5ba1\u6279";
    private static final String NO_NEED_AUDIT = "noNeedAudit";

    @Override
    public FscBillOrderCreateBusiRspBO dealApprovalCreate(FscBillOrderCreateBusiReqBO reqBO) {
        log.info("\u7ed3\u7b97\u5ba1\u6279-\u4fdd\u5b58\u5165\u53c2:{}", (Object)reqBO);
        ArrayList<FscOrderPO> fscOrderPOS = new ArrayList<FscOrderPO>();
        ArrayList<FscOrderRelationPO> fscOrderRelationPOS = new ArrayList<FscOrderRelationPO>();
        ArrayList fscOrderItemPOS = new ArrayList();
        ArrayList<FscOrderInvoicePO> fscOrderInvoicePOS = new ArrayList<FscOrderInvoicePO>();
        ArrayList<FscInvoiceRulePO> fscInvoiceRulePOS = new ArrayList<FscInvoiceRulePO>();
        ArrayList<Long> fscOrderIds = new ArrayList<Long>();
        Integer elecFlag = FscConstants.FscInvoiceRuleElecFlag.NO;
        if (FscConstants.FscInvoiceCategory.ELEC.equals(reqBO.getInvoiceCategory())) {
            elecFlag = FscConstants.FscInvoiceRuleElecFlag.YES;
        }
        int num = 0;
        FscOrderPO fscOrderPo = (FscOrderPO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderPO.class);
        if (ObjectUtil.isEmpty((Object)reqBO.getFscOrderId())) {
            fscOrderPo.setFscOrderId(Long.valueOf(Sequence.getInstance().nextId()));
        } else {
            fscOrderPo.setFscOrderId(reqBO.getFscOrderId());
        }
        fscOrderPo.setCreateTime(new Date());
        fscOrderPo.setCreateOperId(reqBO.getUserId());
        fscOrderPo.setCreateOperName(reqBO.getName());
        fscOrderPo.setCreateOrgId(reqBO.getOrgId());
        fscOrderPo.setCreateOrgName(reqBO.getOrgName());
        fscOrderPo.setCreateCompanyId(reqBO.getCompanyId());
        fscOrderPo.setCreateCompanyName(reqBO.getCompanyName());
        fscOrderPo.setSyncFailReason("\u5931\u8d25,\u8bf7\u68c0\u67e5");
        fscOrderPo.setOrderNo(reqBO.getOrderNos().get(num));
        fscOrderPo.setBuildAction(FscConstants.FscOrderBuildAction.HAND);
        if (null != reqBO.getBuildAction()) {
            fscOrderPo.setBuildAction(reqBO.getBuildAction());
        }
        BigDecimal totalChargeMoney = BigDecimal.ZERO;
        Integer orderNum = 0;
        for (SplitOrderBO splitOrderBO : reqBO.getSplitOrderList()) {
            splitOrderBO.setFscOrderId(fscOrderPo.getFscOrderId());
            totalChargeMoney = totalChargeMoney.add(splitOrderBO.getAmount().setScale(2, RoundingMode.HALF_UP));
            if (FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(reqBO.getMakeType())) {
                fscOrderPo.setFscBusiType(splitOrderBO.getOrderBusiType());
                fscOrderPo.setFscBusiTypeName(splitOrderBO.getOrderBusiTypeStr());
            } else {
                fscOrderPo.setFscBusiType(splitOrderBO.getInspectionBusiType());
                fscOrderPo.setFscBusiTypeName(splitOrderBO.getInspectionBusiTypeStr());
            }
            ++num;
            for (RelOrderBO relOrderBO : splitOrderBO.getRelOrderList()) {
                FscOrderInfoBO fscOrderInfoBO = reqBO.getFscOrderInfoBoMap().get(relOrderBO.getAcceptOrderId());
                if (null == fscOrderInfoBO) {
                    throw new FscBusinessException("193008", "\u83b7\u53d6\u8ba2\u5355\u5bf9\u8c61\u4e3a\u7a7a");
                }
                FscOrderRelationPO fscOrderRelationPO = (FscOrderRelationPO)JSONObject.parseObject((String)JSON.toJSONString((Object)fscOrderInfoBO), FscOrderRelationPO.class);
                fscOrderRelationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                fscOrderRelationPO.setFscOrderId(fscOrderPo.getFscOrderId());
                fscOrderRelationPO.setOrderCreateTime(fscOrderInfoBO.getOrderCreateTime());
                fscOrderRelationPO.setAcceptCreateTime(fscOrderInfoBO.getAcceptTime());
                fscOrderRelationPO.setOrderCreateOperName(fscOrderInfoBO.getOrderCreateOperName() + "/" + fscOrderInfoBO.getOrderCreateLoginName());
                fscOrderRelationPO.setOrderTotalCharge(splitOrderBO.getAmount());
                fscOrderRelationPOS.add(fscOrderRelationPO);
                fscOrderItemPOS.addAll(JSONObject.parseArray((String)JSON.toJSONString((Object)fscOrderInfoBO.getFscOrderItemBOS()), FscOrderItemPO.class));
                fscOrderItemPOS.forEach(fscOrderItemPO -> {
                    fscOrderItemPO.setFscOrderId(fscOrderPo.getFscOrderId());
                    fscOrderItemPO.setAccountEndDate(this.calShouldPayDate(fscOrderInfoBO));
                    if (FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(reqBO.getMakeType())) {
                        if (ObjectUtil.isEmpty((Object)fscOrderItemPO.getOrderBusiType())) {
                            fscOrderItemPO.setOrderBusiType(splitOrderBO.getOrderBusiType());
                            fscOrderItemPO.setOrderBusiTypeName(splitOrderBO.getOrderBusiTypeStr());
                        }
                    } else if (ObjectUtil.isEmpty((Object)fscOrderItemPO.getInspectionBusiType())) {
                        fscOrderItemPO.setOrderBusiType(splitOrderBO.getOrderBusiType());
                        fscOrderItemPO.setOrderBusiTypeName(splitOrderBO.getOrderBusiTypeStr());
                        fscOrderItemPO.setInspectionBusiType(splitOrderBO.getInspectionBusiType());
                        fscOrderItemPO.setInspectionBusiTypeName(splitOrderBO.getInspectionBusiTypeStr());
                    }
                });
            }
            orderNum = orderNum + splitOrderBO.getRelOrderList().size();
        }
        fscOrderIds.add(fscOrderPo.getFscOrderId());
        fscOrderPo.setTotalCharge(totalChargeMoney);
        fscOrderPo.setOrderNum(orderNum);
        if (!CollectionUtils.isEmpty(fscOrderItemPOS)) {
            fscOrderPo.setLastPayDate(((FscOrderItemPO)fscOrderItemPOS.stream().sorted(Comparator.comparing(FscOrderItemPO::getAccountEndDate)).collect(Collectors.toList()).get(0)).getAccountEndDate());
        }
        fscOrderPOS.add(fscOrderPo);
        FscOrderInvoicePO fscOrderInvoicePo = (FscOrderInvoicePO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderInvoicePO.class);
        fscOrderInvoicePo.setFscOrderId(fscOrderPo.getFscOrderId());
        fscOrderInvoicePo.setBillOperId(reqBO.getUserId().toString());
        fscOrderInvoicePo.setBillOperName(reqBO.getName());
        fscOrderInvoicePo.setBillTimeStart(new Date());
        fscOrderInvoicePo.setMemo(reqBO.getInvoiceMemo());
        fscOrderInvoicePOS.add(fscOrderInvoicePo);
        FscInvoiceRulePO fscInvoiceRulePO = new FscInvoiceRulePO();
        fscInvoiceRulePO.setFscOrderId(fscOrderPo.getFscOrderId());
        fscInvoiceRulePO.setDataFlag(FscConstants.FscInvoiceRuleDataFlag.YES);
        fscInvoiceRulePO.setDataStatus(FscConstants.FscInvoiceRuleStatus.NO);
        fscInvoiceRulePO.setElecFlag(elecFlag);
        fscInvoiceRulePO.setElecStatus(FscConstants.FscInvoiceRuleStatus.NO);
        fscInvoiceRulePOS.add(fscInvoiceRulePO);
        if (CollectionUtils.isEmpty(fscOrderPOS) || CollectionUtils.isEmpty(fscOrderRelationPOS) || CollectionUtils.isEmpty(fscOrderItemPOS) || CollectionUtils.isEmpty(fscOrderInvoicePOS) || CollectionUtils.isEmpty(fscInvoiceRulePOS)) {
            throw new FscBusinessException("193008", "\u5f00\u7968\u4e3b\u5355\u7ec4\u88c5\u53c2\u6570\u4e3a\u7a7a");
        }
        fscOrderItemPOS.forEach(fscOrderItemPO -> fscOrderItemPO.setId(Long.valueOf(Sequence.getInstance().nextId())));
        if (ObjectUtil.isEmpty((Object)reqBO.getFscOrderId())) {
            this.fscOrderMapper.insertBatch(fscOrderPOS);
            this.fscOrderRelationMapper.insertBatch(fscOrderRelationPOS);
            this.fscOrderItemMapper.insertBatch(fscOrderItemPOS);
            this.fscOrderInvoiceMapper.insertBatch(fscOrderInvoicePOS);
            this.fscInvoiceRuleMapper.insertBatch(fscInvoiceRulePOS);
        } else {
            this.fscOrderMapper.updateBatch(fscOrderPOS);
            this.fscOrderItemMapper.updateBatch(fscOrderItemPOS);
            this.fscOrderInvoiceMapper.updateBatch(fscOrderInvoicePOS);
        }
        FscGeneralBusiRuleExecAtomReqBO fscGeneralBusiRuleExecAtomReqBO = new FscGeneralBusiRuleExecAtomReqBO();
        fscGeneralBusiRuleExecAtomReqBO.setServiceCode("FSC002");
        JSONObject jsonObj = JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)));
        jsonObj.put("orgId", (Object)jsonObj.getString("orgId"));
        fscGeneralBusiRuleExecAtomReqBO.setParamJsonStr(JSON.toJSONString((Object)jsonObj));
        FscGeneralBusiRuleExecAtomRspBO fscGeneralBusiRuleExecAtomRspBO = this.fscGeneralBusiRuleExecAtomService.dealGeneralBusiRuleExec(fscGeneralBusiRuleExecAtomReqBO);
        if (!StringUtils.hasText((String)fscGeneralBusiRuleExecAtomRspBO.getBusiRuleExecResult())) {
            throw new FscBusinessException("193208", "\u6ca1\u6709\u914d\u7f6e\u7ed3\u7b97\u5ba1\u6279\u6d41\u89c4\u5219");
        }
        log.info("\u7ed3\u7b97\u5ba1\u6279\u914d\u7f6e\u89c4\u5219:{}", (Object)fscGeneralBusiRuleExecAtomRspBO);
        JSONObject callRuleRspJsonObj = JSON.parseObject((String)fscGeneralBusiRuleExecAtomRspBO.getBusiRuleExecResult());
        String createEvaProcessKey = callRuleRspJsonObj.getString("processKey");
        if (createEvaProcessKey.equals(NO_NEED_AUDIT)) {
            reqBO.setApproval(false);
        }
        FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = (FscOrderStatusStartAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderStatusStartAtomReqBO.class);
        for (Long fscOrderId : fscOrderIds) {
            HashMap<String, Number> paramMap = new HashMap<String, Number>(2);
            if (reqBO.getApproval().booleanValue()) {
                paramMap.put("auditFlag", FscConstants.APPROVAL_ORDER_STATUS.NEXT);
            } else {
                paramMap.put("auditFlag", FscConstants.APPROVAL_ORDER_STATUS.ACCESS);
            }
            paramMap.put("auditObjId", fscOrderId);
            fscOrderStatusStartAtomReqBO.setParamMap(paramMap);
            fscOrderStatusStartAtomReqBO.setOrderId(fscOrderId);
            log.info("\u521b\u5efa\u7ed3\u7b97\u5ba1\u6279\u4e3b\u6d41\u7a0b\u5165\u53c2:{}", (Object)fscOrderStatusStartAtomReqBO);
            FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealStatusStart(fscOrderStatusStartAtomReqBO);
            if ("0000".equals(fscOrderStatusStartAtomRspBO.getRespCode())) continue;
            throw new FscBusinessException("193008", fscOrderStatusStartAtomRspBO.getRespDesc());
        }
        if (reqBO.getApproval().booleanValue()) {
            try {
                this.createApproval(fscOrderPOS, reqBO, "invoice_flow_approval_key");
            }
            catch (FscBusinessException e) {
                log.info("\u6ca1\u67e5\u8be2\u5230\u914d\u7f6e\u5ba1\u6279\u6d41\u7a0b");
            }
        }
        this.syncOrderStatus(fscOrderIds, reqBO.getMakeType());
        FscBillOrderCreateBusiRspBO rspBO = new FscBillOrderCreateBusiRspBO();
        rspBO.setFscOrderIds(fscOrderIds);
        return rspBO;
    }

    private void syncOrderStatus(List<Long> fscOrderIds, Integer makeType) {
        fscOrderIds.forEach(fscOrderId -> {
            FscUocOrderRelUpdateAtomReqBO fscUocOrderRelUpdateAtomReqBO = new FscUocOrderRelUpdateAtomReqBO();
            fscUocOrderRelUpdateAtomReqBO.setFscOrderId(fscOrderId);
            fscUocOrderRelUpdateAtomReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
            fscUocOrderRelUpdateAtomReqBO.setMakeType(makeType);
            this.fscUocOrderRelUpdateAtomService.dealRelUpdate(fscUocOrderRelUpdateAtomReqBO);
        });
    }

    private Date calShouldPayDate(FscOrderInfoBO fscOrderInfoBO) {
        Calendar now = Calendar.getInstance();
        if (FscConstants.MerchantPayRule.MERCHANT_PAY_RULE_SPECIFY.equals(fscOrderInfoBO.getPayRule())) {
            if (null == fscOrderInfoBO.getPayAccountDay()) {
                throw new FscBusinessException("191019", "\u8ba2\u5355\u6307\u5b9a\u8d26\u671f\u65e5\u4e3a\u7a7a");
            }
            Integer day = now.get(5);
            if (day >= fscOrderInfoBO.getPayAccountDay()) {
                now.add(2, 1);
            }
            now.add(5, fscOrderInfoBO.getPayAccountDay() - day);
        }
        if (FscConstants.MerchantPayRule.Merchant_PAY_RULE_BUSIESS_NODE.equals(fscOrderInfoBO.getPayRule())) {
            if (null == fscOrderInfoBO.getPayAccountDay()) {
                throw new FscBusinessException("191019", "\u8ba2\u5355\u8d26\u671f\u5929\u6570\u4e3a\u7a7a");
            }
            now.add(5, fscOrderInfoBO.getPayAccountDay());
        }
        return now.getTime();
    }

    private void dealAccountRule(FscBillOrderCreateBusiReqBO reqBO, FscOrderPO fscOrderPO) {
        if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(reqBO.getPayType()) && "2".equals(fscOrderPO.getOrderSource())) {
            FscOrderInfoBO fscOrderInfoBO = reqBO.getFscOrderInfoBoMap().values().stream().max(Comparator.comparing(FscOrderInfoBO::getOrderCreateTime)).get();
            if (null == fscOrderInfoBO) {
                throw new FscBusinessException("191019", "\u83b7\u53d6\u8ba2\u5355\u4e3a\u7a7a");
            }
            ArrayList<FscShouldPayBO> fscShouldPayBOS = new ArrayList<FscShouldPayBO>();
            FscShouldPayBO fscShouldPayBO = new FscShouldPayBO();
            fscShouldPayBO.setShouldPayType(FscConstants.ShouldPayType.PAYMENT_DAY_PAY);
            fscShouldPayBO.setShouldPayNo(fscOrderPO.getOrderNo());
            fscShouldPayBO.setObjectType(FscConstants.ShouldObjectType.SIGN_INVOICE_ORDER);
            fscShouldPayBO.setObjectId(fscOrderPO.getFscOrderId());
            fscShouldPayBO.setObjectNo(fscOrderPO.getOrderNo());
            fscShouldPayBO.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD);
            fscShouldPayBO.setShouldPayAmount(fscOrderPO.getTotalCharge());
            fscShouldPayBO.setPayeeId(fscOrderPO.getPayeeId());
            fscShouldPayBO.setPayeeName(fscOrderPO.getPayeeName());
            fscShouldPayBO.setPayerId(fscOrderPO.getPayerId());
            fscShouldPayBO.setPayerName(fscOrderPO.getPayerName());
            fscShouldPayBO.setPenaltyRatio(fscOrderInfoBO.getPayBreakScale());
            fscShouldPayBO.setContractId(fscOrderInfoBO.getModelContractId());
            fscShouldPayBO.setContractNo(fscOrderInfoBO.getModelContractNo());
            fscShouldPayBO.setShouldPayDate(this.calShouldPayDate(fscOrderInfoBO));
            fscShouldPayBOS.add(fscShouldPayBO);
            if (CollectionUtils.isEmpty(reqBO.getFscShouldPayBOS())) {
                reqBO.setFscShouldPayBOS(new ArrayList<FscShouldPayBO>());
            }
            reqBO.getFscShouldPayBOS().addAll(fscShouldPayBOS);
        }
    }

    private void createShouldPay(List<FscShouldPayBO> fscShouldPayBOS, FscBillOrderCreateBusiReqBO reqBO) {
        if (!CollectionUtils.isEmpty(fscShouldPayBOS)) {
            FscPayShouldPayCreateAtomReqBO fscPayShouldPayCreateAtomReqBO = new FscPayShouldPayCreateAtomReqBO();
            fscPayShouldPayCreateAtomReqBO.setFscShouldPayBOS(fscShouldPayBOS);
            fscPayShouldPayCreateAtomReqBO.setUserId(reqBO.getUserId());
            fscPayShouldPayCreateAtomReqBO.setName(reqBO.getName());
            fscPayShouldPayCreateAtomReqBO.setUserName(reqBO.getUserName());
            fscPayShouldPayCreateAtomReqBO.setCompanyId(reqBO.getCompanyId());
            fscPayShouldPayCreateAtomReqBO.setCompanyName(reqBO.getCompanyName());
            fscPayShouldPayCreateAtomReqBO.setOrgId(reqBO.getOrgId());
            fscPayShouldPayCreateAtomReqBO.setOrgName(reqBO.getOrgName());
            FscPayShouldPayCreateAtomRspBO fscPayShouldPayCreateAtomRspBO = this.fscPayShouldPayCreateAtomService.dealShouldPayCreate(fscPayShouldPayCreateAtomReqBO);
            if (!"0000".equals(fscPayShouldPayCreateAtomRspBO.getRespCode())) {
                throw new FscBusinessException("193011", fscPayShouldPayCreateAtomRspBO.getRespDesc());
            }
        }
    }

    private void createApproval(List<FscOrderPO> fscOrderPOS, FscBillOrderCreateBusiReqBO reqBO, String key) {
        log.info("\u521b\u5efa\u7ed3\u7b97\u5ba1\u6279\u5165\u53c2:{},\u7ed3\u7b97\u5355\u5165\u53c2:{}", (Object)reqBO, fscOrderPOS);
        FscAuditOrderCreateAtomReqBO fscAuditOrderCreateAtomReqBO = new FscAuditOrderCreateAtomReqBO();
        fscAuditOrderCreateAtomReqBO.setOrderId(fscOrderPOS.get(0).getFscOrderId());
        fscAuditOrderCreateAtomReqBO.setObjId(fscOrderPOS.get(0).getFscOrderId());
        fscAuditOrderCreateAtomReqBO.setObjType(FscConstants.OBJ_TYPE.FSC_ORDER);
        if (FscConstants.OrderFlow.PL_SERVICE_FEE.equals(reqBO.getOrderFlow())) {
            fscAuditOrderCreateAtomReqBO.setObjBusiType(FscConstants.AuditObjType.SERVICE_PROCESS_APPROVAL);
        }
        if (FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(reqBO.getOrderFlow())) {
            fscAuditOrderCreateAtomReqBO.setObjBusiType(FscConstants.AuditObjType.SERVICE_CHARGE_APPROVAL);
        }
        if (FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE.equals(reqBO.getOrderFlow())) {
            fscAuditOrderCreateAtomReqBO.setObjBusiType(FscConstants.AuditObjType.SERVICE_CHARGE_APPROVAL);
        }
        if (FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(reqBO.getOrderFlow())) {
            fscAuditOrderCreateAtomReqBO.setObjBusiType(FscConstants.AuditObjType.SERVICE_CHARGE_APPROVAL);
        }
        if (FscConstants.OrderFlow.INVOICE_APPROVAL.equals(reqBO.getOrderFlow())) {
            fscAuditOrderCreateAtomReqBO.setObjBusiType(FscConstants.AuditObjType.APPROVAL_ORDER_INVOICE);
        }
        fscAuditOrderCreateAtomReqBO.setUserId(reqBO.getUserId());
        fscAuditOrderCreateAtomReqBO.setUserName(reqBO.getName());
        FscAuditOrderCreateAtomRspBO atomRspBO = this.fscAuditOrderCreateAtomService.dealAuditOrderCreate(fscAuditOrderCreateAtomReqBO);
        EacStartProjectAbilityReqBO eacStartProjectAbilityReqBO = (EacStartProjectAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), EacStartProjectAbilityReqBO.class);
        eacStartProjectAbilityReqBO.setSysCode(this.processSysCode);
        eacStartProjectAbilityReqBO.setProcDefKey(key);
        eacStartProjectAbilityReqBO.setPartitionKey(fscOrderPOS.get(0).getFscOrderId().toString());
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("auditId", atomRspBO.getAuditOrderId());
        variables.put("todoOrderNo", fscOrderPOS.get(0).getOrderNo());
        eacStartProjectAbilityReqBO.setVariables(variables);
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(fscOrderPOS.get(0).getFscOrderId().toString());
        eacStartProjectAbilityReqBO.setBusinessIdList(strings);
        eacStartProjectAbilityReqBO.setUserName(reqBO.getName());
        log.info("\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)eacStartProjectAbilityReqBO));
        EacStartProjectAbilityRspBO eacStartProjectAbilityRspBO = this.eacProjectAbilityService.startProjectByMq(eacStartProjectAbilityReqBO);
        log.info("\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)eacStartProjectAbilityRspBO));
        if (!"0000".equals(eacStartProjectAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u5931\u8d25,\u5f02\u5e38\u7f16\u7801\u3010" + eacStartProjectAbilityRspBO.getRespCode() + "\u3011," + eacStartProjectAbilityRspBO.getRespDesc());
        }
    }

    @Override
    public FscOrderStatusStartAtomRspBO finishFscOrderApproval(Long fscOrderId, Integer status) {
        FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = new FscOrderStatusStartAtomReqBO();
        fscOrderStatusStartAtomReqBO.setOrderId(fscOrderId);
        fscOrderStatusStartAtomReqBO.setOrderFlow(FscConstants.OrderFlow.MONTH_SERVICE_FEE);
        fscOrderStatusStartAtomReqBO.setBusiName(BUSI_NAME);
        HashMap<String, Number> paramMap = new HashMap<String, Number>(3);
        paramMap.put("auditOrderStatus", status);
        paramMap.put("auditObjId", fscOrderId);
        fscOrderStatusStartAtomReqBO.setParamMap(paramMap);
        log.info("\u7ed3\u7b97\u5ba1\u6279-\u6d41\u7a0b\u6d41\u8f6c\u5165\u53c2:{}", (Object)fscOrderStatusStartAtomReqBO);
        FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealStatusStart(fscOrderStatusStartAtomReqBO);
        return fscOrderStatusStartAtomRspBO;
    }
}

