/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.cfc.ability.api.CfcQryFinancialTypeMapAbilityService;
import com.tydic.fsc.bill.busi.api.FscBillOrderCreateBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderCreateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderCreateBusiRspBO;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.bo.RelOrderBO;
import com.tydic.fsc.bo.SplitOrderBO;
import com.tydic.fsc.busibase.atom.api.FscOrderFailLogUpdateAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.api.FscPayShouldPayCreateAtomService;
import com.tydic.fsc.busibase.atom.api.FscUocOrderRelUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderFailLogUpdateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderFailLogUpdateAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomReqBO;
import com.tydic.fsc.busibase.busi.api.FscBillOrderCreatePdfBusiService;
import com.tydic.fsc.busibase.external.api.bo.FscUocOrderSyncCheckStatusReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocOrderSyncCheckStatusRspBO;
import com.tydic.fsc.busibase.external.api.uoc.FscUocOrderSyncCheckStatusAbilityService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscApprovalRelationMapper;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscCheckResultItemMapper;
import com.tydic.fsc.dao.FscCheckResultMapper;
import com.tydic.fsc.dao.FscInvoiceRuleMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscApprovalRelationPO;
import com.tydic.fsc.po.FscCheckResultPO;
import com.tydic.fsc.po.FscInvoiceRulePO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillOrderCreateBusiServiceImpl
implements FscBillOrderCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderCreateBusiServiceImpl.class);
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private FscCheckResultMapper fscCheckResultMapper;
    @Autowired
    private FscCheckResultItemMapper fscCheckResultItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscInvoiceRuleMapper fscInvoiceRuleMapper;
    @Autowired
    private FscUocOrderRelUpdateAtomService fscUocOrderRelUpdateAtomService;
    @Autowired
    private FscPayShouldPayCreateAtomService fscPayShouldPayCreateAtomService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscBillOrderCreatePdfBusiService fscBillOrderCreatePdfBusiService;
    @Autowired
    private FscApprovalRelationMapper fscApprovalRelationMapper;
    @Autowired
    private FscUocOrderSyncCheckStatusAbilityService fscUocOrderSyncCheckStatusAbilityService;
    @Autowired
    private FscOrderFailLogUpdateAtomService fscOrderFailLogUpdateAtomService;
    @Autowired
    private CfcQryFinancialTypeMapAbilityService cfcQryFinancialTypeMapAbilityService;

    @Override
    public FscBillOrderCreateBusiRspBO dealCreate(FscBillOrderCreateBusiReqBO reqBO) {
        ArrayList<FscOrderPO> fscOrderPOS = new ArrayList<FscOrderPO>();
        ArrayList<FscOrderRelationPO> fscOrderRelationPOS = new ArrayList<FscOrderRelationPO>();
        ArrayList fscOrderItemPOS = new ArrayList();
        ArrayList<FscOrderInvoicePO> fscOrderInvoicePOS = new ArrayList<FscOrderInvoicePO>();
        ArrayList<FscInvoiceRulePO> fscInvoiceRulePOS = new ArrayList<FscInvoiceRulePO>();
        ArrayList<Long> fscOrderIds = new ArrayList<Long>();
        Integer elecFlag = FscConstants.FscInvoiceRuleElecFlag.NO;
        if (FscConstants.FscInvoiceCategory.ELEC.equals(reqBO.getInvoiceCategory())) {
            elecFlag = FscConstants.FscInvoiceRuleElecFlag.YES;
        }
        int num = 0;
        FscOrderPO approvalFscOrder = new FscOrderPO();
        if (!ObjectUtil.isEmpty((Object)reqBO.getFscOrderId())) {
            FscOrderPO approvalFscOrderPO = new FscOrderPO();
            approvalFscOrderPO.setFscOrderId(reqBO.getFscOrderId());
            approvalFscOrder = this.fscOrderMapper.getModelBy(approvalFscOrderPO);
        }
        for (SplitOrderBO splitOrderBO : reqBO.getSplitOrderList()) {
            FscOrderPO fscOrderPo = (FscOrderPO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderPO.class);
            fscOrderPo.setFscOrderId(Long.valueOf(Sequence.getInstance().nextId()));
            splitOrderBO.setFscOrderId(fscOrderPo.getFscOrderId());
            fscOrderPo.setCreateTime(new Date());
            fscOrderPo.setCreateOperId(ObjectUtil.isEmpty((Object)reqBO.getUserId()) ? approvalFscOrder.getCreateOperId() : reqBO.getUserId());
            fscOrderPo.setCreateOperName(ObjectUtil.isEmpty((Object)reqBO.getName()) ? approvalFscOrder.getCreateOperName() : reqBO.getName());
            fscOrderPo.setCreateOrgId(ObjectUtil.isEmpty((Object)reqBO.getOrgId()) ? approvalFscOrder.getCreateOrgId() : reqBO.getOrgId());
            fscOrderPo.setCreateOrgName(ObjectUtil.isEmpty((Object)reqBO.getOrgName()) ? approvalFscOrder.getCreateOrgName() : reqBO.getOrgName());
            fscOrderPo.setCreateCompanyId(ObjectUtil.isEmpty((Object)reqBO.getCompanyId()) ? approvalFscOrder.getCreateCompanyId() : reqBO.getCompanyId());
            fscOrderPo.setCreateCompanyName(ObjectUtil.isEmpty((Object)reqBO.getCompanyName()) ? approvalFscOrder.getCreateCompanyName() : reqBO.getCompanyName());
            fscOrderPo.setTotalCharge(splitOrderBO.getAmount().setScale(2, RoundingMode.HALF_UP));
            log.info("\u7ed3\u7b97\u91d1\u989d\uff1a{}", (Object)fscOrderPo);
            if (FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(reqBO.getMakeType())) {
                fscOrderPo.setFscBusiType(splitOrderBO.getOrderBusiType());
                fscOrderPo.setFscBusiTypeName(splitOrderBO.getOrderBusiTypeStr());
            } else if (FscConstants.FscOrderMakeType.SUPPLIER.equals(reqBO.getMakeType())) {
                fscOrderPo.setFscBusiType(splitOrderBO.getInspectionBusiType());
                fscOrderPo.setFscBusiTypeName(splitOrderBO.getInspectionBusiTypeStr());
            } else {
                fscOrderPo.setFscBusiType(ObjectUtil.isEmpty((Object)splitOrderBO.getInspectionBusiType()) ? splitOrderBO.getOrderBusiType() : splitOrderBO.getInspectionBusiType());
                fscOrderPo.setFscBusiTypeName(ObjectUtil.isEmpty((Object)splitOrderBO.getInspectionBusiTypeStr()) ? splitOrderBO.getOrderBusiTypeStr() : splitOrderBO.getInspectionBusiTypeStr());
            }
            log.info("\u7ed3\u7b97\u5355\u7c7b\u578b:{}", (Object)splitOrderBO.getFscBusiTypeName());
            fscOrderPo.setOrderNo(reqBO.getOrderNos().get(num));
            fscOrderPo.setBuildAction(FscConstants.FscOrderBuildAction.HAND);
            if (null != reqBO.getBuildAction()) {
                fscOrderPo.setBuildAction(reqBO.getBuildAction());
            }
            ++num;
            fscOrderIds.add(fscOrderPo.getFscOrderId());
            for (RelOrderBO relOrderBO : splitOrderBO.getRelOrderList()) {
                FscOrderInfoBO fscOrderInfoBO = reqBO.getFscOrderInfoBoMap().get(relOrderBO.getAcceptOrderId());
                log.info("\u5546\u54c1\u660e\u7ec6\u5165\u53c2-\u4ee5\u540e\u5220\u9664:{}", (Object)fscOrderInfoBO.getFscOrderItemBOS());
                if (null == fscOrderInfoBO) {
                    throw new FscBusinessException("193008", "\u83b7\u53d6\u8ba2\u5355\u5bf9\u8c61\u4e3a\u7a7a");
                }
                FscOrderRelationPO fscOrderRelationPO = (FscOrderRelationPO)JSONObject.parseObject((String)JSON.toJSONString((Object)fscOrderInfoBO), FscOrderRelationPO.class);
                fscOrderRelationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                fscOrderRelationPO.setFscOrderId(fscOrderPo.getFscOrderId());
                fscOrderRelationPO.setOrderCreateTime(fscOrderInfoBO.getOrderCreateTime());
                fscOrderRelationPO.setAcceptCreateTime(fscOrderInfoBO.getAcceptTime());
                fscOrderRelationPO.setOrderCreateOperName(fscOrderInfoBO.getOrderCreateOperName() + "/" + fscOrderInfoBO.getOrderCreateLoginName());
                fscOrderRelationPO.setOrderTotalCharge(splitOrderBO.getAmount());
                fscOrderRelationPOS.add(fscOrderRelationPO);
                fscOrderItemPOS.addAll(JSONObject.parseArray((String)JSON.toJSONString((Object)fscOrderInfoBO.getFscOrderItemBOS()), FscOrderItemPO.class));
                fscOrderItemPOS.forEach(fscOrderItemPO -> {
                    fscOrderItemPO.setFscOrderId(fscOrderPo.getFscOrderId());
                    if (ObjectUtil.isEmpty((Object)fscOrderItemPO.getAccountEndDate())) {
                        fscOrderItemPO.setAccountEndDate(this.calShouldPayDate(fscOrderInfoBO));
                    }
                    if (FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(reqBO.getMakeType())) {
                        if (ObjectUtil.isEmpty((Object)fscOrderItemPO.getOrderBusiType())) {
                            fscOrderItemPO.setOrderBusiType(splitOrderBO.getOrderBusiType());
                            fscOrderItemPO.setOrderBusiTypeName(splitOrderBO.getFscBusiTypeName());
                        }
                    } else if (FscConstants.FscOrderMakeType.SUPPLIER.equals(reqBO.getMakeType())) {
                        if (ObjectUtil.isEmpty((Object)fscOrderItemPO.getInspectionBusiType())) {
                            fscOrderItemPO.setOrderBusiType(splitOrderBO.getOrderBusiType());
                            fscOrderItemPO.setOrderBusiTypeName(splitOrderBO.getOrderBusiTypeStr());
                            fscOrderItemPO.setInspectionBusiType(splitOrderBO.getInspectionBusiType());
                            fscOrderItemPO.setInspectionBusiTypeName(splitOrderBO.getInspectionBusiTypeStr());
                        }
                    } else {
                        if (ObjectUtil.isEmpty((Object)fscOrderItemPO.getInspectionBusiType())) {
                            fscOrderItemPO.setInspectionBusiType(ObjectUtil.isEmpty((Object)splitOrderBO.getInspectionBusiType()) ? "" : splitOrderBO.getInspectionBusiType());
                            fscOrderItemPO.setInspectionBusiTypeName(ObjectUtil.isEmpty((Object)splitOrderBO.getInspectionBusiTypeStr()) ? "" : splitOrderBO.getInspectionBusiTypeStr());
                        }
                        if (ObjectUtil.isEmpty((Object)fscOrderItemPO.getOrderBusiType())) {
                            fscOrderItemPO.setOrderBusiType(ObjectUtil.isEmpty((Object)splitOrderBO.getOrderBusiType()) ? "" : splitOrderBO.getOrderBusiType());
                            fscOrderItemPO.setOrderBusiTypeName(ObjectUtil.isEmpty((Object)splitOrderBO.getFscBusiTypeName()) ? "" : splitOrderBO.getFscBusiTypeName());
                        }
                    }
                });
            }
            if (!CollectionUtils.isEmpty(fscOrderItemPOS)) {
                fscOrderPo.setLastPayDate(((FscOrderItemPO)fscOrderItemPOS.stream().sorted(Comparator.comparing(FscOrderItemPO::getAccountEndDate)).collect(Collectors.toList()).get(0)).getAccountEndDate());
            }
            fscOrderPo.setOrderNum(Integer.valueOf(splitOrderBO.getRelOrderList().size()));
            fscOrderPOS.add(fscOrderPo);
            log.info("\u7ed3\u7b97\u5355\u5165\u53c2:{}", (Object)fscOrderPo);
            FscOrderInvoicePO fscOrderInvoicePo = (FscOrderInvoicePO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderInvoicePO.class);
            fscOrderInvoicePo.setFscOrderId(fscOrderPo.getFscOrderId());
            fscOrderInvoicePo.setBillOperId(ObjectUtil.isEmpty((Object)reqBO.getUserId()) ? approvalFscOrder.getCreateOperId().toString() : reqBO.getUserId().toString());
            fscOrderInvoicePo.setBillOperName(ObjectUtil.isEmpty((Object)reqBO.getName()) ? approvalFscOrder.getCreateOperName() : reqBO.getName());
            fscOrderInvoicePo.setBillTimeStart(new Date());
            fscOrderInvoicePo.setMemo(reqBO.getInvoiceMemo());
            fscOrderInvoicePOS.add(fscOrderInvoicePo);
            FscInvoiceRulePO fscInvoiceRulePO = new FscInvoiceRulePO();
            fscInvoiceRulePO.setFscOrderId(fscOrderPo.getFscOrderId());
            fscInvoiceRulePO.setDataFlag(FscConstants.FscInvoiceRuleDataFlag.YES);
            fscInvoiceRulePO.setDataStatus(FscConstants.FscInvoiceRuleStatus.NO);
            fscInvoiceRulePO.setElecFlag(elecFlag);
            fscInvoiceRulePO.setElecStatus(FscConstants.FscInvoiceRuleStatus.NO);
            fscInvoiceRulePOS.add(fscInvoiceRulePO);
            if (null == reqBO.getPayType()) {
                reqBO.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD);
            }
            log.info("\u521b\u5efa\u5e94\u4ed8\u5355\u524d\u53c2\u6570:{}---fscOrderPo:{}", (Object)reqBO, (Object)fscOrderPo);
            this.dealAccountRule(reqBO, fscOrderPo);
            log.info("\u521b\u5efa\u5e94\u4ed8\u5355\u540e\u53c2\u6570:{}---fscOrderPo:{}", (Object)reqBO, (Object)fscOrderPo);
        }
        if (CollectionUtils.isEmpty(fscOrderPOS) || CollectionUtils.isEmpty(fscOrderRelationPOS) || CollectionUtils.isEmpty(fscOrderItemPOS) || CollectionUtils.isEmpty(fscOrderInvoicePOS) || CollectionUtils.isEmpty(fscInvoiceRulePOS)) {
            throw new FscBusinessException("193008", "\u5f00\u7968\u4e3b\u5355\u7ec4\u88c5\u53c2\u6570\u4e3a\u7a7a");
        }
        fscOrderItemPOS.forEach(fscOrderItemPO -> fscOrderItemPO.setId(Long.valueOf(Sequence.getInstance().nextId())));
        this.fscOrderMapper.insertBatch(fscOrderPOS);
        this.fscOrderRelationMapper.insertBatch(fscOrderRelationPOS);
        this.fscOrderItemMapper.insertBatch(fscOrderItemPOS);
        this.fscOrderInvoiceMapper.insertBatch(fscOrderInvoicePOS);
        this.fscInvoiceRuleMapper.insertBatch(fscInvoiceRulePOS);
        if (!ObjectUtil.isEmpty((Object)reqBO.getFscOrderId())) {
            log.info("\u7ed3\u7b97\u5ba1\u6279\u5355\u53f7:{}", (Object)reqBO.getFscOrderId());
            ArrayList<FscApprovalRelationPO> fscApprovalRelationPOS = new ArrayList<FscApprovalRelationPO>();
            for (Long fscOrderId : fscOrderIds) {
                FscApprovalRelationPO fscApprovalRelationPO = new FscApprovalRelationPO();
                fscApprovalRelationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                fscApprovalRelationPO.setFscApprovalOrderId(reqBO.getFscOrderId());
                fscApprovalRelationPO.setFscOrderId(fscOrderId);
                fscApprovalRelationPOS.add(fscApprovalRelationPO);
            }
            this.fscApprovalRelationMapper.insertBatch(fscApprovalRelationPOS);
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
            fscOrderPO.setSyncFailReason("\u5df2\u751f\u6210" + fscOrderIds.size() + "\u5f20\u7ed3\u7b97\u5355");
            fscOrderPO.setSyncState(Integer.valueOf(1));
            this.fscOrderMapper.updateByFscOrderId(fscOrderPO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getFscShouldPayBOS())) {
            this.createShouldPay(reqBO.getFscShouldPayBOS(), reqBO, approvalFscOrder);
        }
        this.syncOrderCheckStatus(fscOrderRelationPOS, reqBO);
        FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = (FscOrderStatusStartAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderStatusStartAtomReqBO.class);
        for (Long fscOrderId : fscOrderIds) {
            fscOrderStatusStartAtomReqBO.setOrderId(fscOrderId);
            FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealStatusStart(fscOrderStatusStartAtomReqBO);
            if ("0000".equals(fscOrderStatusStartAtomRspBO.getRespCode())) continue;
            throw new FscBusinessException("193008", fscOrderStatusStartAtomRspBO.getRespDesc());
        }
        this.syncOrderStatus(fscOrderIds, reqBO.getMakeType());
        FscBillOrderCreateBusiRspBO fscBillOrderCreateBusiRspBO = new FscBillOrderCreateBusiRspBO();
        if (!ObjectUtil.isEmpty((Object)reqBO.getFscOrderId())) {
            fscOrderIds.add(reqBO.getFscOrderId());
        }
        fscBillOrderCreateBusiRspBO.setFscOrderIds(fscOrderIds);
        return fscBillOrderCreateBusiRspBO;
    }

    private void syncOrderStatus(List<Long> fscOrderIds, Integer makeType) {
        fscOrderIds.forEach(fscOrderId -> {
            FscUocOrderRelUpdateAtomReqBO fscUocOrderRelUpdateAtomReqBO = new FscUocOrderRelUpdateAtomReqBO();
            fscUocOrderRelUpdateAtomReqBO.setFscOrderId(fscOrderId);
            fscUocOrderRelUpdateAtomReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
            fscUocOrderRelUpdateAtomReqBO.setMakeType(makeType);
            this.fscUocOrderRelUpdateAtomService.dealRelUpdate(fscUocOrderRelUpdateAtomReqBO);
        });
    }

    private void syncOrderCheckStatus(List<FscOrderRelationPO> fscOrderRelationPOS, FscBillOrderCreateBusiReqBO reqBO) {
        if (FscConstants.FscOrderMakeType.SUPPLIER.equals(reqBO.getMakeType()) && FscConstants.FscOrderReceiveType.OPERATION.equals(reqBO.getReceiveType()) && "3".equals(reqBO.getOrderSource())) {
            List acceptOrderIds = fscOrderRelationPOS.stream().map(FscOrderRelationPO::getAcceptOrderId).collect(Collectors.toList());
            List fscCheckResultPos = this.fscCheckResultMapper.selectByAcceptOrderIds(acceptOrderIds);
            if (CollectionUtils.isEmpty((Collection)fscCheckResultPos) || fscCheckResultPos.size() == 0) {
                this.insert(fscOrderRelationPOS, reqBO);
            }
            for (FscOrderRelationPO fscOrderRelationPO : fscOrderRelationPOS) {
                FscUocOrderSyncCheckStatusReqBO uocOrderSyncCheckStatusReqBO = new FscUocOrderSyncCheckStatusReqBO();
                uocOrderSyncCheckStatusReqBO.setCheckState(FscConstants.BillCheck.CONFIRMED);
                uocOrderSyncCheckStatusReqBO.setInspectionVoucherId(fscOrderRelationPO.getAcceptOrderId());
                uocOrderSyncCheckStatusReqBO.setOrderId(fscOrderRelationPO.getOrderId());
                FscUocOrderSyncCheckStatusRspBO uocOrderSyncCheckStatusRspBO = this.fscUocOrderSyncCheckStatusAbilityService.dealSyncCheckStatus(uocOrderSyncCheckStatusReqBO);
                if ("0000".equals(uocOrderSyncCheckStatusRspBO.getRespCode())) continue;
                this.writeFailLog(uocOrderSyncCheckStatusRspBO, uocOrderSyncCheckStatusReqBO, fscOrderRelationPO);
            }
        }
    }

    private Date calShouldPayDate(FscOrderInfoBO fscOrderInfoBO) {
        Calendar now = Calendar.getInstance();
        if (FscConstants.MerchantPayRule.MERCHANT_PAY_RULE_SPECIFY.equals(fscOrderInfoBO.getPayRule())) {
            if (null == fscOrderInfoBO.getPayAccountDay()) {
                throw new FscBusinessException("191019", "\u8ba2\u5355\u6307\u5b9a\u8d26\u671f\u65e5\u4e3a\u7a7a");
            }
            Integer day = now.get(5);
            if (day >= fscOrderInfoBO.getPayAccountDay()) {
                now.add(2, 1);
            }
            now.add(5, fscOrderInfoBO.getPayAccountDay() - day);
        }
        if (FscConstants.MerchantPayRule.Merchant_PAY_RULE_BUSIESS_NODE.equals(fscOrderInfoBO.getPayRule())) {
            if (null == fscOrderInfoBO.getPayAccountDay()) {
                throw new FscBusinessException("191019", "\u8ba2\u5355\u8d26\u671f\u5929\u6570\u4e3a\u7a7a");
            }
            now.add(5, fscOrderInfoBO.getPayAccountDay());
        }
        return now.getTime();
    }

    private void dealAccountRule(FscBillOrderCreateBusiReqBO reqBO, FscOrderPO fscOrderPO) {
        if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(reqBO.getPayType())) {
            FscOrderInfoBO fscOrderInfoBO = reqBO.getFscOrderInfoBoMap().values().stream().max(Comparator.comparing(FscOrderInfoBO::getOrderCreateTime)).get();
            if (null == fscOrderInfoBO) {
                throw new FscBusinessException("191019", "\u83b7\u53d6\u8ba2\u5355\u4e3a\u7a7a");
            }
            ArrayList<FscShouldPayBO> fscShouldPayBOS = new ArrayList<FscShouldPayBO>();
            FscShouldPayBO fscShouldPayBO = new FscShouldPayBO();
            fscShouldPayBO.setShouldPayType(FscConstants.ShouldPayType.PAYMENT_DAY_PAY);
            fscShouldPayBO.setShouldPayNo(fscOrderPO.getOrderNo());
            fscShouldPayBO.setObjectType(FscConstants.ShouldObjectType.SIGN_INVOICE_ORDER);
            fscShouldPayBO.setObjectId(fscOrderPO.getFscOrderId());
            fscShouldPayBO.setObjectNo(fscOrderPO.getOrderNo());
            fscShouldPayBO.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD);
            fscShouldPayBO.setShouldPayAmount(fscOrderPO.getTotalCharge());
            fscShouldPayBO.setPayeeId(fscOrderPO.getPayeeId());
            fscShouldPayBO.setPayeeName(fscOrderPO.getPayeeName());
            fscShouldPayBO.setPayerId(fscOrderPO.getPayerId());
            fscShouldPayBO.setPayerName(fscOrderPO.getPayerName());
            fscShouldPayBO.setPenaltyRatio(fscOrderInfoBO.getPayBreakScale());
            fscShouldPayBO.setContractId(fscOrderInfoBO.getModelContractId());
            fscShouldPayBO.setContractNo(fscOrderInfoBO.getModelContractNo());
            fscShouldPayBO.setShouldPayDate(this.calShouldPayDate(fscOrderInfoBO));
            fscShouldPayBOS.add(fscShouldPayBO);
            if (CollectionUtils.isEmpty(reqBO.getFscShouldPayBOS())) {
                reqBO.setFscShouldPayBOS(new ArrayList<FscShouldPayBO>());
            }
            reqBO.getFscShouldPayBOS().addAll(fscShouldPayBOS);
        }
    }

    private void createShouldPay(List<FscShouldPayBO> fscShouldPayBOS, FscBillOrderCreateBusiReqBO reqBO, FscOrderPO approvalFscOrder) {
        if (!CollectionUtils.isEmpty(fscShouldPayBOS)) {
            FscPayShouldPayCreateAtomReqBO fscPayShouldPayCreateAtomReqBO = new FscPayShouldPayCreateAtomReqBO();
            fscPayShouldPayCreateAtomReqBO.setFscShouldPayBOS(fscShouldPayBOS);
            fscPayShouldPayCreateAtomReqBO.setUserId(ObjectUtil.isEmpty((Object)reqBO.getUserId()) ? approvalFscOrder.getCreateOperId() : reqBO.getUserId());
            fscPayShouldPayCreateAtomReqBO.setName(ObjectUtil.isEmpty((Object)reqBO.getName()) ? approvalFscOrder.getCreateOperName() : reqBO.getName());
            fscPayShouldPayCreateAtomReqBO.setUserName(ObjectUtil.isEmpty((Object)reqBO.getUserName()) ? approvalFscOrder.getCreateOperName() : reqBO.getUserName());
            fscPayShouldPayCreateAtomReqBO.setCompanyId(ObjectUtil.isEmpty((Object)reqBO.getCompanyId()) ? approvalFscOrder.getCreateCompanyId() : reqBO.getCompanyId());
            fscPayShouldPayCreateAtomReqBO.setCompanyName(ObjectUtil.isEmpty((Object)reqBO.getCompanyName()) ? approvalFscOrder.getCreateCompanyName() : reqBO.getCompanyName());
            fscPayShouldPayCreateAtomReqBO.setOrgId(ObjectUtil.isEmpty((Object)reqBO.getOrgId()) ? approvalFscOrder.getCreateOrgId() : reqBO.getOrgId());
            fscPayShouldPayCreateAtomReqBO.setOrgName(ObjectUtil.isEmpty((Object)reqBO.getOrgName()) ? approvalFscOrder.getCreateOrgName() : reqBO.getOrgName());
            FscPayShouldPayCreateAtomRspBO fscPayShouldPayCreateAtomRspBO = this.fscPayShouldPayCreateAtomService.dealShouldPayCreate(fscPayShouldPayCreateAtomReqBO);
            if (!"0000".equals(fscPayShouldPayCreateAtomRspBO.getRespCode())) {
                throw new FscBusinessException("193011", fscPayShouldPayCreateAtomRspBO.getRespDesc());
            }
        }
    }

    private void writeFailLog(FscUocOrderSyncCheckStatusRspBO uocOrderSyncCheckStatusRspBO, FscUocOrderSyncCheckStatusReqBO uocOrderSyncCheckStatusReqBO, FscOrderRelationPO fscOrderRelationPO) {
        FscOrderFailLogUpdateAtomReqBO fscOrderFailLogUpdateAtomReqBO = new FscOrderFailLogUpdateAtomReqBO();
        long id = Sequence.getInstance().nextId();
        fscOrderFailLogUpdateAtomReqBO.setId(Long.valueOf(id));
        fscOrderFailLogUpdateAtomReqBO.setObjId(uocOrderSyncCheckStatusReqBO.getOrderId());
        fscOrderFailLogUpdateAtomReqBO.setObjNo(fscOrderRelationPO.getOrderNo());
        fscOrderFailLogUpdateAtomReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.ORDER_CHECK_STATUS_SYNC);
        fscOrderFailLogUpdateAtomReqBO.setBusiFailDesc(uocOrderSyncCheckStatusRspBO.getRespDesc());
        FscOrderFailLogUpdateAtomRspBO fscOrderFailLogUpdateAtomRspBO = this.fscOrderFailLogUpdateAtomService.dealInsert(fscOrderFailLogUpdateAtomReqBO);
        if (!"0000".equals(fscOrderFailLogUpdateAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193002", fscOrderFailLogUpdateAtomRspBO.getRespDesc());
        }
    }

    private void insert(List<FscOrderRelationPO> relOrderList, FscBillOrderCreateBusiReqBO reqBO) {
        Date checkTime = new Date();
        for (FscOrderRelationPO fscBillSupplierCheckBusiOrderItemBO : relOrderList) {
            FscCheckResultPO fscCheckResultPo = new FscCheckResultPO();
            fscCheckResultPo.setAcceptOrderId(fscBillSupplierCheckBusiOrderItemBO.getAcceptOrderId());
            fscCheckResultPo.setOrderId(fscBillSupplierCheckBusiOrderItemBO.getOrderId());
            fscCheckResultPo.setOtherNo(String.valueOf(reqBO.getOrgId()));
            fscCheckResultPo.setSupplierId(reqBO.getSupplierId());
            fscCheckResultPo.setStatus(FscConstants.BillCheck.CONFIRMED);
            fscCheckResultPo.setCheckTime(checkTime);
            fscCheckResultPo.setOperId(reqBO.getUserId());
            fscCheckResultPo.setOperName(reqBO.getName());
            int insert = this.fscCheckResultMapper.insert(fscCheckResultPo);
            if (1 == insert) continue;
            throw new FscBusinessException("193013", "\u66f4\u65b0\u6570\u636e\u5e93\u5931\u8d25");
        }
    }
}

