/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.fsc.bill.ability.api.FscBillEcomCheckAbilityService;
import com.tydic.fsc.bill.ability.api.FscBillEcomCheckTaskAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillEcomCheckAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillEcomCheckAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscBillEcomCheckTaskReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillEcomCheckTaskRspBO;
import com.tydic.fsc.bill.busi.api.FscBillEcomCheckApplyBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillEcomCheckApplyBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillEcomCheckApplyBusiRspBO;
import com.tydic.fsc.bo.RelOrderBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocInspectionDetailsListBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocInspectionDetailsListPageQueryReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocInspectionDetailsListPageQueryRspBO;
import com.tydic.fsc.busibase.external.api.uoc.FscUocInspectionDetailsListPageQueryService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillEcomCheckTaskAbilityService"})
public class FscBillEcomCheckTaskServiceAbilityImpl
implements FscBillEcomCheckTaskAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillEcomCheckTaskServiceAbilityImpl.class);
    @Autowired
    private FscUocInspectionDetailsListPageQueryService fscUocInspectionDetailsListPageQueryService;
    @Autowired
    private FscBillEcomCheckAbilityService fscBillEcomCheckAbilityService;
    @Autowired
    private FscBillEcomCheckApplyBusiService fscBillEcomCheckApplyBusiService;
    @Autowired
    private CacheClient cacheClient;
    private static final String AUTO_ECOM_CHECK_KEY = "AUTO_ECOM_CHECK_KEY_";

    @PostMapping(value={"dealAotuEcomCheck"})
    public FscBillEcomCheckTaskRspBO dealAotuEcomCheck(@RequestBody FscBillEcomCheckTaskReqBO reqBo) {
        FscUocInspectionDetailsListPageQueryRspBO inspectionDetailsList = this.getOrder(1, 100);
        if (CollectionUtils.isEmpty((Collection)inspectionDetailsList.getRows())) {
            return new FscBillEcomCheckTaskRspBO();
        }
        this.dealCheck(inspectionDetailsList);
        if (inspectionDetailsList.getRecordsTotal() > 100) {
            for (int i = 2; i <= inspectionDetailsList.getTotal(); ++i) {
                FscUocInspectionDetailsListPageQueryRspBO orders = this.getOrder(i, 100);
                this.dealCheck(orders);
            }
        }
        return new FscBillEcomCheckTaskRspBO();
    }

    private void dealCheck(FscUocInspectionDetailsListPageQueryRspBO inspectionDetailsList) {
        for (FscUocInspectionDetailsListBO order : inspectionDetailsList.getRows()) {
            FscBillEcomCheckApplyBusiReqBO applyBusiReqBO = null;
            ArrayList<RelOrderBO> relOrderBOList = null;
            if (null == this.cacheClient.get(AUTO_ECOM_CHECK_KEY + order.getOrderId())) {
                try {
                    applyBusiReqBO = new FscBillEcomCheckApplyBusiReqBO();
                    applyBusiReqBO.setSupplierId(this.str2Long(order.getSupplierId()));
                    relOrderBOList = new ArrayList<RelOrderBO>();
                    RelOrderBO relOrderBO = new RelOrderBO();
                    relOrderBO.setAcceptOrderId(order.getAcceptOrderId());
                    relOrderBO.setMyAmount(order.getInspTotalPurchaseFee());
                    relOrderBO.setOrderId(order.getSaleOrderId());
                    relOrderBO.setOtherNo(order.getSaleOrderNoExt());
                    relOrderBO.setSaleAmount(order.getInspTotalSalefee());
                    relOrderBOList.add(relOrderBO);
                    applyBusiReqBO.setRelOrderList(relOrderBOList);
                }
                catch (Exception e) {
                    log.error("\u81ea\u52a8\u5bf9\u8d26\u51fa\u9519\uff0c\u8ba2\u5355\u53f7\uff1a{}", (Object)order.getOrderId(), (Object)e);
                }
                FscBillEcomCheckApplyBusiRspBO applyBusiRspBO = this.fscBillEcomCheckApplyBusiService.dealEcomCheckApply(applyBusiReqBO);
                if (!"0000".equals(applyBusiRspBO.getRespCode())) {
                    log.error("\u8ba2\u5355id:{}\u5bf9\u8d26\u51fa\u9519\uff1a{}", (Object)order.getOrderId(), (Object)applyBusiRspBO.getRespDesc());
                    continue;
                }
                this.cacheClient.set(AUTO_ECOM_CHECK_KEY + order.getOrderId(), (Object)order.getOrderId());
            }
            if (null == this.cacheClient.get(AUTO_ECOM_CHECK_KEY + order.getOrderId())) continue;
            FscBillEcomCheckAbilityReqBO checkAbilityReqBO = new FscBillEcomCheckAbilityReqBO();
            checkAbilityReqBO.setRelOrderList(relOrderBOList);
            FscBillEcomCheckAbilityRspBO checkAbilityRspBO = this.fscBillEcomCheckAbilityService.dealEcomCheck(checkAbilityReqBO);
            if (!"0000".equals(checkAbilityRspBO.getRespCode())) {
                log.error("\u8ba2\u5355id:{}\u5bf9\u8d26\u51fa\u9519\uff1a{}", (Object)order.getOrderId(), (Object)checkAbilityRspBO.getRespDesc());
                this.cacheClient.delete(AUTO_ECOM_CHECK_KEY + order.getOrderId());
                continue;
            }
            this.cacheClient.delete(AUTO_ECOM_CHECK_KEY + order.getOrderId());
        }
    }

    private FscUocInspectionDetailsListPageQueryRspBO getOrder(Integer pageNo, Integer pageSize) {
        FscUocInspectionDetailsListPageQueryReqBO fscUocInspectionDetailsListPageQueryReqBO = new FscUocInspectionDetailsListPageQueryReqBO();
        ArrayList<String> orderSourceList = new ArrayList<String>();
        orderSourceList.add("2");
        fscUocInspectionDetailsListPageQueryReqBO.setOrderSourceList(orderSourceList);
        ArrayList<Integer> checkStateList = new ArrayList<Integer>();
        checkStateList.add(FscConstants.BillCheck.NOT_CHECK);
        checkStateList.add(FscConstants.BillCheck.NOT_EQUALS);
        fscUocInspectionDetailsListPageQueryReqBO.setCheckStateList(checkStateList);
        fscUocInspectionDetailsListPageQueryReqBO.setPageNo(pageNo);
        fscUocInspectionDetailsListPageQueryReqBO.setPageSize(pageSize);
        FscUocInspectionDetailsListPageQueryRspBO inspectionDetailsList = this.fscUocInspectionDetailsListPageQueryService.getInspectionDetailsList(fscUocInspectionDetailsListPageQueryReqBO);
        if (!"0000".equals(inspectionDetailsList.getRespCode())) {
            throw new FscBusinessException("191034", inspectionDetailsList.getRespDesc());
        }
        return inspectionDetailsList;
    }

    private Long str2Long(String str) {
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            throw new FscBusinessException("191034", "\u6570\u636e\u8f6c\u6362\u5f02\u5e38");
        }
    }
}

