/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.bill.ability.api.FscBillSupplierCheckImportAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillSupplierCheckImportAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillSupplierCheckImportAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillSupplierCheckBusiService;
import com.tydic.fsc.bill.busi.api.FscBillSupplierCheckImportBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillSupplierCheckBusiOrderItemBO;
import com.tydic.fsc.bill.busi.bo.FscBillSupplierCheckBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillSupplierCheckBusiRspBO;
import com.tydic.fsc.bo.RelOrderItemBO;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.util.ExcelUtils;
import com.tydic.fsc.util.FileUtils;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillSupplierCheckImportAbilityService"})
public class FscBillSupplierCheckImportAbilityServiceImpl
implements FscBillSupplierCheckImportAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillSupplierCheckImportAbilityServiceImpl.class);
    @Autowired
    private FscBillSupplierCheckImportBusiService fscBillSupplierCheckImportBusiService;
    @Autowired
    private FscBillSupplierCheckBusiService fscBillSupplierCheckBusiService;
    public static final Map<Integer, String> ORDER_MAP = new LinkedHashMap<Integer, String>(10);
    public static final Map<Integer, String> SKU_MAP = new LinkedHashMap<Integer, String>(10);

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealSupplierCheckImport"})
    public FscBillSupplierCheckImportAbilityRspBO dealSupplierCheckImport(@RequestBody FscBillSupplierCheckImportAbilityReqBO reqBO) {
        int orderItems;
        List excelData;
        this.verification(reqBO);
        File file = FileUtils.getExcelFileByUrl((String)reqBO.getFileUrl());
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            MockMultipartFile multipartFile = new MockMultipartFile("excel" + file.getName(), file.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
            excelData = ExcelUtils.getExcelData((MultipartFile)multipartFile, (Integer)2);
            if (log.isDebugEnabled()) {
                log.debug("\u8bfb\u53d6\u7684excel\u6570\u636e:{}", (Object)JSON.toJSONString((Object)excelData));
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new FscBusinessException("191025", "\u83b7\u53d6\u6587\u4ef6\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty((Collection)excelData)) {
            throw new FscBusinessException("191025", "\u4f20\u5165\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff01\u8bf7\u4ed4\u7ec6\u6838\u5bf9\u540e\u91cd\u65b0\u4e0a\u4f20\u3002");
        }
        ArrayList<FscBillSupplierCheckBusiOrderItemBO> busiOrderItemBos = new ArrayList<FscBillSupplierCheckBusiOrderItemBO>();
        int size = excelData.size();
        for (int i = 0; i < size; i += orderItems) {
            orderItems = 3;
            List excelDatum = (List)excelData.get(i);
            if ("".equals(excelDatum.get(0))) continue;
            FscBillSupplierCheckBusiOrderItemBO orderItemBo = new FscBillSupplierCheckBusiOrderItemBO();
            this.val(excelDatum);
            orderItemBo.setOrderCode((String)excelDatum.get(2));
            orderItemBo.setAcceptOrderCode((String)excelDatum.get(3));
            orderItemBo.setAmount(new BigDecimal((String)excelDatum.get(4)));
            orderItemBo.setRelAmount(new BigDecimal((String)excelDatum.get(5)));
            ArrayList<RelOrderItemBO> relOrderItemBos = new ArrayList<RelOrderItemBO>();
            int j = i + 2;
            while (size != j && "".equals(((List)excelData.get(j)).get(0))) {
                RelOrderItemBO relOrderItemBO = new RelOrderItemBO();
                List cells = (List)excelData.get(j);
                this.val2(cells);
                relOrderItemBO.setSkuId(Long.valueOf((String)cells.get(1)));
                relOrderItemBO.setPrice(new BigDecimal((String)cells.get(3)));
                relOrderItemBO.setNum(new BigDecimal((String)cells.get(4)));
                relOrderItemBO.setOtherNum(new BigDecimal((String)cells.get(5)));
                relOrderItemBO.setRemark((String)cells.get(6));
                relOrderItemBos.add(relOrderItemBO);
                ++j;
                ++orderItems;
            }
            orderItemBo.setRelOrderitemList(relOrderItemBos);
            busiOrderItemBos.add(orderItemBo);
        }
        if (CollectionUtils.isEmpty(busiOrderItemBos)) {
            throw new FscBusinessException("191025", "\u4f20\u5165\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff01\u8bf7\u4ed4\u7ec6\u6838\u5bf9\u540e\u91cd\u65b0\u4e0a\u4f20\u3002");
        }
        FscBillSupplierCheckBusiReqBO busiReqBO = new FscBillSupplierCheckBusiReqBO();
        busiReqBO.setOrderId(reqBO.getOrderId());
        busiReqBO.setSupplierId(reqBO.getSupplierId());
        busiReqBO.setRelOrderList(busiOrderItemBos);
        FscBillSupplierCheckBusiRspBO busiRspBO = this.fscBillSupplierCheckBusiService.dealSupplierCheck(busiReqBO, "1");
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new FscBusinessException("191025", busiRspBO.getRespDesc());
        }
        return new FscBillSupplierCheckImportAbilityRspBO();
    }

    private void verification(FscBillSupplierCheckImportAbilityReqBO reqBO) {
        if (null == reqBO.getFileUrl() || "".equals(reqBO.getFileUrl())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[fileUrl]\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[orderId]\u4e3a\u7a7a");
        }
        if (null == reqBO.getSupplierId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[supplierId]\u4e3a\u7a7a");
        }
    }

    private void val(List<String> excelDatum) {
        try {
            if (StringUtils.isBlank((String)excelDatum.get(2))) {
                throw new FscBusinessException("191025", ORDER_MAP.get(2));
            }
            if (StringUtils.isBlank((String)excelDatum.get(3))) {
                throw new FscBusinessException("191025", ORDER_MAP.get(3));
            }
            if (StringUtils.isBlank((String)excelDatum.get(4))) {
                throw new FscBusinessException("191025", ORDER_MAP.get(4));
            }
            if (StringUtils.isBlank((String)excelDatum.get(5))) {
                throw new FscBusinessException("191025", ORDER_MAP.get(5));
            }
        }
        catch (FscBusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FscBusinessException("191025", "\u4e0a\u4f20\u6587\u4ef6\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u7684\u6587\u4ef6\u6a21\u677f");
        }
    }

    private void val2(List<String> cells) {
        try {
            if (StringUtils.isBlank((String)cells.get(1))) {
                throw new FscBusinessException("191025", SKU_MAP.get(1));
            }
            if (StringUtils.isBlank((String)cells.get(3))) {
                throw new FscBusinessException("191025", SKU_MAP.get(3));
            }
            if (StringUtils.isBlank((String)cells.get(4))) {
                throw new FscBusinessException("191025", SKU_MAP.get(4));
            }
            if (StringUtils.isBlank((String)cells.get(5))) {
                throw new FscBusinessException("191025", SKU_MAP.get(5));
            }
            if (new BigDecimal(cells.get(4)).compareTo(new BigDecimal(cells.get(5))) != 0 && StringUtils.isBlank((String)cells.get(6))) {
                throw new FscBusinessException("191025", SKU_MAP.get(6));
            }
        }
        catch (FscBusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FscBusinessException("191025", "\u4e0a\u4f20\u6587\u4ef6\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u7684\u6587\u4ef6\u6a21\u677f");
        }
    }

    static {
        ORDER_MAP.put(1, "\u3010\u5e8f\u53f7\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        ORDER_MAP.put(2, "\u3010\u8ba2\u5355\u7f16\u53f7\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        ORDER_MAP.put(3, "\u3010\u9a8c\u6536\u5355\u53f7\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        ORDER_MAP.put(4, "\u3010\u9a8c\u6536\u5355\u91d1\u989d\uff08\u5143\uff09\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        ORDER_MAP.put(5, "\u3010\u4f9b\u5e94\u5546\u53ef\u7ed3\u7b97\u91d1\u989d\uff08\u5143\uff09\u3011\u4e3a\u7a7a\uff0c\u7ea2\u8272\u5217\u6807\u9898\u4e3a\u5fc5\u586b\u9879");
        ORDER_MAP.put(6, "\u3010\u4e0b\u5355\u65f6\u95f4\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        ORDER_MAP.put(7, "\u3010\u786e\u8ba4\u5230\u8d27\u65f6\u95f4\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        ORDER_MAP.put(8, "\u3010\u91c7\u8d2d\u5355\u4f4d\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        ORDER_MAP.put(9, "\u3010\u4e0b\u5355\u4eba/\u4e0b\u5355\u4eba\u8d26\u53f7\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        ORDER_MAP.put(10, "\u3010\u8ba2\u5355\u72b6\u6001\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        SKU_MAP.put(1, "\u3010\u5546\u54c1\u7f16\u7801\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        SKU_MAP.put(2, "\u3010\u5546\u54c1\u540d\u79f0\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        SKU_MAP.put(3, "\u3010\u5355\u4ef7\uff08\u5143\uff09\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        SKU_MAP.put(4, "\u3010\u6570\u91cf\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        SKU_MAP.put(5, "\u3010\u4f9b\u5e94\u5546\u53ef\u7ed3\u7b97\u6570\u91cf\u3011\u4e3a\u7a7a\uff0c\u7ea2\u8272\u5217\u6807\u9898\u4e3a\u5fc5\u586b\u9879");
        SKU_MAP.put(6, "\u3010\u5dee\u5f02\u539f\u56e0\u3011\u4e3a\u7a7a\uff0c\u6570\u91cf\u4e0d\u4e00\u81f4\u65f6\uff0c\u5dee\u5f02\u539f\u56e0\u4e3a\u5fc5\u586b\u9879");
        SKU_MAP.put(7, "\u3010\u603b\u91d1\u989d\uff08\u5143\uff09\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        SKU_MAP.put(8, "\u3010\u5355\u4f4d\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        SKU_MAP.put(9, "\u3010\u89c4\u683c\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
        SKU_MAP.put(10, "\u3010\u578b\u53f7\u3011\u4e3a\u7a7a\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9");
    }
}

