/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.consumer;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.fsc.bill.ability.api.FscBillOrderCreateAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderCreateAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderCreateAbilityRspBO;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.constants.FscConstants;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FscDownTakeUpCreateOrderServiceConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(FscDownTakeUpCreateOrderServiceConsumer.class);
    @Autowired
    private FscBillOrderCreateAbilityService fscBillOrderCreateAbilityService;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        try {
            FscBillOrderCreateAbilityRspBO rspBO;
            FscBillOrderCreateAbilityReqBO reqBO = (FscBillOrderCreateAbilityReqBO)JSON.parseObject((String)message.getContent(), FscBillOrderCreateAbilityReqBO.class);
            if (log.isDebugEnabled()) {
                log.debug("\u4e0b\u6e38\u5e26\u52a8\u4e0a\u6e38\u5f00\u7968\u6d88\u8d39\u8005\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqBO));
            }
            if (!"0000".equals((rspBO = this.fscBillOrderCreateAbilityService.dealCreate(reqBO)).getRespCode())) {
                this.writeFailLog(reqBO, rspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private void writeFailLog(FscBillOrderCreateAbilityReqBO reqBO, String failDesc) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setBusiFailReq(JSON.toJSONString((Object)reqBO));
        fscOrderFailLogUpdateBusiReqBO.setBusiFailDesc(failDesc);
        fscOrderFailLogUpdateBusiReqBO.setBusiFailTime(new Date());
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_DOWN_TAKE_UP_FAIL);
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }
}

