/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.fsc.bill.ability.api.FscEcomReapplyBillInvoiceAbilityService;
import com.tydic.fsc.bill.ability.bo.FscEcomReapplyBillInvoiceAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscEcomReapplyBillInvoiceAbilityRspBO;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceImplBusiReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscInvoiceSubmitExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscInvoiceSubmitExternalRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscInvoiceSubmitExternalService;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscEcomReapplyBillInvoiceAbilityService"})
public class FscEcomReapplyBillInvoiceAbilityServiceImpl
implements FscEcomReapplyBillInvoiceAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscEcomReapplyBillInvoiceAbilityServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscInvoiceSubmitExternalService fscInvoiceSubmitExternalService;
    @Resource(name="ecomInvoiceBatchNo")
    private OrderSequence ecomInvoiceBatchNo;

    @PostMapping(value={"reapplyBillInvoice"})
    public FscEcomReapplyBillInvoiceAbilityRspBO reapplyBillInvoice(@RequestBody FscEcomReapplyBillInvoiceAbilityReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getFscOrderNo())) {
            throw new FscBusinessException("191009", "\u7ed3\u7b97\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setOrderNo(reqBO.getFscOrderNo());
        log.info("\u91cd\u65b0\u7533\u8bf7\u53d1\u7968\u67e5\u8be2\u7ed3\u7b97\u5355\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)fscOrderPO));
        fscOrderPO = this.fscOrderMapper.getOrderInvoiceInfoByFscOrderId(fscOrderPO);
        if (null == fscOrderPO) {
            throw new FscBusinessException("191009", "\u67e5\u8be2\u7ed3\u7b97\u4e3b\u5355\u4e3a\u7a7a");
        }
        log.info("\u91cd\u65b0\u7533\u8bf7\u53d1\u7968\u67e5\u8be2\u7ed3\u7b97\u5355\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)fscOrderPO));
        if (!Convert.toInt((Object)"2").equals(fscOrderPO.getOrderSource())) {
            return new FscEcomReapplyBillInvoiceAbilityRspBO();
        }
        if (!FscBillStatus.INVOICING_SUBMISSION.getCode().equals(fscOrderPO.getOrderState())) {
            throw new FscBusinessException("191009", "\u5f53\u524d\u72b6\u6001\u4e0d\u5904\u7406\u5f00\u7968");
        }
        FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
        fscOrderRelationPO.setFscOrderId(fscOrderPO.getFscOrderId());
        List fscOrderRelationPOS = this.fscOrderRelationMapper.getList(fscOrderRelationPO);
        if (CollectionUtils.isEmpty((Collection)fscOrderRelationPOS)) {
            throw new FscBusinessException("191009", "\u5f00\u7968\u5931\u8d25\uff0c\u67e5\u8be2\u7ed3\u7b97\u5355\u8ba2\u5355\u4e3a\u7a7a");
        }
        ArrayList<String> extOrderNos = new ArrayList<String>();
        for (FscOrderRelationPO fscOrderRelation : fscOrderRelationPOS) {
            if (StringUtils.isBlank((CharSequence)fscOrderRelation.getExtOrderNo())) {
                throw new FscBusinessException("191009", "\u5f00\u7968\u5931\u8d25\uff0c\u67e5\u8be2\u4f9b\u5e94\u5546\u8ba2\u5355\u53f7\u4e3a\u7a7a");
            }
            extOrderNos.add(fscOrderRelation.getExtOrderNo());
        }
        FscBillInvoiceImplBusiReqBO fscBillInvoiceImplBusiReqBO = (FscBillInvoiceImplBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)fscOrderPO), FscBillInvoiceImplBusiReqBO.class));
        fscBillInvoiceImplBusiReqBO.setExtOrderNos(extOrderNos);
        fscBillInvoiceImplBusiReqBO.setCurStatus(fscOrderPO.getOrderState());
        fscBillInvoiceImplBusiReqBO.setInvoiceCategory(fscOrderPO.getInvoiceCategory());
        fscBillInvoiceImplBusiReqBO.setPurchaserId(fscOrderPO.getPurchaserId().toString());
        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPO.getReceiveType())) {
            fscBillInvoiceImplBusiReqBO.setReceiveOrgName(fscOrderPO.getPurchaserName());
            fscBillInvoiceImplBusiReqBO.setJdOrgId(fscOrderPO.getPurchaserId().toString());
        }
        if (FscConstants.FscOrderReceiveType.OPERATION.equals(fscOrderPO.getReceiveType())) {
            fscBillInvoiceImplBusiReqBO.setReceiveOrgName(fscOrderPO.getProOrgName());
            fscBillInvoiceImplBusiReqBO.setJdOrgId(fscOrderPO.getProOrgId().toString());
        }
        fscBillInvoiceImplBusiReqBO.setReceiveAddr(fscOrderPO.getProvince() + fscOrderPO.getCity() + fscOrderPO.getArea() + fscOrderPO.getTown() + fscOrderPO.getReceiveAddr());
        fscBillInvoiceImplBusiReqBO.setCurrentBatch(this.getCurrentBatch());
        this.reapplySubmitInvoice(fscBillInvoiceImplBusiReqBO);
        return new FscEcomReapplyBillInvoiceAbilityRspBO();
    }

    private void reapplySubmitInvoice(FscBillInvoiceImplBusiReqBO reqBO) {
        FscInvoiceSubmitExternalReqBO fscInvoiceSubmitExternalReqBO = new FscInvoiceSubmitExternalReqBO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)fscInvoiceSubmitExternalReqBO);
        fscInvoiceSubmitExternalReqBO.setFscOrderId(reqBO.getFscOrderId().toString());
        FscInvoiceSubmitExternalRspBO fscInvoiceSubmitExternalRspBO = this.fscInvoiceSubmitExternalService.submitInvoice(fscInvoiceSubmitExternalReqBO);
        if (!"0000".equals(fscInvoiceSubmitExternalRspBO.getRespCode())) {
            throw new FscBusinessException("193005", fscInvoiceSubmitExternalRspBO.getRespDesc());
        }
    }

    private Long getCurrentBatch() {
        try {
            return this.ecomInvoiceBatchNo.nextId();
        }
        catch (SQLException throwables) {
            throw new FscBusinessException("191000", "\u83b7\u53d6\u7535\u5546\u6279\u6b21\u53f7\u5931\u8d25");
        }
    }
}

