/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.fsc.bill.ability.api.FscBillTaxDeaInvoiceAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillTaxDealInvoiceAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillTaxDealInvoiceAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscBillTaxDealInvoiceDetailBO;
import com.tydic.fsc.bill.ability.bo.FscInvoiceCallBackSourceInfoBO;
import com.tydic.fsc.bill.busi.api.FscBillInvoiceUploadCrcExtBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceUploadBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceUploadBusiRspBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscInvoiceInfoBO;
import com.tydic.fsc.bo.InvoiceItemBO;
import com.tydic.fsc.common.ability.api.FscBillMailSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComInvoiceSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscBillMailListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComInvoiceListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.utils.FileUpLoad;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillTaxDeaInvoiceAbilityService"})
public class FscBillTaxDeaInvoiceAbilityServiceImpl
implements FscBillTaxDeaInvoiceAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillTaxDeaInvoiceAbilityServiceImpl.class);
    @Value(value="${changeSwitch:on}")
    private String changeSwitch;
    @Value(value="${beforeChangeUrl}")
    private String beforeChangeUrl;
    @Value(value="${afterChangeUrl}")
    private String afterChangeUrl;
    @Autowired
    private FileUpLoad fileUpLoad;
    @Autowired
    private FscBillInvoiceUploadCrcExtBusiService fscBillInvoiceUploadCrcExtBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscBillMailSyncAbilityService fscBillMailSyncAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscComInvoiceSyncAbilityService fscComInvoiceSyncAbilityService;
    @Value(value="${TYPE_SWITCH:true}")
    private Boolean TYPE_SWITCH;

    @PostMapping(value={"dealBillTaxReturnInvoice"})
    public FscBillTaxDealInvoiceAbilityRspBO dealBillTaxReturnInvoice(@RequestBody FscBillTaxDealInvoiceAbilityReqBO reqBO) {
        log.info("\u534e\u6da6\u7a0e\u63a7\u5f00\u7968\u56de\u8c03\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        this.val(reqBO);
        FscBillInvoiceUploadBusiReqBO fscBillInvoiceUploadBusiReqBO = new FscBillInvoiceUploadBusiReqBO();
        ArrayList<FscInvoiceInfoBO> fscInvoiceInfoBOS = new ArrayList<FscInvoiceInfoBO>();
        ArrayList<Long> fscOrderIds = new ArrayList<Long>();
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setOrderNo(reqBO.getOrderNo());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        Long fscOrderId = fscOrderPO.getFscOrderId();
        fscOrderIds.add(fscOrderId);
        fscBillInvoiceUploadBusiReqBO.setFscOrderId(fscOrderId);
        fscBillInvoiceUploadBusiReqBO.setCurStatus(fscOrderPO.getOrderState());
        FscInvoiceInfoBO fscInvoiceInfoBO = new FscInvoiceInfoBO();
        FscOrderInvoicePO fscOrderInvoicePO = new FscOrderInvoicePO();
        fscOrderInvoicePO.setFscOrderId(fscOrderId);
        fscOrderInvoicePO = this.fscOrderInvoiceMapper.getModelBy(fscOrderInvoicePO);
        fscInvoiceInfoBO.setBuyName(fscOrderInvoicePO.getBuyName());
        fscInvoiceInfoBO.setTaxNo(fscOrderInvoicePO.getTaxNo());
        fscInvoiceInfoBO.setBank(fscOrderInvoicePO.getBank());
        fscInvoiceInfoBO.setAccount(fscOrderInvoicePO.getAccount());
        fscInvoiceInfoBO.setPhone(fscOrderInvoicePO.getPhone());
        fscInvoiceInfoBO.setAddress(fscOrderInvoicePO.getAddress());
        fscInvoiceInfoBO.setFscOrderId(fscOrderId);
        fscInvoiceInfoBO.setInvoiceNo(reqBO.getInvoiceNum());
        fscInvoiceInfoBO.setInvoiceCode(reqBO.getInvoiceCode());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String billDate = sdf.format(reqBO.getInvoiceDate());
        fscInvoiceInfoBO.setBillDate(billDate);
        BigDecimal totalsAmount = new BigDecimal(0);
        BigDecimal taxAmt = new BigDecimal(0);
        for (Object fscBillTaxDealInvoiceDetailBO : reqBO.getInvoiceDetail()) {
            taxAmt = taxAmt.add(new BigDecimal(fscBillTaxDealInvoiceDetailBO.getTax()));
            totalsAmount = totalsAmount.add(new BigDecimal(fscBillTaxDealInvoiceDetailBO.getAmount()));
        }
        fscInvoiceInfoBO.setUntaxAmt(totalsAmount);
        fscInvoiceInfoBO.setTaxAmt(taxAmt);
        fscInvoiceInfoBO.setAmt(totalsAmount.add(taxAmt));
        fscInvoiceInfoBO.setInvoiceCategory(fscOrderInvoicePO.getInvoiceCategory());
        fscInvoiceInfoBO.setInvoiceType(fscOrderInvoicePO.getInvoiceType());
        if (FscConstants.OrderFlow.INVOICE.equals(fscOrderPO.getOrderFlow())) {
            ArrayList<InvoiceItemBO> invoiceItemBOS = new ArrayList<InvoiceItemBO>();
            for (FscBillTaxDealInvoiceDetailBO fscBillTaxDealInvoiceDetailBO : reqBO.getInvoiceDetail()) {
                String[] rowIds;
                for (String rowId : rowIds = ((FscInvoiceCallBackSourceInfoBO)fscBillTaxDealInvoiceDetailBO.getSourceInfoList().get(0)).getRowId().split(",")) {
                    FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
                    fscOrderItemPO.setFscOrderId(fscOrderId);
                    fscOrderItemPO.setId(Long.valueOf(Long.parseLong(rowId)));
                    fscOrderItemPO = this.fscOrderItemMapper.getModelBy(fscOrderItemPO);
                    if (ObjectUtil.isEmpty((Object)fscOrderItemPO)) continue;
                    InvoiceItemBO invoiceItemBO = new InvoiceItemBO();
                    invoiceItemBO.setOrderId(fscOrderItemPO.getOrderId());
                    invoiceItemBO.setSkuId(fscOrderItemPO.getSkuId());
                    invoiceItemBO.setAcceptOrderId(fscOrderItemPO.getAcceptOrderId());
                    invoiceItemBO.setSkuName(fscBillTaxDealInvoiceDetailBO.getItemName());
                    invoiceItemBO.setModel(fscOrderItemPO.getModel());
                    invoiceItemBO.setSpec(fscOrderItemPO.getSpec());
                    invoiceItemBO.setUnit(fscBillTaxDealInvoiceDetailBO.getItemUnit());
                    invoiceItemBO.setNum(new BigDecimal(fscBillTaxDealInvoiceDetailBO.getItemNum()));
                    invoiceItemBO.setPrice(new BigDecimal(fscBillTaxDealInvoiceDetailBO.getItemPrice()));
                    invoiceItemBO.setOrderItemId(fscOrderItemPO.getOrderItemId());
                    invoiceItemBO.setAmt(new BigDecimal(fscBillTaxDealInvoiceDetailBO.getAmount()).add(new BigDecimal(fscBillTaxDealInvoiceDetailBO.getTax())));
                    invoiceItemBO.setUntaxAmt(new BigDecimal(fscBillTaxDealInvoiceDetailBO.getAmount()));
                    invoiceItemBO.setTaxAmt(new BigDecimal(fscBillTaxDealInvoiceDetailBO.getTax()));
                    invoiceItemBO.setTax(new BigDecimal(fscBillTaxDealInvoiceDetailBO.getTaxRate()));
                    invoiceItemBO.setTaxCode(fscBillTaxDealInvoiceDetailBO.getItemTaxCode());
                    invoiceItemBOS.add(invoiceItemBO);
                }
            }
            fscInvoiceInfoBO.setInvoiceItemBOS(invoiceItemBOS);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPdfUrl())) {
            if (this.changeSwitch.equals("on")) {
                reqBO.setPdfUrl(this.upload(reqBO.getPdfUrl()));
            }
            AttachmentBO attachmentBO = new AttachmentBO();
            attachmentBO.setAttachmentUrl(reqBO.getPdfUrl());
            attachmentBO.setAttachmentName("\u7535\u5b50\u53d1\u7968");
            ArrayList<AttachmentBO> attachmentList = new ArrayList<AttachmentBO>(1);
            attachmentList.add(attachmentBO);
            fscInvoiceInfoBO.setAttachmentList(attachmentList);
        }
        fscInvoiceInfoBOS.add(fscInvoiceInfoBO);
        fscBillInvoiceUploadBusiReqBO.setFscInvoiceInfoBOS(fscInvoiceInfoBOS);
        FscBillInvoiceUploadBusiRspBO fscBillInvoiceUploadBusiRspBO = this.fscBillInvoiceUploadCrcExtBusiService.dealInvoiceUpload(fscBillInvoiceUploadBusiReqBO);
        if (!fscBillInvoiceUploadBusiRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException("191026", fscBillInvoiceUploadBusiRspBO.getRespDesc());
        }
        for (Long each : fscOrderIds) {
            this.sendMq(each);
        }
        return new FscBillTaxDealInvoiceAbilityRspBO();
    }

    private void val(FscBillTaxDealInvoiceAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getTaxNo())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[taxNo]\u4e3a\u7a7a");
        }
        if (null == reqBO.getOldOrderNo()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[oldOrderNo]\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderNo()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[orderNo]\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceDate()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[invoiceDate]\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceCode()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[invoiceCode]\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceNum()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[invoiceNum]\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceDetail() || reqBO.getInvoiceDetail().size() == 0) {
            throw new FscBusinessException("191000", "\u5165\u53c2[invoiceDetail]\u4e3a\u7a7a");
        }
        List detail = reqBO.getInvoiceDetail();
        for (FscBillTaxDealInvoiceDetailBO fscBillTaxDealInvoiceDetailBO : detail) {
            if (StringUtils.isEmpty((CharSequence)fscBillTaxDealInvoiceDetailBO.getAmount())) {
                throw new FscBusinessException("191000", "\u5165\u53c2[invoiceDetail]amount");
            }
            if (null == fscBillTaxDealInvoiceDetailBO.getItemName()) {
                throw new FscBusinessException("191000", "\u5165\u53c2[invoiceDetail]\u4e2d\u7684itemName\u4e3a\u7a7a");
            }
            if (null == fscBillTaxDealInvoiceDetailBO.getItemNum()) {
                throw new FscBusinessException("191000", "\u5165\u53c2[invoiceDetail]\u4e2d\u7684itemNum\u4e3a\u7a7a");
            }
            if (null == fscBillTaxDealInvoiceDetailBO.getItemPrice()) {
                throw new FscBusinessException("191000", "\u5165\u53c2[invoiceDetail]\u4e2d\u7684itemPrice\u4e3a\u7a7a");
            }
            if (null == fscBillTaxDealInvoiceDetailBO.getItemTaxCode()) {
                throw new FscBusinessException("191000", "\u5165\u53c2[invoiceDetail]\u4e2d\u7684itemTaxCode\u4e3a\u7a7a");
            }
            if (null == fscBillTaxDealInvoiceDetailBO.getItemUnit()) {
                throw new FscBusinessException("191000", "\u5165\u53c2[invoiceDetail]\u4e2d\u7684itemUnit\u4e3a\u7a7a");
            }
            if (null == fscBillTaxDealInvoiceDetailBO.getTax()) {
                throw new FscBusinessException("191000", "\u5165\u53c2[invoiceDetail]\u4e2d\u7684tax\u4e3a\u7a7a");
            }
            if (null == fscBillTaxDealInvoiceDetailBO.getTaxRate()) {
                throw new FscBusinessException("191000", "\u5165\u53c2[invoiceDetail]\u4e2d\u7684taxRate\u4e3a\u7a7a");
            }
            if (CollectionUtils.isEmpty((Collection)fscBillTaxDealInvoiceDetailBO.getSourceInfoList())) {
                throw new FscBusinessException("191000", "\u5165\u53c2[invoiceDetail]\u4e2d\u7684tax\u4e3a\u7a7a");
            }
            if (null != ((FscInvoiceCallBackSourceInfoBO)fscBillTaxDealInvoiceDetailBO.getSourceInfoList().get(0)).getRowId()) continue;
            throw new FscBusinessException("191000", "\u5165\u53c2[invoiceDetail]\u4e2d\u7684sourceInfoList\u7684RowId\u4e3a\u7a7a");
        }
    }

    private void sendMq(Long fscOrderId) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        FscBillMailListSyncAbilityReqBO fscBillMailListSyncAbilityReqBO = new FscBillMailListSyncAbilityReqBO();
        fscBillMailListSyncAbilityReqBO.setFscOrderId(fscOrderId);
        this.fscBillMailSyncAbilityService.syncBillMail(fscBillMailListSyncAbilityReqBO);
        FscComInvoiceListSyncAbilityReqBO fscComInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
        fscComInvoiceListSyncAbilityReqBO.setFscOrderId(fscOrderId);
        this.fscComInvoiceSyncAbilityService.dealComOrderSyncEs(fscComInvoiceListSyncAbilityReqBO);
    }

    private String upload(String url) {
        url = url.replace(this.beforeChangeUrl, this.afterChangeUrl);
        URL urlBean = null;
        try {
            urlBean = new URL(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new BusinessException("8888", "\u7a0e\u63a7\u56de\u8c03pdfUrl\u89e3\u6790\u5931\u8d25\uff1a" + e.getMessage());
        }
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)urlBean.openConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("8888", "\u7a0e\u63a7\u56de\u8c03pdf\u83b7\u53d6\u8fde\u63a5\u5931\u8d25\uff1a" + e.getMessage());
        }
        conn.setConnectTimeout(3000);
        conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
        InputStream inputStream = null;
        try {
            inputStream = conn.getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BusinessException("8888", "\u7a0e\u63a7\u56de\u8c03pdfIO\u6d41\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buff = new byte[1024];
        try {
            int ch;
            while ((ch = inputStream.read(buff, 0, 1024)) > 0) {
                byteArrayOutputStream.write(buff, 0, ch);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
                throw new BusinessException("8888", "\u7a0e\u63a7\u56de\u8c03pdfIO\u6d41\u8bfb\u53d6\u5931\u8d25\uff1a" + e.getMessage());
            }
            throw new BusinessException("8888", "\u7a0e\u63a7\u56de\u8c03pdfIO\u6d41\u8bfb\u53d6\u5931\u8d25\uff1a" + e.getMessage());
        }
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BusinessException("8888", "\u7a0e\u63a7\u56de\u8c03pdfIO\u6d41\u8bfb\u53d6\u5931\u8d25\uff1a" + e.getMessage());
        }
        byte[] b = byteArrayOutputStream.toByteArray();
        String fileUrl = this.fileUpLoad.upload("\u7535\u5b50\u53d1\u7968-" + System.currentTimeMillis(), b, ".pdf");
        log.info("fastdfs\u8fd4\u56defileUrl:" + fileUrl);
        return fileUrl;
    }
}

