/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.atom.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.fsc.bill.ability.api.FscBillOrderPrintPreviewAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderPrintPreviewAbilityReqBO;
import com.tydic.fsc.bill.atom.api.FscSendSaleOrderAtomService;
import com.tydic.fsc.bill.atom.bo.FscSendSaleOrderAtomReqBO;
import com.tydic.fsc.bill.atom.bo.FscSendSaleOrderAtomRspBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderMsgLogMapper;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderMsgLogPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.util.FileUtils;
import com.tydic.fsc.utils.SSLClient;
import com.tydic.umc.general.ability.api.CrcQryMainUserInfoByPartIdAbilityService;
import com.tydic.umc.general.ability.api.UmcQryOrgAccountCodeByOrgIdAbilityService;
import com.tydic.umc.general.ability.bo.CrcQryMainUserInfoByPartIdAbilityReqBO;
import com.tydic.umc.general.ability.bo.CrcQryMainUserInfoByPartIdAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcQryOrgAccountCodeByOrgIdAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcQryOrgAccountCodeByOrgIdAbilityRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class FscSendSaleOrderAtomServiceImpl
implements FscSendSaleOrderAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscSendSaleOrderAtomServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private CrcQryMainUserInfoByPartIdAbilityService crcQryMainUserInfoByPartIdAbilityService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscOrderMsgLogMapper fscOrderMsgLogMapper;
    @Autowired
    private UmcQryOrgAccountCodeByOrgIdAbilityService umcQryOrgAccountCodeByOrgIdAbilityService;
    @Value(value="${ESB_SEND_SALE_ORDER_URL}")
    private String ESB_SEND_SALE_ORDER_URL;
    @Autowired
    private FscBillOrderPrintPreviewAbilityService fscBillOrderPrintPreviewAbilityService;

    @Override
    public FscSendSaleOrderAtomRspBO sendSaleOrderToFinancialSharing(FscSendSaleOrderAtomReqBO reqBO) {
        FscSendSaleOrderAtomRspBO rspBO = new FscSendSaleOrderAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        this.val(reqBO);
        FscOrderPO fscOrderPO = (FscOrderPO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderPO.class);
        log.info("\u8d22\u52a1\u5171\u4eab\u63a8\u9001\u67e5\u8be2\u9500\u552e\u7ed3\u7b97\u5355\u5165\u53c2:{}", (Object)fscOrderPO);
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (ObjectUtils.isEmpty((Object)fscOrderPO)) {
            throw new BaseBusinessException("8888", "\u63a8\u9001\u9500\u552e\u7ed3\u7b97\u5355\u5931\u8d25,\u9500\u552e\u7ed3\u7b97\u5355\u67e5\u8be2\u4e3a\u7a7a");
        }
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(fscOrderPO.getFscOrderId());
        log.info("\u8d22\u52a1\u5171\u4eab\u63a8\u9001\u67e5\u8be2\u9500\u552e\u7ed3\u7b97\u5355\u5546\u54c1\u660e\u7ec6\u5165\u53c2:{}", (Object)fscOrderItemPO);
        List fscOrderItemPOList = this.fscOrderItemMapper.getList(fscOrderItemPO);
        if (ObjectUtils.isEmpty((Object)fscOrderItemPOList)) {
            throw new BaseBusinessException("8888", "\u63a8\u9001\u9500\u552e\u7ed3\u7b97\u5355\u5931\u8d25,\u9500\u552e\u7ed3\u7b97\u5355\u8ba2\u5355\u660e\u7ec6\u67e5\u8be2\u4e3a\u7a7a");
        }
        FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
        fscAttachmentPO.setFscOrderId(fscOrderPO.getFscOrderId());
        fscAttachmentPO.setAttachmentType(FscConstants.AttachmentType.FSC_ORDER_PDF);
        log.info("\u83b7\u53d6\u9644\u4ef6\u5165\u53c2:{}", (Object)fscAttachmentPO);
        fscAttachmentPO = this.fscAttachmentMapper.getModelBy(fscAttachmentPO);
        if (ObjectUtil.isEmpty((Object)fscAttachmentPO)) {
            FscBillOrderPrintPreviewAbilityReqBO fscBillOrderPrintPreviewAbilityReqBO = new FscBillOrderPrintPreviewAbilityReqBO();
            fscBillOrderPrintPreviewAbilityReqBO.setFscOrderId(fscOrderPO.getFscOrderId());
            fscBillOrderPrintPreviewAbilityReqBO.setIsShowMark(Boolean.valueOf(true));
            fscBillOrderPrintPreviewAbilityReqBO.setSourceType(FscConstants.FSC_ORDER_PDF_TYPE.DOWN_ELC_ORDER);
            this.fscBillOrderPrintPreviewAbilityService.orderPrintPreview(fscBillOrderPrintPreviewAbilityReqBO);
        }
        String sendParams = this.initSendParams(fscOrderPO, fscOrderItemPOList);
        log.info("\u9500\u552e\u7ed3\u7b97\u5355\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u8bf7\u6c42\u5730\u5740:{}", (Object)this.ESB_SEND_SALE_ORDER_URL);
        log.info("\u9500\u552e\u7ed3\u7b97\u5355\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u8bf7\u6c42\u53c2\u6570:{}", (Object)sendParams);
        String returnString = SSLClient.doPost((String)this.ESB_SEND_SALE_ORDER_URL, (String)sendParams);
        log.info("\u9500\u552e\u7ed3\u7b97\u5355\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u8bf7\u6c42\u54cd\u5e94:{}", (Object)returnString);
        FscOrderMsgLogPO fscOrderMsgLogPO = new FscOrderMsgLogPO();
        fscOrderMsgLogPO.setSendUrl(this.ESB_SEND_SALE_ORDER_URL);
        fscOrderMsgLogPO.setSendContent(sendParams);
        fscOrderMsgLogPO.setMsgContent(returnString);
        fscOrderMsgLogPO.setObjId(fscOrderPO.getFscOrderId());
        fscOrderMsgLogPO.setPushTime(new Date());
        if (ObjectUtil.isEmpty((Object)returnString)) {
            fscOrderMsgLogPO.setResultString("0");
            fscOrderMsgLogPO.setFailureReason("\u8c03\u7528ESB\u63a5\u53e3\u9500\u552e\u7ed3\u7b97\u5355\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
            this.writeLog(fscOrderMsgLogPO);
            throw new BaseBusinessException("8888", "\u8c03\u7528ESB\u63a5\u53e3\u9500\u552e\u7ed3\u7b97\u5355\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
        }
        this.resolveRsp(returnString, reqBO, fscOrderMsgLogPO);
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        return rspBO;
    }

    private void val(FscSendSaleOrderAtomReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getFscOrderId())) {
            throw new BaseBusinessException("8888", "\u9500\u552e\u7ed3\u7b97\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private String initSendParams(FscOrderPO fscOrderPO, List<FscOrderItemPO> fscOrderItemPOList) {
        CrcQryMainUserInfoByPartIdAbilityReqBO crcQryMainUserInfoByPartIdAbilityReqBO = new CrcQryMainUserInfoByPartIdAbilityReqBO();
        crcQryMainUserInfoByPartIdAbilityReqBO.setMemId(fscOrderPO.getCreateOperId());
        log.info("\u8c03\u7528\u4f1a\u5458\u83b7\u53d6\u4e3b\u8d26\u53f7\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)crcQryMainUserInfoByPartIdAbilityReqBO));
        CrcQryMainUserInfoByPartIdAbilityRspBO crcQryMainUserInfoByPartIdAbilityRspBO = this.crcQryMainUserInfoByPartIdAbilityService.qryMainUserInfoByPartId(crcQryMainUserInfoByPartIdAbilityReqBO);
        log.info("\u8c03\u7528\u4f1a\u5458\u83b7\u53d6\u4e3b\u8d26\u53f7\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)crcQryMainUserInfoByPartIdAbilityRspBO));
        if (!"0000".equals(crcQryMainUserInfoByPartIdAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u4f1a\u5458\u5f02\u5e38\uff1a" + crcQryMainUserInfoByPartIdAbilityRspBO.getRespDesc());
        }
        String creatorLdap = crcQryMainUserInfoByPartIdAbilityRspBO.getMainMemInformation().getRegAccount();
        UmcQryOrgAccountCodeByOrgIdAbilityReqBO umcQryOrgAccountCodeByOrgIdAbilityReqBO = new UmcQryOrgAccountCodeByOrgIdAbilityReqBO();
        umcQryOrgAccountCodeByOrgIdAbilityReqBO.setOrgId(fscOrderPO.getSupplierId());
        log.info("\u67e5\u8be2\u4f1a\u5458\u91c7\u8d2d\u5355\u4f4d\u7f16\u7801\u5165\u53c2\uff1a" + JSON.toJSONString((Object)umcQryOrgAccountCodeByOrgIdAbilityReqBO));
        UmcQryOrgAccountCodeByOrgIdAbilityRspBO umcQryOrgAccountCodeByOrgIdAbilityRspBO = this.umcQryOrgAccountCodeByOrgIdAbilityService.qryOrgAccountCodeByOrgId(umcQryOrgAccountCodeByOrgIdAbilityReqBO);
        log.info("\u67e5\u8be2\u4f1a\u5458\u91c7\u8d2d\u5355\u4f4d\u7f16\u7801\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)umcQryOrgAccountCodeByOrgIdAbilityRspBO));
        String orgAccountCode = umcQryOrgAccountCodeByOrgIdAbilityRspBO.getOrgAccountCode();
        JSONObject reqJson = new JSONObject();
        reqJson.put("ouCode", (Object)"SZZB0");
        reqJson.put("sourceNo", (Object)fscOrderPO.getOrderNo());
        reqJson.put("serialNo", (Object)Sequence.getInstance().nextId());
        reqJson.put("applyLdapId", (Object)creatorLdap);
        reqJson.put("applyDate", (Object)DateUtil.dateToStr((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        String summaryStr = "\u9500\u552e\u6536\u5165\u7ed3\u7b97\u5355/" + fscOrderPO.getOrderNo();
        reqJson.put("summary", (Object)summaryStr);
        JSONArray lines = new JSONArray();
        Map<String, List<FscOrderItemPO>> fscOrderL1CatalogNameMap = fscOrderItemPOList.stream().collect(Collectors.groupingBy(item -> item.getL1CatalogName()));
        fscOrderL1CatalogNameMap.forEach((k, v) -> {
            Map<String, List<FscOrderItemPO>> tempListMap = v.stream().collect(Collectors.groupingBy(it -> ObjectUtils.isEmpty((Object)it.getTaxRate()) ? "" : it.getTaxRate().setScale(2, RoundingMode.HALF_UP).toString()));
            for (Map.Entry<String, List<FscOrderItemPO>> entry : tempListMap.entrySet()) {
                BigDecimal allPrice = BigDecimal.ZERO;
                BigDecimal allUntaxAmt = BigDecimal.ZERO;
                BigDecimal allTaxAmt = BigDecimal.ZERO;
                List list = JSON.parseArray((String)JSON.toJSONString(entry.getValue()), FscOrderItemPO.class);
                allPrice = list.stream().map(FscOrderItemPO::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                allUntaxAmt = list.stream().map(FscOrderItemPO::getUntaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                allTaxAmt = list.stream().map(FscOrderItemPO::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("subcategoryCode", (Object)"");
                jsonObject.put("vendorCode", (Object)orgAccountCode);
                jsonObject.put("vendorName", (Object)fscOrderPO.getSupplierName());
                jsonObject.put("currencyCode", (Object)"CNY");
                BigDecimal tempTax = new BigDecimal(entry.getKey().toString()).setScale(2, RoundingMode.HALF_UP);
                if (tempTax.compareTo(new BigDecimal(1)) > 1) {
                    jsonObject.put("taxRate", (Object)(tempTax + "%"));
                } else {
                    jsonObject.put("taxRate", (Object)(tempTax.multiply(new BigDecimal("100")) + "%"));
                }
                jsonObject.put("settlementTaxAmount", (Object)allPrice.setScale(2, RoundingMode.HALF_UP));
                jsonObject.put("settlementAmount", (Object)allUntaxAmt.setScale(2, RoundingMode.HALF_UP));
                jsonObject.put("taxAmount", (Object)allTaxAmt.setScale(2, RoundingMode.HALF_UP));
                jsonObject.put("lineSummary", (Object)fscOrderPO.getOrderNo());
                lines.add((Object)jsonObject);
            }
        });
        reqJson.put("lines", (Object)lines);
        FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
        fscAttachmentPO.setFscOrderId(fscOrderPO.getFscOrderId());
        fscAttachmentPO.setAttachmentTypeList(Arrays.asList(FscConstants.AttachmentType.FSC_ORDER_PDF, FscConstants.AttachmentType.INVOICE));
        log.info("\u83b7\u53d6\u9644\u4ef6\u5165\u53c2:{}", (Object)fscAttachmentPO);
        List fscAttachmentPOList = this.fscAttachmentMapper.getList(fscAttachmentPO);
        JSONArray attachmentList = new JSONArray();
        if (!ObjectUtils.isEmpty((Object)fscAttachmentPOList)) {
            for (FscAttachmentPO item2 : fscAttachmentPOList) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("attachmentName", (Object)item2.getAttachmentName());
                jsonObject.put("attachmentType", (Object)item2.getAttachmentType());
                String size = FileUtils.getFileLength((String)item2.getAttachmentUrl(), (String)"kb");
                jsonObject.put("attachmentSize", (Object)size);
                jsonObject.put("attachmentUrl", (Object)item2.getAttachmentUrl());
                jsonObject.put("sourceNo", (Object)fscOrderPO.getOrderNo());
                attachmentList.add((Object)jsonObject);
            }
        }
        reqJson.put("attachments", (Object)attachmentList);
        log.info("\u63a8\u9001\u51fa\u53c2:{}", (Object)reqJson);
        return reqJson.toJSONString();
    }

    private void resolveRsp(String returnString, FscSendSaleOrderAtomReqBO atomReqBO, FscOrderMsgLogPO fscOrderMsgLogPO) {
        JSONObject rspJsonObject;
        try {
            rspJsonObject = JSONObject.parseObject((String)returnString);
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
            fscOrderMsgLogPO.setResultString("0");
            fscOrderMsgLogPO.setFailureReason("\u8f6c\u6362\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519:" + e.getMessage());
            this.writeLog(fscOrderMsgLogPO);
            throw new RuntimeException("\u8f6c\u6362\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(atomReqBO.getFscOrderId());
        fscOrderPO.setOrderSyncTime(new Date(System.currentTimeMillis()));
        if (null == rspJsonObject.getJSONObject("RESPONSE") || null == rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA")) {
            fscOrderPO.setOrderSyncState(FscConstants.SYNC_STOCK_STATE_TYPE.FAIL);
            fscOrderPO.setOrderSyncFailReason("ECSB\u8c03\u7528\u8fd4\u56de\u5f02\u5e38");
            this.fscOrderMapper.updateByFscOrderId(fscOrderPO);
            fscOrderMsgLogPO.setResultString("0");
            fscOrderMsgLogPO.setFailureReason("ECSB\u8c03\u7528\u8fd4\u56de\u5f02\u5e38");
            this.writeLog(fscOrderMsgLogPO);
            return;
        }
        if (rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA").get((Object)"status").equals("SUCC")) {
            fscOrderPO.setOrderSyncState(FscConstants.SYNC_STOCK_STATE_TYPE.SUCCESS);
            fscOrderPO.setOrderSyncFailReason("");
            this.fscOrderMapper.updateByFscOrderId(fscOrderPO);
            fscOrderMsgLogPO.setResultString("1");
        } else {
            fscOrderPO.setOrderSyncState(FscConstants.SYNC_STATE_TYPE.FAIL);
            fscOrderPO.setOrderSyncFailReason(rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA").get((Object)"errorMsg").toString());
            this.fscOrderMapper.updateByFscOrderId(fscOrderPO);
            fscOrderMsgLogPO.setResultString("0");
            fscOrderMsgLogPO.setFailureReason(rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA").get((Object)"errorMsg").toString());
        }
        this.writeLog(fscOrderMsgLogPO);
    }

    private void writeLog(FscOrderMsgLogPO fscOrderMsgLogPO) {
        fscOrderMsgLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        fscOrderMsgLogPO.setMsgType(FscConstants.FSC_ORDER_OUT_MSG_TYPE.PUSH_SALE_ORDER);
        fscOrderMsgLogPO.setObjType(FscConstants.FSC_ORDER_OUT_OBJ_TYPE.SALE_FSC_ORDER);
        fscOrderMsgLogPO.setCreateTime(new Date());
        this.fscOrderMsgLogMapper.insert(fscOrderMsgLogPO);
    }
}

