/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.util.StrUtil;
import com.jd.open.api.sdk.internal.JSON.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.fsc.bill.ability.api.FscPayQueryBankCheckFileAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBankCheckFileItemBO;
import com.tydic.fsc.bill.ability.bo.FscPayQueryBankCheckFileAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscPayQueryBankCheckFileAbilityRspBO;
import com.tydic.fsc.bill.atom.api.FscFileUploadOSSByUrlAtomService;
import com.tydic.fsc.bill.atom.bo.FscFileUploadOSSByUrlAtomReqBO;
import com.tydic.fsc.bill.atom.bo.FscFileUploadOSSByUrlAtomRspBO;
import com.tydic.fsc.bill.busi.api.FscPayBillBankCheckFileBusiService;
import com.tydic.fsc.bill.busi.bo.FscBankCheckFileBO;
import com.tydic.fsc.bill.busi.bo.FscPayBillBankCheckFileBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscPayBillBankCheckFileBusiRspBO;
import com.tydic.fsc.busibase.comb.api.FscUocOrderRelUpdateCombService;
import com.tydic.fsc.busibase.external.api.bo.FscUocOrderRelUpdateReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocOrderRelUpdateRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocProOrderPaymentCallbackAbilityBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocProOrderPaymentCallbackAbilityReqBO;
import com.tydic.fsc.busibase.external.api.pay.FscBToBPingAnBankDownLoadCheckFileService;
import com.tydic.fsc.busibase.external.api.pay.FscBToBPingAnBankQueryCheckFileService;
import com.tydic.fsc.busibase.external.api.pay.bo.FscBToBPingAnBankDownLoadCheckFileReqBO;
import com.tydic.fsc.busibase.external.api.pay.bo.FscBToBPingAnBankDownLoadCheckFileRspBO;
import com.tydic.fsc.busibase.external.api.pay.bo.FscBToBPingAnBankQueryCheckFileReqBO;
import com.tydic.fsc.busibase.external.api.pay.bo.FscBToBPingAnBankQueryCheckFileRspBO;
import com.tydic.fsc.busibase.external.api.uoc.FscUocOrderRelUpdateAbilityService;
import com.tydic.fsc.busibase.external.api.uoc.FscUocProOrderPaymentCallbackAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscBankCheckFileItemMapper;
import com.tydic.fsc.dao.FscBankCheckFileMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscBankCheckFileItemPO;
import com.tydic.fsc.po.FscBankCheckFilePO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.utils.BigDecimalConvert;
import com.tydic.umc.general.ability.api.UmcDycEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcDycEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcDycEnterpriseOrgQryDetailAbilityRspBO;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscPayQueryBankCheckFileAbilityService"})
public class FscPayQueryBankCheckFileAbilityServiceImpl
implements FscPayQueryBankCheckFileAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscPayQueryBankCheckFileAbilityServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscBankCheckFileMapper fscBankCheckFileMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscBankCheckFileItemMapper fscBankCheckFileItemMapper;
    @Autowired
    private FscBToBPingAnBankQueryCheckFileService fscBToBPingAnBankQueryCheckFileService;
    @Autowired
    private FscPayBillBankCheckFileBusiService fscPayBillBankCheckFileBusiService;
    @Autowired
    private FscBToBPingAnBankDownLoadCheckFileService fscBToBPingAnBankDownLoadCheckFileService;
    @Autowired
    private FscFileUploadOSSByUrlAtomService fscFileUploadOSSByUrlAtomService;
    @Autowired
    private FscUocOrderRelUpdateCombService fscUocOrderRelUpdateCombService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscUocOrderRelUpdateAbilityService fscUocOrderRelUpdateAbilityService;
    @Autowired
    private UmcDycEnterpriseOrgQryDetailAbilityService umcDycEnterpriseOrgQryDetailAbilityService;
    @Autowired
    private FscUocProOrderPaymentCallbackAbilityService fscUocProOrderPaymentCallbackAbilityService;
    @Autowired
    private FileClient fileClient;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"qryBankCheckFile"})
    public FscPayQueryBankCheckFileAbilityRspBO qryBankCheckFile(@RequestBody FscPayQueryBankCheckFileAbilityReqBO abilityReqBO) {
        FscPayBillBankCheckFileBusiReqBO fscPayBillBankCheckFileBusiReqBO;
        FscBToBPingAnBankQueryCheckFileReqBO bankReqBO = new FscBToBPingAnBankQueryCheckFileReqBO();
        if (!StringUtils.isEmpty((Object)abilityReqBO.getFileDate())) {
            bankReqBO.setFileDate(abilityReqBO.getFileDate());
        } else {
            Calendar curDate = Calendar.getInstance();
            curDate.setTime(new Date());
            curDate.add(5, -1);
            bankReqBO.setFileDate(DateUtil.dateToStrYYYYMMdd((Date)curDate.getTime()));
        }
        bankReqBO.setFileType("B2BL");
        FscBToBPingAnBankQueryCheckFileRspBO bankRspBO = this.fscBToBPingAnBankQueryCheckFileService.checkAmountFile(bankReqBO);
        if (!"0000".equals(bankRspBO.getRespCode())) {
            throw new FscBusinessException("193130", bankRspBO.getRespDesc());
        }
        ArrayList<FscBankCheckFileBO> fscBankCheckFileBOs = new ArrayList<FscBankCheckFileBO>();
        if (null != bankRspBO && !CollectionUtils.isEmpty((Collection)bankRspBO.getTranItemArray())) {
            bankRspBO.getTranItemArray().forEach(row -> {
                if (row.getFileName().indexOf(".txt.enc") > 0) {
                    FscBankCheckFileBO fscBankCheckFileBO = new FscBankCheckFileBO();
                    fscBankCheckFileBO.setFileName(row.getFileName());
                    fscBankCheckFileBO.setFilePath(row.getFilePath());
                    fscBankCheckFileBO.setRandomPassword(row.getRandomPassword());
                    fscBankCheckFileBO.setDrawCode(row.getDrawCode());
                    fscBankCheckFileBOs.add(fscBankCheckFileBO);
                }
            });
        }
        if (!CollectionUtils.isEmpty(fscBankCheckFileBOs)) {
            FscPayBillBankCheckFileBusiReqBO fscPayBillBankCheckFileBusiReqBO2 = new FscPayBillBankCheckFileBusiReqBO();
            fscPayBillBankCheckFileBusiReqBO2.setFscBankCheckFileBOs(fscBankCheckFileBOs);
            fscPayBillBankCheckFileBusiReqBO2.setOperType(FscConstants.BANK_CHECK_OPER_TYPE.INSERT_FILE);
            FscPayBillBankCheckFileBusiRspBO fscPayBillBankCheckFileBusiRspBO = this.fscPayBillBankCheckFileBusiService.bankCheckFile(fscPayBillBankCheckFileBusiReqBO2);
            if (!"0000".equals(fscPayBillBankCheckFileBusiRspBO.getRespCode())) {
                throw new FscBusinessException("193130", fscPayBillBankCheckFileBusiRspBO.getRespDesc());
            }
        }
        FscBankCheckFilePO fscBankCheckFilePO = new FscBankCheckFilePO();
        fscBankCheckFilePO.setStatus(FscConstants.BANK_CHECK_STATUS.NO);
        List fscBankCheckFilePOList = this.fscBankCheckFileMapper.getList(fscBankCheckFilePO);
        if (!CollectionUtils.isEmpty((Collection)fscBankCheckFilePOList)) {
            for (FscBankCheckFilePO fscBankCheckFilePOFor : fscBankCheckFilePOList) {
                FscBToBPingAnBankDownLoadCheckFileReqBO downLoadCheckFileReqBO = new FscBToBPingAnBankDownLoadCheckFileReqBO();
                downLoadCheckFileReqBO.setFileName(fscBankCheckFilePOFor.getFileName());
                downLoadCheckFileReqBO.setFilePath(fscBankCheckFilePOFor.getFilePath());
                downLoadCheckFileReqBO.setDecryptKey(fscBankCheckFilePOFor.getRandomPassword());
                FscBToBPingAnBankDownLoadCheckFileRspBO dlRspBO = null;
                try {
                    dlRspBO = this.fscBToBPingAnBankDownLoadCheckFileService.downLoadCheckFile(downLoadCheckFileReqBO);
                }
                catch (FscBusinessException e) {
                    e.printStackTrace();
                    log.debug("\u8bfb\u53d6\u94f6\u884c\u5bf9\u8d26\u6587\u4ef6\u9519\u8bef");
                    continue;
                }
                FscFileUploadOSSByUrlAtomReqBO fscFileUploadOSSByUrlAtomReqBO = new FscFileUploadOSSByUrlAtomReqBO();
                fscFileUploadOSSByUrlAtomReqBO.setLocalUrl(dlRspBO.getLocalFilePath());
                FscFileUploadOSSByUrlAtomRspBO uploadRspBO = null;
                try {
                    uploadRspBO = this.fscFileUploadOSSByUrlAtomService.uploadFileByBrl(fscFileUploadOSSByUrlAtomReqBO);
                }
                catch (FscBusinessException e) {
                    e.printStackTrace();
                    log.debug("\u8bfb\u53d6\u94f6\u884c\u5bf9\u8d26\u6587\u4ef6\u9519\u8bef");
                    continue;
                }
                int updateResult = this.updateBankFileStatus(FscConstants.BANK_CHECK_STATUS.DOWNLOAD, fscBankCheckFilePOFor.getFileName(), uploadRspBO);
                if (updateResult >= 1) continue;
                log.debug("\u66f4\u65b0\u6587\u4ef6\uff1a{}\u72b6\u6001\u4e3a\u5df2\u4e0b\u8f7d\u9519\u8bef", (Object)fscBankCheckFilePOFor.getFileName());
            }
        }
        FscBankCheckFilePO downloadCheckFile = new FscBankCheckFilePO();
        downloadCheckFile.setStatus(FscConstants.BANK_CHECK_STATUS.DOWNLOAD);
        List downloadCheckFileList = this.fscBankCheckFileMapper.getList(downloadCheckFile);
        log.info("\u5df2\u4e0b\u8f7d\u6587\u4ef6\uff1a{}", (Object)downloadCheckFileList);
        for (FscBankCheckFilePO downloadFile : downloadCheckFileList) {
            ArrayList<FscBankCheckFileItemBO> fscBankCheckFileItemBOList = new ArrayList<FscBankCheckFileItemBO>();
            try {
                String[] pad = downloadFile.getAttachmentUrl().split("group1");
                String filePath = "group1" + pad[1].replaceFirst("/", ",");
                InputStream in = this.fileClient.downLoadToInputStream(filePath);
                log.error("in___________=" + in);
                InputStreamReader insr = new InputStreamReader(in, "GBK");
                BufferedReader reader = new BufferedReader(insr);
                String str = null;
                str = reader.readLine();
                Integer totalRows = 0;
                if (!StringUtils.isEmpty((Object)str)) {
                    String[] newStr = str.split("&");
                    totalRows = Integer.parseInt(newStr[1]);
                }
                String tempStr = "";
                int readCount = 0;
                while ((str = reader.readLine()) != null) {
                    log.info("\u8bfb\u53d6\u6b21\u6570\uff1a{}", (Object)readCount++);
                    if (StringUtils.isEmpty((Object)str)) continue;
                    log.info("\u89e3\u6790\u524d\u884c\u6570\u636e--\u524d\uff1a{}", (Object)str);
                    if (!ObjectUtils.isEmpty((Object)tempStr)) {
                        str = new StringBuilder(str).insert(0, tempStr).toString();
                    }
                    log.info("\u89e3\u6790\u524d\u884c\u6570\u636e\uff1a{}", (Object)str);
                    String[] newStr = str.split("&");
                    log.info("\u5b57\u7b26\u4e32\u957f\u5ea6:{}", (Object)newStr.length);
                    if (newStr.length < 16) {
                        tempStr = str;
                        log.info("\u4e34\u65f6\u5b57\u7b26\u4e32\uff1a{}", (Object)tempStr);
                        continue;
                    }
                    FscBankCheckFileItemBO fscBankCheckFileItemBO = new FscBankCheckFileItemBO();
                    fscBankCheckFileItemBO.setBankCheckId(Long.valueOf(Sequence.getInstance().nextId()));
                    fscBankCheckFileItemBO.setSortNo(newStr[0]);
                    fscBankCheckFileItemBO.setPayeeOraCode(newStr[1]);
                    Long payeeId = Long.parseLong(newStr[1]);
                    fscBankCheckFileItemBO.setPayeeId(payeeId);
                    fscBankCheckFileItemBO.setPayeeSubAccountNo(newStr[2]);
                    fscBankCheckFileItemBO.setPayeeAccountName(newStr[3]);
                    fscBankCheckFileItemBO.setPayeeName(newStr[3]);
                    if (!StringUtils.isEmpty((Object)newStr[4])) {
                        fscBankCheckFileItemBO.setTradeAmt(new BigDecimal(newStr[4]));
                    }
                    if (!StringUtils.isEmpty((Object)newStr[5])) {
                        fscBankCheckFileItemBO.setHandlingFee(new BigDecimal(newStr[5]));
                    }
                    fscBankCheckFileItemBO.setTradeDate(newStr[6]);
                    fscBankCheckFileItemBO.setTradeTime(newStr[7]);
                    fscBankCheckFileItemBO.setBankWitnessSeq(newStr[8]);
                    fscBankCheckFileItemBO.setBankTradeSeq(newStr[9]);
                    String memo = newStr[10];
                    String shouldPayNo = "";
                    if (!StringUtils.isEmpty((Object)memo)) {
                        try {
                            shouldPayNo = memo.substring(memo.lastIndexOf("FKD-"), memo.lastIndexOf("FKD-") + 16);
                        }
                        catch (Exception e) {
                            shouldPayNo = memo;
                        }
                    }
                    fscBankCheckFileItemBO.setMemo(memo);
                    fscBankCheckFileItemBO.setShouldPayNo(shouldPayNo);
                    fscBankCheckFileItemBO.setPayerBankAccount(newStr[13]);
                    fscBankCheckFileItemBO.setPayerAccountName(newStr[14]);
                    fscBankCheckFileItemBO.setPayerBankName(newStr[15]);
                    fscBankCheckFileItemBO.setFileName(downloadFile.getFileName());
                    fscBankCheckFileItemBO.setFileAddr(downloadFile.getAttachmentUrl());
                    fscBankCheckFileItemBO.setWithdrawalStatus(FscConstants.WITHDRAWAL_STATUS.UN_WITHDRAWAL);
                    fscBankCheckFileItemBOList.add(fscBankCheckFileItemBO);
                    tempStr = "";
                }
                if (fscBankCheckFileItemBOList.size() != totalRows.intValue()) {
                    log.debug("\u6587\u4ef6\u6761\u6570\u9519\u8bef\u603b\u6761\u6570:{},\u89e3\u6790\u6761\u6570:{}", (Object)totalRows, (Object)fscBankCheckFileItemBOList.size());
                    throw new ZTBusinessException("\u6587\u4ef6\u89e3\u6790\u6570\u636e\u603b\u6761\u6570\u9519\u8bef");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.debug("\u8bfb\u53d6\u94f6\u884c\u5bf9\u8d26\u6587\u4ef6\u9519\u8bef");
                int updateResult = this.updateBankFileStatus(FscConstants.BANK_CHECK_STATUS.RESOLVING_FAIL, downloadFile.getFileName());
                if (updateResult >= 1) continue;
                log.debug("\u66f4\u65b0\u6587\u4ef6\uff1a{}\u72b6\u6001\u4e3a\u89e3\u6790\u9519\u8bef", (Object)downloadFile.getFileName());
                continue;
            }
            if (CollectionUtils.isEmpty(fscBankCheckFileItemBOList)) continue;
            fscPayBillBankCheckFileBusiReqBO = new FscPayBillBankCheckFileBusiReqBO();
            fscPayBillBankCheckFileBusiReqBO.setFileName(downloadFile.getFileName());
            fscPayBillBankCheckFileBusiReqBO.setAttachmentUrl(downloadFile.getAttachmentUrl());
            fscPayBillBankCheckFileBusiReqBO.setAttachmentName(downloadFile.getFileName());
            fscPayBillBankCheckFileBusiReqBO.setStatus(FscConstants.BANK_CHECK_STATUS.YES);
            fscPayBillBankCheckFileBusiReqBO.setFscBankCheckFileItemBOs(fscBankCheckFileItemBOList);
            fscPayBillBankCheckFileBusiReqBO.setOperType(FscConstants.BANK_CHECK_OPER_TYPE.INSERT_FILE_ITEM);
            try {
                this.fscPayBillBankCheckFileBusiService.bankCheckFile(fscPayBillBankCheckFileBusiReqBO);
            }
            catch (FscBusinessException e) {
                e.printStackTrace();
                log.debug("\u5199\u5bf9\u8d26\u6587\u4ef6\u660e\u7ec6\u5931\u8d25");
            }
        }
        FscBankCheckFileItemPO fscBankCheckFileItemPo = new FscBankCheckFileItemPO();
        fscBankCheckFileItemPo.setStatus(FscConstants.BANK_CHECK_ITEM_STATUS.NO_CHECK);
        fscBankCheckFileItemPo.setWriteOffFlag("0".toString());
        List fscBankCheckFileItemPOList = this.fscBankCheckFileItemMapper.getList(fscBankCheckFileItemPo);
        if (!CollectionUtils.isEmpty((Collection)fscBankCheckFileItemPOList)) {
            for (FscBankCheckFileItemPO fscBankCheckFileItemPO : fscBankCheckFileItemPOList) {
                fscPayBillBankCheckFileBusiReqBO = new FscPayBillBankCheckFileBusiReqBO();
                FscBankCheckFileItemBO fscBankCheckFileItemBO = new FscBankCheckFileItemBO();
                BeanUtils.copyProperties((Object)fscBankCheckFileItemPO, (Object)fscBankCheckFileItemBO);
                UmcDycEnterpriseOrgQryDetailAbilityReqBO umcDycEnterpriseOrgQryDetailAbilityReqBO = new UmcDycEnterpriseOrgQryDetailAbilityReqBO();
                umcDycEnterpriseOrgQryDetailAbilityReqBO.setOrgIdWeb(fscBankCheckFileItemPO.getPayeeId());
                log.info("\u662f\u5426\u662f\u8fd0\u8425\u5165\u53c2:{}", (Object)JSON.toString((Object)umcDycEnterpriseOrgQryDetailAbilityReqBO));
                UmcDycEnterpriseOrgQryDetailAbilityRspBO rspBO = this.umcDycEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(umcDycEnterpriseOrgQryDetailAbilityReqBO);
                log.info("\u662f\u5426\u662f\u8fd0\u8425\u51fa\u53c2:{}", (Object)JSON.toString((Object)rspBO));
                if (!ObjectUtils.isEmpty((Object)rspBO.getEnterpriseOrgBO()) && rspBO.getEnterpriseOrgBO().getIsProfessionalOrg().equals("0")) {
                    fscBankCheckFileItemBO.setOrgOpertion(Boolean.valueOf(true));
                    fscBankCheckFileItemBO.setWithdrawalStatus(FscConstants.WITHDRAWAL_STATUS.WITHDRAWAL);
                } else {
                    fscBankCheckFileItemBO.setOrgOpertion(Boolean.valueOf(false));
                }
                fscPayBillBankCheckFileBusiReqBO.setFscBankCheckFileItemBOs(Arrays.asList(fscBankCheckFileItemBO));
                fscPayBillBankCheckFileBusiReqBO.setOperType(FscConstants.BANK_CHECK_OPER_TYPE.CHECK_FILE_ITEM);
                FscPayBillBankCheckFileBusiRspBO fscPayBillBankCheckFileBusiRspBO = null;
                try {
                    fscPayBillBankCheckFileBusiRspBO = this.fscPayBillBankCheckFileBusiService.bankCheckFile(fscPayBillBankCheckFileBusiReqBO);
                }
                catch (FscBusinessException e) {
                    e.printStackTrace();
                    continue;
                }
                log.info("\u81ea\u52a8\u6838\u9500\u51fa\u53c2:{}", (Object)JSON.toString((Object)((Object)fscPayBillBankCheckFileBusiRspBO)));
                if (null == fscPayBillBankCheckFileBusiRspBO || CollectionUtils.isEmpty(fscPayBillBankCheckFileBusiRspBO.getFscOrderIds())) continue;
                for (Long fscOrderId : fscPayBillBankCheckFileBusiRspBO.getFscOrderIds()) {
                    log.info("\u540c\u6b65es:{}", (Object)fscOrderId);
                    FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
                    fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
                    this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
                    this.syncOrderStatus1(fscOrderId);
                }
            }
        }
        return new FscPayQueryBankCheckFileAbilityRspBO();
    }

    private void syncOrderStatus(Long fscPayOrderId) {
        List fscShouldPayPOList = this.fscShouldPayMapper.getByFscOrderId(fscPayOrderId);
        for (FscShouldPayPO fscShouldPayPO : fscShouldPayPOList) {
            FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
            fscOrderRelationPo.setFscOrderId(fscShouldPayPO.getObjectId());
            List fscOrderRelationPOs = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
            for (FscOrderRelationPO fscOrderRelationPO : fscOrderRelationPOs) {
                if (null == fscOrderRelationPO.getAcceptOrderId()) continue;
                FscUocOrderRelUpdateReqBO fscUocOrderRelUpdateReqBO = new FscUocOrderRelUpdateReqBO();
                fscUocOrderRelUpdateReqBO.setOrderId(fscOrderRelationPO.getOrderId());
                fscUocOrderRelUpdateReqBO.setRelId(fscShouldPayPO.getObjectId());
                fscUocOrderRelUpdateReqBO.setRelState(FscConstants.FscRelStatus.COMMITTED);
                fscUocOrderRelUpdateReqBO.setPayState(FscConstants.PAY_STATE.PAYED.toString());
                fscUocOrderRelUpdateReqBO.setRelType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
                fscUocOrderRelUpdateReqBO.setObjId(fscOrderRelationPO.getAcceptOrderId());
                fscUocOrderRelUpdateReqBO.setObjType(FscConstants.ORDER_OBJ_TYPE.SALE);
                fscUocOrderRelUpdateReqBO.setPayTime(new Date());
                FscUocOrderRelUpdateRspBO fscUocOrderRelUpdateRspBO = this.fscUocOrderRelUpdateAbilityService.dealRelUpdate(fscUocOrderRelUpdateReqBO);
                if ("0000".equals(fscUocOrderRelUpdateRspBO.getRespCode())) continue;
                throw new FscBusinessException("193207", StrUtil.format((CharSequence)"\u540c\u6b65\u66f4\u65b0\u8ba2\u5355\u51fa\u9519\uff1a{}", (Object[])new Object[]{fscUocOrderRelUpdateRspBO.getRespDesc()}));
            }
        }
    }

    private void syncOrderStatus1(Long fscPayOrderId) {
        List fscShouldPayPOList = this.fscShouldPayMapper.getByFscOrderId(fscPayOrderId);
        Map<Long, FscShouldPayPO> fscShouldPayPOMap = fscShouldPayPOList.stream().collect(Collectors.toMap(FscShouldPayPO::getObjectId, FscShouldPayPO2 -> FscShouldPayPO2));
        FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
        fscOrderRelationPo.setFscOrderIds(fscShouldPayPOList.stream().map(FscShouldPayPO::getObjectId).collect(Collectors.toList()));
        List fscOrderRelationPOs = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
        if (!CollectionUtils.isEmpty((Collection)fscShouldPayPOList)) {
            FscUocProOrderPaymentCallbackAbilityReqBO fscUocProOrderPaymentCallbackAbilityReqBO = new FscUocProOrderPaymentCallbackAbilityReqBO();
            fscUocProOrderPaymentCallbackAbilityReqBO.setUocPaymentCallbackBOS(fscOrderRelationPOs.stream().map(fscPaySuccessCallBackOrderBO -> {
                FscUocProOrderPaymentCallbackAbilityBO fscUocProOrderPaymentCallbackAbilityBO = new FscUocProOrderPaymentCallbackAbilityBO();
                fscUocProOrderPaymentCallbackAbilityBO.setSaleOrderId(fscPaySuccessCallBackOrderBO.getOrderId());
                fscUocProOrderPaymentCallbackAbilityBO.setPayMod(Integer.valueOf(30));
                fscUocProOrderPaymentCallbackAbilityBO.setPayResult(Boolean.valueOf(true));
                fscUocProOrderPaymentCallbackAbilityBO.setShouldPayMoney(fscPaySuccessCallBackOrderBO.getOrderTotalCharge());
                fscUocProOrderPaymentCallbackAbilityBO.setFscShouldPayId(((FscShouldPayPO)fscShouldPayPOMap.get(fscPaySuccessCallBackOrderBO.getFscOrderId())).getShouldPayId());
                return fscUocProOrderPaymentCallbackAbilityBO;
            }).collect(Collectors.toList()));
            this.fscUocProOrderPaymentCallbackAbilityService.dealOrderPaymentCallback(fscUocProOrderPaymentCallbackAbilityReqBO);
        }
    }

    public int updateBankFileStatus(Integer status, String fileName) {
        FscBankCheckFilePO setParams = new FscBankCheckFilePO();
        setParams.setStatus(status);
        FscBankCheckFilePO whereParams = new FscBankCheckFilePO();
        whereParams.setFileName(fileName);
        int updateResult = this.fscBankCheckFileMapper.updateBy(setParams, whereParams);
        return updateResult;
    }

    public int updateBankFileStatus(Integer status, String fileName, FscFileUploadOSSByUrlAtomRspBO uploadRspBO) {
        FscBankCheckFilePO setParams = new FscBankCheckFilePO();
        setParams.setStatus(status);
        setParams.setAttachmentName(fileName.replace(".enc", ""));
        setParams.setAttachmentUrl(uploadRspBO.getInnerFileUrl());
        FscBankCheckFilePO whereParams = new FscBankCheckFilePO();
        whereParams.setFileName(fileName);
        int updateResult = this.fscBankCheckFileMapper.updateBy(setParams, whereParams);
        return updateResult;
    }
}

