/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.commodity.base.constant.PesappCommonConstant;
import com.tydic.fsc.bill.ability.api.FscExportPayOrderItemAbilityService;
import com.tydic.fsc.bill.ability.bo.FscExportPayOrderItemAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscExportPayOrderItemAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscPayOrderItemStatisticBO;
import com.tydic.fsc.common.ability.api.FscComOrderListPageQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListQueryAbilityReqBO;
import com.tydic.fsc.dao.FscPayOrderItemStatisticMapper;
import com.tydic.fsc.po.FscPayOrderItemStatisticPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.util.poi.Excel;
import com.tydic.fsc.util.poi.Excels;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscExportPayOrderItemAbilityService"})
public class FscExportPayOrderItemAbilityServiceImpl
implements FscExportPayOrderItemAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscExportPayOrderItemAbilityServiceImpl.class);
    @Autowired
    private FileClient fileClient;
    private static final String PATH = "dyc-common/";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${oss.accessUrl}")
    private String accessUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    private static final Integer ROW_ACCESS_WINDOW_SIZE = 65535;
    @Value(value="${export.maxRows}")
    private Integer maxRows;
    @Autowired
    private FscComOrderListPageQueryAbilityService fscComOrderListPageQueryAbilityService;
    @Autowired
    private FscPayOrderItemStatisticMapper fscPayOrderItemStatisticMapper;

    @PostMapping(value={"payOrderItemExport"})
    public FscExportPayOrderItemAbilityRspBO payOrderItemExport(@RequestBody FscExportPayOrderItemAbilityReqBO reqBO) {
        FscExportPayOrderItemAbilityRspBO fscExportPayOrderItemAbilityRspBO = new FscExportPayOrderItemAbilityRspBO();
        FscPayOrderItemStatisticPO fscPayOrderItemStatisticPO = new FscPayOrderItemStatisticPO();
        fscPayOrderItemStatisticPO.setSupplierId(reqBO.getSupplierId());
        fscPayOrderItemStatisticPO.setPayeeId(reqBO.getPayeeId());
        fscPayOrderItemStatisticPO.setPayeeAccountNo(reqBO.getPayeeAccountNo());
        log.info("\u7ed3\u7b97\u5355\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)fscPayOrderItemStatisticPO));
        List fscPayOrderItemStatisticPOS = this.fscPayOrderItemStatisticMapper.getList(fscPayOrderItemStatisticPO);
        List list = JSON.parseArray((String)JSON.toJSONString((Object)fscPayOrderItemStatisticPOS), FscPayOrderItemStatisticBO.class);
        String fileName = this.exportExcel(list, FscPayOrderItemStatisticBO.class.getName());
        String url = this.uploadFile(fileName);
        fscExportPayOrderItemAbilityRspBO.setRespCode("0000");
        fscExportPayOrderItemAbilityRspBO.setRespDesc("\u6210\u529f");
        fscExportPayOrderItemAbilityRspBO.setUrl(url);
        File file = new File(fileName);
        file.delete();
        return fscExportPayOrderItemAbilityRspBO;
    }

    private FscComOrderListQueryAbilityReqBO initParams(FscExportPayOrderItemAbilityReqBO reqBO) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date date = DateUtil.getDate((Date)new Date(), (Integer)-1);
        FscComOrderListQueryAbilityReqBO fscComOrderListQueryAbilityReqBO = new FscComOrderListQueryAbilityReqBO();
        if (!ObjectUtil.isEmpty((Object)reqBO.getStarDate())) {
            fscComOrderListQueryAbilityReqBO.setCreateTimeBegin(reqBO.getStarDate());
        } else {
            fscComOrderListQueryAbilityReqBO.setCreateTimeBegin(DateUtil.getCurrentMinDate((String)formatter.format(date)));
        }
        if (!ObjectUtil.isEmpty((Object)reqBO.getEndDate())) {
            fscComOrderListQueryAbilityReqBO.setCreateTimeEnd(reqBO.getEndDate());
        } else {
            fscComOrderListQueryAbilityReqBO.setCreateTimeEnd(DateUtil.getCurrentMaxDate((String)formatter.format(date)));
        }
        if (!ObjectUtil.isEmpty((Object)reqBO.getOrderNo())) {
            fscComOrderListQueryAbilityReqBO.setFscOrderNo(reqBO.getOrderNo());
        }
        fscComOrderListQueryAbilityReqBO.setOrderFlows(Arrays.asList(1));
        return fscComOrderListQueryAbilityReqBO;
    }

    public String exportExcel(List<FscPayOrderItemStatisticBO> list, String className) {
        String string;
        log.info("\u914d\u7f6e\u884c\u6570:{}", (Object)this.maxRows);
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        List<Object> fields = this.getFields(clazz);
        fields = fields.stream().sorted(Comparator.comparing(objects -> ((Excel)objects[1]).sort())).collect(Collectors.toList());
        int rowNum = 0;
        SXSSFWorkbook wb = new SXSSFWorkbook(ROW_ACCESS_WINDOW_SIZE.intValue());
        Sheet sheet = wb.createSheet();
        FileOutputStream out = null;
        try {
            int sheetNo = Math.max(1, (int)Math.ceil((double)list.size() * 1.0 / 2000.0));
            for (int index = 0; index < sheetNo; ++index) {
                String[] str;
                if (sheetNo > 1 && index > 0) {
                    sheet = wb.createSheet();
                    wb.setSheetName(index, "sheet" + index);
                }
                Row row = sheet.createRow(rowNum);
                int column = 0;
                for (Object[] objectArray : fields) {
                    Excel excel = (Excel)objectArray[1];
                    Cell cell = row.createCell(column);
                    cell.setCellValue(excel.name());
                    ++column;
                }
                Map<String, List<FscPayOrderItemStatisticBO>> bankCheckIdMap = list.stream().collect(Collectors.groupingBy(FscPayOrderItemStatisticBO::getBankCheckId));
                Map<String, List<FscPayOrderItemStatisticBO>> map = list.stream().collect(Collectors.groupingBy(item -> item.getBankCheckId() + item.getPayOrderNo()));
                Map<String, List<FscPayOrderItemStatisticBO>> orderNoMap = list.stream().collect(Collectors.groupingBy(item -> item.getBankCheckId() + item.getPayOrderNo() + item.getOrderNo()));
                int startNo = index * this.maxRows;
                int endNo = Math.min(startNo + this.maxRows, list.size());
                HashMap<String, String> bankCheckIdMergeMap = new HashMap<String, String>();
                HashMap<String, String> payOrderNoMergeMap = new HashMap<String, String>();
                HashMap<String, String> orderNoMergeMap = new HashMap<String, String>();
                for (int i = startNo; i < endNo; ++i) {
                    String orderNoStr;
                    String payOrderNoStr;
                    row = sheet.createRow(i + 1 + rowNum - startNo);
                    int columns = 0;
                    FscPayOrderItemStatisticBO fscPayOrderItemStatisticBO = list.get(i);
                    String bankCheckId = list.get(i).getBankCheckId();
                    String payOrderNo = list.get(i).getPayOrderNo();
                    String orderNo = list.get(i).getOrderNo();
                    Field[] itemFields = fscPayOrderItemStatisticBO.getClass().getDeclaredFields();
                    int firstIndex = 1;
                    for (Field field : itemFields) {
                        if (firstIndex <= 2) {
                            ++firstIndex;
                            continue;
                        }
                        field.setAccessible(true);
                        String type = field.getType().toString();
                        String value = "";
                        value = "class java.math.BigDecimal".equals(type) ? (ObjectUtil.isEmpty((Object)field.get(fscPayOrderItemStatisticBO)) ? "" : new BigDecimal(field.get(fscPayOrderItemStatisticBO).toString()).setScale(2, RoundingMode.HALF_UP).toString()) : (ObjectUtil.isEmpty((Object)field.get(fscPayOrderItemStatisticBO)) ? "" : field.get(fscPayOrderItemStatisticBO).toString());
                        Cell cell = null;
                        try {
                            cell = row.createCell(columns++);
                            cell.setCellValue(ObjectUtil.isEmpty((Object)value) ? "" : value);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (bankCheckIdMap.get(bankCheckId).size() > 1) {
                        int starIndex = i + 1 + rowNum - startNo;
                        int endIndex = i + rowNum - startNo + bankCheckIdMap.get(bankCheckId).size();
                        String mergeStr = starIndex + "," + endIndex;
                        if (!bankCheckIdMergeMap.containsKey(bankCheckId)) {
                            bankCheckIdMergeMap.put(bankCheckId, mergeStr);
                        }
                    }
                    if (map.get(payOrderNoStr = bankCheckId + payOrderNo).size() > 1) {
                        int starIndex = i + 1 + rowNum - startNo;
                        int endIndex = i + rowNum - startNo + map.get(payOrderNoStr).size();
                        String mergeStr = starIndex + "," + endIndex;
                        if (!payOrderNoMergeMap.containsKey(payOrderNoStr)) {
                            payOrderNoMergeMap.put(payOrderNoStr, mergeStr);
                        }
                    }
                    if (orderNoMap.get(orderNoStr = bankCheckId + payOrderNo + orderNo).size() <= 1) continue;
                    int starIndex = i + 1 + rowNum - startNo;
                    int endIndex = i + rowNum - startNo + orderNoMap.get(orderNoStr).size();
                    String mergeStr = starIndex + "," + endIndex;
                    if (orderNoMergeMap.containsKey(orderNoStr)) continue;
                    orderNoMergeMap.put(orderNoStr, mergeStr);
                }
                for (Map.Entry entry : bankCheckIdMergeMap.entrySet()) {
                    str = entry.getValue().toString().split(",");
                    sheet.addMergedRegion(new CellRangeAddress(Integer.parseInt(str[0]), Integer.parseInt(str[1]), 0, 0));
                }
                for (Map.Entry entry : payOrderNoMergeMap.entrySet()) {
                    str = entry.getValue().toString().split(",");
                    sheet.addMergedRegion(new CellRangeAddress(Integer.parseInt(str[0]), Integer.parseInt(str[1]), 1, 1));
                    sheet.addMergedRegion(new CellRangeAddress(Integer.parseInt(str[0]), Integer.parseInt(str[1]), 2, 2));
                }
                for (Map.Entry entry : orderNoMergeMap.entrySet()) {
                    str = entry.getValue().toString().split(",");
                    sheet.addMergedRegion(new CellRangeAddress(Integer.parseInt(str[0]), Integer.parseInt(str[1]), 3, 3));
                    sheet.addMergedRegion(new CellRangeAddress(Integer.parseInt(str[0]), Integer.parseInt(str[1]), 4, 4));
                }
            }
            String filename = UUID.randomUUID().toString().replaceAll("-", "") + ".xlsx";
            log.info("filename:{}", (Object)filename);
            String downloadPath = filename;
            out = new FileOutputStream(downloadPath);
            wb.write((OutputStream)out);
            string = filename;
        }
        catch (Exception e) {
            try {
                log.info(e.getMessage());
                throw new ZTBusinessException("\u5bfc\u51faExcel\u5931\u8d25\uff01");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((Closeable)wb);
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)wb);
        IOUtils.closeQuietly((Closeable)out);
        return string;
    }

    public List<Object[]> getFields(Class clazz) {
        ArrayList<Object[]> fields = new ArrayList<Object[]>();
        ArrayList<Field> tempFields = new ArrayList<Field>();
        tempFields.addAll(Arrays.asList(clazz.getSuperclass().getDeclaredFields()));
        tempFields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        for (Field field : tempFields) {
            Excel[] excels;
            Excel attr;
            if (field.isAnnotationPresent(Excel.class) && (attr = field.getAnnotation(Excel.class)) != null && attr.type() == Excel.Type.ALL) {
                field.setAccessible(true);
                fields.add(new Object[]{field, attr});
            }
            if (!field.isAnnotationPresent(Excels.class)) continue;
            Excels attrs = field.getAnnotation(Excels.class);
            for (Excel attr2 : excels = attrs.value()) {
                if (attr2 == null || attr2.type() != Excel.Type.ALL) continue;
                field.setAccessible(true);
                fields.add(new Object[]{field, attr2});
            }
        }
        return fields;
    }

    private String uploadFile(String fileName) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(new File(fileName));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        log.info("pdf\u4e0a\u4f20\u8def\u5f84:{}", (Object)path);
        String fileUrl = null;
        String innerFileUrl = null;
        if (PesappCommonConstant.FileService.FILE_TYPE_OSS.equals(this.fileType)) {
            innerFileUrl = this.accessUrl + path;
            fileUrl = this.ossFileUrl + path;
        } else if (PesappCommonConstant.FileService.FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            innerFileUrl = "http://" + this.fastdfsTrackerServers.substring(0, this.fastdfsTrackerServers.indexOf(":")) + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        log.info("innerFileUrl:{}", (Object)innerFileUrl);
        log.info("fileUrl:{}", (Object)fileUrl);
        return fileUrl;
    }
}

