/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bill.ability.api.FscQueryAccountListAbilityService;
import com.tydic.fsc.bill.ability.bo.FscQueryAccountInfoAbilityBO;
import com.tydic.fsc.bill.ability.bo.FscQueryAccountListAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscQueryAccountListAbilityRspBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.po.FscAccountPO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscQueryAccountListAbilityService"})
public class FscQueryAccountListAbilityServiceImpl
implements FscQueryAccountListAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscQueryAccountListAbilityServiceImpl.class);
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;

    @PostMapping(value={"queryAccountList"})
    public FscQueryAccountListAbilityRspBO queryAccountList(@RequestBody FscQueryAccountListAbilityReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getCompanyId()) && ObjectUtil.isEmpty((Object)reqBO.getOrganizationId()) && ObjectUtil.isEmpty((Object)reqBO.getOrgId()) && CollectionUtils.isEmpty((Collection)reqBO.getCompanyIdS())) {
            throw new ZTBusinessException("\u6cd5\u4eba\u516c\u53f8id\u4e3a\u7a7a");
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        FscQueryAccountListAbilityRspBO rspBO = new FscQueryAccountListAbilityRspBO();
        FscAccountPO po = new FscAccountPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        po.setB2bStatus(reqBO.getAccountBtobStatus());
        log.debug("\u67e5\u8be2\u8d26\u53f7\u4fe1\u606f\u5165\u53c2\u4e3a:{}", (Object)po);
        po.setOrgName(reqBO.getOrganizationName());
        if ("0".equals(reqBO.getIsprofess())) {
            po.setOrgId(null);
        } else {
            po.setOrgId(ObjectUtil.isEmpty((Object)reqBO.getCompanyId()) ? reqBO.getOrgId() : reqBO.getCompanyId());
        }
        if (null != reqBO.getOrganizationId()) {
            po.setOrgId(reqBO.getOrganizationId());
        }
        if (!ObjectUtil.isEmpty((Object)reqBO.getCompanyId())) {
            po.setOrgId(reqBO.getCompanyId());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getCompanyIdS())) {
            po.setOrgIdS(reqBO.getCompanyIdS());
        }
        List list = this.fscAccountMapper.getStatusPage(po, page);
        log.debug("\u67e5\u8be2\u8d26\u53f7\u4fe1\u606f\u51fa\u5e93\u4fe1\u606f\u4e3a:{}", (Object)list);
        Map transactorCertType = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_BANK_REPR_GLOBAL_TYPE");
        Map legalPersonCertType = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_BANK_REPR_GLOBAL_TYPE");
        List accountList = JSON.parseArray((String)JSON.toJSONString((Object)list), FscQueryAccountInfoAbilityBO.class);
        log.debug("\u67e5\u8be2\u8d26\u53f7\u4fe1\u606f\u590d\u5236\u4fe1\u606f\u4e3a:{}", (Object)accountList);
        for (FscQueryAccountInfoAbilityBO x : accountList) {
            x.setLegalOrgName(x.getOrgName());
            x.setLegalCertNo(x.getLegalCertNo());
            x.setSubAccountNo(x.getSubAccountNo());
            x.setLegalOrgId(x.getOrgId() + "");
            x.setFrontSeqNo(x.getFrontSeqNo());
            x.setDepositBankName(x.getDepositBankName());
            x.setCreateTime(x.getCreateTime());
            x.setIsPabc(x.getIsPabc());
            x.setSizeLineNumber(x.getSizeLineNumber());
            x.setSuperLineNumber(x.getSuperLineNumber());
            x.setIsTransactor(x.getIsTransactor());
            x.setIsTransactorDesc(this.getIsTransactorDesc(x.getIsTransactor()));
            x.setTransactorName(x.getTransactorName());
            x.setTransactorCertType(x.getTransactorCertType());
            log.debug("1:x.getTransactorCertType():{}", (Object)x.getTransactorCertType());
            x.setTransactorCertTypeDesc((String)transactorCertType.getOrDefault(x.getTransactorCertType() + "", null));
            log.debug("2:x.getTransactorCertTypeDesc():{}", (Object)x.getTransactorCertTypeDesc());
            x.setTransactorCertNo(x.getTransactorCertNo());
            x.setTransactorPhone(x.getTransactorPhone());
            x.setIsLegalPerson(Integer.valueOf(1));
            x.setIsLegalPersonDesc("\u662f");
            x.setLegalPersonName(this.getLegalPersonName(x.getId(), list));
            x.setLegalPersonCertType(this.getLegalPersonCertType(x.getId(), list));
            log.debug("3:x.getLegalPersonCertType():{}", (Object)x.getLegalPersonCertType());
            x.setLegalPersonCertTypeDesc((String)legalPersonCertType.getOrDefault(x.getLegalPersonCertType() + "", null));
            log.debug("4:x.getLegalPersonCertTypeDesc():{}", (Object)x.getLegalPersonCertTypeDesc());
            x.setLegalPersonCertNo(this.getLegalPersonCertNo(x.getId(), list));
            x.setMemberTypeDesc(this.getMemberTypeDesc(x.getMemberType()));
            x.setRecvSubLedgerBankName("\u5e73\u5b89\u94f6\u884c");
            this.transformation(x);
        }
        log.debug("\u67e5\u8be2\u8d26\u53f7\u4fe1\u606f\u51fa\u53c2[accountList]\u4e3a:{}", (Object)accountList);
        rspBO.setRows(accountList);
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String getMemberTypeDesc(String memberType) {
        if ("00".equals(memberType)) {
            return "\u666e\u901a\u5b50\u8d26\u6237";
        }
        if ("SH".equals(memberType)) {
            return "\u5546\u6237\u5b50\u8d26\u6237";
        }
        return "";
    }

    private String getLegalPersonCertNo(Long id, List<FscAccountPO> list) {
        String legalPersonCertNo = null;
        for (FscAccountPO fscAccountPO : list) {
            if (!fscAccountPO.getId().equals(id)) continue;
            legalPersonCertNo = fscAccountPO.getLegalCertNo();
        }
        return legalPersonCertNo;
    }

    private Integer getLegalPersonCertType(Long id, List<FscAccountPO> list) {
        Integer legalPersonCertType = null;
        for (FscAccountPO fscAccountPO : list) {
            if (!fscAccountPO.getId().equals(id)) continue;
            legalPersonCertType = fscAccountPO.getLegalCertType();
        }
        return legalPersonCertType;
    }

    private String getLegalPersonName(Long id, List<FscAccountPO> list) {
        String legalPersonName = null;
        for (FscAccountPO fscAccountPO : list) {
            if (!fscAccountPO.getId().equals(id)) continue;
            legalPersonName = fscAccountPO.getLegalName();
        }
        return legalPersonName;
    }

    private String getIsTransactorDesc(Integer isTransactor) {
        if (isTransactor == null) {
            return "";
        }
        if (isTransactor == 1) {
            return "\u662f";
        }
        return "\u5426";
    }

    private void transformation(FscQueryAccountInfoAbilityBO fscQueryAccountInfoAbilityBO) {
        if (fscQueryAccountInfoAbilityBO.getIsPabc() == null) {
            fscQueryAccountInfoAbilityBO.setIsPabcDesc("");
        } else if (fscQueryAccountInfoAbilityBO.getIsPabc() == 1) {
            fscQueryAccountInfoAbilityBO.setIsPabcDesc("\u662f");
        } else {
            fscQueryAccountInfoAbilityBO.setIsPabcDesc("\u5426");
        }
    }
}

