/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.atom.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.fsc.bill.atom.api.FscSendFeeServiceOrderAtomService;
import com.tydic.fsc.bill.atom.bo.FscSendFeeServiceOrderAtomReqBO;
import com.tydic.fsc.bill.atom.bo.FscSendFeeServiceOrderAtomRspBO;
import com.tydic.fsc.busibase.busi.api.FscServiceFeeCreatePdfBusiService;
import com.tydic.fsc.busibase.busi.bo.FscServiceFeeCreatePdfBusiReqBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscInvoiceProxyAddressMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderMsgLogMapper;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscInvoiceProxyAddressPO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderMsgLogPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.util.FileUtils;
import com.tydic.fsc.utils.SSLClient;
import com.tydic.umc.general.ability.api.CrcQryMainUserInfoByPartIdAbilityService;
import com.tydic.umc.general.ability.api.UmcQryOrgAccountCodeByOrgIdAbilityService;
import com.tydic.umc.general.ability.bo.CrcQryMainUserInfoByPartIdAbilityReqBO;
import com.tydic.umc.general.ability.bo.CrcQryMainUserInfoByPartIdAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcQryOrgAccountCodeByOrgIdAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcQryOrgAccountCodeByOrgIdAbilityRspBO;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class FscSendFeeServiceOrderAtomServiceImpl
implements FscSendFeeServiceOrderAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscSendFeeServiceOrderAtomServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private CrcQryMainUserInfoByPartIdAbilityService crcQryMainUserInfoByPartIdAbilityService;
    @Autowired
    private UmcQryOrgAccountCodeByOrgIdAbilityService umcQryOrgAccountCodeByOrgIdAbilityService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscOrderMsgLogMapper fscOrderMsgLogMapper;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Value(value="${ESB_SEND_FEE_SERVICE_SALE_ORDER_URL}")
    private String ESB_SEND_FEE_SERVICE_SALE_ORDER_URL;
    @Autowired
    private FscServiceFeeCreatePdfBusiService fscServiceFeeCreatePdfBusiService;
    @Autowired
    private FscInvoiceProxyAddressMapper fscInvoiceProxyAddressMapper;

    @Override
    public FscSendFeeServiceOrderAtomRspBO sendFeeServiceOrder(FscSendFeeServiceOrderAtomReqBO reqBO) {
        FscSendFeeServiceOrderAtomRspBO rspBO = new FscSendFeeServiceOrderAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        this.val(reqBO);
        FscOrderPO fscOrderPO = (FscOrderPO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderPO.class);
        log.info("\u8d22\u52a1\u5171\u4eab\u63a8\u9001\u67e5\u8be2\u6210\u4ea4\u670d\u52a1\u8d39\u7ed3\u7b97\u5355\u5165\u53c2:{}", (Object)fscOrderPO);
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (ObjectUtils.isEmpty((Object)fscOrderPO)) {
            throw new BaseBusinessException("8888", "\u63a8\u9001\u6210\u4ea4\u670d\u52a1\u8d39\u7ed3\u7b97\u5355\u5931\u8d25,\u6210\u4ea4\u670d\u52a1\u8d39\u7ed3\u7b97\u5355\u67e5\u8be2\u4e3a\u7a7a");
        }
        if (!ObjectUtils.isEmpty((Object)fscOrderPO.getReimburseNo()) && !fscOrderPO.getOrderSyncState().equals(FscConstants.FINANCIAL_SYNC_STATE_TYPE.REJECT)) {
            throw new BaseBusinessException("8888", "\u6210\u4ea4\u670d\u52a1\u8d39\u7ed3\u7b97\u5355\u5df2\u6210\u529f\u63a8\u9001\u8bf7\u52ff\u91cd\u590d\u63a8\u9001");
        }
        FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
        fscAttachmentPO.setFscOrderId(fscOrderPO.getFscOrderId());
        fscAttachmentPO.setAttachmentType(FscConstants.AttachmentType.FSC_SERVICE_FEE_ORDER_PDF);
        log.info("\u5220\u9664\u9644\u4ef6\u5165\u53c2:{}", (Object)fscAttachmentPO);
        this.fscAttachmentMapper.deleteBy(fscAttachmentPO);
        try {
            FscServiceFeeCreatePdfBusiReqBO fscServiceFeeCreatePdfBusiReqBO = (FscServiceFeeCreatePdfBusiReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscServiceFeeCreatePdfBusiReqBO.class);
            fscServiceFeeCreatePdfBusiReqBO.setFscOrderId(fscOrderPO.getFscOrderId());
            this.fscServiceFeeCreatePdfBusiService.createServiceFeePdf(fscServiceFeeCreatePdfBusiReqBO);
        }
        catch (Exception e) {
            log.info("\u6210\u4ea4\u670d\u52a1\u8d39:{},\u521b\u5efapdf\u5931\u8d25", (Object)fscOrderPO.getOrderNo());
        }
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(fscOrderPO.getFscOrderId());
        log.info("\u8d22\u52a1\u5171\u4eab\u63a8\u9001\u67e5\u8be2\u6210\u4ea4\u670d\u52a1\u8d39\u7ed3\u7b97\u5355\u5546\u54c1\u660e\u7ec6\u5165\u53c2:{}", (Object)fscOrderItemPO);
        List fscOrderItemPOList = this.fscOrderItemMapper.getList(fscOrderItemPO);
        if (ObjectUtils.isEmpty((Object)fscOrderItemPOList)) {
            throw new BaseBusinessException("8888", "\u63a8\u9001\u6210\u4ea4\u670d\u52a1\u8d39\u7ed3\u7b97\u5355\u5931\u8d25,\u6210\u4ea4\u670d\u52a1\u8d39\u7ed3\u7b97\u5355\u8ba2\u5355\u660e\u7ec6\u67e5\u8be2\u4e3a\u7a7a");
        }
        String sendParams = this.initSendParams(fscOrderPO, fscOrderItemPOList);
        log.info("\u6210\u4ea4\u670d\u52a1\u8d39\u8d39\u7ed3\u7b97\u5355\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u8bf7\u6c42\u5730\u5740:{}", (Object)this.ESB_SEND_FEE_SERVICE_SALE_ORDER_URL);
        log.info("\u6210\u4ea4\u670d\u52a1\u8d39\u7ed3\u7b97\u5355\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u8bf7\u6c42\u53c2\u6570:{}", (Object)sendParams);
        String returnString = SSLClient.doPost((String)this.ESB_SEND_FEE_SERVICE_SALE_ORDER_URL, (String)sendParams);
        log.info("\u6210\u4ea4\u670d\u52a1\u8d39\u7ed3\u7b97\u5355\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u8bf7\u6c42\u54cd\u5e94:{}", (Object)returnString);
        FscOrderMsgLogPO fscOrderMsgLogPO = new FscOrderMsgLogPO();
        fscOrderMsgLogPO.setSendUrl(this.ESB_SEND_FEE_SERVICE_SALE_ORDER_URL);
        fscOrderMsgLogPO.setSendUrl("");
        fscOrderMsgLogPO.setSendContent(sendParams);
        fscOrderMsgLogPO.setMsgContent(returnString);
        fscOrderMsgLogPO.setObjId(fscOrderPO.getFscOrderId());
        fscOrderMsgLogPO.setPushTime(new Date());
        if (ObjectUtil.isEmpty((Object)returnString)) {
            fscOrderMsgLogPO.setResultString("0");
            fscOrderMsgLogPO.setFailureReason("\u8c03\u7528ESB\u63a5\u53e3\u6210\u4ea4\u670d\u52a1\u8d39\u7ed3\u7b97\u5355\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
            this.writeLog(fscOrderMsgLogPO);
            throw new BaseBusinessException("8888", "\u8c03\u7528ESB\u63a5\u53e3\u6210\u4ea4\u670d\u52a1\u8d39\u7ed3\u7b97\u5355\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
        }
        this.resolveRsp(returnString, reqBO, fscOrderMsgLogPO);
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        return rspBO;
    }

    private void val(FscSendFeeServiceOrderAtomReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getFscOrderId())) {
            throw new BaseBusinessException("8888", "\u6210\u4ea4\u670d\u52a1\u8d39\u7ed3\u7b97\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private String initSendParams(FscOrderPO fscOrderPO, List<FscOrderItemPO> fscOrderItemPOList) {
        CrcQryMainUserInfoByPartIdAbilityReqBO crcQryMainUserInfoByPartIdAbilityReqBO = new CrcQryMainUserInfoByPartIdAbilityReqBO();
        crcQryMainUserInfoByPartIdAbilityReqBO.setMemId(fscOrderPO.getCreateOperId());
        log.info("\u8c03\u7528\u4f1a\u5458\u83b7\u53d6\u4e3b\u8d26\u53f7\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)crcQryMainUserInfoByPartIdAbilityReqBO));
        CrcQryMainUserInfoByPartIdAbilityRspBO crcQryMainUserInfoByPartIdAbilityRspBO = this.crcQryMainUserInfoByPartIdAbilityService.qryMainUserInfoByPartId(crcQryMainUserInfoByPartIdAbilityReqBO);
        log.info("\u8c03\u7528\u4f1a\u5458\u83b7\u53d6\u4e3b\u8d26\u53f7\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)crcQryMainUserInfoByPartIdAbilityRspBO));
        if (!"0000".equals(crcQryMainUserInfoByPartIdAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u4f1a\u5458\u5f02\u5e38\uff1a" + crcQryMainUserInfoByPartIdAbilityRspBO.getRespDesc());
        }
        String creatorLdap = crcQryMainUserInfoByPartIdAbilityRspBO.getMainMemInformation().getRegAccount();
        UmcQryOrgAccountCodeByOrgIdAbilityReqBO umcQryOrgAccountCodeByOrgIdAbilityReqBO = new UmcQryOrgAccountCodeByOrgIdAbilityReqBO();
        umcQryOrgAccountCodeByOrgIdAbilityReqBO.setOrgId(fscOrderPO.getSupplierId());
        log.info("\u67e5\u8be2\u4f1a\u5458\u91c7\u8d2d\u5355\u4f4d\u7f16\u7801\u5165\u53c2\uff1a" + JSON.toJSONString((Object)umcQryOrgAccountCodeByOrgIdAbilityReqBO));
        UmcQryOrgAccountCodeByOrgIdAbilityRspBO umcQryOrgAccountCodeByOrgIdAbilityRspBO = this.umcQryOrgAccountCodeByOrgIdAbilityService.qryOrgAccountCodeByOrgId(umcQryOrgAccountCodeByOrgIdAbilityReqBO);
        log.info("\u67e5\u8be2\u4f1a\u5458\u91c7\u8d2d\u5355\u4f4d\u7f16\u7801\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)umcQryOrgAccountCodeByOrgIdAbilityRspBO));
        String orgAccountCode = umcQryOrgAccountCodeByOrgIdAbilityRspBO.getCorporationCode();
        JSONObject reqJson = new JSONObject();
        reqJson.put("ouCode", (Object)"SZZB0");
        reqJson.put("sourceNo", (Object)fscOrderPO.getOrderNo());
        reqJson.put("serialNo", (Object)Sequence.getInstance().nextId());
        reqJson.put("applyLdapId", (Object)creatorLdap);
        reqJson.put("applyDate", (Object)DateUtil.dateToStr((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        String summaryStr = "\u670d\u52a1\u8d39\u6536\u5165\u6536\u6b3e/" + fscOrderPO.getOrderNo();
        reqJson.put("summary", (Object)summaryStr);
        JSONArray lines = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("vendorCode", (Object)orgAccountCode);
        jsonObject.put("vendorName", (Object)fscOrderPO.getSupplierName());
        jsonObject.put("currencyCode", (Object)"CNY");
        jsonObject.put("taxRate", (Object)"6%");
        jsonObject.put("settlementTaxAmount", (Object)String.valueOf(fscOrderPO.getActualAmount()));
        jsonObject.put("settlementAmount", (Object)String.valueOf(fscOrderPO.getActualAmount().divide(new BigDecimal("1.06"), 2, 0)));
        jsonObject.put("taxAmount", (Object)String.valueOf(fscOrderPO.getActualAmount().subtract(fscOrderPO.getActualAmount().divide(new BigDecimal("1.06"), 2, 0))));
        jsonObject.put("lineSummary", (Object)fscOrderPO.getOrderNo());
        lines.add((Object)jsonObject);
        reqJson.put("lines", (Object)lines);
        FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
        fscAttachmentPO.setFscOrderId(fscOrderPO.getFscOrderId());
        fscAttachmentPO.setAttachmentTypeList(Arrays.asList(FscConstants.AttachmentType.FSC_SERVICE_FEE_ORDER_PDF, FscConstants.AttachmentType.INVOICE, FscConstants.AttachmentType.OFD, FscConstants.AttachmentType.XML, FscConstants.AttachmentType.INVOICE_FILE));
        log.info("\u83b7\u53d6\u9644\u4ef6\u5165\u53c2:{}", (Object)fscAttachmentPO);
        List fscAttachmentPOList = this.fscAttachmentMapper.getList(fscAttachmentPO);
        JSONArray attachmentList = new JSONArray();
        int num = 1;
        if (!ObjectUtils.isEmpty((Object)fscAttachmentPOList)) {
            List attachmentTypeList = fscAttachmentPOList.stream().map(FscAttachmentPO::getAttachmentType).collect(Collectors.toList());
            if (!(attachmentTypeList.contains(FscConstants.AttachmentType.INVOICE) && attachmentTypeList.contains(FscConstants.AttachmentType.OFD) && attachmentTypeList.contains(FscConstants.AttachmentType.XML) && attachmentTypeList.contains(FscConstants.AttachmentType.INVOICE_FILE))) {
                this.writeAttachmentFailLog(fscOrderPO.getFscOrderId(), "\u6210\u4ea4\u670d\u52a1\u8d39\u7ed3\u7b97\u5355\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u5931\u8d25,\u7f3a\u5c11\u9500\u552e\u53d1\u7968pdf\u9644\u4ef6");
                throw new BaseBusinessException("8888", "\u6210\u4ea4\u670d\u52a1\u8d39\u7ed3\u7b97\u5355\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u5931\u8d25,\u7f3a\u5c11\u9500\u552e\u53d1\u7968pdf\u9644\u4ef6");
            }
            for (FscAttachmentPO item : fscAttachmentPOList) {
                String invoiceName = "";
                if (item.getAttachmentType().equals(FscConstants.AttachmentType.INVOICE)) {
                    invoiceName = "\u670d\u52a1\u8d39\u53d1\u7968" + fscOrderPO.getOrderNo() + "-00" + num + ".pdf";
                } else if (item.getAttachmentType().equals(FscConstants.AttachmentType.OFD)) {
                    invoiceName = "\u670d\u52a1\u8d39\u53d1\u7968" + fscOrderPO.getOrderNo() + "-00" + num + ".ofd";
                } else if (item.getAttachmentType().equals(FscConstants.AttachmentType.XML)) {
                    invoiceName = "\u670d\u52a1\u8d39\u53d1\u7968" + fscOrderPO.getOrderNo() + "-00" + num + ".zip";
                } else if (item.getAttachmentType().equals(FscConstants.AttachmentType.INVOICE_FILE)) {
                    String[] fileUrlList = item.getAttachmentUrl().split("/");
                    String fileName = fileUrlList[item.getAttachmentUrl().split("/").length - 1];
                    String fileSuffix = "";
                    if (fileName.indexOf(".") != -1) {
                        fileSuffix = fileName.split("\\.")[1];
                    }
                    invoiceName = "\u670d\u52a1\u8d39\u53d1\u7968" + fscOrderPO.getOrderNo() + "-00" + num + fileSuffix;
                }
                if (item.getAttachmentType().equals(FscConstants.AttachmentType.INVOICE) || item.getAttachmentType().equals(FscConstants.AttachmentType.OFD) || item.getAttachmentType().equals(FscConstants.AttachmentType.XML) || item.getAttachmentType().equals(FscConstants.AttachmentType.INVOICE_FILE)) {
                    ++num;
                }
                JSONObject jsonAttachmentObject = new JSONObject();
                if (item.getAttachmentType().equals(FscConstants.AttachmentType.FSC_SERVICE_FEE_ORDER_PDF)) {
                    jsonAttachmentObject.put("attachmentName", (Object)"\u9500\u552e\u6536\u5165\u7ed3\u7b97\u5355\uff08\u7535\u5546\u64ae\u5408\uff09.pdf");
                } else {
                    jsonAttachmentObject.put("attachmentName", (Object)(item.getAttachmentType().equals(FscConstants.AttachmentType.INVOICE) ? invoiceName : item.getAttachmentName()));
                }
                jsonAttachmentObject.put("attachmentType", (Object)item.getAttachmentType());
                String invoiceProxyAddress = this.proxyInvoiceAddress(item.getAttachmentUrl(), fscOrderPO.getSupplierId());
                item.setAttachmentUrl(invoiceProxyAddress);
                String size = FileUtils.getFileLength((String)item.getAttachmentUrl(), (String)"kb");
                jsonAttachmentObject.put("attachmentSize", (Object)size);
                jsonAttachmentObject.put("attachmentUrl", (Object)item.getAttachmentUrl());
                jsonAttachmentObject.put("sourceNo", (Object)fscOrderPO.getOrderNo());
                attachmentList.add((Object)jsonAttachmentObject);
            }
        }
        reqJson.put("attachments", (Object)attachmentList);
        log.info("\u63a8\u9001\u51fa\u53c2:{}", (Object)reqJson);
        return reqJson.toJSONString();
    }

    private void resolveRsp(String returnString, FscSendFeeServiceOrderAtomReqBO atomReqBO, FscOrderMsgLogPO fscOrderMsgLogPO) {
        JSONObject rspJsonObject;
        try {
            rspJsonObject = JSONObject.parseObject((String)returnString);
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
            fscOrderMsgLogPO.setResultString("0");
            fscOrderMsgLogPO.setFailureReason("\u8f6c\u6362\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519:" + e.getMessage());
            this.writeLog(fscOrderMsgLogPO);
            throw new RuntimeException("\u8f6c\u6362\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(atomReqBO.getFscOrderId());
        fscOrderPO.setOrderSyncTime(new Date(System.currentTimeMillis()));
        if (null == rspJsonObject.getJSONObject("RESPONSE") || null == rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA")) {
            fscOrderPO.setOrderSyncState(FscConstants.FINANCIAL_SYNC_STATE_TYPE.FAIL);
            fscOrderPO.setOrderSyncFailReason("ECSB\u8c03\u7528\u8fd4\u56de\u5f02\u5e38");
            this.fscOrderMapper.updateByFscOrderId(fscOrderPO);
            fscOrderMsgLogPO.setResultString("0");
            fscOrderMsgLogPO.setFailureReason("ECSB\u8c03\u7528\u8fd4\u56de\u5f02\u5e38");
            this.writeLog(fscOrderMsgLogPO);
            return;
        }
        if (rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA").get((Object)"status").equals("SUCCESS")) {
            fscOrderPO.setOrderSyncState(FscConstants.FINANCIAL_SYNC_STATE_TYPE.SUCCESS);
            fscOrderPO.setOrderSyncFailReason("");
            fscOrderPO.setReimburseNo(rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA").get((Object)"claimNo").toString());
            this.fscOrderMapper.updateByFscOrderId(fscOrderPO);
            fscOrderMsgLogPO.setResultString("1");
        } else {
            fscOrderPO.setOrderSyncState(FscConstants.FINANCIAL_SYNC_STATE_TYPE.FAIL);
            fscOrderPO.setOrderSyncFailReason(rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA").get((Object)"errorMsg").toString());
            this.fscOrderMapper.updateByFscOrderId(fscOrderPO);
            fscOrderMsgLogPO.setResultString("0");
            fscOrderMsgLogPO.setFailureReason(rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA").get((Object)"errorMsg").toString());
        }
        this.writeLog(fscOrderMsgLogPO);
    }

    private void writeAttachmentFailLog(Long fscOrderId, String errorMsg) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(fscOrderId);
        fscOrderPO.setOrderSyncTime(new Date(System.currentTimeMillis()));
        fscOrderPO.setOrderSyncState(FscConstants.FINANCIAL_SYNC_STATE_TYPE.FAIL);
        fscOrderPO.setOrderSyncFailReason(errorMsg);
        this.fscOrderMapper.updateByFscOrderId(fscOrderPO);
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }

    private void writeLog(FscOrderMsgLogPO fscOrderMsgLogPO) {
        fscOrderMsgLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        fscOrderMsgLogPO.setMsgType(FscConstants.FSC_ORDER_OUT_MSG_TYPE.PUSH_SERVICE_FEE);
        fscOrderMsgLogPO.setObjType(FscConstants.FSC_ORDER_OUT_OBJ_TYPE.PAYMENT_SERVICE_FEE);
        fscOrderMsgLogPO.setCreateTime(new Date());
        this.fscOrderMsgLogMapper.insert(fscOrderMsgLogPO);
    }

    private String proxyInvoiceAddress(String invoiceUrl, Long supplierId) {
        FscInvoiceProxyAddressPO item;
        FscInvoiceProxyAddressPO fscInvoiceProxyAddressPO = new FscInvoiceProxyAddressPO();
        fscInvoiceProxyAddressPO.setSupplierIds(Arrays.asList(supplierId, 0L));
        List fscInvoiceProxyAddressPOS = this.fscInvoiceProxyAddressMapper.getList(fscInvoiceProxyAddressPO);
        if (ObjectUtil.isEmpty((Object)fscInvoiceProxyAddressPOS)) {
            log.info("\u4f9b\u5e94\u5546:{},\u6620\u5c04\u5730\u5740\u4e0d\u5b58\u5728", (Object)supplierId);
            return invoiceUrl;
        }
        String invoiceProxyAddress = "";
        Iterator iterator = fscInvoiceProxyAddressPOS.iterator();
        while (iterator.hasNext() && (invoiceProxyAddress = invoiceUrl.replace((item = (FscInvoiceProxyAddressPO)iterator.next()).getOrderAddress(), item.getProxyAddress())).equals(invoiceUrl)) {
        }
        return invoiceProxyAddress;
    }
}

