/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.busi.api.FscPayPartialVerificationBankCheckFileBusiService;
import com.tydic.fsc.bill.busi.bo.FscPayPartialVerificationBankCheckFileBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscPayPartialVerificationBankCheckFileBusiRspBO;
import com.tydic.fsc.busibase.busi.api.FscOrderStatusFlowBusiService;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscBalanceMapper;
import com.tydic.fsc.dao.FscBankCheckFileItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscWriteOffItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscBalancePO;
import com.tydic.fsc.po.FscBankCheckFileItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscWriteOffItemPO;
import com.tydic.umc.general.ability.api.UmcDycEnterpriseOrgQryDetailAbilityService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class FscPayPartialVerificationBankCheckFileBusiServiceImpl
implements FscPayPartialVerificationBankCheckFileBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPayPartialVerificationBankCheckFileBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscBalanceMapper fscBalanceMapper;
    @Autowired
    private FscBankCheckFileItemMapper fscBankCheckFileItemMapper;
    @Autowired
    private FscOrderStatusFlowBusiService fscOrderStatusFlowBusiService;
    @Autowired
    private FscWriteOffItemMapper fscWriteOffItemMapper;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;
    @Autowired
    private UmcDycEnterpriseOrgQryDetailAbilityService umcDycEnterpriseOrgQryDetailAbilityService;

    @Override
    public FscPayPartialVerificationBankCheckFileBusiRspBO partialVerificationBankCheckFile(FscPayPartialVerificationBankCheckFileBusiReqBO reqBO) {
        FscPayPartialVerificationBankCheckFileBusiRspBO rspBO = new FscPayPartialVerificationBankCheckFileBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        FscOrderPO fscOrderPOFor = reqBO.getFscOrderPO();
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(fscOrderPOFor.getFscOrderId());
        if (!ObjectUtils.isEmpty((Object)reqBO.getUserId())) {
            fscOrderPO.setPayOperId(reqBO.getUserId().toString());
        }
        fscOrderPO.setPayOperName(ObjectUtils.isEmpty((Object)reqBO.getName()) ? "" : reqBO.getName());
        fscOrderPO.setPayTime(new Date());
        fscOrderPO.setPayState(FscConstants.PayOrderPayStatus.PAIED);
        fscOrderPO.setActualAmount(fscOrderPOFor.getTotalCharge());
        fscOrderPO.setOrderState(FscConstants.FscPayOrderState.PAIED);
        int row = this.fscOrderMapper.updateById(fscOrderPO);
        if (row < 1) {
            throw new FscBusinessException("198888", "\u66f4\u65b0\u652f\u4ed8\u72b6\u6001\u5931\u8d25,\u8fd4\u56de\u503c\u5c0f\u4e8e1");
        }
        ArrayList<FscWriteOffItemPO> fscWriteOffItemPOList = new ArrayList<FscWriteOffItemPO>();
        FscBankCheckFileItemPO fscBankCheckFileItemPOFor = reqBO.getFscBankCheckFileItemPO();
        FscBankCheckFileItemPO fscBankCheckFileItemPO = new FscBankCheckFileItemPO();
        fscBankCheckFileItemPO.setWriteOffFlag("1".toString());
        fscBankCheckFileItemPO.setBankCheckId(fscBankCheckFileItemPOFor.getBankCheckId());
        int rows = this.fscBankCheckFileItemMapper.updateByBankCheckId(fscBankCheckFileItemPO);
        if (rows < 1) {
            throw new FscBusinessException("198888", "\u66f4\u65b0\u6838\u9500\u72b6\u6001\u5931\u8d25,\u8fd4\u56de\u503c\u5c0f\u4e8e1");
        }
        FscWriteOffItemPO fscWriteOffItemPO = new FscWriteOffItemPO();
        fscWriteOffItemPO.setMemo("\u4ed8\u6b3e\u5355\u5206\u591a\u6b21\u4ed8\u6b3e\u6838\u9500\u4ed8\u6b3e\u4fe1\u606f");
        fscWriteOffItemPO.setFscOrderId(fscOrderPOFor.getFscOrderId());
        fscWriteOffItemPO.setBankCheckId(fscBankCheckFileItemPOFor.getBankCheckId());
        fscWriteOffItemPO.setWriteOffItemId(Long.valueOf(Sequence.getInstance().nextId()));
        fscWriteOffItemPOList.add(fscWriteOffItemPO);
        if (!CollectionUtils.isEmpty(fscWriteOffItemPOList)) {
            this.fscWriteOffItemMapper.insertBatch(fscWriteOffItemPOList);
        }
        ArrayList<FscBalancePO> fscBalancePOList = new ArrayList<FscBalancePO>();
        FscBalancePO fscBalancePO = new FscBalancePO();
        fscBalancePO.setBalanceId(Long.valueOf(Sequence.getInstance().nextId()));
        fscBalancePO.setBankCheckId(fscBankCheckFileItemPOFor.getBankCheckId());
        fscBalancePO.setOrgId(fscOrderPOFor.getPayeeId());
        fscBalancePO.setOrgCode("");
        fscBalancePO.setOrgName(fscOrderPOFor.getPayeeName());
        fscBalancePO.setSubAccountNo(fscOrderPOFor.getPayeeBankAccount());
        fscBalancePO.setPayerOrgId(fscOrderPOFor.getPayerId());
        fscBalancePO.setPayerOrgName(fscOrderPOFor.getPayerName());
        fscBalancePO.setPayerOrgCode(null);
        fscBalancePO.setPayerSubAccountNo(null);
        fscBalancePO.setFrozenEndTime(this.getConfiguration(fscOrderPOFor.getPayeeId().toString()));
        fscBalancePO.setPayAmount(fscBankCheckFileItemPOFor.getTradeAmt());
        if (fscBalancePO.getFrozenEndTime().compareTo(new Date()) <= 0) {
            fscBalancePO.setFrozenAmount(new BigDecimal(0));
            fscBalancePO.setUsableAmount(fscBankCheckFileItemPOFor.getTradeAmt());
            fscBalancePO.setThawOperTime(new Date());
        } else {
            fscBalancePO.setFrozenAmount(fscBankCheckFileItemPOFor.getTradeAmt());
            fscBalancePO.setUsableAmount(new BigDecimal(0));
        }
        fscBalancePO.setUsedAmount(new BigDecimal(0));
        fscBalancePO.setCreateTime(new Date());
        fscBalancePOList.add(fscBalancePO);
        if (!CollectionUtils.isEmpty(fscBalancePOList)) {
            this.fscBalanceMapper.insertBatch(fscBalancePOList);
        }
        rspBO.setFscOrderId(fscOrderPOFor.getFscOrderId());
        return rspBO;
    }

    private Date getConfiguration(String relId) {
        Calendar curDate = Calendar.getInstance();
        curDate.setTime(new Date());
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("cash_withdrawal");
        fscCfcUniteParamQryListDetailExternalReqBO.setRelId(relId);
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191014", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        Integer advanceUnfreezeDays = 0;
        Integer paymentDays = 0;
        Integer advanceWarningDays = 0;
        if (!StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceUnfreezeDays())) {
            advanceUnfreezeDays = Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceUnfreezeDays());
        }
        if (!StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getPaymentDays())) {
            paymentDays = Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getPaymentDays());
        }
        if (!StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceWarningDays())) {
            advanceWarningDays = Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceWarningDays());
        }
        curDate.add(5, paymentDays - advanceUnfreezeDays);
        return curDate.getTime();
    }
}

