/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.fsc.bill.busi.api.FscBillOrderDescUpdateBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderDescUpdateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderDescUpdateBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.UocOrderTaskInstMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.umc.general.ability.api.UmcSendHaveDoneAbilityService;
import com.tydic.umc.general.ability.bo.UmcSendHaveDoneAbilityReqBO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscBillOrderDescUpdateBusiServiceImpl
implements FscBillOrderDescUpdateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderDescUpdateBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private UocOrderTaskInstMapper uocOrderTaskInstMapper;
    @Autowired
    private UmcSendHaveDoneAbilityService umcSendHaveDoneAbilityService;

    @Override
    public FscBillOrderDescUpdateBusiRspBO dealOrderDesc(FscBillOrderDescUpdateBusiReqBO reqBO) {
        if (null == reqBO.getFscOrderId()) {
            throw new FscBusinessException("193009", "\u5165\u53c2fscOrderId\u4e3a\u7a7a");
        }
        if (FscConstants.ORDER_INVOICING_STATE.SUCCESS.equals(reqBO.getInvoicingState())) {
            FscOrderPO select = new FscOrderPO();
            select.setFscOrderId(reqBO.getFscOrderId());
            select = this.fscOrderMapper.getModelBy(select);
            log.info("\u67e5\u51fa\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)select));
            if (!ObjectUtil.isEmpty((Object)select.getInvoicingState()) && select.getInvoicingState().equals(FscConstants.ORDER_INVOICING_STATE.FAIL)) {
                reqBO.setFscOrderNo(select.getOrderNo());
                reqBO.setCreateUserId(select.getCreateOperId());
                reqBO.setCreateUserName(select.getCreateOperName());
                try {
                    this.todoDone(reqBO);
                }
                catch (Exception e) {
                    log.info("\u53d1\u9001\u5df2\u529e\u5931\u8d25", (Object)JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                }
            }
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPO.setOrderDesc(reqBO.getOrderDesc());
        fscOrderPO.setSuccessRetransFlag(reqBO.getSuccessRetransFlag());
        fscOrderPO.setInvoicingState(reqBO.getInvoicingState());
        fscOrderPO.setInvoicingFailReason(reqBO.getInvoicingFailReason());
        if (log.isDebugEnabled()) {
            log.debug("------{}", (Object)JSON.toJSONString((Object)fscOrderPO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        }
        this.fscOrderMapper.updateById(fscOrderPO);
        return new FscBillOrderDescUpdateBusiRspBO();
    }

    public void todoDone(FscBillOrderDescUpdateBusiReqBO reqBO) {
        UmcSendHaveDoneAbilityReqBO umcSendHaveDoneAbilityReqBO = new UmcSendHaveDoneAbilityReqBO();
        umcSendHaveDoneAbilityReqBO.setBusiId(reqBO.getFscOrderId().toString());
        umcSendHaveDoneAbilityReqBO.setOperUserId(reqBO.getCreateUserId().toString());
        umcSendHaveDoneAbilityReqBO.setOperUserName(reqBO.getCreateUserName());
        this.umcSendHaveDoneAbilityService.sendHaveDone(umcSendHaveDoneAbilityReqBO);
    }
}

