/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.cfc.ability.api.CrcQryPaymentBehalfReverseAbilityService;
import com.tydic.cfc.ability.bo.CrcQryPaymentBehalfReverseAbilityReqBO;
import com.tydic.cfc.ability.bo.CrcQryPaymentBehalfReverseAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscPayBillBankCheckFileBusiService;
import com.tydic.fsc.bill.busi.bo.FscPayBillBankCheckFileBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscPayBillBankCheckFileBusiRspBO;
import com.tydic.fsc.busibase.busi.api.FscOrderStatusFlowBusiService;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscBalanceMapper;
import com.tydic.fsc.dao.FscBankCheckFileItemMapper;
import com.tydic.fsc.dao.FscBankCheckFileMapper;
import com.tydic.fsc.dao.FscBankCheckItemScheduleMapper;
import com.tydic.fsc.dao.FscLegalCompanyMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscWriteOffItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscBalancePO;
import com.tydic.fsc.po.FscBankCheckFileItemPO;
import com.tydic.fsc.po.FscBankCheckFilePO;
import com.tydic.fsc.po.FscBankCheckItemSchedulePO;
import com.tydic.fsc.po.FscLegalCompanyPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscWriteOffItemPO;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscPayBillBankCheckFileBusiServiceImpl
implements FscPayBillBankCheckFileBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPayBillBankCheckFileBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscBankCheckFileItemMapper fscBankCheckFileItemMapper;
    @Autowired
    private FscBankCheckFileMapper fscBankCheckFileMapper;
    @Autowired
    private FscWriteOffItemMapper fscWriteoffitemMapper;
    @Autowired
    private FscBalanceMapper fscBalanceMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscLegalCompanyMapper fscLegalCompanyMapper;
    @Autowired
    private FscOrderStatusFlowBusiService fscOrderStatusFlowBusiService;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;
    @Autowired
    private CrcQryPaymentBehalfReverseAbilityService crcQryPaymentBehalfReverseAbilityService;
    @Autowired
    private FscBankCheckItemScheduleMapper fscBankCheckItemScheduleMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public FscPayBillBankCheckFileBusiRspBO bankCheckFile(FscPayBillBankCheckFileBusiReqBO busiReqBO) {
        FscPayBillBankCheckFileBusiRspBO busiRspBO = new FscPayBillBankCheckFileBusiRspBO();
        if (FscConstants.BANK_CHECK_OPER_TYPE.INSERT_FILE.equals(busiReqBO.getOperType())) {
            ArrayList fscBankCheckFilePOList = new ArrayList();
            if (!CollectionUtils.isEmpty(busiReqBO.getFscBankCheckFileBOs())) {
                busiReqBO.getFscBankCheckFileBOs().forEach(row -> {
                    FscBankCheckFilePO fscBankCheckFilePO = new FscBankCheckFilePO();
                    fscBankCheckFilePO.setFileName(row.getFileName());
                    if (this.fscBankCheckFileMapper.getCheckBy(fscBankCheckFilePO) <= 0) {
                        BeanUtils.copyProperties((Object)row, (Object)fscBankCheckFilePO);
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        String dataStr = sdf.format(new Date());
                        try {
                            Date date = sdf.parse(dataStr);
                            fscBankCheckFilePO.setCreateTime(date);
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                        fscBankCheckFilePO.setStatus(ObjectUtil.isEmpty((Object)row.getStatus()) ? FscConstants.BANK_CHECK_STATUS.NO : row.getStatus());
                        fscBankCheckFilePOList.add(fscBankCheckFilePO);
                    }
                });
            }
            if (!CollectionUtils.isEmpty(fscBankCheckFilePOList)) {
                this.fscBankCheckFileMapper.insertBatch(fscBankCheckFilePOList);
            }
        } else if (FscConstants.BANK_CHECK_OPER_TYPE.INSERT_FILE_ITEM.equals(busiReqBO.getOperType())) {
            ArrayList fscBankCheckFileItemPOList = new ArrayList();
            if (!CollectionUtils.isEmpty(busiReqBO.getFscBankCheckFileItemBOs())) {
                busiReqBO.getFscBankCheckFileItemBOs().forEach(row -> {
                    FscBankCheckFileItemPO fscBankCheckFileItemPO = new FscBankCheckFileItemPO();
                    BeanUtils.copyProperties((Object)row, (Object)fscBankCheckFileItemPO);
                    fscBankCheckFileItemPO.setWriteOffFlag("0");
                    fscBankCheckFileItemPO.setCreateTime(new Date());
                    fscBankCheckFileItemPO.setStatus(FscConstants.BANK_CHECK_ITEM_STATUS.NO_CHECK);
                    try {
                        FscAccountPO fscAccountPo = null;
                        fscAccountPo = new FscAccountPO();
                        fscAccountPo.setAccountNo(fscBankCheckFileItemPO.getPayerBankAccount());
                        fscAccountPo = this.fscAccountMapper.getModelBy(fscAccountPo);
                        fscBankCheckFileItemPO.setPayerId(fscAccountPo.getOrgId());
                        fscBankCheckFileItemPO.setPayerName(fscAccountPo.getOrgName());
                        FscLegalCompanyPO fscLegalCompanyPO = this.fscLegalCompanyMapper.getBySubAccountNo(fscBankCheckFileItemPO.getPayeeSubAccountNo());
                        fscBankCheckFileItemPO.setPayeeId(fscLegalCompanyPO.getOrgId());
                        fscBankCheckFileItemPO.setPayeeName(fscLegalCompanyPO.getOrgName());
                        fscAccountPo = new FscAccountPO();
                        fscAccountPo.setOrgId(fscLegalCompanyPO.getOrgId());
                        List fscAccountPoList = this.fscAccountMapper.getList(fscAccountPo);
                        String accountNo = "";
                        if (!CollectionUtils.isEmpty((Collection)fscAccountPoList)) {
                            for (FscAccountPO account : fscAccountPoList) {
                                if (fscBankCheckFileItemPO.getMemo().contains(account.getRecvSubLedgerAcctNo())) {
                                    accountNo = account.getRecvSubLedgerAcctNo();
                                    break;
                                }
                                accountNo = accountNo + "," + account.getRecvSubLedgerAcctNo();
                            }
                        }
                        FscBankCheckItemSchedulePO fscBankCheckItemSchedulePO = new FscBankCheckItemSchedulePO();
                        fscBankCheckItemSchedulePO.setFrontSeqNo(fscBankCheckFileItemPO.getBankWitnessSeq());
                        fscBankCheckItemSchedulePO = this.fscBankCheckItemScheduleMapper.getModelBy(fscBankCheckItemSchedulePO);
                        if (!ObjectUtil.isEmpty((Object)fscBankCheckItemSchedulePO)) {
                            fscBankCheckFileItemPO.setRefundState(fscBankCheckItemSchedulePO.getRefundState());
                        } else {
                            fscBankCheckFileItemPO.setRefundState(FscConstants.REFUND_STATE.NOT_INITIATED);
                        }
                        fscBankCheckFileItemPO.setPayeeAccountNo(accountNo);
                        fscBankCheckFileItemPO.setWithdrawalStatus(FscConstants.WITHDRAWAL_STATUS.UN_WITHDRAWAL);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    fscBankCheckFileItemPOList.add(fscBankCheckFileItemPO);
                });
                this.fscBankCheckFileItemMapper.insertBatch(fscBankCheckFileItemPOList);
                FscBankCheckFilePO fscBankCheckFilePO = new FscBankCheckFilePO();
                fscBankCheckFilePO.setFileName(busiReqBO.getFileName());
                fscBankCheckFilePO.setAttachmentName(busiReqBO.getAttachmentName());
                fscBankCheckFilePO.setAttachmentUrl(busiReqBO.getAttachmentUrl());
                fscBankCheckFilePO.setStatus(busiReqBO.getStatus());
                this.fscBankCheckFileMapper.updateById(fscBankCheckFilePO);
            }
        } else if (FscConstants.BANK_CHECK_OPER_TYPE.CHECK_FILE_ITEM.equals(busiReqBO.getOperType())) {
            ArrayList fscWriteOffItemPOList = new ArrayList();
            ArrayList fscBalancePOList = new ArrayList();
            ArrayList<Long> fscOrderIds = new ArrayList<Long>();
            if (!CollectionUtils.isEmpty(busiReqBO.getFscBankCheckFileItemBOs())) {
                busiReqBO.getFscBankCheckFileItemBOs().forEach(row -> {
                    if (ObjectUtil.isEmpty((Object)row.getRefundState()) || !ObjectUtil.isEmpty((Object)row.getRefundState()) && FscConstants.REFUND_STATE.NOT_INITIATED.equals(row.getRefundState())) {
                        FscBankCheckFileItemPO fscBankCheckFileItemPO = new FscBankCheckFileItemPO();
                        BeanUtils.copyProperties((Object)row, (Object)fscBankCheckFileItemPO);
                        fscBankCheckFileItemPO.setBankTradeSeq(row.getBankTradeSeq());
                        fscBankCheckFileItemPO.setCreateTime(new Date());
                        if (row.getOrgOpertion().booleanValue()) {
                            FscBalancePO fscBalancePO = new FscBalancePO();
                            fscBalancePO.setBalanceId(Long.valueOf(Sequence.getInstance().nextId()));
                            fscBalancePO.setBankCheckId(fscBankCheckFileItemPO.getBankCheckId());
                            fscBalancePO.setOrgId(row.getPayeeId());
                            fscBalancePO.setOrgCode("");
                            fscBalancePO.setOrgName(row.getPayeeName());
                            fscBalancePO.setSubAccountNo(row.getPayeeAccountNo());
                            fscBalancePO.setPayerOrgId(row.getPayerId());
                            fscBalancePO.setPayerOrgName(row.getPayerName());
                            fscBalancePO.setPayerOrgCode(null);
                            fscBalancePO.setPayerSubAccountNo(null);
                            fscBalancePO.setFrozenEndTime(this.getConfiguration(row.getPayeeId().toString()));
                            fscBalancePO.setPayAmount(row.getTradeAmt());
                            fscBalancePO.setCreateTime(new Date());
                            if (fscBalancePO.getFrozenEndTime().compareTo(new Date()) <= 0) {
                                fscBalancePO.setFrozenAmount(new BigDecimal(0));
                                fscBalancePO.setUsableAmount(row.getTradeAmt());
                                fscBalancePO.setThawOperTime(new Date());
                            } else {
                                fscBalancePO.setFrozenAmount(row.getTradeAmt());
                                fscBalancePO.setUsableAmount(new BigDecimal(0));
                            }
                            fscBalancePO.setUsedAmount(new BigDecimal(0));
                            if (!ObjectUtil.isEmpty((Object)fscBankCheckFileItemPO.getShouldPayNo())) {
                                fscBalancePOList.add(fscBalancePO);
                                FscOrderPO fscOrderPo = new FscOrderPO();
                                fscOrderPo.setOrderNo(fscBankCheckFileItemPO.getShouldPayNo());
                                fscOrderPo.setPayeeBankAccount(ObjectUtil.isEmpty((Object)fscBankCheckFileItemPO.getPayeeAccountNo()) ? "" : fscBankCheckFileItemPO.getPayeeAccountNo());
                                fscOrderPo.setPayerId(fscBankCheckFileItemPO.getPayerId());
                                fscOrderPo = this.fscOrderMapper.getModelBy(fscOrderPo);
                                if (!ObjectUtil.isEmpty((Object)fscOrderPo)) {
                                    fscOrderIds.add(fscOrderPo.getFscOrderId());
                                }
                            }
                        }
                        if (!StringUtils.isEmpty((Object)fscBankCheckFileItemPO.getShouldPayNo())) {
                            FscOrderPO fscOrderPo = new FscOrderPO();
                            fscOrderPo.setOrderNo(fscBankCheckFileItemPO.getShouldPayNo());
                            ArrayList payerIds = new ArrayList();
                            ArrayList payerSecondOrgIds = new ArrayList();
                            CrcQryPaymentBehalfReverseAbilityReqBO crcQryPaymentBehalfReverseAbilityReqBO = new CrcQryPaymentBehalfReverseAbilityReqBO();
                            crcQryPaymentBehalfReverseAbilityReqBO.setPaymentIdList(Arrays.asList(fscBankCheckFileItemPO.getPayerId()));
                            CrcQryPaymentBehalfReverseAbilityRspBO crcQryPaymentBehalfReverseAbilityRspBO = this.crcQryPaymentBehalfReverseAbilityService.qryPaymentBehalfReverse(crcQryPaymentBehalfReverseAbilityReqBO);
                            log.info("\u53cd\u5411\u67e5\u8be2\u4ee3\u4ed8\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)crcQryPaymentBehalfReverseAbilityRspBO));
                            if (!ObjectUtil.isEmpty((Object)crcQryPaymentBehalfReverseAbilityRspBO.getPaymentBehalfMap())) {
                                ArrayList cfcUniteParamBOList;
                                List list = cfcUniteParamBOList = ObjectUtil.isEmpty(crcQryPaymentBehalfReverseAbilityRspBO.getPaymentBehalfMap().get(fscBankCheckFileItemPO.getPayerId())) ? new ArrayList() : (List)crcQryPaymentBehalfReverseAbilityRspBO.getPaymentBehalfMap().get(fscBankCheckFileItemPO.getPayerId());
                                if (!ObjectUtil.isEmpty(cfcUniteParamBOList)) {
                                    cfcUniteParamBOList.forEach(item -> {
                                        if (item.getRelType().equals("1")) {
                                            payerSecondOrgIds.add(item.getRelId());
                                        } else {
                                            payerIds.add(item.getRelId());
                                        }
                                    });
                                }
                            }
                            fscOrderPo.setPayState(Integer.valueOf(1401));
                            fscOrderPo = this.fscOrderMapper.getModelBy(fscOrderPo);
                            if (null != fscOrderPo) {
                                if (!(fscOrderPo.getPayeeId().equals(fscBankCheckFileItemPO.getPayeeId()) || payerIds.contains(fscOrderPo.getPayerId()) || payerSecondOrgIds.contains(fscOrderPo.getSecondOrgId()))) {
                                    fscBankCheckFileItemPO.setStatus(FscConstants.BANK_CHECK_ITEM_STATUS.NO_PAYEE);
                                } else if ((null == fscOrderPo.getTotalCharge() ? BigDecimal.ZERO : fscOrderPo.getTotalCharge()).compareTo(null == fscBankCheckFileItemPO.getTradeAmt() ? BigDecimal.ZERO : fscBankCheckFileItemPO.getTradeAmt()) == 0) {
                                    FscOrderPO fscOrderPoUpdate = new FscOrderPO();
                                    fscOrderPoUpdate.setFscOrderId(fscOrderPo.getFscOrderId());
                                    fscOrderPoUpdate.setPayOperId("1");
                                    fscOrderPoUpdate.setPayOperName("");
                                    fscOrderPoUpdate.setPayState(FscConstants.PayOrderPayStatus.PAIED);
                                    fscOrderPoUpdate.setActualAmount(fscOrderPo.getTotalCharge());
                                    fscOrderPoUpdate.setPayTime(busiReqBO.getPayTime());
                                    fscOrderPoUpdate.setOrderState(FscConstants.FscPayOrderState.PAIED);
                                    int row1 = this.fscOrderMapper.updateByFscOrderId(fscOrderPoUpdate);
                                    fscBankCheckFileItemPO.setStatus(FscConstants.BANK_CHECK_ITEM_STATUS.YES);
                                    fscBankCheckFileItemPO.setWithdrawalStatus(FscConstants.WITHDRAWAL_STATUS.WITHDRAWAL);
                                    fscBankCheckFileItemPO.setWriteOffFlag("1");
                                    FscWriteOffItemPO fscWriteOffItemPO = new FscWriteOffItemPO();
                                    fscWriteOffItemPO.setWriteOffItemId(Long.valueOf(Sequence.getInstance().nextId()));
                                    fscWriteOffItemPO.setBankCheckId(fscBankCheckFileItemPO.getBankCheckId());
                                    fscWriteOffItemPO.setFscOrderId(fscOrderPo.getFscOrderId());
                                    fscWriteOffItemPO.setWriteOffType(FscConstants.FSC_WRITE_OFF_TYPE.PAY_ORDER);
                                    fscWriteOffItemPO.setCreateTime(new Date());
                                    fscWriteOffItemPO.setCreateOperUserName("\u7cfb\u7edf\u7ba1\u7406\u5458");
                                    fscWriteOffItemPO.setCreateOperUserId(Long.valueOf(1L));
                                    fscWriteOffItemPOList.add(fscWriteOffItemPO);
                                    if (!row.getOrgOpertion().booleanValue()) {
                                        FscBalancePO fscBalancePO = new FscBalancePO();
                                        fscBalancePO.setBalanceId(Long.valueOf(Sequence.getInstance().nextId()));
                                        fscBalancePO.setBankCheckId(fscBankCheckFileItemPO.getBankCheckId());
                                        fscBalancePO.setOrgId(fscOrderPo.getPayeeId());
                                        fscBalancePO.setOrgCode("");
                                        fscBalancePO.setOrgName(fscOrderPo.getPayeeName());
                                        fscBalancePO.setSubAccountNo(fscOrderPo.getPayeeBankAccount());
                                        fscBalancePO.setPayerOrgId(fscOrderPo.getPayerId());
                                        fscBalancePO.setPayerOrgName(fscOrderPo.getPayerName());
                                        fscBalancePO.setPayerOrgCode(null);
                                        fscBalancePO.setPayerSubAccountNo(null);
                                        fscBalancePO.setFrozenEndTime(this.getConfiguration(fscOrderPo.getPayeeId().toString()));
                                        fscBalancePO.setPayAmount(fscOrderPo.getTotalCharge());
                                        fscBalancePO.setCreateTime(new Date());
                                        if (fscBalancePO.getFrozenEndTime().compareTo(new Date()) <= 0) {
                                            fscBalancePO.setFrozenAmount(new BigDecimal(0));
                                            fscBalancePO.setUsableAmount(fscOrderPo.getTotalCharge());
                                            fscBalancePO.setThawOperTime(new Date());
                                        } else {
                                            fscBalancePO.setFrozenAmount(fscOrderPo.getTotalCharge());
                                            fscBalancePO.setUsableAmount(new BigDecimal(0));
                                        }
                                        fscBalancePO.setUsedAmount(new BigDecimal(0));
                                        fscBalancePOList.add(fscBalancePO);
                                    }
                                    fscOrderIds.add(fscOrderPo.getFscOrderId());
                                } else if ((null == fscBankCheckFileItemPO.getTradeAmt() ? BigDecimal.ZERO : fscBankCheckFileItemPO.getTradeAmt()).compareTo(null == fscOrderPo.getTotalCharge() ? BigDecimal.ZERO : fscOrderPo.getTotalCharge()) > 0) {
                                    fscBankCheckFileItemPO.setStatus(FscConstants.BANK_CHECK_ITEM_STATUS.MORE);
                                } else {
                                    fscBankCheckFileItemPO.setStatus(FscConstants.BANK_CHECK_ITEM_STATUS.LESS);
                                }
                            } else {
                                fscBankCheckFileItemPO.setStatus(FscConstants.BANK_CHECK_ITEM_STATUS.NO);
                            }
                        } else {
                            fscBankCheckFileItemPO.setStatus(FscConstants.BANK_CHECK_ITEM_STATUS.NO);
                        }
                        this.fscBankCheckFileItemMapper.updateByBankCheckId(fscBankCheckFileItemPO);
                    }
                });
            }
            if (!CollectionUtils.isEmpty(fscWriteOffItemPOList)) {
                this.fscWriteoffitemMapper.insertBatch(fscWriteOffItemPOList);
            }
            if (!CollectionUtils.isEmpty(fscBalancePOList)) {
                this.fscBalanceMapper.insertBatch(fscBalancePOList);
            }
            busiRspBO.setFscOrderIds(fscOrderIds);
        }
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u4fee\u6539\u6210\u529f");
        return busiRspBO;
    }

    private Date getConfiguration(String relId) {
        Calendar curDate = Calendar.getInstance();
        curDate.setTime(new Date());
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("cash_withdrawal");
        fscCfcUniteParamQryListDetailExternalReqBO.setRelId(relId);
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191014", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        Integer advanceUnfreezeDays = 0;
        Integer paymentDays = 0;
        Integer advanceWarningDays = 0;
        if (!StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceUnfreezeDays())) {
            advanceUnfreezeDays = Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceUnfreezeDays());
        }
        if (!StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getPaymentDays())) {
            paymentDays = Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getPaymentDays());
        }
        if (!StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceWarningDays())) {
            advanceWarningDays = Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceWarningDays());
        }
        curDate.add(5, paymentDays - advanceUnfreezeDays);
        return curDate.getTime();
    }
}

