/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.busi.api.FscBillRedInvoiceSaveBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillRedInvoiceSaveReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillRedInvoiceSaveRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscInvoiceItemMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscRedInvoiceLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscInvoiceItemPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.utils.FileUpLoad;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class FscBillRedInvoiceSaveBusiServiceImpl
implements FscBillRedInvoiceSaveBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillRedInvoiceSaveBusiServiceImpl.class);
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscInvoiceItemMapper fscInvoiceItemMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Value(value="${changeSwitch:on}")
    private String changeSwitch;
    @Value(value="${beforeChangeUrl}")
    private String beforeChangeUrl;
    @Value(value="${afterChangeUrl}")
    private String afterChangeUrl;
    @Autowired
    private FileUpLoad fileUpLoad;
    @Autowired
    private FscRedInvoiceLogMapper fscRedInvoiceLogMapper;

    @Override
    public FscBillRedInvoiceSaveRspBO redInvoiceSave(FscBillRedInvoiceSaveReqBO reqBO) {
        List<FscAttachmentPO> attachmentList;
        FscBillRedInvoiceSaveRspBO rspBO = new FscBillRedInvoiceSaveRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        FscInvoicePO oldInvoiceInfo = new FscInvoicePO();
        oldInvoiceInfo.setInvoiceId(reqBO.getInvoiceId());
        oldInvoiceInfo = this.fscInvoiceMapper.getModelBy(oldInvoiceInfo);
        FscInvoiceItemPO fscInvoiceItemPO = new FscInvoiceItemPO();
        fscInvoiceItemPO.setInvoiceId(reqBO.getInvoiceId());
        List oldInvoiceItemPOList = this.fscInvoiceItemMapper.getList(fscInvoiceItemPO);
        Map<Long, FscInvoiceItemPO> oldInvoiceItemMap = oldInvoiceItemPOList.stream().collect(Collectors.toMap(FscInvoiceItemPO::getId, o -> o, (k1, k2) -> k1));
        Long newInvoiceId = Sequence.getInstance().nextId();
        ArrayList<FscInvoiceItemPO> newInvoiceItemPOList = new ArrayList<FscInvoiceItemPO>();
        BigDecimal taxAmt = reqBO.getInvoiceDetail().stream().map(o -> new BigDecimal(o.getTax())).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal amt = reqBO.getInvoiceDetail().stream().map(o -> new BigDecimal(o.getAmount())).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal unTaxAmt = amt.subtract(taxAmt);
        for (FscInvoiceItemPO invoiceItemPO : oldInvoiceItemPOList) {
            FscInvoiceItemPO newInvoiceItemPO = new FscInvoiceItemPO();
            BeanUtils.copyProperties((Object)invoiceItemPO, (Object)newInvoiceItemPO);
            newInvoiceItemPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            newInvoiceItemPO.setInvoiceId(newInvoiceId);
            newInvoiceItemPO.setAmt(invoiceItemPO.getAmt().negate());
            newInvoiceItemPO.setUntaxAmt(invoiceItemPO.getUntaxAmt().negate());
            newInvoiceItemPO.setTaxAmt(invoiceItemPO.getTaxAmt().negate());
            newInvoiceItemPO.setNum(invoiceItemPO.getNum().negate());
            log.info("\u4fdd\u5b58\u7ea2\u5b57\u53d1\u7968\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)newInvoiceItemPO));
            newInvoiceItemPOList.add(newInvoiceItemPO);
        }
        FscInvoicePO fscInvoicePO = new FscInvoicePO();
        BeanUtils.copyProperties((Object)oldInvoiceInfo, (Object)fscInvoicePO);
        fscInvoicePO.setInvoiceId(newInvoiceId);
        fscInvoicePO.setFscOrderId(reqBO.getFscOrderId());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String billDate = sdf.format(reqBO.getInvoiceDate());
        fscInvoicePO.setBillDate(billDate);
        fscInvoicePO.setTaxAmt(taxAmt.setScale(4, RoundingMode.HALF_UP));
        fscInvoicePO.setAmt(amt.setScale(4, RoundingMode.HALF_UP));
        fscInvoicePO.setUntaxAmt(amt.subtract(taxAmt).setScale(4, RoundingMode.HALF_UP));
        fscInvoicePO.setTax(reqBO.getInvoiceDetail().get(0).getTax());
        fscInvoicePO.setInvoiceCode(reqBO.getInvoiceCode());
        fscInvoicePO.setInvoiceNo(ObjectUtil.isEmpty((Object)reqBO.getDigitalInvoiceNum()) ? reqBO.getInvoiceNum() : String.valueOf(reqBO.getDigitalInvoiceNum()));
        fscInvoicePO.setCreateTime(new Date());
        fscInvoicePO.setRedInvoiceStatus(Integer.valueOf(3));
        fscInvoicePO.setInvType(Integer.valueOf(1));
        fscInvoicePO.setInvoiceRelNo(String.valueOf(reqBO.getBlueDigitalInvoiceNum()));
        fscInvoicePO.setInvoiceRelId(reqBO.getInvoiceId());
        log.info("\u4fdd\u5b58\u7ea2\u5b57\u53d1\u7968\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)fscInvoicePO));
        this.fscInvoiceMapper.insert(fscInvoicePO);
        oldInvoiceInfo.setRedInvoiceStatus(Integer.valueOf(3));
        oldInvoiceInfo.setInvoiceRelId(newInvoiceId);
        oldInvoiceInfo.setInvoiceRelNo(ObjectUtil.isEmpty((Object)reqBO.getDigitalInvoiceNum()) ? reqBO.getInvoiceNum() : String.valueOf(reqBO.getDigitalInvoiceNum()));
        this.fscInvoiceMapper.updateById(oldInvoiceInfo);
        if (!ObjectUtil.isEmpty(newInvoiceItemPOList)) {
            this.fscInvoiceItemMapper.insertBatch(newInvoiceItemPOList);
        }
        if (!ObjectUtil.isEmpty(attachmentList = this.getAttachmentList(reqBO, newInvoiceId))) {
            log.info("\u4fdd\u5b58\u7ea2\u5b57\u53d1\u7968\u9644\u4ef6\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(attachmentList));
            this.fscAttachmentMapper.insertBatch(attachmentList);
        }
        FscOrderPO setFscOrderPO = new FscOrderPO();
        setFscOrderPO.setInvStatus(Integer.valueOf(2));
        setFscOrderPO.setInvoicingState(Integer.valueOf(1));
        FscOrderPO whereFscOrderPO = new FscOrderPO();
        whereFscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        if (!ObjectUtils.isEmpty((Object)reqBO.getFscOrderId())) {
            this.fscOrderMapper.updateBy(setFscOrderPO, whereFscOrderPO);
        }
        return rspBO;
    }

    private String upload(String url, String type) {
        url = url.replace(this.beforeChangeUrl, this.afterChangeUrl);
        URL urlBean = null;
        try {
            urlBean = new URL(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new FscBusinessException("8888", "\u7a0e\u63a7\u56de\u8c03pdfUrl\u89e3\u6790\u5931\u8d25\uff1a" + e.getMessage());
        }
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)urlBean.openConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FscBusinessException("8888", "\u7a0e\u63a7\u56de\u8c03pdf\u83b7\u53d6\u8fde\u63a5\u5931\u8d25\uff1a" + e.getMessage());
        }
        conn.setConnectTimeout(3000);
        conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
        InputStream inputStream = null;
        try {
            inputStream = conn.getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new FscBusinessException("8888", "\u7a0e\u63a7\u56de\u8c03pdfIO\u6d41\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buff = new byte[1024];
        try {
            int ch;
            while ((ch = inputStream.read(buff, 0, 1024)) > 0) {
                byteArrayOutputStream.write(buff, 0, ch);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
                throw new FscBusinessException("8888", "\u7a0e\u63a7\u56de\u8c03pdfIO\u6d41\u8bfb\u53d6\u5931\u8d25\uff1a" + e.getMessage());
            }
            throw new FscBusinessException("8888", "\u7a0e\u63a7\u56de\u8c03pdfIO\u6d41\u8bfb\u53d6\u5931\u8d25\uff1a" + e.getMessage());
        }
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new FscBusinessException("8888", "\u7a0e\u63a7\u56de\u8c03pdfIO\u6d41\u8bfb\u53d6\u5931\u8d25\uff1a" + e.getMessage());
        }
        byte[] b = byteArrayOutputStream.toByteArray();
        String fileUrl = this.fileUpLoad.upload("\u7535\u5b50\u53d1\u7968-" + System.currentTimeMillis(), b, "." + type);
        log.info("fastdfs\u8fd4\u56defileUrl:" + fileUrl);
        return fileUrl;
    }

    private List<FscAttachmentPO> getAttachmentList(FscBillRedInvoiceSaveReqBO reqBO, Long newInvoiceId) {
        FscAttachmentPO attachmentBO;
        ArrayList<FscAttachmentPO> attachmentList = new ArrayList<FscAttachmentPO>(1);
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPdfUrl())) {
            if (this.changeSwitch.equals("on")) {
                reqBO.setPdfUrl(this.upload(reqBO.getPdfUrl(), "pdf"));
            }
            attachmentBO = new FscAttachmentPO();
            attachmentBO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
            attachmentBO.setAttachmentUrl(reqBO.getPdfUrl());
            log.info("\u53d1\u7968pdf--url:{}", (Object)reqBO.getPdfUrl());
            attachmentBO.setAttachmentType(FscConstants.AttachmentType.RED_INVOICE);
            attachmentBO.setAttachmentName("\u53d1\u7968pdf\u9644\u4ef6");
            if (attachmentBO.getAttachmentUrl().indexOf("/null") != -1) {
                throw new FscBusinessException("191031", "\u53d1\u7968\u9644\u4ef6\u5730\u5740\u4e0a\u4f20\u9519\u8bef");
            }
            attachmentBO.setObjId(newInvoiceId);
            attachmentBO.setObjType(FscConstants.AttachmentObjType.INVOICE);
            attachmentBO.setFscOrderId(reqBO.getFscOrderId());
            attachmentList.add(attachmentBO);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOfdUrl())) {
            if (this.changeSwitch.equals("on")) {
                reqBO.setOfdUrl(this.upload(reqBO.getOfdUrl(), "ofd"));
            }
            attachmentBO = new FscAttachmentPO();
            attachmentBO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
            attachmentBO.setAttachmentUrl(reqBO.getOfdUrl());
            log.info("\u53d1\u7968ofd--url:{}", (Object)reqBO.getOfdUrl());
            attachmentBO.setAttachmentType(FscConstants.AttachmentType.RED_OFD);
            attachmentBO.setAttachmentName("\u53d1\u7968ofd\u9644\u4ef6");
            if (attachmentBO.getAttachmentUrl().indexOf("/null") != -1) {
                throw new FscBusinessException("191031", "\u53d1\u7968\u9644\u4ef6\u5730\u5740\u4e0a\u4f20\u9519\u8bef");
            }
            attachmentBO.setObjId(newInvoiceId);
            attachmentBO.setObjType(FscConstants.AttachmentObjType.INVOICE);
            attachmentBO.setFscOrderId(reqBO.getFscOrderId());
            attachmentList.add(attachmentBO);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getXmlUrl())) {
            if (this.changeSwitch.equals("on")) {
                reqBO.setXmlUrl(this.upload(reqBO.getXmlUrl(), "zip"));
            }
            attachmentBO = new FscAttachmentPO();
            attachmentBO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
            attachmentBO.setAttachmentUrl(reqBO.getXmlUrl());
            log.info("\u53d1\u7968xml--url:{}", (Object)reqBO.getXmlUrl());
            attachmentBO.setAttachmentName("\u53d1\u7968xml\u9644\u4ef6");
            if (attachmentBO.getAttachmentUrl().indexOf("/null") != -1) {
                throw new FscBusinessException("191031", "\u53d1\u7968\u9644\u4ef6\u5730\u5740\u4e0a\u4f20\u9519\u8bef");
            }
            attachmentBO.setAttachmentType(FscConstants.AttachmentType.RED_XML);
            attachmentBO.setObjId(newInvoiceId);
            attachmentBO.setObjType(FscConstants.AttachmentObjType.INVOICE);
            attachmentBO.setFscOrderId(reqBO.getFscOrderId());
            attachmentList.add(attachmentBO);
        }
        return attachmentList;
    }
}

