/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.cfc.ability.api.CrcQryDealServiceFeeAbilityService;
import com.tydic.cfc.ability.bo.CrcQryDealServiceFeeAbilityReqBO;
import com.tydic.cfc.ability.bo.CrcQryDealServiceFeeAbilityRspBO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.fsc.bill.busi.api.FscCrcInvoicSubmitBusiService;
import com.tydic.fsc.bill.busi.bo.FscCrcInvoicSubmitBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscCrcInvoicSubmitBusiRspBO;
import com.tydic.fsc.bill.busi.bo.FscCrcInvoicSubmitReturnBO;
import com.tydic.fsc.bill.busi.bo.FscCrcInvoicSubmitReturnItemBO;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscLogOrdBusiMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscLogOrdBusiPO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.utils.SSLClient;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscCrcInvoicSubmitBusiServiceImpl
implements FscCrcInvoicSubmitBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscCrcInvoicSubmitBusiServiceImpl.class);
    private Sequence sequence = Sequence.getInstance();
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Value(value="${ESB_SEND_INVOIC_SUBMIT_URL}")
    private String ESB_SEND_INVOIC_SUBMIT_URL;
    @Value(value="${ESB_INVOIC_CALL_BACK_URL}")
    private String ESB_INVOIC_CALL_BACK_URL;
    @Value(value="${drawer}")
    private String drawer;
    @Value(value="${sellerBankAcc}")
    private String sellerBankAcc;
    @Value(value="${sellerAddressAndTel}")
    private String sellerAddressAndTel;
    @Autowired
    private FscLogOrdBusiMapper fscLogOrdBusiMapper;
    @Autowired
    private CrcQryDealServiceFeeAbilityService crcQryDealServiceFeeAbilityService;

    @Override
    public FscCrcInvoicSubmitBusiRspBO InvoicSubmit(FscCrcInvoicSubmitBusiReqBO reqBO) {
        FscCrcInvoicSubmitBusiRspBO rspBO = new FscCrcInvoicSubmitBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        FscOrderPO temp = new FscOrderPO();
        temp.setFscOrderId(reqBO.getOrderId());
        FscOrderPO fscOrderPO = this.fscOrderMapper.getModelBy(temp);
        if (fscOrderPO == null) {
            throw new BaseBusinessException("8888", "\u6ca1\u6709id\u4e3a\uff1a" + reqBO.getOrderId() + "\u7684\u7ed3\u7b97\u5355");
        }
        this.writeLog(reqBO);
        int number = ThreadLocalRandom.current().nextInt(1000, 10000);
        String orderNo = fscOrderPO.getOrderNo() + "-" + number;
        String reqStr = this.initPostStr(reqBO, fscOrderPO, orderNo);
        log.info("\u7a0e\u63a7\u5f00\u7968\u63d0\u4ea4\u8bf7\u6c42\u5730\u5740:{}", (Object)this.ESB_SEND_INVOIC_SUBMIT_URL);
        log.info("\u7a0e\u63a7\u5f00\u7968\u63d0\u4ea4\u8bf7\u6c42\u53c2\u6570:{}", (Object)reqStr);
        String returnString = SSLClient.doPost((String)this.ESB_SEND_INVOIC_SUBMIT_URL, (String)reqStr);
        log.info("\u8c03\u7528ESB\u63a5\u53e3\u7a0e\u63a7\u63d0\u4ea4\u54cd\u5e94\u62a5\u6587:{}", (Object)returnString);
        if (ObjectUtil.isEmpty((Object)returnString)) {
            throw new BaseBusinessException("8888", "\u8c03\u7528ESB\u63a5\u53e3\u7a0e\u63a7\u63d0\u4ea4\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
        }
        this.resolveRsp(returnString, reqBO);
        return rspBO;
    }

    private String initPostStr(FscCrcInvoicSubmitBusiReqBO reqBO, FscOrderPO fscOrderPO, String orderNo) {
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(reqBO.getOrderId());
        List fscOrderItemPOList = this.fscOrderItemMapper.getList(fscOrderItemPO);
        if (CollectionUtils.isEmpty((Collection)fscOrderItemPOList)) {
            throw new FscBusinessException("8888", "\u7ed3\u7b97\u5355\u660e\u7ec6\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
        }
        FscOrderInvoicePO fscOrderInvoicePO = new FscOrderInvoicePO();
        fscOrderInvoicePO.setFscOrderId(reqBO.getOrderId());
        FscOrderInvoicePO orderInvoicePO = this.fscOrderInvoiceMapper.getModelBy(fscOrderInvoicePO);
        if (orderInvoicePO == null) {
            throw new FscBusinessException("8888", "\u7ed3\u7b97\u5355\u53d1\u7968\u4fe1\u606f\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
        }
        JSONObject reqJson = new JSONObject();
        if (!StringUtils.isEmpty((Object)orderInvoicePO.getAddress())) {
            reqJson.put("buyerAddr", (Object)orderInvoicePO.getAddress());
        }
        if (!StringUtils.isEmpty((Object)orderInvoicePO.getBank())) {
            reqJson.put("buyerBankName", (Object)orderInvoicePO.getBank());
        }
        if (!StringUtils.isEmpty((Object)orderInvoicePO.getAccount())) {
            reqJson.put("buyerBankNum", (Object)orderInvoicePO.getAccount());
        }
        if (!StringUtils.isEmpty((Object)orderInvoicePO.getBuyName())) {
            reqJson.put("buyerName", (Object)orderInvoicePO.getBuyName());
        }
        if (!StringUtils.isEmpty((Object)orderInvoicePO.getProvince())) {
            reqJson.put("buyerProvince", (Object)orderInvoicePO.getProvince());
        }
        if (!StringUtils.isEmpty((Object)orderInvoicePO.getTaxNo())) {
            reqJson.put("buyerTaxNo", (Object)orderInvoicePO.getTaxNo());
        }
        if (!StringUtils.isEmpty((Object)orderInvoicePO.getPhone())) {
            reqJson.put("buyerTele", (Object)orderInvoicePO.getPhone());
        }
        reqJson.put("buyerType", (Object)"01");
        reqJson.put("drawer", (Object)reqBO.getName());
        reqJson.put("orderNo", (Object)orderNo);
        if (!ObjectUtil.isEmpty((Object)orderInvoicePO.getMemo()) && orderInvoicePO.getMemo().length() > 200) {
            throw new ZTBusinessException("\u53d1\u7968\u5907\u6ce8\u957f\u5ea6\u4e0d\u5927\u4e8e200\u5b57\u7b26");
        }
        reqJson.put("remarks", (Object)(ObjectUtil.isEmpty((Object)orderInvoicePO.getMemo()) ? "" : orderInvoicePO.getMemo()));
        reqJson.put("sellerBankAcc", (Object)this.sellerBankAcc);
        reqJson.put("sellerAddressAndTel", (Object)this.sellerAddressAndTel);
        if (reqBO.getServiceFee().booleanValue()) {
            reqJson.put("totalAmountTax", (Object)fscOrderPO.getActualAmount().setScale(2, 4).toString());
        } else {
            reqJson.put("totalAmountTax", (Object)fscOrderPO.getTotalCharge());
        }
        if ("00".equals(orderInvoicePO.getInvoiceType())) {
            reqJson.put("kind", (Object)83);
        } else if ("01".equals(orderInvoicePO.getInvoiceType())) {
            reqJson.put("kind", (Object)82);
        } else {
            throw new FscBusinessException("8888", "\u63a8\u9001\u7a0e\u63a7\u9519\u8bef\uff1a\u6ca1\u6709\u5bf9\u5e94\u7684\u53d1\u7968\u7c7b\u578b\uff1a" + JSON.toJSONString((Object)orderInvoicePO));
        }
        reqJson.put("invoiceModality", (Object)1);
        reqJson.put("callbackUrl", (Object)this.ESB_INVOIC_CALL_BACK_URL);
        reqJson.put("dkflags", (Object)0);
        reqJson.put("splitType", (Object)0);
        reqJson.put("isSplit", (Object)true);
        JSONArray manualOrderDetails = new JSONArray();
        if (reqBO.getServiceFee().booleanValue()) {
            FscOrderPO sFeefscOrderPO = new FscOrderPO();
            sFeefscOrderPO.setFscOrderId(reqBO.getOrderId());
            sFeefscOrderPO = this.fscOrderMapper.getModelBy(sFeefscOrderPO);
            CrcQryDealServiceFeeAbilityReqBO crcQryDealServiceFeeAbilityReqBO = new CrcQryDealServiceFeeAbilityReqBO();
            crcQryDealServiceFeeAbilityReqBO.setSupplierId(sFeefscOrderPO.getSupplierId());
            CrcQryDealServiceFeeAbilityRspBO rspBO = this.crcQryDealServiceFeeAbilityService.qryDealServiceFee(crcQryDealServiceFeeAbilityReqBO);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("amount", (Object)fscOrderPO.getActualAmount().setScale(2).toString());
            jsonObject.put("invoiceNature", (Object)0);
            jsonObject.put("itemName", (Object)"*\u4fe1\u606f\u6280\u672f\u670d\u52a1*\u5e73\u53f0\u670d\u52a1\u8d39");
            jsonObject.put("itemNum", (Object)"1");
            jsonObject.put("itemPrice", (Object)"");
            jsonObject.put("itemTaxCode", (Object)rspBO.getTaxCatalog());
            jsonObject.put("itemUnit", (Object)"");
            jsonObject.put("specMode", (Object)"");
            jsonObject.put("tax", (Object)"");
            jsonObject.put("taxIncluded", (Object)"1");
            jsonObject.put("taxRate", (Object)new BigDecimal(rspBO.getTaxRate()).divide(new BigDecimal(100)).setScale(2).toString());
            jsonObject.put("yhzcbs", (Object)"0");
            jsonObject.put("rowId", (Object)((FscOrderItemPO)fscOrderItemPOList.get(0)).getId().toString());
            manualOrderDetails.add((Object)jsonObject);
        } else {
            for (FscOrderItemPO each : fscOrderItemPOList) {
                if (ObjectUtil.isEmpty((Object)each.getNum()) || each.getNum().compareTo(BigDecimal.ZERO) <= 0 || ObjectUtil.isEmpty((Object)each.getAmt()) || each.getAmt().compareTo(BigDecimal.ZERO) <= 0) continue;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("amount", (Object)each.getAmt().toString());
                jsonObject.put("invoiceNature", (Object)0);
                if (!StringUtils.isEmpty((Object)each.getSkuName())) {
                    each.setSkuName(this.limitLength(each.getSkuName(), 92));
                }
                jsonObject.put("itemName", (Object)each.getSkuName());
                jsonObject.put("itemNum", (Object)each.getNum().toString());
                jsonObject.put("itemPrice", (Object)each.getPrice().toString());
                if (StringUtils.isEmpty((Object)each.getTaxCode())) {
                    throw new FscBusinessException("8888", each.getSkuName() + "\uff0c\u6b64\u5546\u54c1\u6ca1\u6709\u7a0e\u6536\u5206\u7c7b\u7f16\u7801");
                }
                jsonObject.put("itemTaxCode", (Object)each.getTaxCode());
                jsonObject.put("itemUnit", (Object)each.getUnit());
                if (!StringUtils.isEmpty((Object)each.getSpec()) && !StringUtils.isEmpty((Object)each.getSpec())) {
                    if ((each.getSpec() + "/" + each.getModel()).getBytes(StandardCharsets.UTF_8).length <= 40) {
                        jsonObject.put("specMode", (Object)(each.getSpec() + "/" + each.getModel()));
                    } else {
                        byte[] bytes = new byte[40];
                        System.arraycopy((each.getSpec() + "/" + each.getModel()).getBytes(StandardCharsets.UTF_8), 0, bytes, 0, 40);
                        jsonObject.put("specMode", (Object)new String(bytes));
                    }
                }
                jsonObject.put("tax", (Object)each.getTaxAmt().toString());
                jsonObject.put("taxIncluded", (Object)"1");
                jsonObject.put("taxRate", (Object)each.getTaxRate().setScale(2).toString());
                jsonObject.put("yhzcbs", (Object)"0");
                jsonObject.put("rowId", (Object)each.getId().toString());
                manualOrderDetails.add((Object)jsonObject);
            }
        }
        reqJson.put("manualOrderDetails", (Object)manualOrderDetails);
        return reqJson.toString();
    }

    private void resolveRsp(String returnString, FscCrcInvoicSubmitBusiReqBO reqBO) {
        FscCrcInvoicSubmitReturnBO fscCrcInvoicSubmitReturnBO;
        try {
            fscCrcInvoicSubmitReturnBO = (FscCrcInvoicSubmitReturnBO)JSONObject.parseObject((String)returnString, FscCrcInvoicSubmitReturnBO.class);
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
            throw new RuntimeException("\u8f6c\u6362\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
        }
        if (StringUtils.isEmpty((Object)fscCrcInvoicSubmitReturnBO.getOperateCode()) || !fscCrcInvoicSubmitReturnBO.getOperateCode().equals("S")) {
            throw new BaseBusinessException("8888", "\u8c03\u7528ESB\u63a5\u53e3\u7a0e\u63a7\u63d0\u4ea4\u5bf9\u7aef\u62a5\u9519\uff1a" + fscCrcInvoicSubmitReturnBO.getMessage());
        }
        if (CollectionUtils.isEmpty(fscCrcInvoicSubmitReturnBO.getDatas())) {
            throw new BaseBusinessException("8888", "\u8c03\u7528ESB\u63a5\u53e3\u7a0e\u63a7\u63d0\u4ea4\u5bf9\u7aef\u8fd4\u56dedatas\u4e3a\u7a7a");
        }
        ArrayList<FscInvoicePO> list = new ArrayList<FscInvoicePO>();
        Date createTime = new Date(System.currentTimeMillis());
        List<FscCrcInvoicSubmitReturnItemBO> datas = fscCrcInvoicSubmitReturnBO.getDatas();
        for (int i = 0; i < datas.size(); ++i) {
            FscInvoicePO fscInvoicePO = new FscInvoicePO();
            fscInvoicePO.setInvoiceId(Long.valueOf(this.sequence.nextId()));
            fscInvoicePO.setFscOrderId(reqBO.getOrderId());
            fscInvoicePO.setCreateTime(createTime);
            fscInvoicePO.setCallBackStatus(Integer.valueOf(1));
            fscInvoicePO.setInvoiceOutNo(datas.get(i).getOrderNo());
            fscInvoicePO.setCreateOperId(reqBO.getUserId().toString());
            fscInvoicePO.setCreateOperName(reqBO.getName());
            list.add(fscInvoicePO);
        }
        this.fscInvoiceMapper.insertBatch(list);
        if (reqBO.getInvStatus() == 2) {
            FscOrderPO setOrderPO = new FscOrderPO();
            setOrderPO.setInvStatus(Integer.valueOf(4));
            FscOrderPO whereOrderPO = new FscOrderPO();
            whereOrderPO.setFscOrderId(reqBO.getOrderId());
            this.fscOrderMapper.updateBy(setOrderPO, whereOrderPO);
        }
    }

    private String limitLength(String value, int length) {
        int valueLength = 0;
        StringBuilder newValue = new StringBuilder("");
        String chinese = "[\u0391-\uffe5]";
        for (int i = 0; i < value.length(); ++i) {
            String temp = value.substring(i, i + 1);
            valueLength = temp.matches(chinese) ? (valueLength += 3) : ++valueLength;
            if (valueLength > length) {
                return newValue.toString();
            }
            newValue.append(temp);
        }
        return newValue.toString();
    }

    private void writeLog(FscCrcInvoicSubmitBusiReqBO reqBO) {
        FscLogOrdBusiPO fscLogOrdBusiPO = new FscLogOrdBusiPO();
        fscLogOrdBusiPO.setFscOrderId(reqBO.getOrderId());
        fscLogOrdBusiPO.setBusiName("\u9500\u552e\u7ed3\u7b97\u5355\u63a8\u9001\u7a0e\u63a7");
        fscLogOrdBusiPO.setBusiType(Integer.valueOf(99));
        fscLogOrdBusiPO.setCreateTime(new Date());
        fscLogOrdBusiPO.setCreateOperId(reqBO.getUserId());
        fscLogOrdBusiPO.setCreateOperName(reqBO.getUserName());
        fscLogOrdBusiPO.setCreateCompanyId(reqBO.getOrgId());
        fscLogOrdBusiPO.setCreateOrgId(reqBO.getOrgId());
        fscLogOrdBusiPO.setCreateCompanyName(reqBO.getCompanyName());
        fscLogOrdBusiPO.setCreateOrgName(reqBO.getCompanyName());
        this.fscLogOrdBusiMapper.insert(fscLogOrdBusiPO);
    }
}

