/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.fsc.bill.ability.api.FscBillInvoiceRePushAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillInvoiceRePushAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillInvoiceRePushAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscCrcInvoicSubmitBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceImplBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscCrcInvoicSubmitBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscCrcInvoicSubmitBusiRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscInvoiceSubmitExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscInvoiceSubmitExternalRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscInvoiceSubmitExternalService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillInvoiceRePushAbilityService"})
public class FscBillInvoiceRePushAbilityServiceImpl
implements FscBillInvoiceRePushAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillInvoiceRePushAbilityServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscCrcInvoicSubmitBusiService fscCrcInvoicSubmitBusiService;
    @Autowired
    private FscInvoiceSubmitExternalService fscInvoiceSubmitExternalService;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Resource(name="ecomInvoiceBatchNo")
    private OrderSequence ecomInvoiceBatchNo;

    @PostMapping(value={"rePushInvoice"})
    public FscBillInvoiceRePushAbilityRspBO rePushInvoice(@RequestBody FscBillInvoiceRePushAbilityReqBO reqBO) {
        List fscOrderIds = new ArrayList();
        fscOrderIds = reqBO.getFscOrderIds();
        for (String id : fscOrderIds) {
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderId(Long.valueOf(id));
            if (ObjectUtil.isEmpty((Object)(fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO)))) continue;
            if (FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPO.getMakeType()) && FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPO.getReceiveType()) && ("2".equals(String.valueOf(fscOrderPO.getOrderSource())) || "3".equals(String.valueOf(fscOrderPO.getOrderSource())))) {
                FscCrcInvoicSubmitBusiReqBO fscCrcInvoicSubmitBusiReqBO = (FscCrcInvoicSubmitBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscCrcInvoicSubmitBusiReqBO.class));
                fscCrcInvoicSubmitBusiReqBO.setOrderId(Long.valueOf(id));
                if (fscOrderPO.getOrderFlow().equals(FscConstants.OrderFlow.INVOICE)) {
                    fscCrcInvoicSubmitBusiReqBO.setServiceFee(false);
                } else {
                    fscCrcInvoicSubmitBusiReqBO.setServiceFee(true);
                }
                FscCrcInvoicSubmitBusiRspBO fscCrcInvoicSubmitBusiRspBO = null;
                fscCrcInvoicSubmitBusiReqBO.setInvStatus(fscOrderPO.getInvStatus());
                try {
                    fscCrcInvoicSubmitBusiRspBO = this.fscCrcInvoicSubmitBusiService.InvoicSubmit(fscCrcInvoicSubmitBusiReqBO);
                }
                catch (Exception e) {
                    this.updateInvoiceState(fscOrderPO, FscConstants.ORDER_INVOICING_STATE.FAIL, fscOrderPO.getFscOrderId() + "\u7cfb\u7edf\u5f02\u5e38");
                    log.info("\u7ed3\u7b97\u5355id:{},\u63a8\u9001\u7a0e\u63a7\u5f00\u7968\u7533\u8bf7\u7cfb\u7edf\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0:{}", (Object)fscOrderPO.getFscOrderId(), (Object)e.getMessage());
                    continue;
                }
                if ("0000".equals(fscCrcInvoicSubmitBusiRspBO.getRespCode())) continue;
                this.updateInvoiceState(fscOrderPO, FscConstants.ORDER_INVOICING_STATE.FAIL, fscCrcInvoicSubmitBusiRspBO.getRespDesc());
                log.info("\u7ed3\u7b97\u5355id:{},\u63a8\u9001\u7a0e\u63a7\u5f00\u7968\u7533\u8bf7\u5931\u8d25,\u5931\u8d25\u539f\u56e0:{}", (Object)fscOrderPO.getFscOrderId(), (Object)fscCrcInvoicSubmitBusiRspBO.getRespDesc());
                continue;
            }
            FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
            fscOrderRelationPO.setFscOrderId(fscOrderPO.getFscOrderId());
            List fscOrderRelationPOS = this.fscOrderRelationMapper.getList(fscOrderRelationPO);
            if (CollectionUtils.isEmpty((Collection)fscOrderRelationPOS)) {
                this.updateInvoiceState(fscOrderPO, FscConstants.ORDER_INVOICING_STATE.FAIL, fscOrderPO.getFscOrderId() + "\u5f00\u7968\u5931\u8d25\uff0c\u67e5\u8be2\u7ed3\u7b97\u5355\u8ba2\u5355\u4e3a\u7a7a");
                log.info("\u7ed3\u7b97\u5355id:{},\u63a8\u9001\u7535\u5546\u5f00\u7968\u7533\u8bf7\u7cfb\u7edf\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0:{}", (Object)fscOrderPO.getFscOrderId(), (Object)"\u5f00\u7968\u5931\u8d25\uff0c\u67e5\u8be2\u7ed3\u7b97\u5355\u8ba2\u5355\u4e3a\u7a7a");
                continue;
            }
            ArrayList<String> extOrderNos = new ArrayList<String>();
            for (FscOrderRelationPO fscOrderRelation : fscOrderRelationPOS) {
                if (StringUtils.isBlank((CharSequence)fscOrderRelation.getExtOrderNo())) {
                    this.updateInvoiceState(fscOrderPO, FscConstants.ORDER_INVOICING_STATE.FAIL, fscOrderPO.getFscOrderId() + "\u5f00\u7968\u5931\u8d25\uff0c\u67e5\u8be2\u4f9b\u5e94\u5546\u8ba2\u5355\u53f7\u4e3a\u7a7a");
                    log.info("\u7ed3\u7b97\u5355id:{},\u63a8\u9001\u7535\u5546\u5f00\u7968\u7533\u8bf7\u7cfb\u7edf\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0:{}", (Object)fscOrderPO.getFscOrderId(), (Object)"\u5f00\u7968\u5931\u8d25\uff0c\u67e5\u8be2\u7ed3\u7b97\u5355\u8ba2\u5355\u4e3a\u7a7a");
                    continue;
                }
                extOrderNos.add(fscOrderRelation.getExtOrderNo());
            }
            FscBillInvoiceImplBusiReqBO fscBillInvoiceImplBusiReqBO = (FscBillInvoiceImplBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)fscOrderPO), FscBillInvoiceImplBusiReqBO.class));
            fscBillInvoiceImplBusiReqBO.setExtOrderNos(extOrderNos);
            fscBillInvoiceImplBusiReqBO.setCurStatus(fscOrderPO.getOrderState());
            fscBillInvoiceImplBusiReqBO.setInvoiceCategory(fscOrderPO.getInvoiceCategory());
            fscBillInvoiceImplBusiReqBO.setPurchaserId(fscOrderPO.getPurchaserId().toString());
            if (FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPO.getReceiveType())) {
                fscBillInvoiceImplBusiReqBO.setReceiveOrgName(fscOrderPO.getPurchaserName());
                fscBillInvoiceImplBusiReqBO.setJdOrgId(fscOrderPO.getPurchaserId().toString());
            }
            if (FscConstants.FscOrderReceiveType.OPERATION.equals(fscOrderPO.getReceiveType())) {
                fscBillInvoiceImplBusiReqBO.setReceiveOrgName(fscOrderPO.getProOrgName());
                fscBillInvoiceImplBusiReqBO.setJdOrgId(fscOrderPO.getProOrgId().toString());
            }
            fscBillInvoiceImplBusiReqBO.setReceiveAddr(fscOrderPO.getProvince() + fscOrderPO.getCity() + fscOrderPO.getArea() + fscOrderPO.getTown() + fscOrderPO.getReceiveAddr());
            fscBillInvoiceImplBusiReqBO.setCurrentBatch(this.getCurrentBatch());
            FscInvoiceSubmitExternalReqBO fscInvoiceSubmitExternalReqBO = new FscInvoiceSubmitExternalReqBO();
            BeanUtils.copyProperties((Object)((Object)fscBillInvoiceImplBusiReqBO), (Object)fscInvoiceSubmitExternalReqBO);
            fscInvoiceSubmitExternalReqBO.setFscOrderId(id);
            fscInvoiceSubmitExternalReqBO.setBillToProvinceName(fscOrderPO.getProvince());
            fscInvoiceSubmitExternalReqBO.setBillToCityName(fscOrderPO.getCity());
            fscInvoiceSubmitExternalReqBO.setBillToCountyName(fscOrderPO.getArea());
            fscInvoiceSubmitExternalReqBO.setBillToTownName(fscOrderPO.getTown());
            FscInvoiceSubmitExternalRspBO fscInvoiceSubmitExternalRspBO = null;
            try {
                fscInvoiceSubmitExternalRspBO = this.fscInvoiceSubmitExternalService.submitInvoice(fscInvoiceSubmitExternalReqBO);
            }
            catch (Exception e) {
                this.updateInvoiceState(fscOrderPO, FscConstants.ORDER_INVOICING_STATE.FAIL, fscOrderPO.getFscOrderId() + "\u7cfb\u7edf\u5f02\u5e38");
                log.info("\u7ed3\u7b97\u5355id:{},\u63a8\u9001\u7535\u5546\u5f00\u7968\u7533\u8bf7\u7cfb\u7edf\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0:{}", (Object)fscOrderPO.getFscOrderId(), (Object)e.getMessage());
                continue;
            }
            if ("0000".equals(fscInvoiceSubmitExternalRspBO.getRespCode())) continue;
            this.updateInvoiceState(fscOrderPO, FscConstants.ORDER_INVOICING_STATE.FAIL, fscInvoiceSubmitExternalRspBO.getRespDesc());
            log.info("\u7ed3\u7b97\u5355id:{},\u63a8\u9001\u7535\u5546\u5f00\u7968\u7533\u8bf7\u7cfb\u7edf\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0:{}", (Object)fscOrderPO.getFscOrderId(), (Object)fscInvoiceSubmitExternalRspBO.getRespDesc());
        }
        return new FscBillInvoiceRePushAbilityRspBO();
    }

    private void updateInvoiceState(FscOrderPO fscOrderPO, Integer state, String memo) {
        FscOrderPO set = new FscOrderPO();
        FscOrderPO where = new FscOrderPO();
        set.setInvoicingFailReason(memo);
        where.setFscOrderId(fscOrderPO.getFscOrderId());
        this.fscOrderMapper.updateBy(set, where);
    }

    private Long getCurrentBatch() {
        try {
            return this.ecomInvoiceBatchNo.nextId();
        }
        catch (SQLException throwables) {
            throw new FscBusinessException("191000", "\u83b7\u53d6\u7535\u5546\u6279\u6b21\u53f7\u5931\u8d25");
        }
    }
}

