/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.bill.ability.api.FscBillSupplierCheckAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillSupplierCheckAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillSupplierCheckAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscBillSupplierCheckOrderItemBO;
import com.tydic.fsc.bill.busi.api.FscBillSupplierCheckBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillSupplierCheckBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillSupplierCheckBusiRspBO;
import com.tydic.fsc.busibase.atom.api.FscSendInvoiceMessageAtomService;
import com.tydic.fsc.busibase.atom.bo.FscSendMessageAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.SendMessageBO;
import com.tydic.fsc.busibase.atom.bo.SendMessageReceiverBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.fsc.utils.BigDecimalConvert;
import com.tydic.umc.general.ability.api.UmcDycMemberQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcDycMemberQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcDycMemberQryDetailAbilityRspBO;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillSupplierCheckAbilityService"})
public class FscBillSupplierCheckAbilityServiceImpl
implements FscBillSupplierCheckAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillSupplierCheckAbilityServiceImpl.class);
    @Autowired
    private FscBillSupplierCheckBusiService fscBillSupplierCheckBusiService;
    private static final Integer SUBMIT_FAIL = 1;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private UmcDycMemberQryDetailAbilityService umcDycMemberQryDetailAbilityService;
    @Autowired
    private FscSendInvoiceMessageAtomService fscSendInvoiceMessageAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;

    @FscDuplicateCommitLimit
    @BigDecimalConvert(value=2)
    @PostMapping(value={"dealSupplierCheck"})
    public FscBillSupplierCheckAbilityRspBO dealSupplierCheck(@RequestBody FscBillSupplierCheckAbilityReqBO reqBO) {
        this.verification(reqBO);
        String jsonString = JSON.toJSONString((Object)reqBO);
        FscBillSupplierCheckBusiReqBO busiReqBO = (FscBillSupplierCheckBusiReqBO)((Object)JSON.parseObject((String)jsonString, FscBillSupplierCheckBusiReqBO.class));
        FscBillSupplierCheckBusiRspBO busiRspBO = this.fscBillSupplierCheckBusiService.dealSupplierCheck(busiReqBO, "2");
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new FscBusinessException("191024", busiRspBO.getRespDesc());
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        this.sendMessage(fscOrderPO);
        this.sendMq(reqBO);
        return new FscBillSupplierCheckAbilityRspBO();
    }

    private void sendMq(FscBillSupplierCheckAbilityReqBO reqBO) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }

    private void verification(FscBillSupplierCheckAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[orderId]\u4e3a\u7a7a");
        }
        if (null == reqBO.getSupplierId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[supplierId]\u4e3a\u7a7a");
        }
        if (null == reqBO.getRelOrderList() || reqBO.getRelOrderList().size() == 0) {
            throw new FscBusinessException("191000", "\u5165\u53c2[relOrderList]\u4e3a\u7a7a");
        }
        List relOrderList = reqBO.getRelOrderList();
        for (FscBillSupplierCheckOrderItemBO relOrderBO : relOrderList) {
            if (null == relOrderBO.getOrderId()) {
                throw new FscBusinessException("191000", "\u5165\u53c2[relOrderList]\u4e2d[orderId]\u4e3a\u7a7a");
            }
            if (null == relOrderBO.getAcceptOrderId()) {
                throw new FscBusinessException("191000", "\u5165\u53c2[relOrderList]\u4e2d[acceptOrderId]\u4e3a\u7a7a");
            }
            if (null == relOrderBO.getAmount()) {
                throw new FscBusinessException("191000", "\u5165\u53c2[relOrderList]\u4e2d[amount]\u4e3a\u7a7a");
            }
            if (null == relOrderBO.getRelAmount()) {
                throw new FscBusinessException("191000", "\u4f9b\u5e94\u5546\u53ef\u7ed3\u7b97\u91d1\u989d\u4e3a\u7a7a");
            }
            if (null == relOrderBO.getRelOrderitemList() || relOrderBO.getRelOrderitemList().size() == 0) {
                throw new FscBusinessException("191000", "\u5165\u53c2[relOrderList]\u4e2d[relOrderitemList]\u4e3a\u7a7a");
            }
            List relOrderitemList = relOrderBO.getRelOrderitemList();
            relOrderitemList.forEach(relOrderItemBO -> {
                if (null == relOrderItemBO.getOtherNum()) {
                    throw new FscBusinessException("191000", "\u4f9b\u5e94\u5546\u53ef\u7ed3\u7b97\u6570\u91cf\u5fc5\u586b");
                }
                if (relOrderItemBO.getNum().compareTo(relOrderItemBO.getOtherNum()) != 0 && StringUtils.isBlank((CharSequence)relOrderItemBO.getRemark())) {
                    throw new FscBusinessException("191000", "\u6570\u91cf\u4e0d\u4e00\u81f4\u65f6\uff0c\u5dee\u5f02\u539f\u56e0\u4e3a\u5fc5\u586b\u9879");
                }
            });
        }
    }

    private void sendMessage(FscOrderPO fscOrderPO) {
        if (!fscOrderPO.getOrderState().equals(FscConstants.FscInvoiceOrderState.BILLED)) {
            return;
        }
        FscSendMessageAtomReqBO fscSendMessageAtomReqBO = new FscSendMessageAtomReqBO();
        ArrayList<SendMessageBO> sendMessageBOList = new ArrayList<SendMessageBO>();
        SendMessageBO sendMessageBO = new SendMessageBO();
        sendMessageBO.setFscOrderNo(fscOrderPO.getOrderNo());
        sendMessageBO.setPurchaserName(fscOrderPO.getPurchaserName());
        sendMessageBO.setSupplierName(fscOrderPO.getSupplierName());
        sendMessageBO.setTaskCode("INVOICE_FINISH_NOTICE");
        sendMessageBO.setSendId("1");
        sendMessageBO.setSendName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        Long receiverId = ObjectUtil.isEmpty((Object)fscOrderPO.getSwapUserId()) ? fscOrderPO.getCreateOperId() : fscOrderPO.getSwapUserId();
        UmcDycMemberQryDetailAbilityReqBO umcDycMemberQryDetailAbilityReqBO = new UmcDycMemberQryDetailAbilityReqBO();
        umcDycMemberQryDetailAbilityReqBO.setMemId(receiverId);
        UmcDycMemberQryDetailAbilityRspBO umcDycMemberQryDetailAbilityRspBO = this.umcDycMemberQryDetailAbilityService.qryMemberDetail(umcDycMemberQryDetailAbilityReqBO);
        if (!ObjectUtil.isEmpty((Object)umcDycMemberQryDetailAbilityRspBO.getMemberBO().getRegEmail())) {
            ArrayList<SendMessageReceiverBO> sendMessageReceiverBOList = new ArrayList<SendMessageReceiverBO>();
            SendMessageReceiverBO sendMessageReceiverBO = new SendMessageReceiverBO();
            sendMessageReceiverBO.setReceiverId(String.valueOf(receiverId));
            sendMessageReceiverBO.setReceiverName(fscOrderPO.getCreateOperName());
            sendMessageReceiverBO.setEMail(umcDycMemberQryDetailAbilityRspBO.getMemberBO().getRegEmail());
            sendMessageReceiverBOList.add(sendMessageReceiverBO);
            sendMessageBO.setReceiverBOList(sendMessageReceiverBOList);
            sendMessageBOList.add(sendMessageBO);
            fscSendMessageAtomReqBO.setSendMessageBOList(sendMessageBOList);
            log.info("\u53d1\u9001\u7ad9\u5185\u4fe1\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)fscSendMessageAtomReqBO));
            this.fscSendInvoiceMessageAtomService.sendMessageAtomService(fscSendMessageAtomReqBO);
        } else {
            log.info("\u4e3a\u67e5\u8be2\u5230\u90ae\u7bb1:\u7ed3\u7b97\u5355\uff1a{}", (Object)fscOrderPO.getOrderNo());
        }
    }
}

