/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.api.FscGoodsRecordCreateAdjustAbilityService;
import com.tydic.fsc.bill.ability.bo.FscGoodsDeductionRecordBO;
import com.tydic.fsc.bill.ability.bo.FscGoodsDeductionRecordItemBO;
import com.tydic.fsc.bill.ability.bo.FscGoodsRecordCreateAdjustAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscGoodsRecordCreateAdjustAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscGoodsRecordSumBusiService;
import com.tydic.fsc.bill.busi.bo.FscGoodsRecordSumBusiReqBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscGoodsDeductionRecordItemMapper;
import com.tydic.fsc.dao.FscGoodsDeductionRecordMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscGoodsDeductionRecordItemPO;
import com.tydic.fsc.po.FscGoodsDeductionRecordPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscGoodsRecordCreateAdjustAbilityService"})
public class FscGoodsRecordCreateAdjustAbilityServiceImpl
implements FscGoodsRecordCreateAdjustAbilityService {
    @Autowired
    private FscGoodsDeductionRecordItemMapper fscGoodsDeductionRecordItemMapper;
    @Autowired
    private FscGoodsDeductionRecordMapper fscGoodsDeductionRecordMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscGoodsRecordSumBusiService fscGoodsRecordSumBusiService;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"goodsRecordCreateAdjust"})
    public FscGoodsRecordCreateAdjustAbilityRspBO goodsRecordCreateAdjust(@RequestBody FscGoodsRecordCreateAdjustAbilityReqBO reqBO) {
        FscGoodsDeductionRecordPO fscRecordPO = (FscGoodsDeductionRecordPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscGoodsDeductionRecordPO.class);
        if (ObjectUtil.isNotEmpty((Object)reqBO.getCancelOrderNo()) || ObjectUtil.isNotEmpty((Object)reqBO.getCancelOrderNo())) {
            FscGoodsDeductionRecordItemPO fscGoodsDeductionRecordItemPo = new FscGoodsDeductionRecordItemPO();
            fscGoodsDeductionRecordItemPo.setCancelOrderNo(reqBO.getCancelOrderNo());
            fscGoodsDeductionRecordItemPo.setCancelAcceptNo(reqBO.getCancelOrderNo());
            List itemPOList = this.fscGoodsDeductionRecordItemMapper.getList(fscGoodsDeductionRecordItemPo);
            if (ObjectUtil.isNotEmpty((Object)itemPOList)) {
                fscRecordPO.setAdjustSummaryIdList(itemPOList.stream().filter(bo -> null != bo.getAdjustSummaryId()).map(FscGoodsDeductionRecordItemPO::getAdjustSummaryId).collect(Collectors.toList()));
            }
        }
        fscRecordPO.setStatus(FscConstants.GoodsRecordStatus.NO_DEAL);
        List fscItemPageList = this.fscGoodsDeductionRecordMapper.getList(fscRecordPO);
        if (CollectionUtils.isEmpty((Collection)fscItemPageList)) {
            return new FscGoodsRecordCreateAdjustAbilityRspBO();
        }
        Map<String, List<FscGoodsDeductionRecordPO>> recordGroupMap = fscItemPageList.stream().collect(Collectors.groupingBy(bo -> bo.getEditYear() + "-" + bo.getEditMonth() + "-" + bo.getSupplierId() + "-" + bo.getPurchaseId()));
        ArrayList<FscGoodsDeductionRecordBO> fscGoodsDeductionRecordBOList = new ArrayList<FscGoodsDeductionRecordBO>();
        ArrayList<FscGoodsDeductionRecordItemBO> fscGoodsDeductionRecordItemBOList = new ArrayList<FscGoodsDeductionRecordItemBO>();
        for (String groupKey : recordGroupMap.keySet()) {
            List<FscGoodsDeductionRecordPO> groupItemList = recordGroupMap.get(groupKey);
            FscGoodsDeductionRecordBO recordBO = new FscGoodsDeductionRecordBO();
            BeanUtils.copyProperties((Object)groupItemList.get(0), (Object)recordBO);
            recordBO.setAdjustSummaryNo(this.getSerial());
            recordBO.setAdjustSummaryId(Long.valueOf(Sequence.getInstance().nextId()));
            recordBO.setStatus(FscConstants.GoodsRecordStatus.NO_DEAL);
            recordBO.setCreateDate(new Date());
            recordBO.setCreateOperUserId(Long.valueOf(null != reqBO.getUserId() ? reqBO.getUserId() : 1L));
            recordBO.setCreateOperUserName(ObjectUtil.isNotEmpty((Object)reqBO.getName()) ? reqBO.getName() + (ObjectUtil.isNotEmpty((Object)reqBO.getMainLdap()) ? "(" + reqBO.getMainLdap() + ")" : "") : "\u5b9a\u65f6\u81ea\u52a8\u6c47\u603b");
            recordBO.setCreateOrgId(reqBO.getOrgId());
            recordBO.setCreateOrgName(reqBO.getOrgName());
            BigDecimal summaryNum = BigDecimal.ZERO;
            BigDecimal summaryAmount = BigDecimal.ZERO;
            for (FscGoodsDeductionRecordPO fscGoodsDeductionRecordItemPO : groupItemList) {
                summaryNum = summaryNum.add(fscGoodsDeductionRecordItemPO.getSummaryNum());
                summaryAmount = summaryAmount.add(fscGoodsDeductionRecordItemPO.getSummaryAmount());
                FscGoodsDeductionRecordItemBO itemBO = new FscGoodsDeductionRecordItemBO();
                itemBO.setGoodsDeductionId(fscGoodsDeductionRecordItemPO.getAdjustSummaryId());
                itemBO.setAdjustSummaryId(recordBO.getAdjustSummaryId());
                itemBO.setStatus(FscConstants.GoodsRecordItemStatus.sum);
                itemBO.setAdjustSummaryNo(recordBO.getAdjustSummaryNo());
                fscGoodsDeductionRecordItemBOList.add(itemBO);
            }
            recordBO.setSummaryNum(summaryNum);
            recordBO.setSummaryAmount(summaryAmount);
            fscGoodsDeductionRecordBOList.add(recordBO);
        }
        FscGoodsRecordSumBusiReqBO busiReqBO = (FscGoodsRecordSumBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscGoodsRecordSumBusiReqBO.class));
        busiReqBO.setFscGoodsDeductionRecordBOList(fscGoodsDeductionRecordBOList);
        busiReqBO.setFscGoodsDeductionRecordItemBOList(fscGoodsDeductionRecordItemBOList);
        FscGoodsRecordCreateAdjustAbilityRspBO rspBO = new FscGoodsRecordCreateAdjustAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String getSerial() {
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setOrgType("-1");
        encodedSerialGetServiceReqBO.setEncodedRuleCode("ADJUST_SUMMARY_CODE");
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        if (null == encodedSerialGetServiceRspBO || CollectionUtils.isEmpty((Collection)encodedSerialGetServiceRspBO.getSerialNoList()) || StringUtils.isBlank((CharSequence)((CharSequence)encodedSerialGetServiceRspBO.getSerialNoList().get(0)))) {
            throw new FscBusinessException("191014", "\u83b7\u53d6\u914d\u7f6e\u6d41\u6c34\u53f7\u5f02\u5e38");
        }
        return (String)encodedSerialGetServiceRspBO.getSerialNoList().get(0);
    }
}

