/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.api.FscGoodsRecordSumAbilityService;
import com.tydic.fsc.bill.ability.bo.FscGoodsDeductionRecordBO;
import com.tydic.fsc.bill.ability.bo.FscGoodsDeductionRecordItemBO;
import com.tydic.fsc.bill.ability.bo.FscGoodsRecordSumQryAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscGoodsRecordSumQryAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscGoodsRecordSumBusiService;
import com.tydic.fsc.bill.busi.bo.FscGoodsRecordSumBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscGoodsRecordSumBusiRspBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscGoodsDeductionRecordItemMapper;
import com.tydic.fsc.dao.FscGoodsDeductionRecordMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscGoodsDeductionRecordItemPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.utils.BigDecimalConvert;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscGoodsRecordSumAbilityService"})
public class FscGoodsRecordSumAbilityServiceImpl
implements FscGoodsRecordSumAbilityService {
    @Autowired
    private FscGoodsDeductionRecordItemMapper fscGoodsDeductionRecordItemMapper;
    @Autowired
    private FscGoodsDeductionRecordMapper fscGoodsDeductionRecordMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscGoodsRecordSumBusiService fscGoodsRecordSumBusiService;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private CacheClient cacheClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BigDecimalConvert(value=2)
    @PostMapping(value={"sumGoodsRecordItem"})
    public FscGoodsRecordSumQryAbilityRspBO sumGoodsRecordItem(@RequestBody FscGoodsRecordSumQryAbilityReqBO reqBO) {
        FscGoodsDeductionRecordItemPO fscItemPO = (FscGoodsDeductionRecordItemPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscGoodsDeductionRecordItemPO.class);
        Object obj = this.cacheClient.get("FSC_GOODS_DEDUCTION_RECORD_SUM_INSERT");
        if (null != obj) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u6c47\u603b\u4fe1\u606f\u6b63\u5728\u751f\u6210\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u5904\u7406\uff01");
        }
        this.cacheClient.set("FSC_GOODS_DEDUCTION_RECORD_SUM_INSERT", (Object)reqBO.getUserId(), 180);
        Page page = new Page();
        page.setPageNo(reqBO.getPageNo().intValue());
        page.setPageSize(-1);
        fscItemPO.setStatus(FscConstants.GoodsRecordItemStatus.NO_SUM);
        List fscItemPageList = this.fscGoodsDeductionRecordItemMapper.getListPage(fscItemPO, page);
        if (CollectionUtils.isEmpty((Collection)fscItemPageList)) {
            this.cacheClient.delete("FSC_GOODS_DEDUCTION_RECORD_SUM_INSERT");
            throw new FscBusinessException("198888", "\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u8bb0\u5f55\uff01");
        }
        Map<String, List<FscGoodsDeductionRecordItemPO>> itemGroupMap = fscItemPageList.stream().collect(Collectors.groupingBy(bo -> bo.getSkuCode() + "-" + bo.getPrice() + "-" + bo.getTaxRate() + "-" + bo.getCostTypeName() + "-" + bo.getSupplierId() + "-" + bo.getPurchaseId() + "-" + bo.getUnit() + "-" + DateUtil.dateToStr((Date)bo.getCancelTime(), (String)"yyyy-MM")));
        ArrayList<FscGoodsDeductionRecordBO> fscGoodsDeductionRecordBOList = new ArrayList<FscGoodsDeductionRecordBO>();
        ArrayList<FscGoodsDeductionRecordItemBO> fscGoodsDeductionRecordItemBOList = new ArrayList<FscGoodsDeductionRecordItemBO>();
        try {
            List<String> serialNoList = this.getSerial(itemGroupMap.size());
            int serialIndex = 0;
            for (String groupKey : itemGroupMap.keySet()) {
                List<FscGoodsDeductionRecordItemPO> groupItemList = itemGroupMap.get(groupKey);
                FscGoodsDeductionRecordBO recordBO = new FscGoodsDeductionRecordBO();
                BeanUtils.copyProperties((Object)groupItemList.get(0), (Object)recordBO);
                recordBO.setAdjustSummaryNo(serialNoList.get(serialIndex++));
                recordBO.setAdjustSummaryId(Long.valueOf(Sequence.getInstance().nextId()));
                recordBO.setEditYear(DateUtil.dateToStr((Date)groupItemList.get(0).getCancelTime(), (String)"yyyy"));
                recordBO.setEditMonth(Long.valueOf(Long.parseLong(DateUtil.dateToStr((Date)groupItemList.get(0).getCancelTime(), (String)"MM"))));
                recordBO.setStatus(FscConstants.GoodsRecordStatus.NO_DEAL);
                recordBO.setCreateDate(new Date());
                recordBO.setCreateOperUserId(Long.valueOf(null != reqBO.getUserId() ? reqBO.getUserId() : 1L));
                recordBO.setCreateOperUserName(ObjectUtil.isNotEmpty((Object)reqBO.getName()) ? reqBO.getName() + (ObjectUtil.isNotEmpty((Object)reqBO.getMainLdap()) ? "(" + reqBO.getMainLdap() + ")" : "") : "\u5b9a\u65f6\u81ea\u52a8\u6c47\u603b");
                recordBO.setCreateOrgId(reqBO.getOrgId());
                recordBO.setCreateOrgName(reqBO.getOrgName());
                BigDecimal summaryNum = BigDecimal.ZERO;
                BigDecimal summaryAmount = BigDecimal.ZERO;
                for (FscGoodsDeductionRecordItemPO fscGoodsDeductionRecordItemPO : groupItemList) {
                    summaryNum = summaryNum.add(fscGoodsDeductionRecordItemPO.getCancelNum());
                    summaryAmount = summaryAmount.add(fscGoodsDeductionRecordItemPO.getCancelAmount());
                    FscGoodsDeductionRecordItemBO itemBO = new FscGoodsDeductionRecordItemBO();
                    itemBO.setGoodsDeductionId(fscGoodsDeductionRecordItemPO.getGoodsDeductionId());
                    itemBO.setAdjustSummaryId(recordBO.getAdjustSummaryId());
                    itemBO.setStatus(FscConstants.GoodsRecordItemStatus.sum);
                    itemBO.setAdjustSummaryNo(recordBO.getAdjustSummaryNo());
                    fscGoodsDeductionRecordItemBOList.add(itemBO);
                }
                recordBO.setSummaryNum(summaryNum);
                recordBO.setSummaryAmount(summaryAmount);
                fscGoodsDeductionRecordBOList.add(recordBO);
            }
        }
        catch (BeansException serialNoList) {
        }
        catch (NumberFormatException serialNoList) {
        }
        finally {
            this.cacheClient.delete("FSC_GOODS_DEDUCTION_RECORD_SUM_INSERT");
        }
        FscGoodsRecordSumBusiReqBO busiReqBO = (FscGoodsRecordSumBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscGoodsRecordSumBusiReqBO.class));
        busiReqBO.setFscGoodsDeductionRecordBOList(fscGoodsDeductionRecordBOList);
        busiReqBO.setFscGoodsDeductionRecordItemBOList(fscGoodsDeductionRecordItemBOList);
        FscGoodsRecordSumBusiRspBO fscGoodsRecordSumBusiRspBO = this.fscGoodsRecordSumBusiService.insertBatchGoodsRecord(busiReqBO);
        if (!"0000".equals(fscGoodsRecordSumBusiRspBO.getRespCode())) {
            this.cacheClient.delete("FSC_GOODS_DEDUCTION_RECORD_SUM_INSERT");
            throw new FscBusinessException("194202", fscGoodsRecordSumBusiRspBO.getRespDesc());
        }
        this.cacheClient.delete("FSC_GOODS_DEDUCTION_RECORD_SUM_INSERT");
        FscGoodsRecordSumQryAbilityRspBO rspBO = new FscGoodsRecordSumQryAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<String> getSerial(int num) {
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setOrgType("-1");
        encodedSerialGetServiceReqBO.setEncodedRuleCode("ADJUST_SUMMARY_CODE");
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(num));
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        if (null == encodedSerialGetServiceRspBO || CollectionUtils.isEmpty((Collection)encodedSerialGetServiceRspBO.getSerialNoList()) || StringUtils.isBlank((CharSequence)((CharSequence)encodedSerialGetServiceRspBO.getSerialNoList().get(0)))) {
            throw new FscBusinessException("191014", "\u83b7\u53d6\u914d\u7f6e\u6d41\u6c34\u53f7\u5f02\u5e38");
        }
        return encodedSerialGetServiceRspBO.getSerialNoList();
    }
}

