/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.tydic.fsc.bill.busi.api.FscBillInvoiceImplBusiService;
import com.tydic.fsc.bill.busi.api.FscBillOrderDescUpdateBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceImplBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceImplBusiRspBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderDescUpdateBusiReqBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscUocOrderRelUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscInvoiceSubmitExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscInvoiceSubmitExternalRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscInvoiceSubmitExternalService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscBillInvoiceImplBusiServiceImpl
implements FscBillInvoiceImplBusiService {
    @Autowired
    private FscInvoiceSubmitExternalService fscInvoiceSubmitExternalService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscBillOrderDescUpdateBusiService fscBillOrderDescUpdateBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    private static final String BUSI_NAME = "\u5f00\u7968\u6d88\u8d39\u8005\u5904\u7406";
    @Autowired
    private FscUocOrderRelUpdateAtomService fscUocOrderRelUpdateAtomService;

    @Override
    public FscBillInvoiceImplBusiRspBO dealInvoiceImpl(FscBillInvoiceImplBusiReqBO reqBO) {
        this.submitInvoice(reqBO);
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setOrderId(reqBO.getFscOrderId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(reqBO.getCurStatus());
        fscOrderStatusFlowAtomReqBO.setBusiCode(BUSI_NAME);
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!"0000".equals(fscOrderStatusFlowAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193005", fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
        this.syncOrderStatus(reqBO.getFscOrderId());
        return new FscBillInvoiceImplBusiRspBO();
    }

    private void submitInvoice(FscBillInvoiceImplBusiReqBO reqBO) {
        FscInvoiceSubmitExternalReqBO fscInvoiceSubmitExternalReqBO = new FscInvoiceSubmitExternalReqBO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)fscInvoiceSubmitExternalReqBO);
        fscInvoiceSubmitExternalReqBO.setFscOrderId(reqBO.getFscOrderId().toString());
        fscInvoiceSubmitExternalReqBO.setBillToProvinceName(reqBO.getProvince());
        fscInvoiceSubmitExternalReqBO.setBillToCityName(reqBO.getCity());
        fscInvoiceSubmitExternalReqBO.setBillToCountyName(reqBO.getArea());
        fscInvoiceSubmitExternalReqBO.setBillToTownName(reqBO.getTown());
        FscInvoiceSubmitExternalRspBO fscInvoiceSubmitExternalRspBO = null;
        try {
            fscInvoiceSubmitExternalRspBO = this.fscInvoiceSubmitExternalService.submitInvoice(fscInvoiceSubmitExternalReqBO);
        }
        catch (Exception e) {
            this.updateOrderDesc(reqBO.getFscOrderId(), FscConstants.ORDER_INVOICING_STATE.FAIL, e.getMessage());
            this.syncOrderEs(reqBO.getFscOrderId());
            throw new FscBusinessException("193005", e.getMessage());
        }
        if (!"0000".equals(fscInvoiceSubmitExternalRspBO.getRespCode())) {
            this.updateOrderDesc(reqBO.getFscOrderId(), FscConstants.ORDER_INVOICING_STATE.FAIL, fscInvoiceSubmitExternalRspBO.getRespDesc());
            this.syncOrderEs(reqBO.getFscOrderId());
            throw new FscBusinessException("193005", fscInvoiceSubmitExternalRspBO.getRespDesc());
        }
    }

    private void syncOrderStatus(Long fscOrderId) {
        FscUocOrderRelUpdateAtomReqBO fscUocOrderRelUpdateAtomReqBO = new FscUocOrderRelUpdateAtomReqBO();
        fscUocOrderRelUpdateAtomReqBO.setFscOrderId(fscOrderId);
        fscUocOrderRelUpdateAtomReqBO.setRelState(FscConstants.FscRelStatus.BILLING);
        fscUocOrderRelUpdateAtomReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
        this.fscUocOrderRelUpdateAtomService.dealRelUpdate(fscUocOrderRelUpdateAtomReqBO);
    }

    private void updateOrderDesc(Long fscOrderId, Integer invoicingState, String invoicingFailReason) {
        FscBillOrderDescUpdateBusiReqBO fscBillOrderDescUpdateBusiReqBO = new FscBillOrderDescUpdateBusiReqBO();
        fscBillOrderDescUpdateBusiReqBO.setFscOrderId(fscOrderId);
        fscBillOrderDescUpdateBusiReqBO.setInvoicingState(invoicingState);
        fscBillOrderDescUpdateBusiReqBO.setInvoicingFailReason(invoicingFailReason);
        this.fscBillOrderDescUpdateBusiService.dealOrderDesc(fscBillOrderDescUpdateBusiReqBO);
    }

    private void syncOrderEs(Long fscOrderId) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }
}

