/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.busi.api.FscBillOrderInvoiceSignBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignBusiRspBO;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscPayShouldPayCreateAtomService;
import com.tydic.fsc.busibase.atom.api.FscStockOperAtomService;
import com.tydic.fsc.busibase.atom.api.FscUocOrderRelUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscStockOperAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscStockOperAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceCheckResultMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoiceCheckResultPO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderPO;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillOrderInvoiceSignBusiServiceImpl
implements FscBillOrderInvoiceSignBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderInvoiceSignBusiServiceImpl.class);
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscInvoiceCheckResultMapper fscInvoiceCheckResultMapper;
    @Autowired
    private FscUocOrderRelUpdateAtomService fscUocOrderRelUpdateAtomService;
    @Autowired
    private FscPayShouldPayCreateAtomService fscPayShouldPayCreateAtomService;
    private static final String BUSI_NAME = "\u53d1\u7968\u7b7e\u6536";
    @Autowired
    private FscStockOperAtomService fscStockOperAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;

    @Override
    public FscBillOrderInvoiceSignBusiRspBO dealOrderInvoiceSign(FscBillOrderInvoiceSignBusiReqBO reqBO) {
        FscOrderInvoicePO fscOrderInvoicePoSet = new FscOrderInvoicePO();
        if (null != reqBO.getUserId()) {
            fscOrderInvoicePoSet.setSignOperId(reqBO.getUserId().toString());
        }
        fscOrderInvoicePoSet.setSignOperName(reqBO.getName());
        fscOrderInvoicePoSet.setSignTime(new Date());
        fscOrderInvoicePoSet.setSignTimeStart(new Date());
        FscOrderInvoicePO fscOrderInvoicePowhere = new FscOrderInvoicePO();
        fscOrderInvoicePowhere.setFscOrderId(reqBO.getOrderId());
        this.fscOrderInvoiceMapper.updateBy(fscOrderInvoicePoSet, fscOrderInvoicePowhere);
        if (null != reqBO.getInvoiceCmpResult()) {
            FscInvoiceCheckResultPO fscInvoiceCheckResultPO = new FscInvoiceCheckResultPO();
            fscInvoiceCheckResultPO.setAmountMargin(reqBO.getInvoiceCmpResult().getAmountMargin());
            fscInvoiceCheckResultPO.setCmpResult(reqBO.getInvoiceCmpResult().getCmpResultStr());
            fscInvoiceCheckResultPO.setIteNumMargin(reqBO.getInvoiceCmpResult().getItemNumMargin());
            fscInvoiceCheckResultPO.setUntaxAmtMargin(reqBO.getInvoiceCmpResult().getUntaxAmtMargin());
            fscInvoiceCheckResultPO.setTaxMargin(reqBO.getInvoiceCmpResult().getTaxMargin());
            fscInvoiceCheckResultPO.setCreateOperId(reqBO.getUserId());
            fscInvoiceCheckResultPO.setCreateOperName(reqBO.getName());
            fscInvoiceCheckResultPO.setCreateTime(new Date());
            fscInvoiceCheckResultPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscInvoiceCheckResultPO.setFscOrderId(reqBO.getOrderId());
            this.fscInvoiceCheckResultMapper.insert(fscInvoiceCheckResultPO);
        }
        if (reqBO.getCreateShouldPayFlag().booleanValue()) {
            this.createShouldPay(reqBO.getFscShouldPayBOS(), reqBO);
        }
        if (reqBO.getNeedOperStockEnable().booleanValue()) {
            try {
                this.inStock(reqBO.getOrderId(), reqBO.getStockFlag());
            }
            catch (Exception e) {
                log.info("\u751f\u6210\u51fa\u5165\u5e93\u5355\u9519\u8bef:{}", (Object)e.getMessage());
            }
        }
        if (!ObjectUtil.isEmpty((Object)reqBO.getOrderId())) {
            FscOrderPO setStatusPo = new FscOrderPO();
            setStatusPo.setOrderState(FscConstants.FscInvoiceOrderState.SIGNED);
            FscOrderPO whereStatusPo = new FscOrderPO();
            whereStatusPo.setFscOrderId(reqBO.getOrderId());
            log.info("\u66f4\u65b0\u7ed3\u7b97\u5355\u72b6\u6001\u5165\u53c2\uff1a{},\u6761\u4ef6:{}", (Object)JSON.toJSONString((Object)setStatusPo), (Object)JSON.toJSONString((Object)whereStatusPo));
            this.fscOrderMapper.updateBy(setStatusPo, whereStatusPo);
        }
        this.syncOrderStatus(reqBO.getOrderId());
        return new FscBillOrderInvoiceSignBusiRspBO();
    }

    private void syncOrderStatus(Long fscOrderId) {
        FscUocOrderRelUpdateAtomReqBO fscUocOrderRelUpdateAtomReqBO = new FscUocOrderRelUpdateAtomReqBO();
        fscUocOrderRelUpdateAtomReqBO.setFscOrderId(fscOrderId);
        fscUocOrderRelUpdateAtomReqBO.setRelState(FscConstants.FscRelStatus.SIGN);
        fscUocOrderRelUpdateAtomReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
        this.fscUocOrderRelUpdateAtomService.dealRelUpdate(fscUocOrderRelUpdateAtomReqBO);
    }

    private void createShouldPay(List<FscShouldPayBO> fscShouldPayBOS, FscBillOrderInvoiceSignBusiReqBO reqBO) {
        if (!CollectionUtils.isEmpty(fscShouldPayBOS)) {
            FscPayShouldPayCreateAtomReqBO fscPayShouldPayCreateAtomReqBO = new FscPayShouldPayCreateAtomReqBO();
            fscPayShouldPayCreateAtomReqBO.setFscShouldPayBOS(fscShouldPayBOS);
            fscPayShouldPayCreateAtomReqBO.setUserId(reqBO.getUserId());
            fscPayShouldPayCreateAtomReqBO.setName(reqBO.getName());
            fscPayShouldPayCreateAtomReqBO.setUserName(reqBO.getUserName());
            fscPayShouldPayCreateAtomReqBO.setCompanyId(reqBO.getCompanyId());
            fscPayShouldPayCreateAtomReqBO.setCompanyName(reqBO.getCompanyName());
            fscPayShouldPayCreateAtomReqBO.setOrgId(reqBO.getOrgId());
            fscPayShouldPayCreateAtomReqBO.setOrgName(reqBO.getOrgName());
            FscPayShouldPayCreateAtomRspBO fscPayShouldPayCreateAtomRspBO = this.fscPayShouldPayCreateAtomService.dealShouldPayCreate(fscPayShouldPayCreateAtomReqBO);
            if (!"0000".equals(fscPayShouldPayCreateAtomRspBO.getRespCode())) {
                throw new FscBusinessException("193011", fscPayShouldPayCreateAtomRspBO.getRespDesc());
            }
        }
    }

    private void inStock(Long fscOrderId, Integer stockFlag) {
        FscStockOperAtomReqBO fscStockOperAtomReqBO = new FscStockOperAtomReqBO();
        fscStockOperAtomReqBO.setOperType(stockFlag);
        fscStockOperAtomReqBO.setFscOrderId(fscOrderId);
        FscStockOperAtomRspBO fscStockOperAtomRspBO = this.fscStockOperAtomService.dealStockOper(fscStockOperAtomReqBO);
        if (!"0000".equals(fscStockOperAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193011", fscStockOperAtomRspBO.getRespDesc());
        }
    }
}

