/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.busi.api.FscBillRedInvoiceConfirmOrderAddBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillRedInvoiceConfirmOrderAddReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillRedInvoiceConfirmOrderAddRspBO;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.utils.SSLClient;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class FscBillRedInvoiceConfirmOrderAddBusiServiceImpl
implements FscBillRedInvoiceConfirmOrderAddBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillRedInvoiceConfirmOrderAddBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Value(value="${fsc.sellerTaxNum}")
    private String sellerTaxNum;
    @Value(value="${fsc.sellerTaxName}")
    private String sellerTaxName;
    @Value(value="${fsc.redConfimCreate}")
    private String url;

    @Override
    public FscBillRedInvoiceConfirmOrderAddRspBO redInvoiceConfirmOrderAdd(FscBillRedInvoiceConfirmOrderAddReqBO reqBO) {
        FscBillRedInvoiceConfirmOrderAddRspBO rspBO = new FscBillRedInvoiceConfirmOrderAddRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        this.val(reqBO);
        ArrayList<Long> invoiceIds = new ArrayList<Long>();
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (ObjectUtils.isEmpty((Object)fscOrderPO)) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u4fe1\u606f");
        }
        FscInvoicePO fscInvoicePO = new FscInvoicePO();
        fscInvoicePO.setFscOrderId(reqBO.getFscOrderId());
        fscInvoicePO.setInvType(Integer.valueOf(0));
        List invoiceList = this.fscInvoiceMapper.getList(fscInvoicePO);
        if (ObjectUtils.isEmpty((Object)invoiceList)) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u53d1\u7968\u4fe1\u606f");
        }
        FscOrderInvoicePO fscOrderInvoicePO = new FscOrderInvoicePO();
        fscOrderInvoicePO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderInvoicePO = this.fscOrderInvoiceMapper.getModelBy(fscOrderInvoicePO);
        String errorMessage = "";
        for (FscInvoicePO invoicePO : invoiceList) {
            String sendParams = this.initParams(invoicePO, fscOrderInvoicePO);
            log.info("\u822a\u4fe1\u7a0e\u63a7\u7ea2\u5b57\u53d1\u7968\u65b0\u589e\u8bf7\u6c42\u5730\u5740:{}", (Object)this.url);
            log.info("\u822a\u4fe1\u7a0e\u63a7\u7ea2\u5b57\u53d1\u7968\u65b0\u589e\u8bf7\u6c42\u53c2\u6570:{}", (Object)sendParams);
            String returnString = SSLClient.doPost((String)this.url, (String)sendParams);
            log.info("\u822a\u4fe1\u7a0e\u63a7\u7ea2\u5b57\u53d1\u7968\u65b0\u589e\u8bf7\u6c42\u54cd\u5e94:{}", (Object)returnString);
            JSONObject rspJsonObject = null;
            try {
                rspJsonObject = JSONObject.parseObject((String)returnString);
            }
            catch (Exception e) {
                rspBO.setRespCode("198888");
                rspBO.setRespDesc("\u822a\u4fe1\u7a0e\u63a7\u7ea2\u5b57\u53d1\u7968\u65b0\u589e\u8fd4\u56de\u62a5\u6587\u8f6c\u6362\u9519\u8bef");
            }
            if (!"S".equals(rspJsonObject.get((Object)"operateCode").toString())) {
                errorMessage = rspJsonObject.get((Object)"message").toString();
                rspBO.setRespCode("198888");
                rspBO.setRespDesc(errorMessage);
            } else if (ObjectUtils.isEmpty((Object)rspJsonObject.get((Object)"datas"))) {
                rspBO.setRespCode("198888");
                rspBO.setRespDesc("\u822a\u4fe1\u7a0e\u63a7\u7ea2\u5b57\u53d1\u7968\u65b0\u589e\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a");
            }
            if (!"0000".equals(rspBO.getRespCode())) {
                invoiceIds.clear();
                break;
            }
            invoiceIds.add(invoicePO.getInvoiceId());
        }
        FscOrderPO setOrderPO = new FscOrderPO();
        if (!"0000".equals(rspBO.getRespCode())) {
            setOrderPO.setInvStatus(Integer.valueOf(0));
            setOrderPO.setInvoicingState(Integer.valueOf(0));
            setOrderPO.setInvoicingFailReason(rspBO.getRespDesc());
        } else {
            setOrderPO.setInvStatus(Integer.valueOf(1));
            setOrderPO.setInvoicingState(Integer.valueOf(1));
            setOrderPO.setInvoicingFailReason("");
        }
        FscOrderPO whereOrderPO = new FscOrderPO();
        whereOrderPO.setFscOrderId(reqBO.getFscOrderId());
        if (!ObjectUtils.isEmpty((Object)reqBO.getFscOrderId())) {
            this.fscOrderMapper.updateBy(setOrderPO, whereOrderPO);
        }
        if (!ObjectUtils.isEmpty(invoiceIds)) {
            FscInvoicePO setPO = new FscInvoicePO();
            setPO.setRedInvoiceStatus(Integer.valueOf(1));
            FscInvoicePO wherePO = new FscInvoicePO();
            wherePO.setInvoiceIds(invoiceIds);
            this.fscInvoiceMapper.updateBy(setPO, wherePO);
        }
        rspBO.setInvoiceIds(invoiceIds);
        return rspBO;
    }

    private void val(FscBillRedInvoiceConfirmOrderAddReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getFscOrderId())) {
            throw new ZTBusinessException("\u7ed3\u7b97\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private String initParams(FscInvoicePO invoicePO, FscOrderInvoicePO orderInvoicePO) {
        JSONObject reqJson = new JSONObject();
        reqJson.put("redConfirmApplyNum", (Object)String.valueOf(invoicePO.getInvoiceId()));
        int invoiceKind = 82;
        if ("00".equals(orderInvoicePO.getInvoiceType())) {
            invoiceKind = 83;
        } else if ("01".equals(orderInvoicePO.getInvoiceType())) {
            invoiceKind = 82;
        } else {
            throw new FscBusinessException("8888", "\u63a8\u9001\u7a0e\u63a7\u9519\u8bef\uff1a\u6ca1\u6709\u5bf9\u5e94\u7684\u53d1\u7968\u7c7b\u578b\uff1a" + JSON.toJSONString((Object)orderInvoicePO));
        }
        reqJson.put("invoiceKind", (Object)invoiceKind);
        reqJson.put("oiIdentity", (Object)1);
        reqJson.put("digitalInvoiceNum", (Object)invoicePO.getInvoiceNo());
        reqJson.put("invoiceDate", (Object)(invoicePO.getBillDate() + " 00:00:00"));
        reqJson.put("sellerTaxNum", (Object)this.sellerTaxNum);
        reqJson.put("sellerTaxName", (Object)this.sellerTaxName);
        if (!StringUtils.isEmpty((Object)orderInvoicePO.getTaxNo())) {
            reqJson.put("buyerTaxNum", (Object)orderInvoicePO.getTaxNo());
        }
        if (!StringUtils.isEmpty((Object)orderInvoicePO.getBuyName())) {
            reqJson.put("buyerTaxName", (Object)orderInvoicePO.getBuyName());
        }
        reqJson.put("offsetReason", (Object)2);
        reqJson.put("offsetMode", (Object)1);
        if (invoiceKind == 84 || invoiceKind == 85) {
            reqJson.put("invoiceCode", (Object)invoicePO.getInvoiceCode());
            reqJson.put("invoiceNum", (Object)invoicePO.getInvoiceNo());
        }
        reqJson.put("replayId", (Object)("replayId-" + Sequence.getInstance().nextId()));
        return reqJson.toJSONString();
    }
}

