/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.bill.ability.api.FscBillAdjustInvoiceUploadAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillAdjustInvoiceUploadAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillAdjustInvoiceUploadAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscBillInvoiceMaintainItemBO;
import com.tydic.fsc.bill.ability.bo.FscBillInvoiceUploadAbilityReqBO;
import com.tydic.fsc.bill.busi.api.FscBillAdjustInvoiceMaintainBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillAdjustInvoiceMaintainBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillAdjustInvoiceMaintainBusiRspBO;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceMaintainItemBusiBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscGoodsDeductionAdjustMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscGoodsDeductionAdjustPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillAdjustInvoiceUploadAbilityService"})
public class FscBillAdjustInvoiceUploadAbilityServiceImpl
implements FscBillAdjustInvoiceUploadAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillAdjustInvoiceUploadAbilityServiceImpl.class);
    @Autowired
    private FscGoodsDeductionAdjustMapper fscGoodsDeductionAdjustMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;
    @Autowired
    private FscBillAdjustInvoiceMaintainBusiService fscBillAdjustInvoiceMaintainBusiService;
    private static final String BUSI_NAME = "\u4e3b\u5355\u53d1\u7968\u4e0a\u4f20";
    private static final String NOT_NEED_INVOICE_INFO = "0";
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealInvoiceUpload"})
    public FscBillAdjustInvoiceUploadAbilityRspBO dealInvoiceUpload(@RequestBody FscBillAdjustInvoiceUploadAbilityReqBO reqBO) {
        this.val(reqBO);
        FscGoodsDeductionAdjustPO fscAdjustPo = new FscGoodsDeductionAdjustPO();
        fscAdjustPo.setFscAdjustId(reqBO.getFscAdjustId());
        fscAdjustPo.setSysTenantId(reqBO.getSysTenantId());
        fscAdjustPo = this.fscGoodsDeductionAdjustMapper.getModelBy(fscAdjustPo);
        if (null == fscAdjustPo) {
            throw new FscBusinessException("191011", "\u7ed3\u7b97\u8c03\u6574\u5355\u4e0d\u5b58\u5728");
        }
        FscOrderInvoicePO fscOrderInvoicePO = new FscOrderInvoicePO();
        fscOrderInvoicePO.setFscOrderId(reqBO.getFscAdjustId());
        fscOrderInvoicePO.setSysTenantId(reqBO.getSysTenantId());
        fscOrderInvoicePO = this.fscOrderInvoiceMapper.getModelBy(fscOrderInvoicePO);
        if (null == fscOrderInvoicePO) {
            throw new FscBusinessException("191011", "\u67e5\u8be2\u4e3b\u5355\u53d1\u7968\u4e3a\u7a7a");
        }
        FscBillAdjustInvoiceMaintainBusiReqBO fscBillInvoiceMaintainBusiReqBO = (FscBillAdjustInvoiceMaintainBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscBillAdjustInvoiceMaintainBusiReqBO.class));
        List billInvoiceMaintainItemBusiBOS = JSON.parseArray((String)JSON.toJSONString((Object)reqBO.getFscBillInvoiceMaintainItemBOS()), FscBillInvoiceMaintainItemBusiBO.class);
        fscBillInvoiceMaintainBusiReqBO.setBillInvoiceMaintainItemBusiBOS(billInvoiceMaintainItemBusiBOS);
        fscBillInvoiceMaintainBusiReqBO.setFscAdjustId(reqBO.getFscAdjustId());
        fscBillInvoiceMaintainBusiReqBO.setCurStatus(fscAdjustPo.getStatus());
        fscBillInvoiceMaintainBusiReqBO.setFscOrderTotalCharge(fscAdjustPo.getFscAdjustAmount());
        fscBillInvoiceMaintainBusiReqBO.setIsSign(reqBO.getIsSign());
        log.info("\u7ed3\u7b97\u5355\u53d1\u7968\u7ef4\u62a4\u6d41\u8f6c\u5165\u53c2:{}", (Object)fscBillInvoiceMaintainBusiReqBO);
        FscBillAdjustInvoiceMaintainBusiRspBO fscBillInvoiceMaintainBusiRspBO = this.fscBillAdjustInvoiceMaintainBusiService.dealInvoiceUpload(fscBillInvoiceMaintainBusiReqBO);
        if (!"0000".equals(fscBillInvoiceMaintainBusiRspBO.getRespCode())) {
            throw new FscBusinessException("191011", fscBillInvoiceMaintainBusiRspBO.getRespDesc());
        }
        return new FscBillAdjustInvoiceUploadAbilityRspBO();
    }

    private boolean isAutoSign(FscBillInvoiceUploadAbilityReqBO reqBO, FscOrderPO fscOrderPo) {
        if (FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPo.getMakeType())) {
            FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
            fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("operinvoice_sign");
            if (FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPo.getReceiveType())) {
                fscCfcUniteParamQryListDetailExternalReqBO.setRelId(String.valueOf(fscOrderPo.getPurchaserId()));
            } else if (FscConstants.FscOrderReceiveType.SUPPLIER.equals(fscOrderPo.getReceiveType())) {
                fscCfcUniteParamQryListDetailExternalReqBO.setRelId(String.valueOf(fscOrderPo.getSupplierId()));
            }
            FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
            if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
                throw new FscBusinessException("191011", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
            }
            if (StringUtils.isBlank((String)fscCfcUniteParamQryListDetailExternalRspBO.getReqSign())) {
                throw new FscBusinessException("191011", "\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3[operinvoice_sign]\u8fd4\u56de[reqSign]\u4e3a\u7a7a");
            }
            return NOT_NEED_INVOICE_INFO.equals(fscCfcUniteParamQryListDetailExternalRspBO.getReqSign());
        }
        return false;
    }

    private boolean needInvoiceInfos(FscOrderPO fscOrderPo) {
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        String orderSource = fscOrderPo.getOrderSource().toString();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("invoice_upload_details_" + orderSource);
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191011", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)fscCfcUniteParamQryListDetailExternalRspBO.getReqDetailed())) {
            String reqDetailed = fscCfcUniteParamQryListDetailExternalRspBO.getReqDetailed();
            return !NOT_NEED_INVOICE_INFO.equals(reqDetailed);
        }
        return true;
    }

    private void val(FscBillAdjustInvoiceUploadAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getFscAdjustId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[fscAdjustId]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getFscBillInvoiceMaintainItemBOS())) {
            throw new FscBusinessException("191000", "\u53d1\u7968\u660e\u7ec6\u4e3a\u7a7a");
        }
        for (FscBillInvoiceMaintainItemBO item : reqBO.getFscBillInvoiceMaintainItemBOS()) {
            FscInvoicePO fscInvoicePO = new FscInvoicePO();
            fscInvoicePO.setInvoiceNo(item.getInvoiceNo());
            fscInvoicePO.setFscOrderId(reqBO.getFscAdjustId());
            List invoiceCode = this.fscInvoiceMapper.checkInvoice(fscInvoicePO);
            if (!ObjectUtil.isEmpty((Object)invoiceCode)) {
                if (!ObjectUtil.isEmpty((Object)item.getInvoiceCode())) {
                    List invoiceCodeS = invoiceCode.stream().map(FscInvoicePO::getInvoiceCode).collect(Collectors.toList());
                    if (invoiceCodeS.contains(item.getInvoiceCode())) {
                        String invoiceCodeErrorMsg = ObjectUtil.isEmpty((Object)((FscInvoicePO)invoiceCode.get(0)).getInvoiceCode()) ? "" : "\u53d1\u7968\u4ee3\u7801:" + ((FscInvoicePO)invoiceCode.get(0)).getInvoiceCode();
                        String invoiceNumErrorMsg = ObjectUtil.isEmpty((Object)((FscInvoicePO)invoiceCode.get(0)).getInvoiceNo()) ? "" : "\u53d1\u7968\u53f7\u7801:" + ((FscInvoicePO)invoiceCode.get(0)).getInvoiceNo();
                        String errorMsg = invoiceCodeErrorMsg + invoiceNumErrorMsg + "\u5df2\u5b58\u5728,\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0";
                        throw new FscBusinessException("191000", errorMsg);
                    }
                } else {
                    String invoiceCodeErrorMsg = ObjectUtil.isEmpty((Object)((FscInvoicePO)invoiceCode.get(0)).getInvoiceCode()) ? "" : "\u53d1\u7968\u4ee3\u7801:" + ((FscInvoicePO)invoiceCode.get(0)).getInvoiceCode();
                    String invoiceNumErrorMsg = ObjectUtil.isEmpty((Object)((FscInvoicePO)invoiceCode.get(0)).getInvoiceNo()) ? "" : "\u53d1\u7968\u53f7\u7801:" + ((FscInvoicePO)invoiceCode.get(0)).getInvoiceNo();
                    String errorMsg = invoiceCodeErrorMsg + invoiceNumErrorMsg + "\u5df2\u5b58\u5728,\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0";
                    throw new FscBusinessException("191000", errorMsg);
                }
            }
            if (item.getUntaxAmt().compareTo(item.getAmt()) > 0) {
                throw new FscBusinessException("191000", "\u53d1\u7968\u91d1\u989d(\u4e0d\u542b\u7a0e)\u4e0d\u80fd\u5927\u4e8e\u53d1\u7968\u603b\u91d1\u989d");
            }
            if (item.getTaxAmt().compareTo(item.getAmt()) <= 0) continue;
            throw new FscBusinessException("191000", "\u7a0e\u989d\u4e0d\u80fd\u5927\u4e8e\u53d1\u7968\u603b\u91d1\u989d");
        }
    }

    private Long string2Long(String str) {
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            throw new FscBusinessException("191011", "\u5546\u54c1\u660e\u7ec6ID\u8f6c\u6362\u5f02\u5e38");
        }
    }
}

