/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.tydic.fsc.bill.busi.api.FscBillInvoiceUploadBusiService;
import com.tydic.fsc.bill.busi.api.FscGetInvoiceDataBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceUploadBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceUploadBusiRspBO;
import com.tydic.fsc.bill.busi.bo.FscGetInvoiceDataBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscGetInvoiceDataBusiRspBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscInvoiceInfoBO;
import com.tydic.fsc.bo.InvoiceItemBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetInvoiceInfoItemReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetInvoiceInfoItemRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetInvoiceInfoItemSkuRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetInvoiceInfoListRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetInvoiceInfoReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetInvoiceInfoRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscGetInvoiceInfoExternalService;
import com.tydic.fsc.busibase.external.api.esb.FscGetInvoiceInfoItemExternalService;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscGetInvoiceDataBusiServiceImpl
implements FscGetInvoiceDataBusiService {
    @Autowired
    private FscBillInvoiceUploadBusiService fscBillInvoiceUploadBusiService;
    @Autowired
    private FscGetInvoiceInfoExternalService fscGetInvoiceInfoExternalService;
    @Autowired
    private FscGetInvoiceInfoItemExternalService fscGetInvoiceInfoItemExternalService;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    private static final String BUSI_NAME = "\u83b7\u53d6\u7535\u5546\u53d1\u7968";
    @Autowired
    private Environment environment;
    private static final String JD_SUP_ID = "JD_SUP_ID";

    @Override
    public FscGetInvoiceDataBusiRspBO getInvoiceData(FscGetInvoiceDataBusiReqBO reqBO) {
        FscGetInvoiceInfoReqBO fscGetInvoiceInfoReqBO = new FscGetInvoiceInfoReqBO();
        fscGetInvoiceInfoReqBO.setMarkId(String.valueOf(reqBO.getFscOrderId()));
        fscGetInvoiceInfoReqBO.setSupplierId(String.valueOf(reqBO.getSupplierId()));
        fscGetInvoiceInfoReqBO.setProOrgId(String.valueOf(reqBO.getProOrgId()));
        fscGetInvoiceInfoReqBO.setSysTenantId(reqBO.getSysTenantId());
        FscGetInvoiceInfoRspBO invoiceInfo = this.fscGetInvoiceInfoExternalService.getInvoiceInfo(fscGetInvoiceInfoReqBO);
        if (!"0000".equals(invoiceInfo.getRespCode())) {
            throw new FscBusinessException("193016", invoiceInfo.getRespDesc());
        }
        List invoiceInfoResultList = invoiceInfo.getResult();
        FscOrderInvoicePO fscOrderInvoicePo = new FscOrderInvoicePO();
        fscOrderInvoicePo.setFscOrderId(reqBO.getFscOrderId());
        fscOrderInvoicePo.setSysTenantId(reqBO.getSysTenantId());
        fscOrderInvoicePo = this.fscOrderInvoiceMapper.getModelBy(fscOrderInvoicePo);
        if (null == fscOrderInvoicePo) {
            throw new FscBusinessException("193016", "\u67e5\u8be2\u4e3b\u5355\u53d1\u7968\u4e3a\u7a7a");
        }
        FscOrderItemPO fscOrderItemPo = new FscOrderItemPO();
        fscOrderItemPo.setFscOrderId(reqBO.getFscOrderId());
        fscOrderItemPo.setSysTenantId(reqBO.getSysTenantId());
        List fscOrderItemPos = this.fscOrderItemMapper.getList(fscOrderItemPo);
        if (CollectionUtils.isEmpty((Collection)fscOrderItemPos)) {
            throw new FscBusinessException("193016", "\u67e5\u8be2\u4e3b\u5355\u660e\u7ec6\u4e3a\u7a7a");
        }
        ArrayList<FscInvoiceInfoBO> fscInvoiceInfoBos = new ArrayList<FscInvoiceInfoBO>();
        if (!CollectionUtils.isEmpty((Collection)invoiceInfoResultList)) {
            for (FscGetInvoiceInfoListRspBO fscGetInvoiceInfoListRspBO : invoiceInfoResultList) {
                FscInvoiceInfoBO fscInvoiceInfoBO = this.createEntity(fscGetInvoiceInfoListRspBO, reqBO, fscOrderInvoicePo, fscOrderItemPos);
                fscInvoiceInfoBos.add(fscInvoiceInfoBO);
            }
        }
        FscBillInvoiceUploadBusiReqBO fscBillInvoiceUploadBusiReqBO = new FscBillInvoiceUploadBusiReqBO();
        fscBillInvoiceUploadBusiReqBO.setFscInvoiceInfoBOS(fscInvoiceInfoBos);
        fscBillInvoiceUploadBusiReqBO.setFscOrderId(reqBO.getFscOrderId());
        fscBillInvoiceUploadBusiReqBO.setBusiName(BUSI_NAME);
        fscBillInvoiceUploadBusiReqBO.setCurStatus(FscBillStatus.INVOICING_SUBMISSION.getCode());
        fscBillInvoiceUploadBusiReqBO.setSysTenantId(reqBO.getSysTenantId());
        FscBillInvoiceUploadBusiRspBO fscBillInvoiceUploadBusiRspBO = this.fscBillInvoiceUploadBusiService.dealInvoiceUpload(fscBillInvoiceUploadBusiReqBO);
        if (!"0000".equals(fscBillInvoiceUploadBusiRspBO.getRespCode())) {
            throw new FscBusinessException("193016", fscBillInvoiceUploadBusiRspBO.getRespDesc());
        }
        return new FscGetInvoiceDataBusiRspBO();
    }

    private FscInvoiceInfoBO createEntity(FscGetInvoiceInfoListRspBO fscGetInvoiceInfoListRspBO, FscGetInvoiceDataBusiReqBO reqBO, FscOrderInvoicePO fscOrderInvoicePo, List<FscOrderItemPO> fscOrderItemPos) {
        AttachmentBO attachmentBo;
        String jdSupId = this.environment.getProperty(JD_SUP_ID);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        FscGetInvoiceInfoItemReqBO fscGetInvoiceInfoItemReqBO = new FscGetInvoiceInfoItemReqBO();
        fscGetInvoiceInfoItemReqBO.setInvoiceCode(fscGetInvoiceInfoListRspBO.getInvoiceCode());
        fscGetInvoiceInfoItemReqBO.setInvoiceId(fscGetInvoiceInfoListRspBO.getInvoiceId());
        fscGetInvoiceInfoItemReqBO.setSupplierId(String.valueOf(reqBO.getSupplierId()));
        fscGetInvoiceInfoItemReqBO.setProOrgId(String.valueOf(reqBO.getProOrgId()));
        fscGetInvoiceInfoItemReqBO.setSysTenantId(reqBO.getSysTenantId());
        FscGetInvoiceInfoItemRspBO invoiceInfoItem = this.fscGetInvoiceInfoItemExternalService.getInvoiceInfoItem(fscGetInvoiceInfoItemReqBO);
        if (!"0000".equals(invoiceInfoItem.getRespCode())) {
            throw new FscBusinessException("193016", invoiceInfoItem.getRespDesc());
        }
        FscInvoiceInfoBO fscInvoiceInfoBO = new FscInvoiceInfoBO();
        List skuEntity = invoiceInfoItem.getResult().getSkuEntity();
        Map<String, FscGetInvoiceInfoItemSkuRspBO> extInvoiceItemMap = skuEntity.stream().collect(Collectors.toMap(FscGetInvoiceInfoItemSkuRspBO::getExtSkuId, v -> v));
        ArrayList invoiceItemBOList = new ArrayList();
        fscOrderItemPos.forEach(fscOrderItemPo -> {
            InvoiceItemBO invoiceItemBO = new InvoiceItemBO();
            invoiceItemBO.setFscOrderId(fscOrderItemPo.getFscOrderId());
            invoiceItemBO.setAcceptOrderId(fscOrderItemPo.getAcceptOrderId());
            invoiceItemBO.setOrderId(fscOrderItemPo.getOrderId());
            invoiceItemBO.setOrderItemId(fscOrderItemPo.getOrderItemId());
            invoiceItemBO.setSkuId(fscOrderItemPo.getSkuId());
            invoiceItemBO.setSkuName(fscOrderItemPo.getSkuName());
            invoiceItemBO.setSpec(fscOrderItemPo.getSpec());
            invoiceItemBO.setModel(fscOrderItemPo.getModel());
            invoiceItemBO.setPrice(fscOrderItemPo.getPrice());
            invoiceItemBO.setTaxAmt(((FscGetInvoiceInfoItemSkuRspBO)extInvoiceItemMap.get(fscOrderItemPo.getSkuIdExt())).getTaxAmount());
            invoiceItemBO.setUnit(((FscGetInvoiceInfoItemSkuRspBO)extInvoiceItemMap.get(fscOrderItemPo.getSkuIdExt())).getSettleUnit());
            invoiceItemBO.setTaxCode(((FscGetInvoiceInfoItemSkuRspBO)extInvoiceItemMap.get(fscOrderItemPo.getSkuIdExt())).getTaxId());
            invoiceItemBO.setNum(((FscGetInvoiceInfoItemSkuRspBO)extInvoiceItemMap.get(fscOrderItemPo.getSkuIdExt())).getNum());
            invoiceItemBO.setAmt(((FscGetInvoiceInfoItemSkuRspBO)extInvoiceItemMap.get(fscOrderItemPo.getSkuIdExt())).getAmount());
            invoiceItemBO.setUntaxAmt(((FscGetInvoiceInfoItemSkuRspBO)extInvoiceItemMap.get(fscOrderItemPo.getSkuIdExt())).getAmountUnTax());
            invoiceItemBOList.add(invoiceItemBO);
        });
        fscInvoiceInfoBO.setInvoiceItemBOS(invoiceItemBOList);
        fscInvoiceInfoBO.setFscOrderId(reqBO.getFscOrderId());
        fscInvoiceInfoBO.setInvoiceType(fscOrderInvoicePo.getInvoiceType());
        fscInvoiceInfoBO.setInvoiceCategory(fscOrderInvoicePo.getInvoiceCategory());
        fscInvoiceInfoBO.setCreateTime(fscOrderInvoicePo.getBillTime());
        fscInvoiceInfoBO.setCreateOperId(fscOrderInvoicePo.getBillOperId());
        fscInvoiceInfoBO.setCreateOperName(fscOrderInvoicePo.getBillOperName());
        fscInvoiceInfoBO.setBank(fscGetInvoiceInfoListRspBO.getBank());
        fscInvoiceInfoBO.setInvoiceCode(fscGetInvoiceInfoListRspBO.getInvoiceCode());
        fscInvoiceInfoBO.setInvoiceNo(fscGetInvoiceInfoListRspBO.getInvoiceId());
        fscInvoiceInfoBO.setBillDate(simpleDateFormat.format(fscGetInvoiceInfoListRspBO.getInvoiceDate()));
        fscInvoiceInfoBO.setUntaxAmt(fscGetInvoiceInfoListRspBO.getInvoiceNakedAmount());
        fscInvoiceInfoBO.setTax(fscGetInvoiceInfoListRspBO.getInvoiceTaxRate());
        fscInvoiceInfoBO.setTaxAmt(fscGetInvoiceInfoListRspBO.getInvoiceTaxAmount());
        fscInvoiceInfoBO.setAmt(fscGetInvoiceInfoListRspBO.getInvoiceAmount());
        fscInvoiceInfoBO.setBuyName(fscGetInvoiceInfoListRspBO.getTitle());
        fscInvoiceInfoBO.setTaxNo(fscGetInvoiceInfoListRspBO.getEnterpriseTaxpayer());
        fscInvoiceInfoBO.setAddress(fscGetInvoiceInfoListRspBO.getAddress());
        fscInvoiceInfoBO.setPhone(fscGetInvoiceInfoListRspBO.getTel());
        fscInvoiceInfoBO.setAccount(fscGetInvoiceInfoListRspBO.getAccount());
        ArrayList<AttachmentBO> attachmentList = new ArrayList<AttachmentBO>();
        if (!StringUtils.isBlank((String)fscGetInvoiceInfoListRspBO.getFileUrl()) || !StringUtils.isBlank((String)fscGetInvoiceInfoListRspBO.getPdfUrl())) {
            attachmentBo = new AttachmentBO();
            attachmentBo.setAttachmentType(FscConstants.AttachmentType.INVOICE);
            attachmentBo.setAttachmentUrl(StringUtils.isBlank((String)fscGetInvoiceInfoListRspBO.getFileUrl()) ? fscGetInvoiceInfoListRspBO.getPdfUrl() : fscGetInvoiceInfoListRspBO.getFileUrl());
            attachmentList.add(attachmentBo);
        }
        if (!StringUtils.isBlank((String)fscGetInvoiceInfoListRspBO.getXmlUrl()) || !StringUtils.isBlank((String)fscGetInvoiceInfoListRspBO.getXmlSourceFileUrl())) {
            attachmentBo = new AttachmentBO();
            attachmentBo.setAttachmentType(FscConstants.AttachmentType.XML);
            attachmentBo.setAttachmentUrl(StringUtils.isBlank((String)fscGetInvoiceInfoListRspBO.getXmlUrl()) ? fscGetInvoiceInfoListRspBO.getXmlSourceFileUrl() : fscGetInvoiceInfoListRspBO.getXmlUrl());
            attachmentList.add(attachmentBo);
        }
        if (!StringUtils.isBlank((String)fscGetInvoiceInfoListRspBO.getOfdUrl()) || !StringUtils.isBlank((String)fscGetInvoiceInfoListRspBO.getOfdFileUrl())) {
            attachmentBo = new AttachmentBO();
            attachmentBo.setAttachmentType(FscConstants.AttachmentType.OFD);
            attachmentBo.setAttachmentUrl(StringUtils.isBlank((String)fscGetInvoiceInfoListRspBO.getOfdUrl()) ? fscGetInvoiceInfoListRspBO.getOfdFileUrl() : fscGetInvoiceInfoListRspBO.getOfdUrl());
            attachmentList.add(attachmentBo);
        }
        fscInvoiceInfoBO.setAttachmentList(attachmentList);
        return fscInvoiceInfoBO;
    }
}

