/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.cfc.ability.api.CrcQryPaymentBehalfReverseAbilityService;
import com.tydic.fsc.bill.busi.api.FscPayBillWithdrawalBankCheckFileBusiService;
import com.tydic.fsc.bill.busi.bo.FscPayBillBankCheckFileBusiRspBO;
import com.tydic.fsc.bill.busi.bo.FscPayBillWithdrawalBankCheckFileBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscWithdrawalBankCheckFileItemBO;
import com.tydic.fsc.busibase.busi.api.FscOrderStatusFlowBusiService;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscBalanceMapper;
import com.tydic.fsc.dao.FscBankCheckItemScheduleMapper;
import com.tydic.fsc.dao.FscLegalCompanyMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscWithdrawalBankCheckFileItemMapper;
import com.tydic.fsc.dao.FscWithdrawalBankCheckFileMapper;
import com.tydic.fsc.dao.FscWriteOffItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscWithdrawalBankCheckFileItemPO;
import com.tydic.fsc.po.FscWithdrawalBankCheckFilePO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscPayBillWithdrawalBankCheckFileBusiServiceImpl
implements FscPayBillWithdrawalBankCheckFileBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPayBillWithdrawalBankCheckFileBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscWithdrawalBankCheckFileItemMapper fscWithdrawalBankCheckFileItemMapper;
    @Autowired
    private FscWithdrawalBankCheckFileMapper fscWithdrawalBankCheckFileMapper;
    @Autowired
    private FscWriteOffItemMapper fscWriteoffitemMapper;
    @Autowired
    private FscBalanceMapper fscBalanceMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscLegalCompanyMapper fscLegalCompanyMapper;
    @Autowired
    private FscOrderStatusFlowBusiService fscOrderStatusFlowBusiService;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;
    @Autowired
    private CrcQryPaymentBehalfReverseAbilityService crcQryPaymentBehalfReverseAbilityService;
    @Autowired
    private FscBankCheckItemScheduleMapper fscBankCheckItemScheduleMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public FscPayBillBankCheckFileBusiRspBO bankCheckFile(FscPayBillWithdrawalBankCheckFileBusiReqBO busiReqBO) {
        FscPayBillBankCheckFileBusiRspBO busiRspBO = new FscPayBillBankCheckFileBusiRspBO();
        if (FscConstants.BANK_CHECK_OPER_TYPE.INSERT_FILE.equals(busiReqBO.getOperType())) {
            ArrayList fscBankCheckFilePOList = new ArrayList();
            if (!CollectionUtils.isEmpty(busiReqBO.getFscBankCheckFileBOs())) {
                busiReqBO.getFscBankCheckFileBOs().forEach(row -> {
                    FscWithdrawalBankCheckFilePO fscBankCheckFilePO = new FscWithdrawalBankCheckFilePO();
                    fscBankCheckFilePO.setFileName(row.getFileName());
                    fscBankCheckFilePO.setSysTenantId(busiReqBO.getSysTenantId());
                    if (this.fscWithdrawalBankCheckFileMapper.getCheckBy(fscBankCheckFilePO) <= 0) {
                        BeanUtils.copyProperties((Object)row, (Object)fscBankCheckFilePO);
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        String dataStr = sdf.format(new Date());
                        try {
                            Date date = sdf.parse(dataStr);
                            fscBankCheckFilePO.setCreateTime(date);
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                        fscBankCheckFilePO.setStatus(ObjectUtil.isEmpty((Object)row.getStatus()) ? FscConstants.BANK_CHECK_STATUS.NO : row.getStatus());
                        fscBankCheckFilePO.setSysTenantId(busiReqBO.getSysTenantId());
                        fscBankCheckFilePO.setSysTenantName(busiReqBO.getSysTenantName());
                        fscBankCheckFilePOList.add(fscBankCheckFilePO);
                    }
                });
            }
            if (!CollectionUtils.isEmpty(fscBankCheckFilePOList)) {
                this.fscWithdrawalBankCheckFileMapper.insertBatch(fscBankCheckFilePOList);
            }
        } else if (FscConstants.BANK_CHECK_OPER_TYPE.INSERT_FILE_ITEM.equals(busiReqBO.getOperType())) {
            ArrayList<FscWithdrawalBankCheckFileItemPO> fscBankCheckFileItemPOList = new ArrayList<FscWithdrawalBankCheckFileItemPO>();
            if (!CollectionUtils.isEmpty(busiReqBO.getFscBankCheckFileItemBOs())) {
                for (FscWithdrawalBankCheckFileItemBO row2 : busiReqBO.getFscBankCheckFileItemBOs()) {
                    FscWithdrawalBankCheckFileItemPO fscBankCheckFileItemPO = new FscWithdrawalBankCheckFileItemPO();
                    BeanUtils.copyProperties((Object)row2, (Object)fscBankCheckFileItemPO);
                    fscBankCheckFileItemPO.setCreateTime(new Date());
                    fscBankCheckFileItemPO.setStatus(FscConstants.BANK_CHECK_ITEM_STATUS.NO_CHECK);
                    fscBankCheckFileItemPO.setSysTenantId(busiReqBO.getSysTenantId());
                    fscBankCheckFileItemPO.setSysTenantName(busiReqBO.getSysTenantName());
                    fscBankCheckFileItemPOList.add(fscBankCheckFileItemPO);
                }
                this.fscWithdrawalBankCheckFileItemMapper.insertBatch(fscBankCheckFileItemPOList);
                FscWithdrawalBankCheckFilePO fscBankCheckFilePO = new FscWithdrawalBankCheckFilePO();
                fscBankCheckFilePO.setFileName(busiReqBO.getFileName());
                fscBankCheckFilePO.setAttachmentName(busiReqBO.getAttachmentName());
                fscBankCheckFilePO.setAttachmentUrl(busiReqBO.getAttachmentUrl());
                fscBankCheckFilePO.setStatus(busiReqBO.getStatus());
                fscBankCheckFilePO.setSysTenantId(busiReqBO.getSysTenantId());
                this.fscWithdrawalBankCheckFileMapper.updateById(fscBankCheckFilePO);
            }
        }
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u4fee\u6539\u6210\u529f");
        return busiRspBO;
    }

    private Date getConfiguration(String relId, Long sysTenantId) {
        Calendar curDate = Calendar.getInstance();
        curDate.setTime(new Date());
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("cash_withdrawal");
        fscCfcUniteParamQryListDetailExternalReqBO.setRelId(relId);
        fscCfcUniteParamQryListDetailExternalReqBO.setSysTenantId(sysTenantId);
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191014", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        Integer advanceUnfreezeDays = 0;
        Integer paymentDays = 0;
        Integer advanceWarningDays = 0;
        if (!StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceUnfreezeDays())) {
            advanceUnfreezeDays = Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceUnfreezeDays());
        }
        if (!StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getPaymentDays())) {
            paymentDays = Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getPaymentDays());
        }
        if (!StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceWarningDays())) {
            advanceWarningDays = Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceWarningDays());
        }
        curDate.add(5, paymentDays - advanceUnfreezeDays);
        return curDate.getTime();
    }
}

