/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.budget.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.fsc.budget.ability.api.FscQryBudgetDetailItemPageListAbilityService;
import com.tydic.fsc.budget.ability.bo.FscBudgetItemBO;
import com.tydic.fsc.budget.ability.bo.FscBudgetMainTabsInfoBO;
import com.tydic.fsc.budget.ability.bo.FscQryBudgetDetailItemPageListAbilityReqBO;
import com.tydic.fsc.budget.ability.bo.FscQryBudgetDetailItemPageListAbilityRspBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.dao.FscBudgetItemMapper;
import com.tydic.fsc.po.FscBudgetItemPO;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.budget.ability.api.FscQryBudgetDetailItemPageListAbilityService"})
public class FscQryBudgetDetailItemPageListAbilityServiceImpl
implements FscQryBudgetDetailItemPageListAbilityService {
    @Autowired
    private FscBudgetItemMapper fscBudgetItemMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;

    @PostMapping(value={"qryBudgetDetailItemPageList"})
    public FscQryBudgetDetailItemPageListAbilityRspBO qryBudgetDetailItemPageList(@RequestBody FscQryBudgetDetailItemPageListAbilityReqBO reqBO) {
        Page page = new Page();
        page.setPageSize(reqBO.getPageSize().intValue());
        page.setPageNo(reqBO.getPageNo().intValue());
        FscBudgetItemPO fscBudgetItemPo = (FscBudgetItemPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscBudgetItemPO.class);
        List fscBudgetItemPOList = this.fscBudgetItemMapper.getBudgetItemListPage(fscBudgetItemPo, page);
        ArrayList<FscBudgetItemBO> fscBudgetItemBOList = new ArrayList<FscBudgetItemBO>();
        if (!ObjectUtil.isEmpty(fscBudgetItemBOList)) {
            Map mainStateMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_BUDGET_MAIN_STATE");
            for (FscBudgetItemPO item : fscBudgetItemPOList) {
                FscBudgetItemBO fscBudgetItemBO = new FscBudgetItemBO();
                BeanUtils.copyProperties((Object)item, (Object)fscBudgetItemBO);
                fscBudgetItemBO.setStatusStr((String)mainStateMap.get(item.getStatus().toString()));
                try {
                    if (fscBudgetItemBO.getCurrentBudget() != null) {
                        fscBudgetItemBO.setCurrentBudget(MoneyUtils.Long2BigDecimal((Long)item.getCurrentBudget()));
                    }
                    if (fscBudgetItemBO.getUsedBudget() != null) {
                        fscBudgetItemBO.setUsedBudget(MoneyUtils.Long2BigDecimal((Long)item.getUsedBudget()));
                    }
                    if (fscBudgetItemBO.getFixSpaceBudget() != null) {
                        fscBudgetItemBO.setFixSpaceBudget(MoneyUtils.Long2BigDecimal((Long)item.getFixSpaceBudget()));
                    }
                    if (fscBudgetItemBO.getOriginSpaceBudget() != null) {
                        fscBudgetItemBO.setOriginSpaceBudget(MoneyUtils.Long2BigDecimal((Long)item.getOriginSpaceBudget()));
                    }
                    if (fscBudgetItemBO.getPastBudget() != null) {
                        fscBudgetItemBO.setPastBudget(MoneyUtils.Long2BigDecimal((Long)item.getPastBudget()));
                    }
                    if (fscBudgetItemBO.getNowSpaceBudget() != null) {
                        fscBudgetItemBO.setNowSpaceBudget(MoneyUtils.Long2BigDecimal((Long)item.getNowSpaceBudget()));
                    }
                    if (fscBudgetItemBO.getTotalSpaceBudget() != null) {
                        fscBudgetItemBO.setTotalSpaceBudget(MoneyUtils.Long2BigDecimal((Long)item.getTotalSpaceBudget()));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new BusinessException("8888", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
                }
                fscBudgetItemBOList.add(fscBudgetItemBO);
            }
        }
        FscQryBudgetDetailItemPageListAbilityRspBO rspBO = new FscQryBudgetDetailItemPageListAbilityRspBO();
        rspBO.setRows(fscBudgetItemBOList);
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        this.statisticTab(rspBO);
        return rspBO;
    }

    private void statisticTab(FscQryBudgetDetailItemPageListAbilityRspBO rspBO) {
        Page page = new Page();
        page.setPageSize(10000);
        page.setPageNo(1);
        List fscBudgetItemPOList = this.fscBudgetItemMapper.getBudgetItemListPage(new FscBudgetItemPO(), page);
        ArrayList<FscBudgetMainTabsInfoBO> fscBudgetMainTabsInfoBOS = new ArrayList<FscBudgetMainTabsInfoBO>();
        FscBudgetMainTabsInfoBO all = new FscBudgetMainTabsInfoBO();
        all.setTabName("\u5168\u90e8");
        all.setCount(Integer.valueOf(0));
        all.setSort(Integer.valueOf(0));
        FscBudgetMainTabsInfoBO starIng = new FscBudgetMainTabsInfoBO();
        starIng.setTabName("\u8fdb\u884c\u4e2d");
        starIng.setCount(Integer.valueOf(0));
        starIng.setSort(Integer.valueOf(1));
        FscBudgetMainTabsInfoBO notStarted = new FscBudgetMainTabsInfoBO();
        notStarted.setTabName("\u672a\u5f00\u59cb");
        notStarted.setCount(Integer.valueOf(0));
        notStarted.setSort(Integer.valueOf(2));
        FscBudgetMainTabsInfoBO finish = new FscBudgetMainTabsInfoBO();
        finish.setTabName("\u5df2\u7ed3\u675f");
        finish.setCount(Integer.valueOf(0));
        finish.setSort(Integer.valueOf(3));
        if (!ObjectUtil.isEmpty((Object)fscBudgetItemPOList)) {
            all.setCount(Integer.valueOf(fscBudgetItemPOList.size()));
            Map<Integer, List<FscBudgetItemPO>> fscBudgetPOListMap = fscBudgetItemPOList.stream().collect(Collectors.groupingBy(FscBudgetItemPO::getStatus));
            for (Map.Entry<Integer, List<FscBudgetItemPO>> entry : fscBudgetPOListMap.entrySet()) {
                String key;
                List<FscBudgetItemPO> tempList = entry.getValue();
                switch (key = ((Object)entry.getKey()).toString()) {
                    case "1": {
                        Integer notStartedCount = tempList.size();
                        notStarted.setCount(notStartedCount);
                    }
                    case "2": {
                        Integer starIngCount = tempList.size();
                        starIng.setCount(starIngCount);
                    }
                    case "3": {
                        Integer finishCount = tempList.size();
                        finish.setCount(finishCount);
                    }
                }
            }
        }
        fscBudgetMainTabsInfoBOS.add(all);
        fscBudgetMainTabsInfoBOS.add(starIng);
        fscBudgetMainTabsInfoBOS.add(notStarted);
        fscBudgetMainTabsInfoBOS.add(finish);
        List sortList = fscBudgetMainTabsInfoBOS.stream().sorted(Comparator.comparing(FscBudgetMainTabsInfoBO::getSort)).collect(Collectors.toList());
        rspBO.setFscBudgetMainTabsInfoBOS(sortList);
    }
}

