/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.budget.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.budget.ability.api.FscQryBudgetMainInfoPageListAbilityService;
import com.tydic.fsc.budget.ability.bo.FscBudgetMainBO;
import com.tydic.fsc.budget.ability.bo.FscBudgetMainTabsInfoBO;
import com.tydic.fsc.budget.ability.bo.FscQryBudgetMainInfoPageListAbilityReqBO;
import com.tydic.fsc.budget.ability.bo.FscQryBudgetMainInfoPageListAbilityRspBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.dao.FscBudgetMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscBudgetPO;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.budget.ability.api.FscQryBudgetMainInfoPageListAbilityService"})
public class FscQryBudgetMainInfoPageListAbilityServiceImpl
implements FscQryBudgetMainInfoPageListAbilityService {
    @Autowired
    private FscBudgetMapper fscBudgetMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;

    @PostMapping(value={"qryBudgetMainInfoPageList"})
    public FscQryBudgetMainInfoPageListAbilityRspBO qryBudgetMainInfoPageList(@RequestBody FscQryBudgetMainInfoPageListAbilityReqBO reqBO) {
        Page page = new Page();
        page.setPageNo(reqBO.getPageNo().intValue());
        page.setPageSize(reqBO.getPageSize().intValue());
        FscBudgetPO fscBudgetPO = new FscBudgetPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)fscBudgetPO);
        List fscBudgetPOList = this.fscBudgetMapper.getListPage(fscBudgetPO, page);
        List fscBudgetMainBOList = JSON.parseArray((String)JSON.toJSONString((Object)fscBudgetPOList), FscBudgetMainBO.class);
        if (!ObjectUtil.isEmpty((Object)fscBudgetMainBOList)) {
            Map mainStateMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_BUDGET_MAIN_STATE");
            for (FscBudgetMainBO item : fscBudgetMainBOList) {
                item.setStatusStr((String)mainStateMap.get(item.getStatus().toString()));
            }
        }
        FscQryBudgetMainInfoPageListAbilityRspBO rspBO = new FscQryBudgetMainInfoPageListAbilityRspBO();
        rspBO.setRows(fscBudgetMainBOList);
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        this.statisticTab(rspBO);
        return rspBO;
    }

    private void val(FscQryBudgetMainInfoPageListAbilityReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getBudgetCode()) && ObjectUtil.isEmpty((Object)reqBO.getBudgetId())) {
            throw new FscBusinessException("198888", "\u9884\u7b97\u4e3b\u5355\u4fe1\u606f\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void statisticTab(FscQryBudgetMainInfoPageListAbilityRspBO rspBO) {
        List fscBudgetPOList = this.fscBudgetMapper.getList(new FscBudgetPO());
        ArrayList<FscBudgetMainTabsInfoBO> fscBudgetMainTabsInfoBOS = new ArrayList<FscBudgetMainTabsInfoBO>();
        FscBudgetMainTabsInfoBO all = new FscBudgetMainTabsInfoBO();
        all.setTabName("\u5168\u90e8");
        all.setCount(Integer.valueOf(0));
        all.setSort(Integer.valueOf(0));
        FscBudgetMainTabsInfoBO starIng = new FscBudgetMainTabsInfoBO();
        starIng.setTabName("\u8fdb\u884c\u4e2d");
        starIng.setCount(Integer.valueOf(0));
        starIng.setSort(Integer.valueOf(1));
        FscBudgetMainTabsInfoBO notStarted = new FscBudgetMainTabsInfoBO();
        notStarted.setTabName("\u672a\u5f00\u59cb");
        notStarted.setCount(Integer.valueOf(0));
        notStarted.setSort(Integer.valueOf(2));
        FscBudgetMainTabsInfoBO finish = new FscBudgetMainTabsInfoBO();
        finish.setTabName("\u5df2\u7ed3\u675f");
        finish.setCount(Integer.valueOf(0));
        finish.setSort(Integer.valueOf(3));
        if (!ObjectUtil.isEmpty((Object)fscBudgetPOList)) {
            all.setCount(Integer.valueOf(fscBudgetPOList.size()));
            Map<Integer, List<FscBudgetPO>> fscBudgetPOListMap = fscBudgetPOList.stream().collect(Collectors.groupingBy(FscBudgetPO::getStatus));
            for (Map.Entry<Integer, List<FscBudgetPO>> entry : fscBudgetPOListMap.entrySet()) {
                String key;
                List<FscBudgetPO> tempList = entry.getValue();
                switch (key = ((Object)entry.getKey()).toString()) {
                    case "1": {
                        Integer notStartedCount = tempList.size();
                        notStarted.setCount(notStartedCount);
                    }
                    case "2": {
                        Integer starIngCount = tempList.size();
                        starIng.setCount(starIngCount);
                    }
                    case "3": {
                        Integer finishCount = tempList.size();
                        finish.setCount(finishCount);
                    }
                }
            }
        }
        fscBudgetMainTabsInfoBOS.add(all);
        fscBudgetMainTabsInfoBOS.add(starIng);
        fscBudgetMainTabsInfoBOS.add(notStarted);
        fscBudgetMainTabsInfoBOS.add(finish);
        List sortList = fscBudgetMainTabsInfoBOS.stream().sorted(Comparator.comparing(FscBudgetMainTabsInfoBO::getSort)).collect(Collectors.toList());
        rspBO.setFscBudgetMainTabsInfoBOS(sortList);
    }
}

