/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.budget.atom.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.fsc.budget.ability.bo.FscBudgetNumUpdateBO;
import com.tydic.fsc.budget.atom.api.FscBudgetNumUpdateAtomService;
import com.tydic.fsc.budget.atom.bo.FscBudgetNumUpdateAtomReqBO;
import com.tydic.fsc.budget.atom.bo.FscBudgetNumUpdateAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscBudgetItemLogMapper;
import com.tydic.fsc.dao.FscBudgetItemMapper;
import com.tydic.fsc.po.FscBudgetItemLogPO;
import com.tydic.fsc.po.FscBudgetItemPO;
import com.tydic.fsc.po.FscbudgetNumUpdatePO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FscBudgetNumUpdateAtomServiceImpl
implements FscBudgetNumUpdateAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscBudgetNumUpdateAtomServiceImpl.class);
    @Autowired
    private FscBudgetItemMapper fscBudgetItemMapper;
    @Autowired
    private FscBudgetItemLogMapper fscBudgetItemLogMapper;
    private Sequence sequence = Sequence.getInstance();

    @Override
    public FscBudgetNumUpdateAtomRspBO budgetNumUpdate(FscBudgetNumUpdateAtomReqBO reqBO) {
        FscBudgetItemPO fscBudgetItemPO;
        FscBudgetNumUpdateAtomRspBO rspBO = this.judge(reqBO);
        Date time = new Date(System.currentTimeMillis());
        ArrayList<FscbudgetNumUpdatePO> updatePOList = new ArrayList<FscbudgetNumUpdatePO>();
        for (FscBudgetNumUpdateBO each : reqBO.getRows()) {
            if (each.getBudgetItemId() == null) {
                fscBudgetItemPO = new FscBudgetItemPO();
                fscBudgetItemPO.setBudgetDepartmentId(each.getBudgetDepartmentId());
                fscBudgetItemPO.setStatus(FscConstants.FSC_BUDGET_MAIN_STATE.STARTED);
                FscBudgetItemPO modelBy = this.fscBudgetItemMapper.getModelBy(fscBudgetItemPO);
                if (modelBy == null) {
                    throw new BusinessException("198888", "\u5165\u53c2\u90e8\u95e8id\uff1a" + each.getBudgetItemId() + "\u672a\u67e5\u8be2\u5230\u8fdb\u884c\u4e2d\u7684\u9884\u7b97\u4fe1\u606f");
                }
                each.setBudgetItemId(modelBy.getBudgetItemId());
            }
            FscbudgetNumUpdatePO updatePO = new FscbudgetNumUpdatePO();
            BeanUtils.copyProperties((Object)each, (Object)updatePO);
            try {
                updatePO.setOperNum(MoneyUtils.BigDecimal2Long((BigDecimal)each.getOperNum()));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BusinessException("198888", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
            }
            updatePOList.add(updatePO);
        }
        Map budgetItemIdMap = reqBO.getRows().stream().collect(Collectors.toMap(FscBudgetNumUpdateBO::getBudgetItemId, Function.identity()));
        List budgetItemIds = reqBO.getRows().stream().map(FscBudgetNumUpdateBO::getBudgetItemId).collect(Collectors.toList());
        fscBudgetItemPO = new FscBudgetItemPO();
        fscBudgetItemPO.setBudgetItemIds(budgetItemIds);
        fscBudgetItemPO.setStatus(FscConstants.FSC_BUDGET_MAIN_STATE.STARTED);
        List list = this.fscBudgetItemMapper.getList(fscBudgetItemPO);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BusinessException("198888", "\u5165\u53c2\u90e8\u95e8\u67e5\u8be2\u5230\u8fdb\u884c\u4e2d\u7684\u9884\u7b97\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (list.size() != reqBO.getRows().size()) {
            log.error("\u67e5\u8be2\u5f53\u524d\u90e8\u95e8:" + JSON.toJSONString((Object)list));
            throw new BusinessException("198888", "\u5165\u53c2\u90e8\u95e8\u67e5\u8be2\u5230\u8fdb\u884c\u4e2d\u7684\u9884\u7b97\u4fe1\u606f\u6570\u76ee\u548c\u5165\u53c2\u4e0d\u76f8\u7b49");
        }
        for (FscBudgetItemPO each : list) {
            BigDecimal nowSpaceBudget;
            BigDecimal currentBudget;
            if (!budgetItemIdMap.containsKey(each.getBudgetItemId()) || ((FscBudgetNumUpdateBO)budgetItemIdMap.get(each.getBudgetItemId())).getOperType() != 2) continue;
            try {
                currentBudget = MoneyUtils.Long2BigDecimal((Long)each.getCurrentBudget());
                nowSpaceBudget = MoneyUtils.Long2BigDecimal((Long)each.getNowSpaceBudget());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BusinessException("198888", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
            }
            if (currentBudget.subtract(((FscBudgetNumUpdateBO)budgetItemIdMap.get(each.getBudgetItemId())).getOperNum()).compareTo(new BigDecimal(0)) < 0) {
                throw new BusinessException("198888", "\u60a8\u8f93\u5165\u7684\u51cf\u5c11\u9884\u7b97\u989d\u5ea6\u201c" + ((FscBudgetNumUpdateBO)budgetItemIdMap.get(each.getBudgetItemId())).getOperNum() + "\u201d\uff0c\u5df2\u8d85\u8fc7\u6700\u5927\u5141\u8bb8\u8c03\u6574\u989d\u5ea6\u503c\u201c" + currentBudget + "\u201d,\u8bf7\u4fee\u6539\u540e\uff0c\u518d\u4fdd\u5b58\u3002");
            }
            if (nowSpaceBudget.subtract(((FscBudgetNumUpdateBO)budgetItemIdMap.get(each.getBudgetItemId())).getOperNum()).compareTo(new BigDecimal(0)) >= 0) continue;
            throw new BusinessException("198888", "\u60a8\u8f93\u5165\u7684\u51cf\u5c11\u9884\u7b97\u989d\u5ea6\u201c" + ((FscBudgetNumUpdateBO)budgetItemIdMap.get(each.getBudgetItemId())).getOperNum() + "\u201d\uff0c\u5df2\u8d85\u8fc7\u6700\u5927\u5141\u8bb8\u8c03\u6574\u989d\u5ea6\u503c\u201c" + nowSpaceBudget + "\u201d,\u8bf7\u4fee\u6539\u540e\uff0c\u518d\u4fdd\u5b58\u3002");
        }
        int i = this.fscBudgetItemMapper.budgetNumBatchUpdate(updatePOList, reqBO.getType(), reqBO.getUserId(), reqBO.getName(), reqBO.getUserName(), time);
        log.info("\u4fee\u6539\u6761\u6570\uff1a" + i);
        if (i != updatePOList.size()) {
            throw new BusinessException("198888", "sql\u66f4\u65b0\u9884\u7b97\u7684\u6570\u76ee\u548c\u5165\u53c2\u6761\u6570\u4e0d\u4e00\u81f4");
        }
        List logPOList = JSON.parseArray((String)JSON.toJSONString((Object)list), FscBudgetItemLogPO.class);
        ArrayList<Long> updateDeductionKeys = new ArrayList<Long>();
        for (FscBudgetItemLogPO each : logPOList) {
            FscBudgetNumUpdateBO fscbudgetNumUpdateBO = (FscBudgetNumUpdateBO)budgetItemIdMap.get(each.getBudgetItemId());
            each.setId(Long.valueOf(this.sequence.nextId()));
            each.setDeductionKey(fscbudgetNumUpdateBO.getDeductionKey());
            each.setOperType(fscbudgetNumUpdateBO.getOperType());
            each.setDeductionStatus(Integer.valueOf(1));
            if (each.getDeductionKey() != null && each.getOperType() == 1) {
                each.setDeductionStatus(Integer.valueOf(3));
                updateDeductionKeys.add(each.getDeductionKey());
            }
            each.setOperId(reqBO.getUserId());
            each.setOperName(reqBO.getName());
            each.setOperTime(time);
            try {
                each.setOperNum(MoneyUtils.BigDecimal2Long((BigDecimal)fscbudgetNumUpdateBO.getOperNum()));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BusinessException("198888", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
            }
        }
        if (!CollectionUtils.isEmpty(updateDeductionKeys)) {
            FscBudgetItemLogPO set = new FscBudgetItemLogPO();
            set.setDeductionStatus(Integer.valueOf(2));
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            set.setColumn6(formatter.format(time));
            FscBudgetItemLogPO where = new FscBudgetItemLogPO();
            where.setDeductionKeys(updateDeductionKeys);
            this.fscBudgetItemLogMapper.updateBy(set, where);
        }
        this.fscBudgetItemLogMapper.insertBatch(logPOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private FscBudgetNumUpdateAtomRspBO judge(FscBudgetNumUpdateAtomReqBO reqBO) {
        FscBudgetNumUpdateAtomRspBO rspBO = new FscBudgetNumUpdateAtomRspBO();
        if (reqBO.getUserId() == null) {
            throw new BusinessException("198888", "\u5165\u53c2\u3010userId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getName())) {
            throw new BusinessException("198888", "\u5165\u53c2\u3010name\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getType() == null) {
            throw new BusinessException("198888", "\u5165\u53c2\u3010type\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBO.getRows())) {
            throw new BusinessException("198888", "\u5165\u53c2\u3010rows\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (FscBudgetNumUpdateBO each : reqBO.getRows()) {
            if (each.getBudgetItemId() == null && each.getBudgetDepartmentId() == null) {
                throw new BusinessException("198888", "\u5165\u53c2\u3010\u671f\u95f4id\u3011\u548c\u3010\u9884\u7b97\u90e8\u95e8id\u3011\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            }
            if (each.getOperType() == null) {
                throw new BusinessException("198888", "\u5165\u53c2\u3010operType\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (each.getOperNum() == null) {
                throw new BusinessException("198888", "\u5165\u53c2\u3010operNum\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (each.getOperNum().compareTo(new BigDecimal(0)) != 0) continue;
            throw new BusinessException("198888", "\u5165\u53c2\u3010operNum\u3011\u4e0d\u80fd\u4e3a0");
        }
        rspBO.setRespCode("0000");
        return rspBO;
    }
}

