/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.budget.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.fsc.budget.ability.api.FscQryBudgetItemInfoAbilityService;
import com.tydic.fsc.budget.ability.bo.FscBudgetItemBO;
import com.tydic.fsc.budget.ability.bo.FscQryBudgetItemInfoAbilityReqBO;
import com.tydic.fsc.budget.ability.bo.FscQryBudgetItemInfoAbilityRspBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.dao.FscBudgetItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscBudgetItemPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.budget.ability.api.FscQryBudgetItemInfoAbilityService"})
public class FscQryBudgetItemInfoAbilityServiceImpl
implements FscQryBudgetItemInfoAbilityService {
    @Autowired
    private FscBudgetItemMapper fscBudgetItemMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;

    @PostMapping(value={"qryBudgetItemInfo"})
    public FscQryBudgetItemInfoAbilityRspBO qryBudgetItemInfo(@RequestBody FscQryBudgetItemInfoAbilityReqBO reqBO) {
        this.val(reqBO);
        FscBudgetItemPO fscBudgetItemPO = (FscBudgetItemPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscBudgetItemPO.class);
        List fscBudgetItemPOList = this.fscBudgetItemMapper.getList(fscBudgetItemPO);
        ArrayList<FscBudgetItemBO> fscBudgetItemBOList = new ArrayList<FscBudgetItemBO>();
        if (!ObjectUtil.isEmpty((Object)fscBudgetItemPOList)) {
            Map spaceStateMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_BUDGET_SPACE_STATE");
            for (FscBudgetItemPO item : fscBudgetItemPOList) {
                FscBudgetItemBO fscBudgetItemBO = new FscBudgetItemBO();
                BeanUtils.copyProperties((Object)item, (Object)fscBudgetItemBO);
                fscBudgetItemBO.setSpaceStatusStr((String)spaceStateMap.get(item.getSpaceStatus().toString()));
                try {
                    if (item.getCurrentBudget() != null) {
                        fscBudgetItemBO.setCurrentBudget(MoneyUtils.Long2BigDecimal((Long)item.getCurrentBudget()));
                    }
                    if (item.getUsedBudget() != null) {
                        fscBudgetItemBO.setUsedBudget(MoneyUtils.Long2BigDecimal((Long)item.getUsedBudget()));
                    }
                    if (item.getFixSpaceBudget() != null) {
                        fscBudgetItemBO.setFixSpaceBudget(MoneyUtils.Long2BigDecimal((Long)item.getFixSpaceBudget()));
                    }
                    if (item.getOriginSpaceBudget() != null) {
                        fscBudgetItemBO.setOriginSpaceBudget(MoneyUtils.Long2BigDecimal((Long)item.getOriginSpaceBudget()));
                    }
                    if (item.getPastBudget() != null) {
                        fscBudgetItemBO.setPastBudget(MoneyUtils.Long2BigDecimal((Long)item.getPastBudget()));
                    }
                    if (item.getNowSpaceBudget() != null) {
                        fscBudgetItemBO.setNowSpaceBudget(MoneyUtils.Long2BigDecimal((Long)item.getNowSpaceBudget()));
                    }
                    if (!ObjectUtil.isEmpty((Object)item.getTotalSpaceBudget())) {
                        BigDecimal totalSpaceBudget = new BigDecimal(item.getTotalSpaceBudget());
                        fscBudgetItemBO.setTotalSpaceBudget(totalSpaceBudget.divide(new BigDecimal("10000"), 2, 1));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new FscBusinessException("8888", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
                }
                fscBudgetItemBO.setUnit("\u5143");
                fscBudgetItemBOList.add(fscBudgetItemBO);
            }
        }
        FscQryBudgetItemInfoAbilityRspBO rspBO = new FscQryBudgetItemInfoAbilityRspBO();
        rspBO.setFscBudgetItemBOList(fscBudgetItemBOList);
        return rspBO;
    }

    private void val(FscQryBudgetItemInfoAbilityReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getBudgetId()) && ObjectUtil.isEmpty((Object)reqBO.getBudgetDetailId()) && ObjectUtil.isEmpty((Object)reqBO.getBudgetItemId())) {
            throw new FscBusinessException("198888", "\u9884\u7b97\u5355\u660e\u7ec6\u5b50\u8868\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

