/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.budget.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.fsc.budget.ability.bo.FscBudgetDetailBO;
import com.tydic.fsc.budget.ability.bo.FscBudgetSubmitAbilityReqBO;
import com.tydic.fsc.budget.ability.bo.FscBudgetSubmitAbilityRspBO;
import com.tydic.fsc.budget.atom.api.FscBudgetOperationAddAtomService;
import com.tydic.fsc.budget.atom.bo.FscBudgetOperationAddAtomBO;
import com.tydic.fsc.budget.atom.bo.FscBudgetOperationAddAtomReqBO;
import com.tydic.fsc.budget.atom.bo.FscBudgetOperationAddAtomRspBO;
import com.tydic.fsc.budget.busi.api.FscBudgetSubmitBusiService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscBudgetDetailMapper;
import com.tydic.fsc.dao.FscBudgetItemMapper;
import com.tydic.fsc.dao.FscBudgetMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscBudgetDetailPO;
import com.tydic.fsc.po.FscBudgetItemPO;
import com.tydic.fsc.po.FscBudgetPO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBudgetSubmitBusiServiceImpl
implements FscBudgetSubmitBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBudgetSubmitBusiServiceImpl.class);
    @Autowired
    private FscBudgetMapper fscBudgetMapper;
    @Autowired
    private FscBudgetDetailMapper fscBudgetDetailMapper;
    @Autowired
    private FscBudgetItemMapper fscBudgetItemMapper;
    @Autowired
    private FscBudgetOperationAddAtomService fscBudgetOperationAddAtomService;

    @Override
    public FscBudgetSubmitAbilityRspBO budgetSubmit(FscBudgetSubmitAbilityReqBO reqBO) {
        FscBudgetSubmitAbilityRspBO rspBO = new FscBudgetSubmitAbilityRspBO();
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        FscBudgetPO fscBudgetPO = new FscBudgetPO();
        fscBudgetPO.setBudgetId(reqBO.getBudgetId());
        FscBudgetPO budgetInfo = this.fscBudgetMapper.getModelBy(fscBudgetPO);
        if (budgetInfo == null) {
            throw new FscBusinessException("198888", "\u9884\u7b97\u5355\u4e0d\u5b58\u5728");
        }
        if (!budgetInfo.getStatus().equals(FscConstants.FSC_BUDGET_MAIN_STATE.DRAFT)) {
            throw new FscBusinessException("198888", "\u53ea\u6709\u8349\u7a3f\u72b6\u6001\u7684\u9884\u7b97\u5355\u624d\u80fd\u63d0\u4ea4");
        }
        FscBudgetDetailPO fscBudgetDetailPO = new FscBudgetDetailPO();
        fscBudgetDetailPO.setBudgetId(reqBO.getBudgetId());
        List list = this.fscBudgetDetailMapper.getList(fscBudgetDetailPO);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new FscBusinessException("198888", "\u9884\u7b97\u5355\u4e0b\u4e0d\u5b58\u5728\u660e\u7ec6");
        }
        FscBudgetPO set = new FscBudgetPO();
        if (Integer.parseInt(budgetInfo.getBudgetYear()) > year) {
            set.setStatus(FscConstants.FSC_BUDGET_MAIN_STATE.NOT_STARTED);
        } else if (Integer.parseInt(budgetInfo.getBudgetYear()) == year) {
            set.setStatus(FscConstants.FSC_BUDGET_MAIN_STATE.STARTED);
        } else {
            set.setStatus(FscConstants.FSC_BUDGET_MAIN_STATE.OVER);
        }
        FscBudgetPO where = new FscBudgetPO();
        where.setBudgetId(reqBO.getBudgetId());
        this.fscBudgetMapper.updateBy(set, where);
        this.fscBudgetDetailMapper.updateOriginSpaceBudget(list.stream().map(FscBudgetDetailPO::getBudgetDetailId).collect(Collectors.toList()));
        this.fscBudgetItemMapper.updateSpaceStatusSubmit(reqBO.getBudgetId());
        FscBudgetItemPO fscBudgetItemPO = new FscBudgetItemPO();
        fscBudgetItemPO.setBudgetId(reqBO.getBudgetId());
        List itemList = this.fscBudgetItemMapper.getList(fscBudgetItemPO);
        List collect = itemList.stream().filter(e -> e.getOriginSpaceBudget() == null).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect)) {
            ArrayList collect1 = new ArrayList(collect.stream().map(FscBudgetItemPO::getBudgetDepartmentName).collect(Collectors.toSet()));
            StringBuilder str = new StringBuilder("\u9884\u7b97\u90e8\u95e8\uff1a");
            for (int i = 0; i < collect1.size(); ++i) {
                if (i != 0) {
                    str.append("\u3001");
                }
                str.append(((FscBudgetItemPO)collect.get(i)).getBudgetDepartmentName());
            }
            str.append("\u7684\u9884\u7b97\u8fd8\u672a\u7ef4\u62a4\uff0c\u4e0d\u80fd\u63d0\u4ea4");
            throw new FscBusinessException("198888", str.toString());
        }
        Map<Long, List<FscBudgetItemPO>> itemMap = itemList.stream().collect(Collectors.groupingBy(FscBudgetItemPO::getBudgetDetailId));
        FscBudgetOperationAddAtomReqBO fscBudgetOperationAddAtomReqBO = new FscBudgetOperationAddAtomReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)fscBudgetOperationAddAtomReqBO));
        fscBudgetOperationAddAtomReqBO.setUserName(reqBO.getUserName());
        fscBudgetOperationAddAtomReqBO.setLogType(FscConstants.FSC_BUDGET_LOG_TYPE.BUDGET_ORDER);
        ArrayList<FscBudgetOperationAddAtomBO> logList = new ArrayList<FscBudgetOperationAddAtomBO>();
        for (FscBudgetDetailPO each : list) {
            FscBudgetOperationAddAtomBO fscBudgetOperationAddAtomBO = new FscBudgetOperationAddAtomBO();
            fscBudgetOperationAddAtomBO.setOperationType(1);
            StringBuilder str = new StringBuilder("\u65b0\u589e\uff1a\u9884\u7b97\u90e8\u95e8\uff1a\u201c");
            str.append(each.getBudgetDepartmentName());
            str.append("\u201d\uff0c\u9884\u7b97\u5e74\u5ea6\uff1a\u201c");
            str.append(budgetInfo.getBudgetYear());
            str.append("\u5e74\u201d\uff1b");
            List<FscBudgetItemPO> items = itemMap.get(each.getBudgetDetailId());
            items.sort(Comparator.comparing(FscBudgetItemPO::getStartTime));
            for (FscBudgetItemPO item : items) {
                str.append("\u9884\u7b97\u671f\u95f4\u201c");
                str.append(item.getSpaceName());
                str.append("\u201d\uff0c\u90e8\u95e8\u671f\u95f4\u9884\u7b97\u989d\u5ea6\u201c");
                try {
                    str.append(MoneyUtils.Long2BigDecimal((Long)item.getNowSpaceBudget()));
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    throw new FscBusinessException("198888", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
                }
                str.append("\u5143\u201d\uff1b");
            }
            fscBudgetOperationAddAtomBO.setOperationContent(str.toString());
            fscBudgetOperationAddAtomBO.setBussiId(each.getBudgetId());
            fscBudgetOperationAddAtomBO.setBussiName(budgetInfo.getBudgetOrgName());
            fscBudgetOperationAddAtomBO.setOrgId(each.getBudgetDepartmentId());
            fscBudgetOperationAddAtomBO.setOrgName(each.getOrgPathName());
            logList.add(fscBudgetOperationAddAtomBO);
        }
        fscBudgetOperationAddAtomReqBO.setList(logList);
        FscBudgetOperationAddAtomRspBO fscBudgetOperationAddAtomRspBO = null;
        try {
            fscBudgetOperationAddAtomRspBO = this.fscBudgetOperationAddAtomService.addBudgetOperation(fscBudgetOperationAddAtomReqBO);
        }
        catch (Exception e3) {
            e3.printStackTrace();
            throw new FscBusinessException("198888", "\u4fdd\u5b58\u64cd\u4f5c\u65e5\u5fd7\u53c2\u6570\u5931\u8d25");
        }
        if (!"0000".equals(fscBudgetOperationAddAtomRspBO.getRespCode())) {
            throw new FscBusinessException("198888", "\u4fdd\u5b58\u64cd\u4f5c\u65e5\u5fd7\u53c2\u6570\u5931\u8d25:" + fscBudgetOperationAddAtomRspBO.getRespDesc());
        }
        if (!CollectionUtils.isEmpty((Collection)list)) {
            rspBO.setDetailInfoList(JSON.parseArray((String)JSON.toJSONString((Object)list), FscBudgetDetailBO.class));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

