/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.budget.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.budget.ability.api.FscBudgetSubmitAbilityService;
import com.tydic.fsc.budget.ability.bo.FscBudgetDetailBO;
import com.tydic.fsc.budget.ability.bo.FscBudgetSubmitAbilityReqBO;
import com.tydic.fsc.budget.ability.bo.FscBudgetSubmitAbilityRspBO;
import com.tydic.fsc.budget.ability.bo.FscBudgetTimeTaskAbilityReqBO;
import com.tydic.fsc.budget.busi.api.FscBudgetSubmitBusiService;
import java.util.Collection;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.budget.ability.api.FscBudgetSubmitAbilityService"})
public class FscBudgetSubmitAbilityServiceImpl
implements FscBudgetSubmitAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBudgetSubmitAbilityServiceImpl.class);
    @Autowired
    private FscBudgetSubmitBusiService fscBudgetSubmitBusiService;
    @Resource(name="fscBudgetTimeTaskProducer")
    private ProxyMessageProducer proxyMessageProducer;
    @Value(value="${FSC_BUDGET_TIME_TASK_TOPIC:FSC_BUDGET_TIME_TASK_TOPIC}")
    private String FSC_BUDGET_TIME_TASK_TOPIC;

    @PostMapping(value={"budgetSubmit"})
    public FscBudgetSubmitAbilityRspBO budgetSubmit(@RequestBody FscBudgetSubmitAbilityReqBO reqBO) {
        FscBudgetSubmitAbilityRspBO rspBO = new FscBudgetSubmitAbilityRspBO();
        if (reqBO.getBudgetId() == null) {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc("\u5165\u53c2budgetId\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        rspBO = this.fscBudgetSubmitBusiService.budgetSubmit(reqBO);
        if (!CollectionUtils.isEmpty((Collection)rspBO.getDetailInfoList())) {
            for (FscBudgetDetailBO each : rspBO.getDetailInfoList()) {
                FscBudgetTimeTaskAbilityReqBO fscBudgetTimeTaskAbilityReqBO = new FscBudgetTimeTaskAbilityReqBO();
                BeanUtils.copyProperties((Object)each, (Object)fscBudgetTimeTaskAbilityReqBO);
                try {
                    log.info("\u9884\u7b97\u5355\u63d0\u4ea4\u53d1mq\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)fscBudgetTimeTaskAbilityReqBO));
                    this.proxyMessageProducer.send(new ProxyMessage(this.FSC_BUDGET_TIME_TASK_TOPIC, "*", JSON.toJSONString((Object)fscBudgetTimeTaskAbilityReqBO)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("-------------------\u9884\u7b97\u5355\u63d0\u4ea4\u53d1mq\u5931\u8d25\uff01\uff01\uff01");
                }
            }
        }
        return rspBO;
    }
}

