/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.budget.busi.impl;

import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.fsc.budget.ability.bo.FscBudgetDetailAndItemUpdateAbilityReqBO;
import com.tydic.fsc.budget.ability.bo.FscBudgetDetailAndItemUpdateAbilityRspBO;
import com.tydic.fsc.budget.ability.bo.FscBudgetItemBO;
import com.tydic.fsc.budget.atom.api.FscBudgetOperationAddAtomService;
import com.tydic.fsc.budget.atom.bo.FscBudgetOperationAddAtomBO;
import com.tydic.fsc.budget.atom.bo.FscBudgetOperationAddAtomReqBO;
import com.tydic.fsc.budget.atom.bo.FscBudgetOperationAddAtomRspBO;
import com.tydic.fsc.budget.busi.api.FscBudgetDetailAndItemUpdateBusiService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscBudgetDetailMapper;
import com.tydic.fsc.dao.FscBudgetItemMapper;
import com.tydic.fsc.dao.FscBudgetMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscBudgetDetailPO;
import com.tydic.fsc.po.FscBudgetItemPO;
import com.tydic.fsc.po.FscBudgetPO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBudgetDetailAndItemUpdateBusiServiceImpl
implements FscBudgetDetailAndItemUpdateBusiService {
    @Autowired
    private FscBudgetMapper fscBudgetMapper;
    @Autowired
    private FscBudgetDetailMapper fscBudgetDetailMapper;
    @Autowired
    private FscBudgetItemMapper fscBudgetItemMapper;
    @Autowired
    private FscBudgetOperationAddAtomService fscBudgetOperationAddAtomService;

    @Override
    public FscBudgetDetailAndItemUpdateAbilityRspBO budgetDetailAndItemUpdate(FscBudgetDetailAndItemUpdateAbilityReqBO reqBO) {
        FscBudgetDetailAndItemUpdateAbilityRspBO rspBO = new FscBudgetDetailAndItemUpdateAbilityRspBO();
        FscBudgetDetailPO qryPO = new FscBudgetDetailPO();
        qryPO.setBudgetDetailId(reqBO.getBudgetDetailId());
        FscBudgetDetailPO budgetDetailInfo = this.fscBudgetDetailMapper.getModelBy(qryPO);
        if (budgetDetailInfo == null) {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc("\u5165\u53c2\u9884\u7b97\u660e\u7ec6\u4e0d\u5b58\u5728");
            return rspBO;
        }
        FscBudgetPO fscBudgetPO = new FscBudgetPO();
        fscBudgetPO.setBudgetId(budgetDetailInfo.getBudgetId());
        FscBudgetPO budgetInfo = this.fscBudgetMapper.getModelBy(fscBudgetPO);
        if (budgetInfo == null) {
            throw new FscBusinessException("198888", "\u9884\u7b97\u5355\u4e0d\u5b58\u5728");
        }
        Date time = new Date(System.currentTimeMillis());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (!FscConstants.FSC_BUDGET_MAIN_STATE.DRAFT.equals(budgetDetailInfo.getStatus()) && time.compareTo(budgetDetailInfo.getStartTime()) > 0) {
            rspBO.setErrorMessage("\u5f53\u524d\u65f6\u95f4\u4e3a\u201c" + dateFormat.format(time) + "\u201d\uff0c\u5df2\u8d85\u8fc7\u9884\u7b97\u5e74\u5ea6\u8d77\u59cb\u65f6\u95f4\u201c" + dateFormat.format(budgetDetailInfo.getStartTime()) + "\u201d\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\uff0c\u53ea\u80fd\u8fdb\u884c\u8c03\u6574\u64cd\u4f5c\u3002");
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        FscBudgetPO set = new FscBudgetPO();
        set.setUpdateOperId(reqBO.getUserId());
        set.setUpdateOperName(reqBO.getName());
        set.setUpdateOperUsername(reqBO.getUserName());
        set.setUpdateTime(time);
        FscBudgetPO where = new FscBudgetPO();
        where.setBudgetId(budgetInfo.getBudgetId());
        this.fscBudgetMapper.updateBy(set, where);
        set = new FscBudgetDetailPO();
        set.setUpdateOperId(reqBO.getUserId());
        set.setUpdateOperName(reqBO.getName());
        set.setUpdateOperUsername(reqBO.getUserName());
        set.setUpdateTime(time);
        where = new FscBudgetDetailPO();
        where.setBudgetDetailId(reqBO.getBudgetDetailId());
        if (!reqBO.getBudgetDepartmentId().equals(budgetDetailInfo.getBudgetDepartmentId())) {
            set.setBudgetDepartmentId(reqBO.getBudgetDepartmentId());
            set.setBudgetDepartmentName(reqBO.getBudgetDepartmentName());
            set.setOrgPath(reqBO.getOrgPath());
            set.setOrgPathName(reqBO.getOrgPathName());
            set.setOriginYearlyTotalBudget(Long.valueOf(0L));
            if (FscConstants.FSC_BUDGET_MAIN_STATE.DRAFT.equals(budgetInfo.getStatus())) {
                this.fscBudgetItemMapper.batchUpdateBudgetByBudgetDetailId(reqBO.getBudgetDetailId(), null);
            } else {
                this.fscBudgetItemMapper.batchUpdateBudgetByBudgetDetailId(reqBO.getBudgetDetailId(), Long.valueOf(0L));
            }
        }
        this.fscBudgetDetailMapper.updateBy((FscBudgetDetailPO)set, (FscBudgetDetailPO)where);
        List itemList = new ArrayList();
        Map collect = null;
        if (!CollectionUtils.isEmpty((Collection)reqBO.getBudgetItemList())) {
            collect = reqBO.getBudgetItemList().stream().collect(Collectors.toMap(FscBudgetItemBO::getBudgetItemId, Function.identity()));
            FscBudgetItemPO fscBudgetItemPO = new FscBudgetItemPO();
            fscBudgetItemPO.setBudgetItemIds(reqBO.getBudgetItemList().stream().map(FscBudgetItemBO::getBudgetItemId).collect(Collectors.toList()));
            itemList = this.fscBudgetItemMapper.getList(fscBudgetItemPO);
            for (FscBudgetItemBO each : reqBO.getBudgetItemList()) {
                Long originSpaceBudget = null;
                try {
                    originSpaceBudget = MoneyUtils.BigDecimal2Long((BigDecimal)each.getOriginSpaceBudget());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new FscBusinessException("8888", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
                }
                FscBudgetItemPO set2 = new FscBudgetItemPO();
                set2.setOriginSpaceBudget(originSpaceBudget);
                set2.setNowSpaceBudget(originSpaceBudget);
                set2.setCurrentBudget(originSpaceBudget);
                set2.setUpdateOperId(reqBO.getUserId());
                set2.setUpdateOperName(reqBO.getName());
                set2.setUpdateOperUsername(reqBO.getUserName());
                set2.setUpdateTime(time);
                FscBudgetItemPO where2 = new FscBudgetItemPO();
                where2.setBudgetItemId(each.getBudgetItemId());
                this.fscBudgetItemMapper.updateBy(set2, where2);
            }
            this.fscBudgetDetailMapper.updateOriginSpaceBudget(Arrays.asList(reqBO.getBudgetDetailId()));
        }
        if (!FscConstants.FSC_BUDGET_MAIN_STATE.DRAFT.equals(budgetInfo.getStatus())) {
            Map<Long, List<FscBudgetItemPO>> itemMap = itemList.stream().collect(Collectors.groupingBy(FscBudgetItemPO::getBudgetDetailId));
            FscBudgetOperationAddAtomReqBO fscBudgetOperationAddAtomReqBO = new FscBudgetOperationAddAtomReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)((Object)fscBudgetOperationAddAtomReqBO));
            fscBudgetOperationAddAtomReqBO.setLogType(FscConstants.FSC_BUDGET_LOG_TYPE.BUDGET_ORDER);
            ArrayList<FscBudgetOperationAddAtomBO> logList = new ArrayList<FscBudgetOperationAddAtomBO>();
            FscBudgetOperationAddAtomBO fscBudgetOperationAddAtomBO = new FscBudgetOperationAddAtomBO();
            fscBudgetOperationAddAtomBO.setOperationType(2);
            StringBuilder str = new StringBuilder("\u4fee\u6539\uff1a\u9884\u7b97\u90e8\u95e8\uff1a\u201c");
            str.append(budgetDetailInfo.getBudgetDepartmentName());
            if (!reqBO.getBudgetDepartmentId().equals(budgetDetailInfo.getBudgetDepartmentId())) {
                str.append("\u201d\u4fee\u6539\u4e3a\u201c");
                str.append(reqBO.getBudgetDepartmentName());
            }
            str.append("\u201d\uff0c\u9884\u7b97\u5e74\u5ea6\uff1a\u201c");
            str.append(budgetInfo.getBudgetYear());
            str.append("\u5e74\u201d\uff1b");
            List<FscBudgetItemPO> items = itemMap.get(budgetDetailInfo.getBudgetDetailId());
            if (!CollectionUtils.isEmpty(items)) {
                items.sort(Comparator.comparing(FscBudgetItemPO::getStartTime));
                for (FscBudgetItemPO item : items) {
                    str.append("\u9884\u7b97\u671f\u95f4\u201c");
                    str.append(item.getSpaceName());
                    str.append("\u201d\uff0c\u90e8\u95e8\u671f\u95f4\u9884\u7b97\u989d\u5ea6\u201c");
                    try {
                        str.append(((FscBudgetItemBO)collect.get(item.getBudgetItemId())).getOriginSpaceBudget());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new FscBusinessException("198888", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
                    }
                    str.append("\u5143\u201d\uff1b");
                }
            }
            fscBudgetOperationAddAtomBO.setOperationContent(str.toString());
            fscBudgetOperationAddAtomBO.setBussiId(budgetInfo.getBudgetId());
            fscBudgetOperationAddAtomBO.setBussiName(budgetInfo.getBudgetOrgName());
            fscBudgetOperationAddAtomBO.setOrgId(budgetDetailInfo.getBudgetDepartmentId());
            fscBudgetOperationAddAtomBO.setOrgName(budgetDetailInfo.getOrgPathName());
            logList.add(fscBudgetOperationAddAtomBO);
            fscBudgetOperationAddAtomReqBO.setList(logList);
            FscBudgetOperationAddAtomRspBO fscBudgetOperationAddAtomRspBO = null;
            try {
                fscBudgetOperationAddAtomRspBO = this.fscBudgetOperationAddAtomService.addBudgetOperation(fscBudgetOperationAddAtomReqBO);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new FscBusinessException("198888", "\u4fdd\u5b58\u64cd\u4f5c\u65e5\u5fd7\u53c2\u6570\u5931\u8d25");
            }
            if (!"0000".equals(fscBudgetOperationAddAtomRspBO.getRespCode())) {
                throw new FscBusinessException("198888", "\u4fdd\u5b58\u64cd\u4f5c\u65e5\u5fd7\u53c2\u6570\u5931\u8d25:" + fscBudgetOperationAddAtomRspBO.getRespDesc());
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

