/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.budget.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.budget.ability.bo.FscBudgetTimeTaskAbilityReqBO;
import com.tydic.fsc.budget.ability.bo.FscBudgetTimeTaskAbilityRspBO;
import com.tydic.fsc.budget.busi.api.FscBudgetTimeTaskBusiService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscBudgetDetailMapper;
import com.tydic.fsc.dao.FscBudgetItemLogMapper;
import com.tydic.fsc.dao.FscBudgetItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscBudgetDetailPO;
import com.tydic.fsc.po.FscBudgetItemLogPO;
import com.tydic.fsc.po.FscBudgetItemPO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBudgetTimeTaskBusiServiceImpl
implements FscBudgetTimeTaskBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBudgetTimeTaskBusiServiceImpl.class);
    @Autowired
    private FscBudgetDetailMapper fscBudgetDetailMapper;
    @Autowired
    private FscBudgetItemMapper fscBudgetItemMapper;
    @Autowired
    private FscBudgetItemLogMapper fscBudgetItemLogMapper;
    private Sequence sequence = Sequence.getInstance();
    @Value(value="${budgetTimeTaskLogOn:1}")
    private String budgetTimeTaskLogOn;
    int year;

    @Override
    public FscBudgetTimeTaskAbilityRspBO budgetTimeTask(FscBudgetTimeTaskAbilityReqBO reqBO) {
        FscBudgetTimeTaskAbilityRspBO rspBO = new FscBudgetTimeTaskAbilityRspBO();
        if (reqBO.getBudgetDepartmentId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2budgetDepartmentId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        log.info("----------------------\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u5904\u7406\u90e8\u95e8id\u4e3a:" + reqBO.getBudgetDepartmentId() + "\u7684\u9884\u7b97\u6570\u636e");
        Date time = new Date(System.currentTimeMillis());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        this.year = cal.get(1);
        List beforeNowTimeList = this.fscBudgetItemMapper.getListByTime(reqBO.getBudgetDepartmentId(), time, null);
        List inNowTimeList = this.fscBudgetItemMapper.getListByTime(reqBO.getBudgetDepartmentId(), null, time);
        ArrayList<FscBudgetItemPO> periodDealList = new ArrayList<FscBudgetItemPO>();
        ArrayList<FscBudgetItemPO> yearDealList = new ArrayList<FscBudgetItemPO>();
        ArrayList<FscBudgetItemPO> cleanList = new ArrayList<FscBudgetItemPO>();
        if (!CollectionUtils.isEmpty((Collection)beforeNowTimeList)) {
            FscBudgetDetailPO fscBudgetDetailPO = new FscBudgetDetailPO();
            fscBudgetDetailPO.setBudgetDepartmentId(reqBO.getBudgetDepartmentId());
            List list = this.fscBudgetDetailMapper.getList(fscBudgetDetailPO);
            list.sort(Comparator.comparing(FscBudgetDetailPO::getStartTime));
            for (int i = 0; i < list.size(); ++i) {
                if (!CollectionUtils.isEmpty((Collection)inNowTimeList) || ((FscBudgetDetailPO)list.get(i)).getYearDealType() != 2 || Integer.parseInt(((FscBudgetDetailPO)list.get(i)).getBudgetYear()) >= this.year) continue;
                Long budgetDetailId = ((FscBudgetDetailPO)list.get(i)).getBudgetDetailId();
                beforeNowTimeList.removeIf(e -> e.getBudgetDetailId().equals(budgetDetailId));
            }
            this.dealEnd(reqBO, beforeNowTimeList, periodDealList, yearDealList, cleanList);
        }
        if (!CollectionUtils.isEmpty((Collection)inNowTimeList)) {
            this.dealStart(reqBO, inNowTimeList, cleanList);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealEnd(FscBudgetTimeTaskAbilityReqBO reqBO, List<FscBudgetItemPO> beforeNowTimeList, List<FscBudgetItemPO> periodDealList, List<FscBudgetItemPO> yearDealList, List<FscBudgetItemPO> cleanList) {
        if (this.budgetTimeTaskLogOn.equals("1")) {
            log.info(reqBO.getBudgetDepartmentId() + "------------------------beforeNowTimeList\uff1a" + JSON.toJSONString(beforeNowTimeList));
        }
        Date time = new Date(System.currentTimeMillis());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (int i = 0; i < beforeNowTimeList.size(); ++i) {
            if (beforeNowTimeList.get(i).getCurrentBudget() == 0L) continue;
            List<Object> fscBudgetItemPOS = new ArrayList<FscBudgetItemPO>();
            if (i + 1 < beforeNowTimeList.size()) {
                fscBudgetItemPOS = beforeNowTimeList.subList(i + 1, beforeNowTimeList.size());
            }
            fscBudgetItemPOS.sort(Comparator.comparing(FscBudgetItemPO::getStartTime));
            List collect1 = fscBudgetItemPOS.stream().filter(e -> e.getPeriodDealType() == 1).collect(Collectors.toList());
            List collect2 = fscBudgetItemPOS.stream().filter(e -> e.getYearDealType() == 1 && Integer.parseInt(e.getBudgetYear()) < this.year).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(collect1) || !CollectionUtils.isEmpty(collect2)) continue;
            if (beforeNowTimeList.get(i).getPeriodDealType() != null && beforeNowTimeList.get(i).getPeriodDealType() == 2 && Integer.parseInt(beforeNowTimeList.get(i).getBudgetYear()) == this.year) {
                periodDealList.add(beforeNowTimeList.get(i));
                continue;
            }
            if (beforeNowTimeList.get(i).getYearDealType() == null || beforeNowTimeList.get(i).getYearDealType() != 2 || Integer.parseInt(beforeNowTimeList.get(i).getBudgetYear()) >= this.year) continue;
            yearDealList.add(beforeNowTimeList.get(i));
        }
        cleanList.addAll(periodDealList);
        cleanList.addAll(yearDealList);
        List collect = beforeNowTimeList.stream().filter(e -> e.getSpaceStatus() != 3).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect)) {
            Set budgetItemIds = collect.stream().map(FscBudgetItemPO::getBudgetItemId).collect(Collectors.toSet());
            log.info("\u5c06\u8981\u53d8\u66f4\u4e3a\u5df2\u7ed3\u675f\u7684\u671f\u95f4id:" + JSON.toJSONString(budgetItemIds));
            FscBudgetItemPO set = new FscBudgetItemPO();
            set.setSpaceStatus(FscConstants.FSC_BUDGET_MAIN_STATE.OVER);
            set.setColumn1("\u5b9a\u65f6\u4efb\u52a1\u53d8\u66f4\u72b6\u6001\u4e3a\u5df2\u7ed3\u675f:" + formatter.format(time));
            FscBudgetItemPO where = new FscBudgetItemPO();
            where.setBudgetItemIds(new ArrayList(budgetItemIds));
            where.setSpaceStatusList(Arrays.asList(1, 2));
            this.fscBudgetItemMapper.updateBy(set, where);
        }
        cleanList.removeIf(e -> e.getCurrentBudget() == 0L);
        beforeNowTimeList.removeIf(e -> e.getCurrentBudget() == 0L);
        if (!CollectionUtils.isEmpty(beforeNowTimeList)) {
            this.fscBudgetItemMapper.cleanCurrentBudget(beforeNowTimeList.stream().map(FscBudgetItemPO::getBudgetItemId).collect(Collectors.toList()));
            List logPOList = JSON.parseArray((String)JSON.toJSONString(beforeNowTimeList), FscBudgetItemLogPO.class);
            for (FscBudgetItemLogPO each : logPOList) {
                each.setId(Long.valueOf(this.sequence.nextId()));
                each.setOperId(Long.valueOf(1L));
                each.setOperName("\u5b9a\u65f6\u4efb\u52a1\u9884\u7b97\u6e05\u96f6");
                each.setOperTime(time);
                each.setOperType(Integer.valueOf(2));
                each.setOperNum(each.getCurrentBudget());
            }
            this.fscBudgetItemLogMapper.insertBatch(logPOList);
        }
    }

    private void dealStart(FscBudgetTimeTaskAbilityReqBO reqBO, List<FscBudgetItemPO> inNowTimeList, List<FscBudgetItemPO> cleanList) {
        if (this.budgetTimeTaskLogOn.equals("1")) {
            log.info(reqBO.getBudgetDepartmentId() + "------------------------inNowTimeList\uff1a" + JSON.toJSONString(inNowTimeList));
            log.info(reqBO.getBudgetDepartmentId() + "------------------------cleanList\uff1a" + JSON.toJSONString(cleanList));
        }
        if (inNowTimeList.size() > 1) {
            throw new FscBusinessException("198888", reqBO.getBudgetDepartmentId() + "\u5f53\u524d\u90e8\u95e8\u5b58\u5728\u591a\u6761\u9700\u8981\u751f\u6548\u7684\u671f\u95f4\u9884\u7b97\uff0c\u8bf7\u6392\u67e5\u6570\u636e");
        }
        Date time = new Date(System.currentTimeMillis());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Long operNum = 0L;
        for (FscBudgetItemPO each : cleanList) {
            operNum = operNum + each.getCurrentBudget();
        }
        log.error(reqBO.getBudgetDepartmentId() + "------------------------\u90e8\u95e8\u589e\u52a0\u53ef\u7528\u9884\u7b97\uff1a\u671f\u95f4id" + inNowTimeList.get(0).getBudgetItemId() + "\uff0c" + operNum);
        if (operNum != 0L) {
            Integer operType;
            if (operNum > 0L) {
                operType = 1;
            } else {
                operType = 2;
                operNum = -1L * operNum;
            }
            int i = this.fscBudgetItemMapper.updateCurrentBudgetAndPastBudget(inNowTimeList.get(0).getBudgetItemId(), operNum, operType);
            log.info("\u4fee\u6539\u6761\u6570\uff1a" + i);
            if (i != 1) {
                throw new FscBusinessException("198888", "sql\u66f4\u65b0\u7d2f\u8ba1\u9884\u7b97\u7684\u6570\u76ee\u4e0d\u662f1\uff01\uff01\uff01");
            }
            List logPOList = JSON.parseArray((String)JSON.toJSONString(inNowTimeList), FscBudgetItemLogPO.class);
            for (FscBudgetItemLogPO each : logPOList) {
                each.setId(Long.valueOf(this.sequence.nextId()));
                each.setOperId(Long.valueOf(1L));
                each.setOperName("\u5b9a\u65f6\u4efb\u52a1\u9884\u7b97\u7d2f\u8ba1");
                each.setOperTime(time);
                each.setOperType(operType);
                each.setOperNum(operNum);
            }
            this.fscBudgetItemLogMapper.insertBatch(logPOList);
        }
        if (!FscConstants.FSC_BUDGET_MAIN_STATE.STARTED.equals(inNowTimeList.get(0).getSpaceStatus())) {
            log.info("\u5c06\u8981\u53d8\u66f4\u4e3a\u8fdb\u884c\u4e2d\u7684\u671f\u95f4id:" + JSON.toJSONString((Object)inNowTimeList.get(0).getBudgetItemId()));
            FscBudgetItemPO set = new FscBudgetItemPO();
            set.setSpaceStatus(FscConstants.FSC_BUDGET_MAIN_STATE.STARTED);
            set.setColumn1("\u5b9a\u65f6\u4efb\u52a1\u53d8\u66f4\u72b6\u6001\u4e3a\u8fdb\u884c\u4e2d:" + formatter.format(time));
            FscBudgetItemPO where = new FscBudgetItemPO();
            where.setBudgetItemId(inNowTimeList.get(0).getBudgetItemId());
            this.fscBudgetItemMapper.updateBy(set, where);
        }
    }
}

