/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.budget.ability.impl;

import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.fsc.budget.ability.api.FscBudgetNumUpdateAbilityService;
import com.tydic.fsc.budget.ability.bo.FscBudgetNumUpdateAbilityReqBO;
import com.tydic.fsc.budget.ability.bo.FscBudgetNumUpdateAbilityRspBO;
import com.tydic.fsc.budget.ability.bo.FscBudgetNumUpdateBO;
import com.tydic.fsc.budget.busi.api.FscbudgetNumUpdateBusiService;
import com.tydic.fsc.dao.FscBudgetItemLogMapper;
import com.tydic.fsc.dao.FscBudgetItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscBudgetItemLogPO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.budget.ability.api.FscBudgetNumUpdateAbilityService"})
public class FscBudgetNumUpdateAbilityServiceImpl
implements FscBudgetNumUpdateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBudgetNumUpdateAbilityServiceImpl.class);
    @Autowired
    private FscbudgetNumUpdateBusiService fscbudgetNumUpdateBusiService;
    @Autowired
    private FscBudgetItemMapper fscBudgetItemMapper;
    @Autowired
    private FscBudgetItemLogMapper fscBudgetItemLogMapper;

    @PostMapping(value={"budgetNumUpdate"})
    public FscBudgetNumUpdateAbilityRspBO budgetNumUpdate(@RequestBody FscBudgetNumUpdateAbilityReqBO reqBO) {
        this.judge(reqBO);
        for (FscBudgetNumUpdateBO each : reqBO.getRows()) {
            FscBudgetItemLogPO firstLog;
            if (each.getOperType() != 1) continue;
            FscBudgetItemLogPO qryPO = new FscBudgetItemLogPO();
            qryPO.setDeductionKey(each.getDeductionKey());
            List list = this.fscBudgetItemLogMapper.getList(qryPO);
            if (CollectionUtils.isEmpty((Collection)list)) {
                throw new FscBusinessException("198888", "\u672a\u627e\u5230\u53ef\u4ee5\u56de\u9000\u7684DeductionKey");
            }
            Map<Integer, List<FscBudgetItemLogPO>> collect = list.stream().collect(Collectors.groupingBy(FscBudgetItemLogPO::getDeductionStatus));
            if (collect.containsKey(1)) {
                if (collect.get(1).size() > 1) {
                    throw new FscBusinessException("198888", each.getDeductionKey() + "\u7684\u6263\u51cf\u8bb0\u5f55\u6709\u591a\u6761");
                }
                firstLog = collect.get(1).get(0);
            } else if (collect.containsKey(2)) {
                if (collect.get(2).size() > 1) {
                    throw new FscBusinessException("198888", each.getDeductionKey() + "\u7684\u6263\u51cf\u8bb0\u5f55\u6709\u591a\u6761");
                }
                firstLog = collect.get(2).get(0);
            } else {
                throw new FscBusinessException("198888", "\u672a\u627e\u5230\u53ef\u4ee5\u56de\u9000\u7684DeductionKey\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
            }
            each.setBudgetItemId(firstLog.getBudgetItemId());
            Long allBackBudget = 0L;
            if (collect.containsKey(3)) {
                List backBudgets = collect.get(3).stream().map(FscBudgetItemLogPO::getOperNum).collect(Collectors.toList());
                for (Long operNum : backBudgets) {
                    allBackBudget = allBackBudget + operNum;
                }
            }
            try {
                allBackBudget = allBackBudget + MoneyUtils.BigDecimal2Long((BigDecimal)each.getOperNum());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new FscBusinessException("198888", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
            }
            if (firstLog.getOperNum() >= allBackBudget) continue;
            log.info(each.getDeductionKey() + "\u6263\u51cf\u989d\u5ea6\uff1a" + firstLog.getOperNum());
            log.info(each.getDeductionKey() + "\u603b\u56de\u9000\u989d\u5ea6\uff1a" + firstLog.getOperNum());
            throw new FscBusinessException("198888", each.getDeductionKey() + "\u7684\u56de\u9000\u603b\u989d\u5ea6\u4e0d\u80fd\u6bd4\u6263\u51cf\u989d\u5ea6\u9ad8");
        }
        FscBudgetNumUpdateAbilityRspBO rspBO = this.fscbudgetNumUpdateBusiService.budgetNumUpdate(reqBO);
        if (!StringUtils.isEmpty((Object)rspBO.getErrorMessage())) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc(rspBO.getErrorMessage());
            return rspBO;
        }
        return rspBO;
    }

    private void judge(FscBudgetNumUpdateAbilityReqBO reqBO) {
        if (reqBO.getUserId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u3010userId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getName())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u3010name\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getType() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u3010type\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getRows())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u3010rows\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (FscBudgetNumUpdateBO each : reqBO.getRows()) {
            if (each.getDeductionKey() == null) {
                throw new FscBusinessException("198888", "\u5165\u53c2\u3010deductionKey\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (each.getOperType() == null) {
                throw new FscBusinessException("198888", "\u5165\u53c2\u3010operType\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (each.getOperNum() == null) {
                throw new FscBusinessException("198888", "\u5165\u53c2\u3010operNum\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (each.getOperNum().compareTo(new BigDecimal(0)) != 0) continue;
            throw new FscBusinessException("198888", "\u5165\u53c2\u3010operNum\u3011\u4e0d\u80fd\u4e3a0");
        }
    }
}

